/*
 * Decompiled with CFR 0.152.
 */
package gfront;

import gfront.GFront;
import gfront.GFrontCommon;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.ProgressMonitor;
import javax.swing.Timer;

public class RightClickTable
implements MouseListener,
ActionListener {
    public JPopupMenu jpop = new JPopupMenu();
    JMenuItem gfrun = new JMenuItem("gfrun");
    JMenuItem gfrm;
    JMenuItem gfexport;
    JMenuItem gfexport_view;
    JMenuItem gfrep;
    JTable jt;
    GFront gfront;
    private ExportTask task;
    private ProgressMonitor progressMonitor;
    private Timer timer;

    RightClickTable(JTable jTable, GFront gFront) {
        this.gfrun.addActionListener(this);
        this.jpop.add(this.gfrun);
        this.gfrm = new JMenuItem("gfrm");
        this.gfrm.addActionListener(this);
        this.jpop.add(this.gfrm);
        this.gfexport = new JMenuItem("gfexport");
        this.gfexport.addActionListener(this);
        this.jpop.add(this.gfexport);
        this.gfexport_view = new JMenuItem("gfexport viewer");
        this.gfexport_view.addActionListener(this);
        this.jpop.add(this.gfexport_view);
        this.gfrep = new JMenuItem("* gfrep");
        this.gfrep.addActionListener(this);
        this.jpop.add(this.gfrep);
        this.jt = jTable;
        this.gfront = gFront;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        long l;
        GFrontCommon gFrontCommon = new GFrontCommon();
        int n = this.jt.getSelectedRow();
        if (n < 0) {
            return;
        }
        String string = (String)this.jt.getValueAt(n, 0);
        String string2 = this.gfront.savedSelectedDirname + string;
        try {
            l = Long.parseLong((String)this.jt.getValueAt(n, 1));
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, "cannot get file size", "error", 0);
            return;
        }
        if (actionEvent.getSource() == this.gfrun) {
            String string3 = JOptionPane.showInputDialog(this.gfront, "gfrun (for the output of strings)", "gfarm:CMD " + string2);
            if (string3 != null) {
                gFrontCommon.runNomalCommand(this.gfront, "gfrun " + string3, "gfrun");
            }
        } else if (actionEvent.getSource() == this.gfrm) {
            Object[] objectArray = new Object[]{"OK", "CANCEL"};
            int n2 = JOptionPane.showOptionDialog(null, "remove " + string2 + " ?", "gfrm", 0, 2, null, objectArray, objectArray[0]);
            if (n2 == 0) {
                System.out.println("$ gfrm " + string2);
                gFrontCommon.runNomalCommand(this.gfront, "gfrm " + string2, "gfrm");
                this.gfront._update_table(this.gfront.savedSelectedDirname);
            } else {
                System.out.println(n2);
            }
        } else if (actionEvent.getSource() == this.gfexport) {
            JFileChooser jFileChooser = new JFileChooser();
            int n3 = jFileChooser.showSaveDialog(this.gfront);
            if (n3 == 0) {
                File file = jFileChooser.getSelectedFile();
                String string4 = file.getName();
                System.out.println("*** $ gfexport " + string2 + " > " + string4);
                if (file.exists()) {
                    Object[] objectArray = new Object[]{"OK", "CANCEL"};
                    int n4 = JOptionPane.showOptionDialog(null, "\"" + string4 + "\" exists. overwrite?", "gfexport", 0, 2, null, objectArray, objectArray[0]);
                    if (n4 != 0) {
                        return;
                    }
                }
                this.run_gfexport(l, string2, file);
            }
        } else if (actionEvent.getSource() == this.gfexport_view) {
            this.run_gfexport(l, string2, null);
        } else if (actionEvent.getSource() == this.gfrep) {
            // empty if block
        }
    }

    private void run_gfexport(long l, String string, File file) {
        boolean bl;
        int n;
        if (l > Integer.MAX_VALUE) {
            n = (int)(l >> 32 & 0xFFFFFFFFFFFFFFFFL);
            bl = true;
        } else {
            n = (int)l;
            bl = false;
        }
        this.progressMonitor = new ProgressMonitor(this.gfront, "gfexport", "", 0, n);
        this.progressMonitor.setProgress(0);
        this.progressMonitor.setMillisToDecideToPopup(200);
        this.progressMonitor.setNote("0 / 0");
        this.task = new ExportTask(string, file, l, bl);
        this.task.start();
        this.timer = new Timer(1000, new ExportTimerListener());
        this.timer.start();
    }

    private void actionPoint(MouseEvent mouseEvent) {
        System.out.println(mouseEvent.getX() + ", " + mouseEvent.getY());
        this.jpop.show(this.jt, mouseEvent.getX(), mouseEvent.getY());
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            System.out.println("Popup");
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            System.out.println("Popup2");
            this.actionPoint(mouseEvent);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            System.out.println("Popup3");
            this.actionPoint(mouseEvent);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    class ExportTimerListener
    implements ActionListener {
        ExportTimerListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (RightClickTable.this.progressMonitor.isCanceled() || RightClickTable.this.task.isDone() || ((RightClickTable)RightClickTable.this).task.isError) {
                RightClickTable.this.task.end();
                RightClickTable.this.progressMonitor.close();
                Toolkit.getDefaultToolkit().beep();
                RightClickTable.this.timer.stop();
                String string = RightClickTable.this.task.viewString();
                if (string != null && string.length() > 0) {
                    GFrontCommon gFrontCommon = new GFrontCommon();
                    gFrontCommon.showTextArea(RightClickTable.this.gfront, "gfexport viewer", string, 30, 60);
                } else if (((RightClickTable)RightClickTable.this).task.isError) {
                    JOptionPane.showMessageDialog(null, ((RightClickTable)RightClickTable.this).task.errorString, "error", 2);
                } else if (RightClickTable.this.task.isDone()) {
                    JOptionPane.showMessageDialog(null, "done", "gfexport", 1);
                } else {
                    JOptionPane.showMessageDialog(null, "canceled", "gfexport", 2);
                }
            } else {
                RightClickTable.this.progressMonitor.setNote(RightClickTable.this.task.getMessage());
                RightClickTable.this.progressMonitor.setProgress(RightClickTable.this.task.getCurrent());
            }
        }
    }

    class ExportTask
    extends Thread {
        String from;
        File to;
        long now;
        long maxsize;
        boolean isLong;
        public boolean isError;
        public String errorString;
        private boolean stopFlag;
        private StringBuffer str;
        private int maxview = 2048;

        ExportTask(String string, File file, long l, boolean bl) {
            this.from = string;
            this.to = file;
            this.maxsize = l;
            this.isLong = bl;
            this.str = this.to == null ? new StringBuffer() : null;
        }

        String getMessage() {
            String string = "copy: " + this.now + " / " + this.maxsize;
            System.out.println(string);
            return string;
        }

        public void run() {
            int n;
            this.now = 0L;
            this.stopFlag = false;
            this.isError = false;
            Runtime runtime = Runtime.getRuntime();
            String[] stringArray = new String[]{"gfexport", this.from};
            Process process = null;
            try {
                process = runtime.exec(stringArray);
            }
            catch (IOException iOException) {
                this.isError = true;
                this.errorString = "gfexport is not found";
                return;
            }
            FileOutputStream fileOutputStream = null;
            if (this.to != null) {
                try {
                    fileOutputStream = new FileOutputStream(this.to);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.isError = true;
                    this.errorString = "file open error: " + this.to;
                    return;
                }
            }
            BufferedInputStream bufferedInputStream = new BufferedInputStream(process.getInputStream());
            byte[] byArray = new byte[1024];
            try {
                while ((n = bufferedInputStream.read(byArray)) != -1 && !this.stopFlag) {
                    if (this.to != null) {
                        fileOutputStream.write(byArray, 0, n);
                    } else {
                        this.str.append(new String(byArray, 0, n));
                        if (this.str.length() > this.maxview) {
                            this.str.append(System.getProperty("line.separator") + System.getProperty("line.separator") + "[print first " + this.maxview + " bytes]");
                            break;
                        }
                    }
                    this.now += (long)n;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.now > this.maxsize) {
                this.isError = true;
                this.errorString = "output file is bigger than input gfarm file";
            }
            if (this.now < this.maxsize) {
                this.isError = true;
                this.errorString = "output file is not enough";
                BufferedInputStream bufferedInputStream2 = new BufferedInputStream(process.getErrorStream());
                try {
                    n = bufferedInputStream2.read(byArray);
                }
                catch (IOException iOException) {
                    n = -1;
                }
                if (n > 0) {
                    this.errorString = new String(byArray, 0, n);
                }
            }
            if (this.stopFlag) {
                System.out.println("Interrupt!");
            }
            try {
                process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.stopFlag = true;
        }

        int getCurrent() {
            if (this.isLong) {
                return (int)(this.now >> 32 & 0xFFFFFFFFFFFFFFFFL);
            }
            return (int)this.now;
        }

        void end() {
            if (RightClickTable.this.progressMonitor.isCanceled()) {
                this.stopFlag = true;
                this.to.delete();
            } else if (this.isError) {
                this.stopFlag = true;
            }
        }

        String viewString() {
            if (this.str != null) {
                return this.str.toString();
            }
            return null;
        }

        boolean isDone() {
            return this.stopFlag || this.now >= this.maxsize;
        }
    }
}

