# From 6.3 to 6.4
*Make sure you view this [upgrade guide from the `master` branch](../../../master/doc/update/6.3-to-6.4.md) for the most up to date instructions.*

## 0. Backup

```bash
cd /home/git/gitlab
sudo -u git -H bundle exec rake gitlab:backup:create RAILS_ENV=production
```

## 1. Stop server

```bash
sudo service gitlab stop
````

## 2. Get latest code

```bash
cd /home/git/gitlab
sudo -u git -H git fetch --all
sudo -u git -H git checkout 6-4-stable
# For GitLab Enterprise Edition: sudo -u git -H git checkout 6-4-stable-ee
```

## 3. Update gitlab-shell (and its config)

```bash
cd /home/git/gitlab-shell
sudo -u git -H git fetch
sudo -u git -H git checkout v1.8.0
```

## 4. Install libs, migrations, etc.

```bash
cd /home/git/gitlab

# MySQL
sudo -u git -H bundle install --without development test postgres --deployment

# PostgreSQL
sudo -u git -H bundle install --without development test mysql --deployment


# Run database migrations
sudo -u git -H bundle exec rake db:migrate RAILS_ENV=production

# Clean up assets and cache
sudo -u git -H bundle exec rake assets:clean assets:precompile cache:clear RAILS_ENV=production

# Update init.d script
sudo cp lib/support/init.d/gitlab /etc/init.d/gitlab
```

## 5. Start application

```bash
sudo service gitlab start
sudo service nginx restart
```

## 6. Check application status

Check if GitLab and its environment are configured correctly:

```bash
sudo -u git -H bundle exec rake gitlab:env:info RAILS_ENV=production
```

To make sure you didn't miss anything run a more thorough check with:

```bash
sudo -u git -H bundle exec rake gitlab:check RAILS_ENV=production
```

If all items are green, then congratulations upgrade complete!

## Things went south? Revert to previous version (6.3)

### 1. Revert the code to the previous version

Follow the [upgrade guide from 6.2 to 6.3](6.2-to-6.3.md), except for the database migration (the backup is already migrated to the previous version).

### 2. Restore from the backup:

```bash
cd /home/git/gitlab
sudo -u git -H bundle exec rake gitlab:backup:restore RAILS_ENV=production
```
