// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package iotfleethubiface provides an interface to enable mocking the AWS IoT Fleet Hub service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package iotfleethubiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/iotfleethub"
)

// IoTFleetHubAPI provides an interface to enable mocking the
// iotfleethub.IoTFleetHub service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// AWS IoT Fleet Hub.
//	func myFunc(svc iotfleethubiface.IoTFleetHubAPI) bool {
//	    // Make svc.CreateApplication request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := iotfleethub.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockIoTFleetHubClient struct {
//	    iotfleethubiface.IoTFleetHubAPI
//	}
//	func (m *mockIoTFleetHubClient) CreateApplication(input *iotfleethub.CreateApplicationInput) (*iotfleethub.CreateApplicationOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockIoTFleetHubClient{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type IoTFleetHubAPI interface {
	CreateApplication(*iotfleethub.CreateApplicationInput) (*iotfleethub.CreateApplicationOutput, error)
	CreateApplicationWithContext(aws.Context, *iotfleethub.CreateApplicationInput, ...request.Option) (*iotfleethub.CreateApplicationOutput, error)
	CreateApplicationRequest(*iotfleethub.CreateApplicationInput) (*request.Request, *iotfleethub.CreateApplicationOutput)

	DeleteApplication(*iotfleethub.DeleteApplicationInput) (*iotfleethub.DeleteApplicationOutput, error)
	DeleteApplicationWithContext(aws.Context, *iotfleethub.DeleteApplicationInput, ...request.Option) (*iotfleethub.DeleteApplicationOutput, error)
	DeleteApplicationRequest(*iotfleethub.DeleteApplicationInput) (*request.Request, *iotfleethub.DeleteApplicationOutput)

	DescribeApplication(*iotfleethub.DescribeApplicationInput) (*iotfleethub.DescribeApplicationOutput, error)
	DescribeApplicationWithContext(aws.Context, *iotfleethub.DescribeApplicationInput, ...request.Option) (*iotfleethub.DescribeApplicationOutput, error)
	DescribeApplicationRequest(*iotfleethub.DescribeApplicationInput) (*request.Request, *iotfleethub.DescribeApplicationOutput)

	ListApplications(*iotfleethub.ListApplicationsInput) (*iotfleethub.ListApplicationsOutput, error)
	ListApplicationsWithContext(aws.Context, *iotfleethub.ListApplicationsInput, ...request.Option) (*iotfleethub.ListApplicationsOutput, error)
	ListApplicationsRequest(*iotfleethub.ListApplicationsInput) (*request.Request, *iotfleethub.ListApplicationsOutput)

	ListApplicationsPages(*iotfleethub.ListApplicationsInput, func(*iotfleethub.ListApplicationsOutput, bool) bool) error
	ListApplicationsPagesWithContext(aws.Context, *iotfleethub.ListApplicationsInput, func(*iotfleethub.ListApplicationsOutput, bool) bool, ...request.Option) error

	ListTagsForResource(*iotfleethub.ListTagsForResourceInput) (*iotfleethub.ListTagsForResourceOutput, error)
	ListTagsForResourceWithContext(aws.Context, *iotfleethub.ListTagsForResourceInput, ...request.Option) (*iotfleethub.ListTagsForResourceOutput, error)
	ListTagsForResourceRequest(*iotfleethub.ListTagsForResourceInput) (*request.Request, *iotfleethub.ListTagsForResourceOutput)

	TagResource(*iotfleethub.TagResourceInput) (*iotfleethub.TagResourceOutput, error)
	TagResourceWithContext(aws.Context, *iotfleethub.TagResourceInput, ...request.Option) (*iotfleethub.TagResourceOutput, error)
	TagResourceRequest(*iotfleethub.TagResourceInput) (*request.Request, *iotfleethub.TagResourceOutput)

	UntagResource(*iotfleethub.UntagResourceInput) (*iotfleethub.UntagResourceOutput, error)
	UntagResourceWithContext(aws.Context, *iotfleethub.UntagResourceInput, ...request.Option) (*iotfleethub.UntagResourceOutput, error)
	UntagResourceRequest(*iotfleethub.UntagResourceInput) (*request.Request, *iotfleethub.UntagResourceOutput)

	UpdateApplication(*iotfleethub.UpdateApplicationInput) (*iotfleethub.UpdateApplicationOutput, error)
	UpdateApplicationWithContext(aws.Context, *iotfleethub.UpdateApplicationInput, ...request.Option) (*iotfleethub.UpdateApplicationOutput, error)
	UpdateApplicationRequest(*iotfleethub.UpdateApplicationInput) (*request.Request, *iotfleethub.UpdateApplicationOutput)
}

var _ IoTFleetHubAPI = (*iotfleethub.IoTFleetHub)(nil)
