package zen

const (
	EVENT_ACTUAL_CPU_CLOCK = 0x01
	UMASK_ACTUAL_CPU_CLOCK = 0x00

	EVENT_APERF = 0x01
	UMASK_APERF = 0x00

	EVENT_MAX_CPU_CLOCK = 0x02
	UMASK_MAX_CPU_CLOCK = 0x00

	EVENT_MPERF = 0x02
	UMASK_MPERF = 0x00

	EVENT_MERGE = 0xFFF
	UMASK_MERGE = 0x00

	EVENT_FPU_PIPE_ASSIGNMENT                          = 0x00
	UMASK_FPU_PIPE_ASSIGNMENT_UOPS_PIPE_0              = 0x01
	UMASK_FPU_PIPE_ASSIGNMENT_UOPS_PIPE_1              = 0x02
	UMASK_FPU_PIPE_ASSIGNMENT_UOPS_PIPE_2              = 0x04
	UMASK_FPU_PIPE_ASSIGNMENT_UOPS_PIPE_3              = 0x08
	UMASK_FPU_PIPE_ASSIGNMENT_UOPS_PIPE_ALL            = 0x0F
	UMASK_FPU_PIPE_ASSIGNMENT_MULTI_PIPE_UOPS_PIPE_0   = 0x10
	UMASK_FPU_PIPE_ASSIGNMENT_MULTI_PIPE_UOPS_PIPE_1   = 0x20
	UMASK_FPU_PIPE_ASSIGNMENT_MULTI_PIPE_UOPS_PIPE_2   = 0x40
	UMASK_FPU_PIPE_ASSIGNMENT_MULTI_PIPE_UOPS_PIPE_3   = 0x80
	UMASK_FPU_PIPE_ASSIGNMENT_MULTI_PIPE_UOPS_PIPE_ALL = 0xF0

	EVENT_FP_SCHEDULER_EMPTY = 0x01
	UMASK_FP_SCHEDULER_EMPTY = 0x00

	EVENT_RETIRED_X87_FLOPS         = 0x02
	UMASK_RETIRED_X87_FLOPS_ADD_SUB = 0x01
	UMASK_RETIRED_X87_FLOPS_MULT    = 0x02
	UMASK_RETIRED_X87_FLOPS_DIV     = 0x04
	UMASK_RETIRED_X87_FLOPS_ALL     = 0x07

	EVENT_RETIRED_SSE_AVX_FLOPS                     = 0x03
	UMASK_RETIRED_SSE_AVX_FLOPS_SINGLE_ADD_SUB      = 0x01
	UMASK_RETIRED_SSE_AVX_FLOPS_SINGLE_MULT         = 0x02
	UMASK_RETIRED_SSE_AVX_FLOPS_SINGLE_DIV          = 0x04
	UMASK_RETIRED_SSE_AVX_FLOPS_SINGLE_ADD_MULT_DIV = 0x07
	UMASK_RETIRED_SSE_AVX_FLOPS_SINGLE_FMA          = 0x08
	UMASK_RETIRED_SSE_AVX_FLOPS_SINGLE_ALL          = 0x0F
	UMASK_RETIRED_SSE_AVX_FLOPS_DOUBLE_ADD_SUB      = 0x10
	UMASK_RETIRED_SSE_AVX_FLOPS_DOUBLE_MULT         = 0x20
	UMASK_RETIRED_SSE_AVX_FLOPS_DOUBLE_DIV          = 0x40
	UMASK_RETIRED_SSE_AVX_FLOPS_DOUBLE_ADD_MULT_DIV = 0x70
	UMASK_RETIRED_SSE_AVX_FLOPS_DOUBLE_FMA          = 0x80
	UMASK_RETIRED_SSE_AVX_FLOPS_DOUBLE_ALL          = 0xF0
	UMASK_RETIRED_SSE_AVX_FLOPS_ALL                 = 0xFF

	EVENT_MOVE_ELIMINATION                = 0x04
	UMASK_MOVE_ELIMINATION_SSE_MOVES      = 0x01
	UMASK_MOVE_ELIMINATION_SSE_MOVE_ELIMS = 0x02

	EVENT_SCALAR_OP_OPTIMIZATIONS           = 0x04
	UMASK_SCALAR_OP_OPTIMIZATIONS_POTENTIAL = 0x04
	UMASK_SCALAR_OP_OPTIMIZATIONS_DONE      = 0x08

	EVENT_RETIRED_SERIALIZING_OPS             = 0x05
	UMASK_RETIRED_SERIALIZING_OPS_SSE_BOTTOM  = 0x00
	UMASK_RETIRED_SERIALIZING_OPS_SSE_CONTROL = 0x01
	UMASK_RETIRED_SERIALIZING_OPS_X87_BOTTOM  = 0x02
	UMASK_RETIRED_SERIALIZING_OPS_X87_CONTROL = 0x04

	EVENT_LS_BAD_STATUS               = 0x24
	UMASK_LS_BAD_STATUS_STLI_NO_STATE = 0x01
	UMASK_LS_BAD_STATUS_STLI_OTHER    = 0x02
	UMASK_LS_BAD_STATUS_STLF_NO_DATA  = 0x04

	EVENT_LOCKS                      = 0x25
	UMASK_LOCKS_BUS_LOCK             = 0x01
	UMASK_LOCKS_NON_SPEC_LOCK        = 0x02
	UMASK_LOCKS_SPEC_LOCK            = 0x04
	UMASK_LOCKS_SPEC_LOCK_MAP_COMMIT = 0x08

	EVENT_RETIRED_CLFLUSH = 0x26
	UMASK_RETIRED_CLFLUSH = 0x00

	EVENT_RETIRED_CPUID = 0x27
	UMASK_RETIRED_CPUID = 0x00

	EVENT_LS_DISPATCH                = 0x29
	UMASK_LS_DISPATCH_LOADS          = 0x01
	UMASK_LS_DISPATCH_STORES         = 0x02
	UMASK_LS_DISPATCH_LOAD_OP_STORES = 0x04
	UMASK_LS_DISPATCH_ANY            = 0x07

	EVENT_SMIS_RECEIVED = 0x2B
	UMASK_SMIS_RECEIVED = 0x00

	EVENT_ST_TO_LD_FWD = 0x35
	UMASK_ST_TO_LD_FWD = 0x00

	EVENT_ST_COMMIT_CANCELS = 0x37
	UMASK_ST_COMMIT_CANCELS = 0x01

	EVENT_DATA_CACHE_ACCESSES = 0x40
	UMASK_DATA_CACHE_ACCESSES = 0x00

	EVENT_MAB_ALLOC_PIPE           = 0x41
	UMASK_MAB_ALLOC_PIPE_DATA      = 0x01
	UMASK_MAB_ALLOC_PIPE_STORE     = 0x02
	UMASK_MAB_ALLOC_PIPE_TLB_LATE  = 0x04
	UMASK_MAB_ALLOC_PIPE_HW_PF     = 0x08
	UMASK_MAB_ALLOC_PIPE_TLB_EARLY = 0x10

	EVENT_DATA_CACHE_REFILLS              = 0x43
	UMASK_DATA_CACHE_REFILLS_LOCAL_L2     = 0x01
	UMASK_DATA_CACHE_REFILLS_LOCAL_CACHE  = 0x02
	UMASK_DATA_CACHE_REFILLS_LOCAL_DRAM   = 0x08
	UMASK_DATA_CACHE_REFILLS_LOCAL_ALL    = 0x0B
	UMASK_DATA_CACHE_REFILLS_REMOTE_CACHE = 0x10
	UMASK_DATA_CACHE_REFILLS_REMOTE_DRAM  = 0x40
	UMASK_DATA_CACHE_REFILLS_REMOTE_ALL   = 0x50
	UMASK_DATA_CACHE_REFILLS_ALL          = 0x5B

	EVENT_L1_DTLB_MISS             = 0x45
	UMASK_L1_DTLB_MISS_4K_L2_HIT   = 0x01
	UMASK_L1_DTLB_MISS_32K_L2_HIT  = 0x02
	UMASK_L1_DTLB_MISS_2M_L2_HIT   = 0x04
	UMASK_L1_DTLB_MISS_1G_L2_HIT   = 0x08
	UMASK_L1_DTLB_MISS_ANY_L2_HIT  = 0x0F
	UMASK_L1_DTLB_MISS_4K_L2_MISS  = 0x10
	UMASK_L1_DTLB_MISS_32K_L2_MISS = 0x20
	UMASK_L1_DTLB_MISS_2M_L2_MISS  = 0x40
	UMASK_L1_DTLB_MISS_1G_L2_MISS  = 0x80
	UMASK_L1_DTLB_MISS_ANY_L2_MISS = 0xF0

	EVENT_TABLEWALKER_ALLOC        = 0x46
	UMASK_TABLEWALKER_ALLOC_DSIDE0 = 0x01
	UMASK_TABLEWALKER_ALLOC_DSIDE1 = 0x02
	UMASK_TABLEWALKER_ALLOC_ISIDE0 = 0x04
	UMASK_TABLEWALKER_ALLOC_ISIDE1 = 0x08

	EVENT_MISALIGNED_LOADS = 0x47
	UMASK_MISALIGNED_LOADS = 0x00

	EVENT_PREF_INSTR_DISPATCHED       = 0x4B
	UMASK_PREF_INSTR_DISPATCHED_LOAD  = 0x01
	UMASK_PREF_INSTR_DISPATCHED_STORE = 0x02
	UMASK_PREF_INSTR_DISPATCHED_NTA   = 0x04

	EVENT_INEFFECTIVE_SW_PREF                = 0x52
	UMASK_INEFFECTIVE_SW_PREF_DATA_CACHE_HIT = 0x01
	UMASK_INEFFECTIVE_SW_PREF_MAB_MATCH      = 0x02

	EVENT_SWPREF_DATA_CACHE_FILLS              = 0x59
	UMASK_SWPREF_DATA_CACHE_FILLS_LOCAL_L2     = 0x01
	UMASK_SWPREF_DATA_CACHE_FILLS_LOCAL_CACHE  = 0x02
	UMASK_SWPREF_DATA_CACHE_FILLS_LOCAL_DRAM   = 0x08
	UMASK_SWPREF_DATA_CACHE_FILLS_LOCAL_ALL    = 0x0B
	UMASK_SWPREF_DATA_CACHE_FILLS_REMOTE_CACHE = 0x10
	UMASK_SWPREF_DATA_CACHE_FILLS_REMOTE_DRAM  = 0x40
	UMASK_SWPREF_DATA_CACHE_FILLS_REMOTE_ALL   = 0x50
	UMASK_SWPREF_DATA_CACHE_FILLS_ALL          = 0x5B

	EVENT_HWPREF_DATA_CACHE_FILLS              = 0x5A
	UMASK_HWPREF_DATA_CACHE_FILLS_LOCAL_L2     = 0x01
	UMASK_HWPREF_DATA_CACHE_FILLS_LOCAL_CACHE  = 0x02
	UMASK_HWPREF_DATA_CACHE_FILLS_LOCAL_DRAM   = 0x08
	UMASK_HWPREF_DATA_CACHE_FILLS_LOCAL_ALL    = 0x0B
	UMASK_HWPREF_DATA_CACHE_FILLS_REMOTE_CACHE = 0x10
	UMASK_HWPREF_DATA_CACHE_FILLS_REMOTE_DRAM  = 0x40
	UMASK_HWPREF_DATA_CACHE_FILLS_REMOTE_ALL   = 0x50
	UMASK_HWPREF_DATA_CACHE_FILLS_ALL          = 0x5B

	EVENT_TABLEWALKER_DATA_CACHE_FILLS              = 0x5B
	UMASK_TABLEWALKER_DATA_CACHE_FILLS_LOCAL_L2     = 0x01
	UMASK_TABLEWALKER_DATA_CACHE_FILLS_LOCAL_CACHE  = 0x02
	UMASK_TABLEWALKER_DATA_CACHE_FILLS_LOCAL_DRAM   = 0x08
	UMASK_TABLEWALKER_DATA_CACHE_FILLS_LOCAL_ALL    = 0x0B
	UMASK_TABLEWALKER_DATA_CACHE_FILLS_REMOTE_CACHE = 0x10
	UMASK_TABLEWALKER_DATA_CACHE_FILLS_REMOTE_DRAM  = 0x40
	UMASK_TABLEWALKER_DATA_CACHE_FILLS_REMOTE_ALL   = 0x50
	UMASK_TABLEWALKER_DATA_CACHE_FILLS_ALL          = 0x5B

	EVENT_CPU_CLOCKS_UNHALTED = 0x76
	UMASK_CPU_CLOCKS_UNHALTED = 0x00

	EVENT_ICACHE_FETCHES = 0x80
	UMASK_ICACHE_FETCHES = 0x00

	EVENT_ICACHE_MISSES = 0x81
	UMASK_ICACHE_MISSES = 0x00

	EVENT_ICACHE_L2_REFILLS = 0x82
	UMASK_ICACHE_L2_REFILLS = 0x00

	EVENT_ICACHE_SYSTEM_REFILLS = 0x83
	UMASK_ICACHE_SYSTEM_REFILLS = 0x00

	EVENT_L1_ITLB_L2_ITLB_HIT = 0x84
	UMASK_L1_ITLB_L2_ITLB_HIT = 0x00

	EVENT_L1_ITLB_L2_ITLB_MISS = 0x85
	UMASK_L1_ITLB_L2_ITLB_MISS = 0x00

	EVENT_PIPELINE_RESTART_DUE_INSTR_STREAM_PROBE = 0x86
	UMASK_PIPELINE_RESTART_DUE_INSTR_STREAM_PROBE = 0x00

	EVENT_INSTR_PIPE_STALL               = 0x87
	UMASK_INSTR_PIPE_STALL_BACK_PRESSURE = 0x01
	UMASK_INSTR_PIPE_STALL_DQ_EMPTY      = 0x02
	UMASK_INSTR_PIPE_STALL_ANY           = 0x04

	EVENT_L1_BTB_CORRECTION = 0x8A
	UMASK_L1_BTB_CORRECTION = 0x00

	EVENT_L2_BTB_CORRECTION = 0x8B
	UMASK_L2_BTB_CORRECTION = 0x00

	EVENT_ICACHE_LINES_INVALIDATED          = 0x8C
	UMASK_ICACHE_LINES_INVALIDATED_FILL     = 0x01
	UMASK_ICACHE_LINES_INVALIDATED_L2_PROBE = 0x02

	EVENT_ITLB_RELOADS = 0x99
	UMASK_ITLB_RELOADS = 0x00

	EVENT_OC_MODE_SWITCH       = 0x28A
	UMASK_OC_MODE_SWITCH_IC_OC = 0x01
	UMASK_OC_MODE_SWITCH_OC_IC = 0x02

	EVENT_DYN_TOKENS_DISP_STALL_CYCLES                      = 0xAF
	UMASK_DYN_TOKENS_DISP_STALL_CYCLES_ALSQ1_TOKEN_STALL    = 0x01
	UMASK_DYN_TOKENS_DISP_STALL_CYCLES_ALSQ2_TOKEN_STALL    = 0x02
	UMASK_DYN_TOKENS_DISP_STALL_CYCLES_ALSQ3_TOKEN_STALL    = 0x04
	UMASK_DYN_TOKENS_DISP_STALL_CYCLES_ALSQ3_0_TOKEN_STALL  = 0x08
	UMASK_DYN_TOKENS_DISP_STALL_CYCLES_ALSQ_ANY_TOKEN_STALL = 0x0F
	UMASK_DYN_TOKENS_DISP_STALL_CYCLES_ALU_TOKEN_STALL      = 0x10
	UMASK_DYN_TOKENS_DISP_STALL_CYCLES_AGSQ_TOKEN_STALL     = 0x20
	UMASK_DYN_TOKENS_DISP_STALL_CYCLES_RETIRE_TOKEN_STALL   = 0x40

	EVENT_RETIRED_INSTRUCTIONS = 0xC0
	UMASK_RETIRED_INSTRUCTIONS = 0x00

	EVENT_RETIRED_UOPS = 0xC1
	UMASK_RETIRED_UOPS = 0x00

	EVENT_RETIRED_BRANCH_INSTR = 0xC2
	UMASK_RETIRED_BRANCH_INSTR = 0x00

	EVENT_RETIRED_MISP_BRANCH_INSTR = 0xC3
	UMASK_RETIRED_MISP_BRANCH_INSTR = 0x00

	EVENT_RETIRED_TAKEN_BRANCH_INSTR = 0xC4
	UMASK_RETIRED_TAKEN_BRANCH_INSTR = 0x00

	EVENT_RETIRED_TAKEN_MISP_BRANCH_INSTR = 0xC5
	UMASK_RETIRED_TAKEN_MISP_BRANCH_INSTR = 0x00

	EVENT_RETIRED_FAR_CONTROL_TRANSFERS = 0xC6
	UMASK_RETIRED_FAR_CONTROL_TRANSFERS = 0x00

	EVENT_RETIRED_BRANCH_RESYNCS = 0xC7
	UMASK_RETIRED_BRANCH_RESYNCS = 0x00

	EVENT_RETIRED_NEAR_RETURNS = 0xC8
	UMASK_RETIRED_NEAR_RETURNS = 0x00

	EVENT_RETIRED_NEAR_RETURNS_MISP = 0xC9
	UMASK_RETIRED_NEAR_RETURNS_MISP = 0x00

	EVENT_RETIRED_INDIRECT_BRANCHES_MISP = 0xCA
	UMASK_RETIRED_INDIRECT_BRANCHES_MISP = 0x00

	EVENT_RETIRED_MMX_FP_INSTR     = 0xCB
	UMASK_RETIRED_MMX_FP_INSTR_X87 = 0x01
	UMASK_RETIRED_MMX_FP_INSTR_MMX = 0x02
	UMASK_RETIRED_MMX_FP_INSTR_SSE = 0x04
	UMASK_RETIRED_MMX_FP_INSTR_ALL = 0x07

	EVENT_RETIRED_COND_BRANCH_INSTR = 0xD1
	UMASK_RETIRED_COND_BRANCH_INSTR = 0x00

	EVENT_RETIRED_COND_BRANCH_INSTR_MISP = 0xD2
	UMASK_RETIRED_COND_BRANCH_INSTR_MISP = 0x00

	EVENT_DIV_BUSY_CYCLES = 0xD3
	UMASK_DIV_BUSY_CYCLES = 0x00

	EVENT_DIV_OP_COUNT = 0xD4
	UMASK_DIV_OP_COUNT = 0x00

	EVENT_TAGGED_IBS_OPS                    = 0x1CF
	UMASK_TAGGED_IBS_OPS_COUNT              = 0x01
	UMASK_TAGGED_IBS_OPS_COUNT_RETIRED      = 0x02
	UMASK_TAGGED_IBS_OPS_IBS_COUNT_ROLLOVER = 0x04

	EVENT_RETIRED_FUSED_BRANCH_INSTR = 0x1D0
	UMASK_RETIRED_FUSED_BRANCH_INSTR = 0x00

	EVENT_REQUESTS_TO_L2_GRP1                   = 0x60
	UMASK_REQUESTS_TO_L2_GRP1_OTHER             = 0x01
	UMASK_REQUESTS_TO_L2_GRP1_L2_HW_PREF        = 0x02
	UMASK_REQUESTS_TO_L2_GRP1_PREF_L2           = 0x04
	UMASK_REQUESTS_TO_L2_GRP1_CHANGE_TO_X       = 0x08
	UMASK_REQUESTS_TO_L2_GRP1_CACHEABLE_IC_READ = 0x10
	UMASK_REQUESTS_TO_L2_GRP1_LS_RD_BLOCK_C_S   = 0x20
	UMASK_REQUESTS_TO_L2_GRP1_RD_BLOCK_X        = 0x40
	UMASK_REQUESTS_TO_L2_GRP1_RD_BLOCK_L        = 0x80
	UMASK_REQUESTS_TO_L2_GRP1_ALL               = 0xFF
	UMASK_REQUESTS_TO_L2_GRP1_ALL_NO_PF         = 0xF9
	UMASK_REQUESTS_TO_L2_GRP1_DATA_CACHE_MISS   = 0xC8

	EVENT_REQUESTS_TO_L2_GRP2                  = 0x61
	UMASK_REQUESTS_TO_L2_GRP2_BUS_LOCK_RESP    = 0x01
	UMASK_REQUESTS_TO_L2_GRP2_BUS_LOCK_ORIG    = 0x02
	UMASK_REQUESTS_TO_L2_GRP2_SMC_INVAL        = 0x04
	UMASK_REQUESTS_TO_L2_GRP2_IC_READ_SIZED_NC = 0x08
	UMASK_REQUESTS_TO_L2_GRP2_IC_READ_SIZED    = 0x10
	UMASK_REQUESTS_TO_L2_GRP2_LS_READ_SIZED_NC = 0x20
	UMASK_REQUESTS_TO_L2_GRP2_LS_READ_SIZED    = 0x40
	UMASK_REQUESTS_TO_L2_GRP2_GRP1             = 0x80
	UMASK_REQUESTS_TO_L2_GRP2_IC_READ          = 0x18

	EVENT_L2_LATENCY_CYCLES               = 0x62
	UMASK_L2_LATENCY_CYCLES_WAIT_ON_FILLS = 0x01

	EVENT_LS_TO_L2_WBC_REQUESTS                 = 0x63
	UMASK_LS_TO_L2_WBC_REQUESTS_CL_ZERO         = 0x01
	UMASK_LS_TO_L2_WBC_REQUESTS_LOCAL_IC_CLEAR  = 0x02
	UMASK_LS_TO_L2_WBC_REQUESTS_ZERO_BYTE_STORE = 0x04
	UMASK_LS_TO_L2_WBC_REQUESTS_I_LINE_FLUSH    = 0x08
	UMASK_LS_TO_L2_WBC_REQUESTS_CACHELINE_FLUSH = 0x10
	UMASK_LS_TO_L2_WBC_REQUESTS_WCB_CLOSE       = 0x20
	UMASK_LS_TO_L2_WBC_REQUESTS_WCB_WRITE       = 0x40
	UMASK_LS_TO_L2_WBC_REQUESTS_ALL             = 0x7F

	EVENT_CORE_TO_L2_CACHE_REQUESTS                     = 0x64
	UMASK_CORE_TO_L2_CACHE_REQUESTS_IC_FILL_MISS        = 0x01
	UMASK_CORE_TO_L2_CACHE_REQUESTS_IC_FILL_HIT_S       = 0x02
	UMASK_CORE_TO_L2_CACHE_REQUESTS_IC_FILL_HIT_X       = 0x04
	UMASK_CORE_TO_L2_CACHE_REQUESTS_LD_READ_BLK_C       = 0x08
	UMASK_CORE_TO_L2_CACHE_REQUESTS_LD_READ_BLK_X       = 0x10
	UMASK_CORE_TO_L2_CACHE_REQUESTS_LD_READ_BLK_L_HIT_S = 0x20
	UMASK_CORE_TO_L2_CACHE_REQUESTS_LD_READ_BLK_L_HIT_X = 0x40
	UMASK_CORE_TO_L2_CACHE_REQUESTS_LD_READ_BLK_CS      = 0x80

	EVENT_CYCLES_FILL_PEND_FROM_L2      = 0x6D
	UMASK_CYCLES_FILL_PEND_FROM_L2_BUSY = 0x01

	EVENT_L2_INST_CACHE_MISS = 0x64
	UMASK_L2_INST_CACHE_MISS = 0x01

	EVENT_L2_DATA_CACHE_MISS = 0x64
	UMASK_L2_DATA_CACHE_MISS = 0x08

	EVENT_L1_INST_MISS_L2_HIT = 0x64
	UMASK_L1_INST_MISS_L2_HIT = 0x06

	EVENT_L1_DATA_MISS_L2_HIT = 0x64
	UMASK_L1_DATA_MISS_L2_HIT = 0x70

	EVENT_L3_ACCESS = 0x01
	UMASK_L3_ACCESS = 0x80

	EVENT_L3_MISS = 0x06
	UMASK_L3_MISS = 0x01

	EVENT_RAPL_CORE_ENERGY = 0x01
	UMASK_RAPL_CORE_ENERGY = 0x00

	EVENT_RAPL_PKG_ENERGY = 0x02
	UMASK_RAPL_PKG_ENERGY = 0x00

	EVENT_DATA_FROM_LOCAL_DRAM_CHANNEL = 0x07
	UMASK_DATA_FROM_LOCAL_DRAM_CHANNEL = 0x38

	EVENT_DATA_TO_LOCAL_DRAM_CHANNEL = 0x47
	UMASK_DATA_TO_LOCAL_DRAM_CHANNEL = 0x38

	EVENT_DATA_OUT_TO_REMOTE_0 = 0x187
	UMASK_DATA_OUT_TO_REMOTE_0 = 0x02

	EVENT_DATA_OUT_TO_REMOTE_1 = 0x1C7
	UMASK_DATA_OUT_TO_REMOTE_1 = 0x02

	EVENT_DATA_OUT_TO_REMOTE_2 = 0x207
	UMASK_DATA_OUT_TO_REMOTE_2 = 0x02

	EVENT_DATA_OUT_TO_REMOTE_3 = 0x287
	UMASK_DATA_OUT_TO_REMOTE_3 = 0x02

	EVENT_DATA_OUT_TO_REMOTE_4 = 0x247
	UMASK_DATA_OUT_TO_REMOTE_4 = 0x02

	EVENT_DATA_OUT_TO_REMOTE_5 = 0x2C7
	UMASK_DATA_OUT_TO_REMOTE_5 = 0x02
)
