/* 
 * gpsk31  - PSK31 for Linux with a GTK+ Interface
 * 
 * Copyright (C) 2000 Luc Langehegermann, LX2GT
 * Copyright (C) 2008 Thomas Ries <tries@gmx.net>
 * Copyright (C) 2005,2006,2007,2008 Joop Stakenborg <pg4i@amsat.org>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * The main author can be reached at pg4i@amsat.org or by smail-mail:
 * Joop Stakenborg, Bramengaarde 24, 3992KG Houten, The Netherlands.
 * 
 */

/*
 * Misc Functions
 */

#include <time.h>
#include <stdio.h>
#include <gtk/gtk.h>
#include <math.h>
#include <string.h>
#include "misc.h"
#include "spectrum.h"
#include "main_screen.h"
#include "globals.h"
#include "server.h"
#include <unistd.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include "text.h"
#include "phasescope.h"
#include "menu.h"
#include "cfg.h"

int OPTnew;

extern int display_waterfall;	/* display - 0: spectrum, 1: waterfall */
extern int waterfall_colored;	/* 0 b/w, 1 color mode */
extern char configfile[];	/* explicit config file to be loaded */

gint				/* Will be called when we click on the spectrum */
  spectrum_motion_event (GtkWidget * widget, GdkEventMotion * event)
{				// Click on the spectrum
  GdkModifierType state;
  GdkEventType    type;
  int x;
  int know_button=0;
  float newfreq;
   
  type=event->type;

  if (event->is_hint) {
    int d1,d2;
    /* figure out the button pressed - if possible */
    gdk_window_get_pointer (event->window, &d1, &d2, &state);
    know_button=1;
  }  

  if ((know_button == 0) || 
      ((type == GDK_BUTTON_PRESS) && (state & GDK_BUTTON1_MASK))) {
    /* left button: set RX freq */
    x = (int) event->x;
    newfreq = spectrum_new_fc (x);
    commControl (COMM_RXCH, COMM_FREQ, (int) (100 * newfreq));
  } else if ((type == GDK_BUTTON_PRESS) && (state & GDK_BUTTON3_MASK)) {
    /* right button: toggle between Waterfall & spectrum */
     if (display_waterfall) {
       display_waterfall=0;
     } else {
       display_waterfall=1;
     }
  } else if ((type == GDK_BUTTON_PRESS) && (state & GDK_BUTTON2_MASK)) {
    /* middle click. toggle b/w - color waterfall */
    if (waterfall_colored) {
      waterfall_colored=0;
    } else {
      waterfall_colored=1;
    }
  }


  return 0;
}

gint display_time (gpointer data)	/* Displays the UTC-Date */
{
  char *c;
  c = get_time_string (NULL);
  gtk_statusbar_pop (GTK_STATUSBAR (statusbar.time), 1);
  gtk_statusbar_push (GTK_STATUSBAR (statusbar.time), 1, c);
  g_free (c);
  return TRUE;
}

/*
 * This function returns a pointer to the time string
 * YOU MUST FREE it
 */


gchar *
get_time_string (gchar * format)
{
  time_t calendar_time;
  struct tm *my_time;
  char time_string[50];

  calendar_time = time (0);
  my_time = gmtime (&calendar_time);
  if (format == NULL)
    strftime (time_string, 50, "%a, %d %b %H:%M:%Sz %Y", my_time);
  else
    strftime (time_string, 50, format, my_time);
  return g_strdup (time_string);
}

/*
 * This function parses the configuration file
 */

void
read_config ()
{
  char *home = getenv ("HOME");
  char conf[strlen (home) + 60];

  if (strlen(configfile) == 0)
  {
    strcpy (conf, home);
    strcat (conf, "/.gpsk31/gpsk31.cfg");
  }
  else
  {
    /* first try full path as specified */
    strcpy (conf, configfile);
    if (!g_file_test(conf, G_FILE_TEST_EXISTS))
    {
      /* not found, try again in $HOME/.gpsk31 */
      strcpy (conf, home);
      strcat (conf, "/.gpsk31/");
      strcat (conf, configfile);
    }
  }
  loadpreferences (conf);
}

/*
 * This function set all the things
 */

void
set_config ()
{
  int result = 0;
  static int server_started;
  phase_scope_init ();		/* Build the Phase Scope GCs */
  draw_arc ();			/* redraw the phase scope circle */
  if (server_started == 0)
    {
      server_started = 1;
      if (strlen (ini_settings.ptt_device) != 0)
	result = server_main (ini_settings.audio_device, ini_settings.ptt_device, DATADIR);	/* Start Server */
      else
	result = server_main (ini_settings.audio_device, NULL, DATADIR);
    }
  else
    g_print ("PSK31-Server already started!\n");
  if (result == -1) exit (1); /* bail out if server not started */
  spectrum_offset (ini_settings.freq);
  spectrum_setup ();		/* init the spectrum */
  if (ini_settings.spectrum_width == 0)	/* init fft */
    fft_setup (1024, ini_settings.spectrum_speed);
  else if (ini_settings.spectrum_width == 1)
    fft_setup (2048, ini_settings.spectrum_speed);
  else
    fft_setup (4096, ini_settings.spectrum_speed);
  commControl (COMM_TXCH, COMM_FREQ, 100 * ini_settings.freq);	/* TX Freq */
  commControl (COMM_RXCH, COMM_FREQ, 100 * ini_settings.freq);	/* RX Freq */
  gtk_spin_button_set_value (GTK_SPIN_BUTTON (main_screen.tx_freq), ini_settings.freq);	/* TX Freq spin button */


  gtk_adjustment_set_value (GTK_ADJUSTMENT (main_screen.dcd_adj),
			    (float) (ini_settings.dcd_level * -1));
  commControl (COMM_TXCH, COMM_LSB, ini_settings.lsb);	/* LSB */
  commControl (COMM_RXCH, COMM_LSB, ini_settings.lsb);
  OPTnew = ini_settings.new_rx;	/* Use new rx? */

	set_button (0);		/* set the buttons labels */
}

/*
 * This functions sets the label in the text-buttons
 */

void set_button (int x)
{
	int i;
	for (i = 0; i<= 7; ++i) {
		if (x == 0)
			gtk_label_set_text (GTK_LABEL
                        (GTK_BIN (main_screen.f_button[i])->child),
                        ini_settings.label[i]);
		else
			gtk_label_set_text (GTK_LABEL
                        (GTK_BIN (main_screen.f_button[i])->child),
                        ini_settings.label[i+8]);
	}
}

