# -*- coding: utf-8 -*-
"""
Tests checkers
"""

import doctest

import grass.gunittest.case
import grass.gunittest.main
import grass.gunittest.utils

import grass.pygrass.raster as pgrass


# doctest does not allow changing the base classes of test case, skip test case
# and test suite, so we need to create a new type which inherits from our class
# and contains doctest's methods
# the alternative is to copy 500 from doctest and change what is needed
# (this might be necessary anyway because of the reports and stdout and stderr)
doctest.DocFileCase = type('DocFileCase',
                           (grass.gunittest.case.TestCase,),
                           dict(doctest.DocFileCase.__dict__))
doctest.SkipDocTestCase = type('SkipDocTestCase',
                               (grass.gunittest.case.TestCase,),
                               dict(doctest.SkipDocTestCase.__dict__))


def load_tests(loader, tests, ignore):
    # TODO: this must be somewhere when doctest is called, not here
    # TODO: ultimate solution is not to use _ as a buildin in lib/python
    # for now it is the only place where it works
    grass.gunittest.utils.do_doctest_gettext_workaround()
    # this should be called at some top level

    from grass.pygrass.modules import Module
    Module("g.region", n=40, s=0, e=40, w=0, res=10)
    Module("r.mapcalc",
        expression="%s = row() + (10 * col())" % (pgrass.test_raster_name),
        overwrite=True)
    Module("r.support", map=pgrass.test_raster_name,
        title="A test map",
        history="Generated by r.mapcalc",
        description="This is a test map")
    cats = """11:A
            12:B
            13:C
            14:D
            21:E
            22:F
            23:G
            24:H
            31:I
            32:J
            33:K
            34:L
            41:M
            42:n
            43:O
            44:P"""
    Module("r.category", rules="-", map=pgrass.test_raster_name,
           stdin_=cats, separator=":")

    Module("r.mapcalc",
        expression="%s = row() + (10 * col())" % (pgrass.abstract.test_raster_name),
        overwrite=True)

    tests.addTests(doctest.DocTestSuite(pgrass))
    tests.addTests(doctest.DocTestSuite(pgrass.abstract))
    return tests


if __name__ == '__main__':
    grass.gunittest.main.test()
