/*
   +----------------------------------------------------------------------+
   | HipHop for PHP                                                       |
   +----------------------------------------------------------------------+
   | Copyright (c) 2010-present Facebook, Inc. (http://www.facebook.com)  |
   +----------------------------------------------------------------------+
   | This source file is subject to version 3.01 of the PHP license,      |
   | that is bundled with this package in the file LICENSE, and is        |
   | available through the world-wide-web at the following url:           |
   | http://www.php.net/license/3_01.txt                                  |
   | If you did not receive a copy of the PHP license and are unable to   |
   | obtain it through the world-wide-web, please send a note to          |
   | license@php.net so we can mail you a copy immediately.               |
   +----------------------------------------------------------------------+
*/
#include "hphp/runtime/vm/jit/minstr-helpers.h"

namespace HPHP { namespace jit { namespace MInstrHelpers {

//////////////////////////////////////////////////////////////////////

NEVER_INLINE
TypedValue arrayGetNotFound(int64_t k) {
  raise_notice("Undefined index: %" PRId64, k);
  return make_tv<KindOfNull>();
}

NEVER_INLINE
TypedValue arrayGetNotFound(const StringData* k) {
  raise_notice("Undefined index: %s", k->data());
  return make_tv<KindOfNull>();
}

//////////////////////////////////////////////////////////////////////

}}}
