#include <signal.h>
#include <unistd.h>

#include "signal_glue.h"

#include <VM.h>
#include <VMState.h>

Value** hlist = (Value**)GC_MALLOC_UNCOLLECTABLE(sizeof(Value*)*63);
VMState* ourvm;

void callHandler(int signo)
{
    signal(signo,callHandler);
    // Block all other signals while we're working.
    sigset_t blk;                 
    sigset_t sigsv;               

    sigfillset(&blk);             
    sigdelset(&blk,signo);       
    sigprocmask(SIG_BLOCK,&blk,&sigsv); /* Block sigs */

    VMState* vm = ourvm;
    Value* h = hlist[signo];
/*    cout << "Calling handler for signal " << signo << endl;
    cout << "Got handler " << h << endl;
    cout << "Got handler " << h->getRaw() << endl;*/
    PUSH(MKINT(0)); /* this temp value is for the return value (which of course gets DISCARDed) */
    PUSH(MKINT(signo));
    CALLFUN(h);
    
    sigprocmask(SIG_SETMASK,&sigsv,0);
}

void setHandler(void *vm, int signo, Value* handlerfn)
{
    struct sigaction sa_old;
    struct sigaction sa_new;

    sa_new.sa_handler = callHandler;    // Point to our function
    hlist[signo] = handlerfn; // Set it in our lookup table
    ourvm = (VMState*)vm;
//    cout << "Set handler to " << handlerfn << endl;
//    cout << "Set handler value to " << handlerfn->getRaw() << endl;

    sigemptyset(&sa_new.sa_mask);   // Clear mask
    sa_new.sa_flags = 0;            // No special flags
    sigaction(signo,&sa_new,&sa_old); // Set handler
}
