/***************************************************************************
 *   Copyright (C) 2008-2011 by Marcel Hasler                              *
 *   mahasler@gmail.com                                                    *
 *                                                                         *
 *   This file is part of KOSD.                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation, either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the          *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program. If not, see <http://www.gnu.org/licenses/>.  *
 ***************************************************************************/

#ifndef OSD_H
#define OSD_H

#include "kosd/kosd.h"

#include <QTimer>

#include <Plasma/Dialog>
#include <Plasma/Svg>

class Osd : protected Plasma::Dialog
{
public:
    Osd();
    virtual ~Osd();

    void setOpacity(unsigned char percent);
    void setPosition(unsigned char xPercent, unsigned char yPercent);
    void setPrimaryScreenLock(bool lock);
    void setTimeout(unsigned int milliseconds);

    QSize pixmapSize() const;

    void show(const QPixmap &pixmap, const QString &text, unsigned char percent);

protected:
    void mousePressEvent(QMouseEvent *event);

    virtual QSize requestedPixmapSize() const = 0;
    virtual void setContents(const QPixmap &pixmap, const QString &text, unsigned char percent) = 0;

private:
    void updatePosition();
    void show();

private:
    QTimer m_timer;
    qreal m_hPos, m_vPos;
    unsigned int m_timeout;
    bool m_lockPrimaryScreen;
};

#endif // OSD_H
