if(PKG_KSPACE)
  option(FFT_SINGLE "Use single precision FFTs instead of double precision FFTs" OFF)
  set(FFTW "FFTW3")
  if(FFT_SINGLE)
    set(FFTW "FFTW3F")
    add_definitions(-DFFT_SINGLE)
  endif()
  find_package(${FFTW} QUIET)
  if(${FFTW}_FOUND)
    set(FFT "FFTW3" CACHE STRING "FFT library for KSPACE package")
  else()
    set(FFT "KISS" CACHE STRING "FFT library for KSPACE package")
  endif()
  set(FFT_VALUES KISS FFTW3 MKL)
  set_property(CACHE FFT PROPERTY STRINGS ${FFT_VALUES})
  validate_option(FFT FFT_VALUES)
  string(TOUPPER ${FFT} FFT)

  if(FFT STREQUAL "FFTW3")
    find_package(${FFTW} REQUIRED)
    add_definitions(-DFFT_FFTW3)
    include_directories(${${FFTW}_INCLUDE_DIRS})
    list(APPEND LAMMPS_LINK_LIBS ${${FFTW}_LIBRARIES})
  elseif(FFT STREQUAL "MKL")
    find_package(MKL REQUIRED)
    add_definitions(-DFFT_MKL)
    include_directories(${MKL_INCLUDE_DIRS})
    list(APPEND LAMMPS_LINK_LIBS ${MKL_LIBRARIES})
  else()
    # last option is KISSFFT
    add_definitions(-DFFT_KISS)
  endif()

  set(FFT_PACK "array" CACHE STRING "Optimization for FFT")
  set(FFT_PACK_VALUES array pointer memcpy)
  set_property(CACHE FFT_PACK PROPERTY STRINGS ${FFT_PACK_VALUES})
  validate_option(FFT_PACK FFT_PACK_VALUES)
  if(NOT FFT_PACK STREQUAL "array")
    string(TOUPPER ${FFT_PACK} FFT_PACK)
    add_definitions(-DFFT_PACK_${FFT_PACK})
  endif()
endif()
