<?php
/*
# Copyright 2006, CRIM, Martin Rioux
#
# This file is part of the MILLE-XTERM distribution.
# See the MILLE-XTERM (english) and/or the MILLE (french) project web site
#
# http://www.revolutionlinux.com/mille-xterm/
# http://www.mille.ca/
#
# The MILLE-XTERM framework is covered by the GNU General Public License. See
# the COPYING file in the top-level MILLE-XTERM directory. Software packages
# that are included in the MILLE-XTERM distribution have their own licenses.
#
# -------------------------------------------------------------------------
*/
/**
 * This class manage printer list
 *
 * 23 mar 2006 - Martin Rioux
 * 23 avril 2007 - Pierre-Olivier A. Gauvin (CSDL)
 */


require_once 'dbFunctions.php';
require_once 'AttributeDef.php';

class PrintersListManager {

	var $isError;
	var $errors;

	function PrintersListManager() {
		/////////////////////////////
		// General construction
		////////////////////////////

		$this->isError = false;
		global $CONFIG;
		if( !is_null( $CONFIG['printer_servers'] ) ){
			$this->printerServers = $CONFIG['printer_servers'];
		} else {
			$this->printerServers = array();
		}
		/////////////////////////
		// Actions
		/////////////////////////

		//--- Synchronize ---//
		if( isset( $_POST['rem_printer'] ) && !empty( $_POST['on_server'] ) ){
			$this->rem_Printers( $_POST['on_server'] );
			$this->synchronizeList( array_keys( $_SESSION[ 'printerList' ] ) );
		}

		if( isset( $_POST['add_printer'] ) && !empty( $_POST['on_db'] ) ){
			$this->add_Printers( $_POST['on_db'] );
			$this->synchronizeList( array_keys( $_SESSION[ 'printerList' ] ) );
		}

		if ( isset ( $_POST['synchronize'] ) ) {
			if( isset( $_POST['printer_server'] ) ){
				$this->synchronizeList( $_POST['printer_server'] );
			} else {
				$_SESSION[ 'printerList' ] = array();
			}
		}

		//--- Ghost Printers ---//
		if( isset( $_POST['add_ghost_printer'] ) ){
			$this->add_Printers( array( $_POST['add_ghost_printer'] ) );
		}

		if( isset( $_POST['rem_ghost_printer'] ) ){
			$this->rem_Printers( $_POST['ghost_printer'] );
		}
		
		$_SESSION['ghost_printers'] = $this->getGhostPrinters();
	}

	// Adds a list of printers to Printer_List and Default_Printer
	function add_Printers( $printer_list ){
		$attributesDef_PL = $this->getPrintersID(); // Definition of the Printer_List Attribute
		$attributesDef_DP = $this->getDefaultPrintersID(); // Definition of the Default_Printer Attribute
		foreach( $printer_list as $printer ){
			$attributesDef_PL->insertDictValue( $printer );
			$attributesDef_DP->insertDictValue( $printer );
		}
	}

	// Removes a list of printers from Printer_List and Default_Printer
	function rem_Printers( $printer_list ){
		$attributesDef_PL = $this->getPrintersID(); // Definition of the Printer_List Attribute
		$attributesDef_DP = $this->getDefaultPrintersID(); // Definition of the Default_Printer Attribute
		foreach( $printer_list as $printer ){
			$attributesDef_PL->deleteDictValue( $printer );
			$attributesDef_DP->deleteDictValue( $printer );
		}
	}

	// Returns the ID used in the BD to designate Printers
	function getPrintersID(){
		$attributesDef = new AttributeDef("static");
		$printerListId = $attributesDef->getFromDB("id","name='LDM_PRINTER_LIST'");
		$attributesDef = new AttributeDef($printerListId["id"]);
		return $attributesDef;
	}

	// Returns the ID used in the DB to designate Default Printers
	function getDefaultPrintersID(){
		$attributesDef = new AttributeDef("static");
		$printerListId = $attributesDef->getFromDB("id","name='LDM_PRINTER_DEFAULT'");
		$attributesDef = new AttributeDef($printerListId["id"]);
		return $attributesDef;
	}

	// Returns the Printers from a specific Server
	function getPrintersFromServer( $printerServer ){
		$tmp_printers = "";
		$ping = substr( trim( shell_exec("ping -c 1 -w 3 ".$printerServer." ; echo $?") ), -1, 1 );
		switch( $ping ){
			case "0" :
				$tmp_printers = shell_exec('lpstat -h '.$printerServer. ' -U root -a|cut -d" " -f1');
				break;
			case "1" :
				$this->errors[$printerServer] = getMessage('printer_no_server');
				break;
			default :
				$this->errors[$printerServer] = getMessage('printer_dead_server');
				break;
		}
		return explode("\n",trim($tmp_printers));
	}

	// This function gets all the printers that are floating around without being attached to a server
	function getGhostPrinters(){
		$ghost_printers = $printersFromServer = array();
		// First, we get all the printers from the servers
		foreach( $this->printerServers as $printerServer ){
			$printersFromServer = $this->getPrintersFromServer( $printerServer );
			if(!empty($previous_printers) && !empty($printersFromServer)){
				$printersFromServer = array_merge($previous_printers,$printersFromServer);
			}
			$previous_printers = $printersFromServer;
		}

		// Then, we get all the printers from the database
		$attributesDef = $this->getPrintersID();
		$databaseValues = $attributesDef->getFromDB("value","attributesdef_id=".$attributesDef->def_id,"attributesdefdict",true,true);
		if( !is_null( $databaseValues ) ){
			foreach( $databaseValues as $printer ){
				// If a computer is in the database but not on the servers, it's a ghost
				if( !in_array( $printer['value'], $printersFromServer ) ){
					$ghost_printers[] = $printer['value'];
				}
			}
		}
		return $ghost_printers;
	}

	function synchronizeList( $serverList ) {
		// Step 1 : Get all printers from the Dictionary
		$_SESSION[ 'printerList' ] = $printerDict = array();
		$attributesDef = $this->getPrintersID();
		$printersFromDatabase = $attributesDef->getFromDB("value","attributesdef_id=".$attributesDef->def_id,"attributesdefdict",true,true);
		if( !is_null( $printersFromDatabase ) ){
			foreach($printersFromDatabase as $printerName){
				$printerDict[] = $printerName['value'];
			}
		}
		// Step 2 : Get the printer's server
		foreach( $serverList as $printerServer ){
			// Step 3 : Get their printers
			$_SESSION[ 'printerList' ][ $printerServer ][ 'onServer' ] = $_SESSION[ 'printerList' ][ $printerServer ][ 'onDB' ] = array();
			$printersFromServer = $this->getPrintersFromServer( $printerServer );
			// Step 4 : For each priner, look if the printers have already been put in the DB (have been synchronized)
			foreach( $printersFromServer as $printer ){
				if( stripos( urlencode( $printer ), "%09" ) === false ){
					if( !in_array( $printer, $printerDict ) ){
						$_SESSION[ 'printerList' ][ $printerServer ][ 'onServer' ][] = $printer;
					} else {
						$_SESSION[ 'printerList' ][ $printerServer ][ 'onDB' ][] = $printer;
					}
				}
			}
		}

		/* ** PREVIOUS CODE **
		//$tmp_printers = shell_exec('lpstat -a|cut -d" " -f1');
		//$printersFromServer = explode("\n",trim($tmp_printers)); 
		foreach( $this->printerServers as $printerServer ){
			$tmp_printers = shell_exec('lpstat -h '.$printerServer. ' -a|cut -d" " -f1');
			$printersFromServer = explode("\n",trim($tmp_printers));
			if(!empty($previous_printers) && !empty($printersFromServer)){
				$printersFromServer = array_merge($previous_printers,$printersFromServer);
			}
			$previous_printers=$printersFromServer;
		}
		$attributesDef = new AttributeDef("static");
		$printerListId = $attributesDef->getFromDB("id","name='LDM_PRINTER_LIST'");
		$attributesDef = new AttributeDef($printerListId["id"]);
		$printersInDatabase = $attributesDef->getFromDB("value","attributesdef_id=".$printerListId['id'],"attributesdefdict",true,true);
		foreach($printersInDatabase as $printerName){
			$printerNames[] = $printerName['value'];
		}
		foreach($printersFromServer as $newPrinter){
			if(!in_array($newPrinter,$printerNames)){
				$error = $attributesDef->insertDictValue($newPrinter);
				if(strlen($error)>1){
					$this->errors[] = $error;
				}
			}
		}
		//Print succes in error
		if(!$this->errors){
			$this->errors[] = "Succes";
		}
		*/
	}

	function isError() {
		return $this->isError;
	}

	function printErrors() {
		if (isset ($this->errors[0])){
			print "<p style='color : red; font-size : smaller;'>\n";
			foreach ($this->errors as $error) {
				print $error . "<br>\n";
			}
			print "</p>\n";
		}
	}

	function printView() {
		if ($this->isError) {
			$this->printErrors();
			return;
		}
		include 'printersListManagerView.php';
	}

}
?>
