#include "pdf/pilot.h"
c ---------------------------------------------------------------------
      double precision function faux5L(ifl,x,q)
c auxiliary function for parametrization of CTEQ5L (J. Pumplin 9/99).
c ---------------------------------------------------------------------
#include "pdf/impdp.inc"
      integer ifl

      parameter (nex=8, nlf=2)
      dimension am(0:nex,0:nlf,-5:2)
      dimension alfvec(-5:2), qmavec(-5:2)
      dimension mexvec(-5:2), mlfvec(-5:2)
      dimension ut1vec(-5:2), ut2vec(-5:2)
      dimension af(0:nex)

      data mexvec( 2) / 8 /
      data mlfvec( 2) / 2 /
      data ut1vec( 2) /  0.4971265E+01 /
      data ut2vec( 2) / -0.1105128E+01 /
      data alfvec( 2) /  0.2987216E+00 /
      data qmavec( 2) /  0.0000000E+00 /
      data (am( 0,k, 2),k=0, 2)
     & /  0.5292616E+01, -0.2751910E+01, -0.2488990E+01 /
      data (am( 1,k, 2),k=0, 2)
     & /  0.9714424E+00,  0.1011827E-01, -0.1023660E-01 /
      data (am( 2,k, 2),k=0, 2)
     & / -0.1651006E+02,  0.7959721E+01,  0.8810563E+01 /
      data (am( 3,k, 2),k=0, 2)
     & / -0.1643394E+02,  0.5892854E+01,  0.9348874E+01 /
      data (am( 4,k, 2),k=0, 2)
     & /  0.3067422E+02,  0.4235796E+01, -0.5112136E+00 /
      data (am( 5,k, 2),k=0, 2)
     & /  0.2352526E+02, -0.5305168E+01, -0.1169174E+02 /
      data (am( 6,k, 2),k=0, 2)
     & / -0.1095451E+02,  0.3006577E+01,  0.5638136E+01 /
      data (am( 7,k, 2),k=0, 2)
     & / -0.1172251E+02, -0.2183624E+01,  0.4955794E+01 /
      data (am( 8,k, 2),k=0, 2)
     & /  0.1662533E-01,  0.7622870E-02, -0.4895887E-03 /

      data mexvec( 1) / 8 /
      data mlfvec( 1) / 2 /
      data ut1vec( 1) /  0.2612618E+01 /
      data ut2vec( 1) / -0.1258304E+06 /
      data alfvec( 1) /  0.3407552E+00 /
      data qmavec( 1) /  0.0000000E+00 /
      data (am( 0,k, 1),k=0, 2)
     & /  0.9905300E+00, -0.4502235E+00,  0.1624441E+00 /
      data (am( 1,k, 1),k=0, 2)
     & /  0.8867534E+00,  0.1630829E-01, -0.4049085E-01 /
      data (am( 2,k, 1),k=0, 2)
     & /  0.8547974E+00,  0.3336301E+00,  0.1371388E+00 /
      data (am( 3,k, 1),k=0, 2)
     & /  0.2941113E+00, -0.1527905E+01,  0.2331879E+00 /
      data (am( 4,k, 1),k=0, 2)
     & /  0.3384235E+02,  0.3715315E+01,  0.8276930E+00 /
      data (am( 5,k, 1),k=0, 2)
     & /  0.6230115E+01,  0.3134639E+01, -0.1729099E+01 /
      data (am( 6,k, 1),k=0, 2)
     & / -0.1186928E+01, -0.3282460E+00,  0.1052020E+00 /
      data (am( 7,k, 1),k=0, 2)
     & / -0.8545702E+01, -0.6247947E+01,  0.3692561E+01 /
      data (am( 8,k, 1),k=0, 2)
     & /  0.1724598E-01,  0.7120465E-02,  0.4003646E-04 /

      data mexvec( 0) / 8 /
      data mlfvec( 0) / 2 /
      data ut1vec( 0) / -0.4656819E+00 /
      data ut2vec( 0) / -0.2742390E+03 /
      data alfvec( 0) /  0.4491863E+00 /
      data qmavec( 0) /  0.0000000E+00 /
      data (am( 0,k, 0),k=0, 2)
     & /  0.1193572E+03, -0.3886845E+01, -0.1133965E+01 /
      data (am( 1,k, 0),k=0, 2)
     & / -0.9421449E+02,  0.3995885E+01,  0.1607363E+01 /
      data (am( 2,k, 0),k=0, 2)
     & /  0.4206383E+01,  0.2485954E+00,  0.2497468E+00 /
      data (am( 3,k, 0),k=0, 2)
     & /  0.1210557E+03, -0.3015765E+01, -0.1423651E+01 /
      data (am( 4,k, 0),k=0, 2)
     & / -0.1013897E+03, -0.7113478E+00,  0.2621865E+00 /
      data (am( 5,k, 0),k=0, 2)
     & / -0.1312404E+01, -0.9297691E+00, -0.1562531E+00 /
      data (am( 6,k, 0),k=0, 2)
     & /  0.1627137E+01,  0.4954111E+00, -0.6387009E+00 /
      data (am( 7,k, 0),k=0, 2)
     & /  0.1537698E+00, -0.2487878E+00,  0.8305947E+00 /
      data (am( 8,k, 0),k=0, 2)
     & /  0.2496448E-01,  0.2457823E-02,  0.8234276E-03 /

      data mexvec(-1) / 8 /
      data mlfvec(-1) / 2 /
      data ut1vec(-1) /  0.3862583E+01 /
      data ut2vec(-1) / -0.1265969E+01 /
      data alfvec(-1) /  0.2457668E+00 /
      data qmavec(-1) /  0.0000000E+00 /
      data (am( 0,k,-1),k=0, 2)
     & /  0.2647441E+02,  0.1059277E+02, -0.9176654E+00 /
      data (am( 1,k,-1),k=0, 2)
     & /  0.1990636E+01,  0.8558918E-01,  0.4248667E-01 /
      data (am( 2,k,-1),k=0, 2)
     & / -0.1476095E+02, -0.3276255E+02,  0.1558110E+01 /
      data (am( 3,k,-1),k=0, 2)
     & / -0.2966889E+01, -0.3649037E+02,  0.1195914E+01 /
      data (am( 4,k,-1),k=0, 2)
     & / -0.1000519E+03, -0.2464635E+01,  0.1964849E+00 /
      data (am( 5,k,-1),k=0, 2)
     & /  0.3718331E+02,  0.4700389E+02, -0.2772142E+01 /
      data (am( 6,k,-1),k=0, 2)
     & / -0.1872722E+02, -0.2291189E+02,  0.1089052E+01 /
      data (am( 7,k,-1),k=0, 2)
     & / -0.1628146E+02, -0.1823993E+02,  0.2537369E+01 /
      data (am( 8,k,-1),k=0, 2)
     & / -0.1156300E+01, -0.1280495E+00,  0.5153245E-01 /

      data mexvec(-2) / 7 /
      data mlfvec(-2) / 2 /
      data ut1vec(-2) /  0.1895615E+00 /
      data ut2vec(-2) / -0.3069097E+01 /
      data alfvec(-2) /  0.5293999E+00 /
      data qmavec(-2) /  0.0000000E+00 /
      data (am( 0,k,-2),k=0, 2)
     & / -0.6556775E+00,  0.2490190E+00,  0.3966485E-01 /
      data (am( 1,k,-2),k=0, 2)
     & /  0.1305102E+01, -0.1188925E+00, -0.4600870E-02 /
      data (am( 2,k,-2),k=0, 2)
     & / -0.2371436E+01,  0.3566814E+00, -0.2834683E+00 /
      data (am( 3,k,-2),k=0, 2)
     & / -0.6152826E+01,  0.8339877E+00, -0.7233230E+00 /
      data (am( 4,k,-2),k=0, 2)
     & / -0.8346558E+01,  0.2892168E+01,  0.2137099E+00 /
      data (am( 5,k,-2),k=0, 2)
     & /  0.1279530E+02,  0.1021114E+00,  0.5787439E+00 /
      data (am( 6,k,-2),k=0, 2)
     & /  0.5858816E+00, -0.1940375E+01, -0.4029269E+00 /
      data (am( 7,k,-2),k=0, 2)
     & / -0.2795725E+02, -0.5263392E+00,  0.1290229E+01 /

      data mexvec(-3) / 7 /
      data mlfvec(-3) / 2 /
      data ut1vec(-3) /  0.3753257E+01 /
      data ut2vec(-3) / -0.1113085E+01 /
      data alfvec(-3) /  0.3713141E+00 /
      data qmavec(-3) /  0.0000000E+00 /
      data (am( 0,k,-3),k=0, 2)
     & /  0.1580931E+01, -0.2273826E+01, -0.1822245E+01 /
      data (am( 1,k,-3),k=0, 2)
     & /  0.2702644E+01,  0.6763243E+00,  0.7231586E-02 /
      data (am( 2,k,-3),k=0, 2)
     & / -0.1857924E+02,  0.3907500E+01,  0.5850109E+01 /
      data (am( 3,k,-3),k=0, 2)
     & / -0.3044793E+02,  0.2639332E+01,  0.5566644E+01 /
      data (am( 4,k,-3),k=0, 2)
     & / -0.4258011E+01, -0.5429244E+01,  0.4418946E+00 /
      data (am( 5,k,-3),k=0, 2)
     & /  0.3465259E+02, -0.5532604E+01, -0.4904153E+01 /
      data (am( 6,k,-3),k=0, 2)
     & / -0.1658858E+02,  0.2923275E+01,  0.2266286E+01 /
      data (am( 7,k,-3),k=0, 2)
     & / -0.1149263E+02,  0.2877475E+01, -0.7999105E+00 /

      data mexvec(-4) / 7 /
      data mlfvec(-4) / 2 /
      data ut1vec(-4) /  0.4400772E+01 /
      data ut2vec(-4) / -0.1356116E+01 /
      data alfvec(-4) /  0.3712017E-01 /
      data qmavec(-4) /  0.1300000E+01 /
      data (am( 0,k,-4),k=0, 2)
     & / -0.8293661E+00, -0.3982375E+01, -0.6494283E-01 /
      data (am( 1,k,-4),k=0, 2)
     & /  0.2754618E+01,  0.8338636E+00, -0.6885160E-01 /
      data (am( 2,k,-4),k=0, 2)
     & / -0.1657987E+02,  0.1439143E+02, -0.6887240E+00 /
      data (am( 3,k,-4),k=0, 2)
     & / -0.2800703E+02,  0.1535966E+02, -0.7377693E+00 /
      data (am( 4,k,-4),k=0, 2)
     & / -0.6460216E+01, -0.4783019E+01,  0.4913297E+00 /
      data (am( 5,k,-4),k=0, 2)
     & /  0.3141830E+02, -0.3178031E+02,  0.7136013E+01 /
      data (am( 6,k,-4),k=0, 2)
     & / -0.1802509E+02,  0.1862163E+02, -0.4632843E+01 /
      data (am( 7,k,-4),k=0, 2)
     & / -0.1240412E+02,  0.2565386E+02, -0.1066570E+02 /

      data mexvec(-5) / 6 /
      data mlfvec(-5) / 2 /
      data ut1vec(-5) /  0.5562568E+01 /
      data ut2vec(-5) / -0.1801317E+01 /
      data alfvec(-5) /  0.4952010E-02 /
      data qmavec(-5) /  0.4500000E+01 /
      data (am( 0,k,-5),k=0, 2)
     & / -0.6031237E+01,  0.1992727E+01, -0.1076331E+01 /
      data (am( 1,k,-5),k=0, 2)
     & /  0.2933912E+01,  0.5839674E+00,  0.7509435E-01 /
      data (am( 2,k,-5),k=0, 2)
     & / -0.8284919E+01,  0.1488593E+01, -0.8251678E+00 /
      data (am( 3,k,-5),k=0, 2)
     & / -0.1925986E+02,  0.2805753E+01, -0.3015446E+01 /
      data (am( 4,k,-5),k=0, 2)
     & / -0.9480483E+01, -0.9767837E+00, -0.1165544E+01 /
      data (am( 5,k,-5),k=0, 2)
     & /  0.2193195E+02, -0.1788518E+02,  0.9460908E+01 /
      data (am( 6,k,-5),k=0, 2)
     & / -0.1327377E+02,  0.1201754E+02, -0.6277844E+01 /

      if(q .le. qmavec(ifl)) then
         faux5L = 0.d0
         return
      endif

      if(x .ge. 1.d0) then
         faux5L = 0.d0
         return
      endif

      tmp = log(q/alfvec(ifl))
      if(tmp .le. 0.d0) then
         faux5L = 0.d0
         return
      endif

      sb = log(tmp)
      sb1 = sb - 1.2d0
      sb2 = sb1*sb1

      do i = 0, nex
         af(i) = 0.d0
         sbx = 1.d0
         do k = 0, mlfvec(ifl)
            af(i) = af(i) + sbx*am(i,k,ifl)
            sbx = sb1*sbx
         enddo
      enddo

      y = -log(x)
      u = log(x/0.00001d0)

      part1 = af(1)*y**(1.d0+0.01d0*af(4))*(1.d0+ af(8)*u)
      part2 = af(0)*(1.d0 - x) + af(3)*x 
      part3 = x*(1.d0-x)*(af(5)+af(6)*(1.d0-x)+af(7)*x*(1.d0-x))
      part4 = ut1vec(ifl)*log(1.d0-x) + 
     &	      AF(2)*log(1.d0+exp(ut2vec(ifl))-x)

      faux5L = exp(log(x) + part1 + part2 + part3 + part4)

c include threshold factor...
      faux5L = faux5L * (1.d0 - qmavec(ifl)/q)

      return
      end
