#!/usr/bin/python

from re import MULTILINE, escape, finditer, findall, search, sub
from sys import argv

if len(argv) not in (2, 3):
    raise SystemExit("Usage: %s INPUT [OUTPUT]" % argv[0])

# Read lcov report in one go.
report = file(argv[1]).read()

# Ignore deleting destructor if the base or the complete object destructor
# was called. There should be switch in lcov to filter them automatically.
for match in finditer(r'^FNDA:0,(\w+)D0Ev$', report, MULTILINE):
    dtor_name = match.group(1)
    pattern = r'^FNDA:[1-9][0-9]*,%sD[12]Ev$' % escape(dtor_name)

    if search(pattern, report, MULTILINE):
        pattern = r'^FN(?:DA)?:[0-9]+,%sD0Ev\n' % escape(dtor_name)
        report = sub(pattern, '', report, flags=MULTILINE)

# Write patched lcov report in one go.
file(argv[-1], 'w').write(report)
