/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

// File TextLine.h
// Baudouin Raoult - ECMWF Jul 99

#ifndef IconHelp_H
#define IconHelp_H

#ifndef UIIconHelp_H
#include "UIIconHelp.h"
#endif
#ifndef HelpFactory_H
#include "HelpFactory.h"
#endif
#ifndef RequestPanelHelp_H
#include "RequestPanelHelp.h"
#endif

#ifndef UIIconHelp_H
#include "UIIconHelp.h"
#endif

#include <string>
using std::string;

#ifndef FolderViewer_H
#include "FolderViewer.h"
#endif

class IconHelp: public XHelp<UIIconHelp_c>, public FolderViewer {
public:

// -- Contructors

	IconHelp(Widget, RequestPanel&, const Parameter&);

// -- Destructor

	virtual ~IconHelp(); 

private:

// No copy allowed

	IconHelp(const IconHelp&);
	IconHelp& operator=(const IconHelp&);

// -- Members

	vector<string> classes_;

// -- Overridden methods

	// from UIIconHelp_c

	virtual void deleteCB( Widget, XtPointer );
	virtual void editCB( Widget, XtPointer );
	virtual void folderCB( Widget, XtPointer );
	virtual void newIconCB( Widget, XtPointer );
	
	// From DragWindow

	virtual Widget menu();
	virtual bool dropCopy() { return true; }

	// From FolderViewer
	
	virtual bool accept(IconObject*);   
	virtual bool fill(int);

};

#endif
