# Contributing

Material for MkDocs is an actively maintained and constantly evolving project
serving a diverse user base with versatile backgrounds and needs. In order to
efficiently address the requirements of all our users, evaluate change requests,
and fix bugs, we put in a lot of work.

Our ever-growing community includes many active users, who open new
issues and discussions several times a day, evolving our [issue tracker] and
[discussion board] into a knowledge base – an important addition to
our [documentation] – yielding value to both new and experienced users.

  [discussion board]: https://github.com/squidfunk/mkdocs-material/discussions
  [issue tracker]: https://github.com/squidfunk/mkdocs-material/issues
  [documentation]: https://squidfunk.github.io/mkdocs-material/

## How you can contribute

We understand that reporting bugs, raising change requests, as well as engaging
in discussions can be time-consuming, which is why we've carefully optimized our
issue templates and defined guidelines to improve the overall interaction
within the project. We've invested a lot of time and effort into making our
[issue tracker] and [discussion board] as efficient as possible.

Our goal is to ensure that our documentation, as well as issue tracker and
discussion board, are __well-structured__, __easy to navigate__, and
__searchable__, so you can find what you need quickly and efficiently. Thus,
when you follow our guidelines, we can help you much faster.

In this section, we guide your through our processes.

### Creating an issue

<div class="grid cards" markdown>

-   :material-bug-outline: &nbsp;
    __Something is not working?__

    ---

    Report a bug in Material for MkDocs by creating an issue with a
    reproduction

    ---

    [:octicons-arrow-right-24: Report a bug][report a bug]

-   :material-file-document-remove-outline: &nbsp;
    __Missing information in our docs?__

    ---

    Report missing information or potential inconsistencies in our
    documentation

    ---

    [:octicons-arrow-right-24: Report a docs issue][report a docs issue]

-   :material-lightbulb-on-20: &nbsp;
    __Want to submit an idea?__

    ---

    Propose a change, feature request, or suggest an improvement

    ---

    [:octicons-arrow-right-24: Request a change][request a change]

-   :material-account-question-outline: &nbsp;
    __Have a question or need help?__

    ---

    Ask a question on our [discussion board] and get in touch with our
    community

    ---

    [:octicons-arrow-right-24: Ask a question][discussion board]

</div>

### Contributing

<div class="grid cards" markdown>

-   :material-translate: &nbsp;
    __Missing support for your language?__

    ---

    Add or improve translations for a new or already supported language

    ---

    [:octicons-arrow-right-24: Add translations][add translations]

-   :material-source-pull: &nbsp;
    __Want to create a pull request?__

    ---

    Learn how to create a comprehensive and useful pull request (PR)

    ---

    [:octicons-arrow-right-24: Create a pull request][create a pull request]

</div>

  [report a bug]: reporting-a-bug.md
  [report a docs issue]: reporting-a-docs-issue.md
  [request a change]: requesting-a-change.md
  [add translations]: https://github.com/squidfunk/mkdocs-material/adding-translations
  [create a pull request]: https://github.com/squidfunk/mkdocs-material/pulls

## Checklist

Before interacting within the project, please take a moment to consider the
following questions. By doing so, you can ensure that you are using the correct
issue template and that you provide all necessary information when interacting
with our community.

!!! warning "Issues, discussions, and comments are forever"

    Please note that everything you write is permanent and will remain
    for everyone to read – forever. Therefore, please always be nice and
    constructive, follow our contribution guidelines, and comply with our
    [Code of Conduct].

### Before creating an issue

- Are you using the appropriate issue template, or is there another issue
  template that better fits the context of your request?

- Have you checked if a similar bug report or change request has already been
  created, or have you stumbled upon something that might be related?

- Did your fill out every field as requested and did you provide all additional
  information we maintainers need to comprehend your request?

### Before asking a question

- Is the topic a question for our [discussion board], or is it a bug report or
  change request that should better be raised on our [issue tracker]?

- Is there an open discussion on the topic of your request? If the answer is yes,
  does your question match the direction of the discussion, or should you open a
  new discussion?

- Did your provide our community with all the necessary information to
  understand your question and help you quickly, or can you make it easier to
  help you?

### Before commenting

- Is your comment relevant to the topic of the current page, post, issue, or
  discussion, or is it a better idea to create a new issue or discussion?

- Does your comment add value to the conversation? Is it constructive and
  respectful to our community and us maintainers? Could you just use a
  [:octicons-smiley-16: reaction][reaction] instead?

  [Code of Conduct]: https://github.com/squidfunk/mkdocs-material/blob/master/CODE_OF_CONDUCT.md
  [reaction]: https://github.blog/2016-03-10-add-reactions-to-pull-requests-issues-and-comments/

## Rights and responsibilities

As maintainers, we reserve the right and have the responsibility to close,
remove, reject, or edit contributions, such as issues, discussions, comments,
or commits, that do not align with our contribution guidelines and our
[Code of Conduct].

### Incomplete issues

We have invested significant time in reviewing our contribution process and
carefully assessed the essential requirements when reviewing and responding to
issues. Each field in our issue templates has been thoughtfully curated, helping
us to understand your matter.

__Therefore, it is mandatory to fill out every field as requested__ to the best
of your knowledge. We need all of this information because it ensures that every
user and maintainer, regardless of their experience, can understand the content
and severity of your bug report or change request.

__We reserve the right to close issues missing essential information__, such as
but not limited to [minimal reproductions], or that do not comply with the
quality standards and requirements stated in our issue templates. Issues
can be reopened once the missing information has been provided.

  [minimal reproductions]: ../guides/creating-a-reproduction.md

### Code of Conduct

As stated in our [Code of Conduct], we expect all members of our community to
treat each other with respect, and use inclusive and welcoming language. We
always strive to create a positive and supportive environment and do not accept
inappropriate, offensive, or harmful behavior.

We take violations seriously and will take appropriate action in response.
