/* 
  Copyright (C) 2008 Jan Friederich, Steffen Basting

        This file is part of mmpong.

        mmpong is free software: you can redistribute it and/or modify
        it under the terms of the GNU General Public License as published by
        the Free Software Foundation, either version 3 of the License, or
        (at your option) any later version.

        mmpong is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU General Public License for more details.

        You should have received a copy of the GNU General Public License
        along with mmpong.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <math.h>
#include "padround.h"

#define BOW 0.2f 	// circle: 1.0, flat: 0.0f


EXPORT int round_padprofile(where, ball)
const float where[2];
struct gameball *ball;
{
	// the circle is centered behind the middle of the paddle
	float n[2], scp;
	n[0] = (ball->pos[0] > 0.5f ? -1.f : 1.f) * cosf(M_PI * BOW * (where[1]-0.5f));
	n[1] = sinf(M_PI * BOW * (where[1]-0.5f));

	// Compute n * dir
	int idx;
	for (idx= 0, scp= 0; idx <= 1; idx++)
		scp+= n[idx] * ball->dir[idx];
	for (idx= 0; idx <= 1; idx++)
		ball->dir[idx]-= 2.f * scp * n[idx];
	return PONG_SUCCESS;
}

