/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.sax;

import com.jclark.xsl.sax.OutputStreamConverter;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class TextOutputHandler
implements DocumentHandler,
OutputStreamConverter {
    private Writer writer;
    private OutputStream out;
    private UsemapCharacterHandler first_map = null;
    private CharacterHandler characterHandler;
    private final CharacterHandler noCharacterHandler = new CharacterHandler();
    private final CharacterHandler defaultCharacterHandler = new DefaultCharacterHandler();
    private final EnterCharacterHandler enterCharacterHandler = new EnterCharacterHandler();
    private static final int ContextNone = 0;
    private static final int ContextDocument = 1;
    private static final int ContextDefmap = 2;
    private static final int ContextEnter = 3;
    private int context;
    private UsemapCharacterHandler defmap;
    private CharacterHandler[] stack = new CharacterHandler[100];
    private int depth = 0;
    private TrailEntry trail_top;

    public TextOutputHandler() {
        this.characterHandler = this.noCharacterHandler;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        try {
            this.characterHandler.characters(cArray, n, n2);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void endDocument() throws SAXException {
        try {
            this.writer.close();
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void endElement(String string) throws SAXException {
        if (string.equals("document")) {
            this.context = 0;
        } else if (string.equals("enter")) {
            this.enterCharacterHandler.endDefinition();
            this.context = 2;
        } else {
            this.context = 1;
        }
        if (string.equals("alias")) {
            this.untrail();
        } else {
            this.pop();
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        this.characters(cArray, n, n2);
    }

    private UsemapCharacterHandler lookup(String string) throws SAXException {
        UsemapCharacterHandler usemapCharacterHandler = this.first_map;
        while (usemapCharacterHandler != null) {
            if (usemapCharacterHandler.name == string) {
                return usemapCharacterHandler.deref();
            }
            usemapCharacterHandler = usemapCharacterHandler.next;
        }
        throw new SAXException("no such map: " + string);
    }

    void pop() {
        this.characterHandler = this.stack[--this.depth];
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        throw new SAXException("processing instructions not allowed: <?" + string + " " + string2 + "?>");
    }

    void push(CharacterHandler characterHandler) {
        if (this.depth >= this.stack.length) {
            CharacterHandler[] characterHandlerArray = new CharacterHandler[2 * this.stack.length];
            System.arraycopy(this.stack, 0, characterHandlerArray, 0, this.stack.length);
            this.stack = characterHandlerArray;
        }
        this.stack[this.depth++] = this.characterHandler;
        this.characterHandler = characterHandler;
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void setOutputStream(OutputStream outputStream) {
        this.out = outputStream;
    }

    public void startDocument() {
        this.writer = new BufferedWriter(new OutputStreamWriter(this.out));
        this.context = 0;
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        if (string.equals("document")) {
            if (this.context != 0) {
                throw new SAXException("element not allowed here: document");
            }
            this.context = 1;
            this.push(this.defaultCharacterHandler);
        } else if (string.equals("defmap")) {
            if (this.context != 1) {
                throw new SAXException("element not allowed here: defmap");
            }
            String string2 = attributeList.getValue("name");
            if (string == null) {
                throw new SAXException("defmap: name attribute mandatory");
            }
            this.context = 2;
            this.defmap = new UsemapCharacterHandler(string2);
            this.defmap.record();
            this.push(this.noCharacterHandler);
        } else if (string.equals("enter")) {
            if (this.context != 2) {
                throw new SAXException("element not allowed here: enter");
            }
            String string3 = attributeList.getValue("char");
            if (string3 == null) {
                throw new SAXException("enter: char attribute mandatory");
            }
            if (string3.length() != 1) {
                throw new SAXException("enter: char attribute value must be string of length 1");
            }
            this.enterCharacterHandler.beginDefinition(string3.charAt(0));
            this.push(this.enterCharacterHandler);
        } else if (string.equals("usemap")) {
            if (this.context != 1) {
                throw new SAXException("element not allowed here: usemap");
            }
            String string4 = attributeList.getValue("name");
            this.push(string4 == null || string4.length() == 0 ? this.defaultCharacterHandler : this.lookup(string4));
        } else if (string.equals("alias")) {
            if (this.context != 1) {
                throw new SAXException("element not allowed here: alias");
            }
            String string5 = attributeList.getValue("from");
            if (string5 == null) {
                throw new SAXException("alias: from attribute mandatory");
            }
            String string6 = attributeList.getValue("to");
            if (string6 == null) {
                throw new SAXException("alias: to attribute mandatory");
            }
            UsemapCharacterHandler usemapCharacterHandler = this.lookup(string5);
            UsemapCharacterHandler usemapCharacterHandler2 = this.lookup(string6);
            this.trail(usemapCharacterHandler);
            usemapCharacterHandler.alias = usemapCharacterHandler2;
        } else {
            throw new SAXException("unknown element: " + string);
        }
    }

    void trail(UsemapCharacterHandler usemapCharacterHandler) {
        new TrailEntry(usemapCharacterHandler).link();
    }

    void untrail() {
        this.trail_top.redo();
    }

    class CharacterHandler {
        CharacterHandler() {
        }

        void characters(char[] cArray, int n, int n2) throws IOException {
            throw new IOException("text not allowed here");
        }
    }

    class DefaultCharacterHandler
    extends CharacterHandler {
        DefaultCharacterHandler() {
        }

        void characters(char[] cArray, int n, int n2) throws IOException {
            TextOutputHandler.this.writer.write(cArray, n, n2);
        }
    }

    class EnterCharacterHandler
    extends CharacterHandler {
        private char c;
        private StringBuffer buf = new StringBuffer();

        EnterCharacterHandler() {
        }

        void beginDefinition(char c) {
            this.c = c;
        }

        void characters(char[] cArray, int n, int n2) throws IOException {
            this.buf.append(cArray, n, n2);
        }

        void endDefinition() {
            TextOutputHandler.this.defmap.enter(this.c, this.buf.toString());
            this.buf.setLength(0);
        }
    }

    class UsemapCharacterHandler
    extends CharacterHandler {
        private String name;
        private UsemapCharacterHandler next;
        private UsemapCharacterHandler alias;
        private String[] table = new String[128];

        UsemapCharacterHandler(String string) {
            this.name = string;
        }

        void characters(char[] cArray, int n, int n2) throws IOException {
            while (n2 > 0) {
                char c = cArray[n];
                if (c < this.table.length) {
                    String string = this.table[c];
                    if (string == null) {
                        TextOutputHandler.this.writer.write(c);
                    } else {
                        TextOutputHandler.this.writer.write(string);
                    }
                } else {
                    TextOutputHandler.this.writer.write(c);
                }
                ++n;
                --n2;
            }
        }

        UsemapCharacterHandler deref() {
            return this.alias == null ? this : this.alias;
        }

        void enter(char c, String string) {
            if (c >= this.table.length) {
                int n = this.table.length;
                while ((n *= 2) <= c) {
                }
                String[] stringArray = new String[n];
                System.arraycopy(this.table, 0, stringArray, 0, this.table.length);
                this.table = stringArray;
            }
            this.table[c] = string;
        }

        void record() throws SAXException {
            UsemapCharacterHandler usemapCharacterHandler = TextOutputHandler.this.first_map;
            while (usemapCharacterHandler != null) {
                if (usemapCharacterHandler.name == this.name) {
                    throw new SAXException("map already exists: " + this.name);
                }
                usemapCharacterHandler = usemapCharacterHandler.next;
            }
            this.next = TextOutputHandler.this.first_map;
            TextOutputHandler.this.first_map = this;
        }
    }

    class TrailEntry {
        private UsemapCharacterHandler map;
        private UsemapCharacterHandler was;
        private TrailEntry next;

        TrailEntry(UsemapCharacterHandler usemapCharacterHandler) {
            this.map = usemapCharacterHandler;
            this.was = usemapCharacterHandler.alias;
        }

        void link() {
            this.next = TextOutputHandler.this.trail_top;
            TextOutputHandler.this.trail_top = this;
        }

        void redo() {
            this.map.alias = this.was;
            TextOutputHandler.this.trail_top = this.next;
        }
    }
}

