#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>

#include "mplinux.h"
#include "f60lib/f60lib.h"

#ifndef USE_OSX
#include <linux/limits.h>
#endif

static usb_dev_handle* mpl_USBHandle = NULL;
int CancelOperation = 0;
int default_device = 1;
unsigned short vendor_id;
unsigned short product_id;

unsigned short mpl_hex_to_short(gchar* string) {
    gchar hex[4];
    gchar c;
    unsigned short ret;
    int i;

    strncpy(hex,string,4);
    ret = 0;
    for(i = 0; i < 4; i++) {
       ret = ret << 4; 
       c = g_ascii_tolower(hex[i]);
        if ( (c >= 'a') && (c <= 'f') ) {
            ret = ret | (c - 87);
        } 
        else if ( (c >= '0') && (c <= '9') ) {
            ret = ret | (c - 48);
        }
        else {
            ret = ret | 0;
        }
    }    

    return ret;
}

void mpl_set_device_id(int use_id, gchar* vendor, gchar* product) {

    vendor_id = mpl_hex_to_short(vendor);
    product_id = mpl_hex_to_short(product);

    if (use_id) { 
        default_device = 0;
    }
    else {
        default_device = 1;
    }
}

void mpl_cancel_operation(gboolean a) {
    if (a == TRUE) {
        CancelOperation = 1;
        f60_error = USER_CANCELED;
    }
    else
        CancelOperation = 0;
}

void file_ext_to_mpm(gchar* c) {

     if (strlen(c) < 5) return;     
     c[strlen(c) - 1] = 'm';
     c[strlen(c) - 2] = 'p';
     c[strlen(c) - 3] = 'm';
     c[strlen(c) - 4] = '.';

}

void file_ext_to_mp3(gchar* c) {
     
     if (strlen(c) < 5) return;
     c[strlen(c) - 1] = '3';
     c[strlen(c) - 2] = 'p';
     c[strlen(c) - 3] = 'm';
     c[strlen(c) - 4] = '.';

}



gchar* mpl_ErrorString() {
     return f60_strerror;
}

gint  mpl_LastError() {
     return f60_error;
}


gboolean mpl_CheckForDevice() {
     if (mpl_USBHandle == NULL) {
	  usb_init();
	  usb_find_busses();
	  usb_find_devices();
      if (default_device) {
          mpl_USBHandle = f60_init();
      }
      else {
          mpl_USBHandle = f60_init_with_id(vendor_id,product_id);
      }
	  if (!mpl_USBHandle) 
	       return FALSE;
     }


     if (f60_get_dir(mpl_USBHandle) != NULL) {
	  return TRUE;
     }

     if (f60_error == F60_ERROR_USB) {
	  f60_close(mpl_USBHandle);
	  usb_init();
	  usb_find_busses();
	  usb_find_devices();
      if (default_device) {
          mpl_USBHandle = f60_init();
      }
      else {
          mpl_USBHandle = f60_init_with_id(vendor_id,product_id);
      }
	  if (mpl_USBHandle) 
	       if (f60_get_dir(mpl_USBHandle) != NULL) 
		    return TRUE;
     }

     
     f60_close(mpl_USBHandle);
     mpl_USBHandle = NULL;
     return FALSE;
}

GList* mpl_RefreshList() {
     struct f60_dir* dirptr;
     gint i;
     guint32 filesize;
     GList* dir = NULL;

     if (mpl_CheckForDevice() == FALSE) return (GList*)MPL_ERROR;
     dirptr =  f60_get_dir(mpl_USBHandle);
     if (dirptr == NULL)
	  return  (GList*)MPL_ERROR;

     dir = g_list_append(dir,(gpointer)dirptr->total_memory);
     dir = g_list_append(dir,(gpointer)dirptr->free_memory);
     
     for(i=0;i < dirptr->size;i++) {
	  f60_big2little_endian((guint32*)&dirptr->contents[i*256],&filesize);
	  dir = g_list_append(dir,f60_strip_path(&dirptr->contents[i*256 + 21]));
	  dir = g_list_append(dir,(gpointer)filesize);
     }

     return dir;
}

gint mpl_DeleteFile(gint index) {
     gint ret;

     if (mpl_CheckForDevice() == FALSE) return MPL_ERROR;

     ret = f60_delete_file(mpl_USBHandle,index);

     if (!ret)
	  return MPL_ERROR;

     return 1;
}

gint mpl_SendFile(gchar* filename,gchar* text) {
     gchar tempname[F60_MAX_FILENAME + 10];

     if (mpl_CheckForDevice() == FALSE) return MPL_ERROR;

     strcpy(tempname,MPL_TEMP_DIR);
     strncat(tempname,f60_strip_path(filename),F60_MAX_FILENAME);
     file_ext_to_mpm(tempname);
     if (!f60_encode_file(filename,tempname))
	  return MPL_ERROR;

     if (!f60_send_file(mpl_USBHandle,tempname,text)) {
	  unlink(tempname);
	  return MPL_ERROR;
     }

     unlink(tempname);

     if (CancelOperation)
         return MPL_ERROR;

     return 1;
}

gint mpl_SendFileNonMp3(gchar* filename) {
	
	if (mpl_CheckForDevice() == FALSE) return MPL_ERROR;
	
	 if (!f60_send_file(mpl_USBHandle,filename,"notmpm")) {
		 return MPL_ERROR;
     }

	 return 1;
}

#define MAX_PATH  PATH_MAX + F60_MAX_FILENAME +1
gchar* mpl_path_cat(gchar* ret,gchar* p1,char* p2) {
     if (strlen(p1) + strlen(p2) > MAX_PATH - 1)
	  return NULL;
     strncpy(ret,p1,MAX_PATH);
     if (p1[strlen(p1) -1] != '/')
	  strcat(ret,"/");
     strncat(ret,p2,MAX_PATH - (strlen(p1) +1));

     return ret;
}

gint mpl_GetFile(gint index,gchar* dirname) {
     gchar* c;
     gchar fullpath[PATH_MAX + F60_MAX_FILENAME + 1];
     gint len;
	 
     if (mpl_CheckForDevice() == FALSE) return MPL_ERROR;
     
     c = f60_get_file(mpl_USBHandle,index,MPL_TEMP_DIR);
     if (c == NULL) 
	  return MPL_ERROR;

     mpl_path_cat(fullpath,dirname,f60_strip_path(c));
	 
	 len = strlen(c);

	 if ( ((len - strlen(MPL_TEMP_DIR)) < 5)  || (strncmp(c + (len -4),".mpm",4) != 0) ) {
		 rename(c,fullpath);
		 return 1; 
	 }
	 
     file_ext_to_mp3(fullpath);
     if (!f60_decode_file(c,fullpath)) {
	  unlink(c);
	  return MPL_ERROR;
     }

     unlink(c);

     if (CancelOperation)
         return MPL_ERROR;

     return 1;
}

void mpl_CloseDevice() {

     if (mpl_USBHandle)
	  f60_close(mpl_USBHandle);

}

gint mpl_ReorderFiles(gchar* order,guchar size) {

     if (mpl_CheckForDevice() == FALSE) return MPL_ERROR;
     
     if (!f60_move_file(mpl_USBHandle,order,size))
	  return MPL_ERROR;

     return 1;
}

gint mpl_FormatMedia(char TKFtype) {
	if (mpl_CheckForDevice() == FALSE) return MPL_ERROR;

	if (!f60_format_media(mpl_USBHandle,TKFtype))
		return MPL_ERROR;

	return 1;
}

void mpl_SelectMemory(gint a) {
     f60_select_memory(a);
}

void mpl_PrintDebugInfo(gint a) {
     f60_set_debug(a);
}

float mpl_GetReadWriteProgress() {
	return f60_get_rw_progress();		
}
