
C       ....................SSP...........................................
C
C          SUBROUTINE KOLM2
C
C          PURPOSE
C
C             TESTS THE DIFFERENCE BETWEEN TWO SAMPLE DISTRIBUTION
C             FUNCTIONS USING THE KOLMOGOROV-SMIRNOV TEST
C
C          USAGE
C             CALL KOLM2(X,Y,N,M,Z,PROB)
C             CALL KOLM2(X,Y,N,M,Z,PROB,D) <== NCL
C
C          DESCRIPTION OF PARAMETERS
C             X    - INPUT VECTOR OF N INDEPENDENT OBSERVATIONS.  ON
C                    RETURN FROM KOLM2, X HAS BEEN SORTED INTO A
C                    MONOTONIC NON-DECREASING SEQUENCE.
C             Y    - INPUT VECTOR OF M INDEPENDENT OBSERVATIONS.  ON
C                    RETURN FROM KOLM2, Y HAS BEEN SORTED INTO A
C                    MONOTONIC NON-DECREASING SEQUENCE.
C             N    - NUMBER OF OBSERVATIONS IN X
C             M    - NUMBER OF OBSERVATIONS IN Y
C             Z    - OUTPUT VARIABLE CONTAINING THE GREATEST VALUE WITH
C                    RESPECT TO THE SPECTRUM OF X AND Y OF
C                    SQRT((M*N)/(M+N))*ABS(FN(X)-GM(Y)) WHERE
C                    FN(X) IS THE EMPIRICAL DISTRIBUTION FUNCTION OF THE
C                    SET (X) AND GM(Y) IS THE EMPIRICAL DISTRIBUTION
C                    FUNCTION OF THE SET (Y).
C             PROB - OUTPUT VARIABLE CONTAINING THE PROBABILITY OF
C                    THE STATISTIC BEING GREATER THAN OR EQUAL TO Z IF
C                    THE HYPOTHESIS THAT X AND Y ARE FROM THE SAME PDF IS
C                    TRUE.  E.G., PROB= 0.05 IMPLIES THAT ONE CAN REJECT
C                    THE NULL HYPOTHESIS THAT THE SETS X AND Y ARE FROM
C                    THE SAME DENSITY WITH 5 PER CENT PROBABILITY OF BEING
C                    INCORRECT.  PROB = 1. - SMIRN(Z).
C
C          REMARKS
C             N AND M SHOULD BE GREATER THAN OR EQUAL TO 100.  (SEE THE
C             MATHEMATICAL DESCRIPTION FOR THIS SUBROUTINE AND FOR THE
C             SUBROUTINE SMIRN, CONCERNING ASYMPTOTIC FORMULAE).
C
C             DOUBLE PRECISION USAGE---IT IS DOUBTFUL THAT THE USER WILL
C             WISH TO PERFORM THIS TEST USING DOUBLE PRECISION ACCURACY.
C             IF ONE WISHES TO COMMUNICATE WITH KOLM2 IN A DOUBLE
C             PRECISION PROGRAM, HE SHOULD CALL THE FORTRAN SUPPLIED
C             PROGRAM SNGL(X) PRIOR TO CALLING KOLM2, AND CALL THE
C             FORTRAN SUPPLIED PROGRAM DBLE(X) AFTER EXITING FROM KOLM2.
C             (NOTE THAT SUBROUTINE SMIRN DOES HAVE DOUBLE PRECISION
C             CAPABILITY AS SUPPLIED BY THIS PACKAGE.)
C
C
C          SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED
C             SMIRN
C
C          METHOD
C             FOR REFERENCE, SEE (1) W. FELLER--ON THE KOLMOGOROV-SMIRNOV
C             LIMIT THEOREMS FOR EMPIRICAL DISTRIBUTIONS--
C             ANNALS OF MATH. STAT., 19, 1948.  177-189,
C             (2) N. SMIRNOV--TABLE FOR ESTIMATING THE GOODNESS OF FIT
C             OF EMPIRICAL DISTRIBUTIONS--ANNALS OF MATH. STAT., 19,
C             1948.  279-281.
C             (3) R. VON MISES--MATHEMATICAL THEORY OF PROBABILITY AND
C             STATISTICS--ACADEMIC PRESS, NEW YORK, 1964.  490-493,
C             (4) B.V. GNEDENKO--THE THEORY OF PROBABILITY--CHELSEA
C             PUBLISHING COMPANY, NEW YORK, 1962.  384-401.
C
C       ..................................................................
C
C C C   SUBOUTINE KOLM2(X,Y,N,M,Z,PROB,D)
C NCLFORTSTART
        SUBROUTINE KOLM2(X,Y,N,M,IFLAG,Z,PROB,D)
C                                            INPUT
        INTEGER N,M, IFLAG
        DOUBLE PRECISION X(N),Y(M)
C                                            OUTPUT
        DOUBLE PRECISION Z, PROB, D
C NCLEND
        DOUBLE PRECISION TEMP, XN, XN1, XM, XM1

        IF (IFLAG.EQ.0) THEN
C
C          SORT X INTO ASCENDING SEQUENCE
C
        DO 5 I=2,N
        IF(X(I)-X(I-1))1,5,5
1       TEMP=X(I)
        IM=I-1
        DO 3 J=1,IM
        L=I-J
        IF(TEMP-X(L))2,4,4
2       X(L+1)=X(L)
3       CONTINUE
        X(1)=TEMP
        GO TO 5
4       X(L+1)=TEMP
5       CONTINUE

C
C          SORT Y INTO ASCENDING SEQUENCE
C
        DO 10 I=2,M
        IF(Y(I)-Y(I-1))6,10,10
6       TEMP=Y(I)
        IM=I-1
        DO 8  J=1,IM
        L=I-J
        IF(TEMP-Y(L))7,9,9
7       Y(L+1)=Y(L)
8       CONTINUE
        Y(1)=TEMP
        GO TO 10
9       Y(L+1)=TEMP
10      CONTINUE

        END IF
C
C          CALCULATE D = ABS(FN-GM) OVER THE SPECTRUM OF X AND Y
C
        XN =DBLE(N)
        XN1=1.0D0/XN
        XM =DBLE(M)
        XM1=1.0D0/XM
        D=0.0D0
        I=0
        J=0
        K=0
        L=0
11      IF(X(I+1)-Y(J+1))12,13,18
12      K=1
        GO TO 14
13      K=0
14      I=I+1
        IF(I-N)15,21,21
15      IF(X(I+1)-X(I))14,14,16
16      IF(K)17,18,17
C
C          CHOOSE THE MAXIMUM DIFFERENCE, D
C
17      D=AMAX1(D,ABS(DBLE(I)*XN1-DBLE(J)*XM1))
        IF(L)22,11,22
18      J=J+1
        IF(J-M)19,20,20
19      IF(Y(J+1)-Y(J))18,18,17
20      L=1
        GO TO 17
21      L=1
        GO TO 16
C
C          CALCULATE THE STATISTIC Z
C
22      Z=D*SQRT((XN*XM)/(XN+XM))
C
C          CALCULATE THE PROBABILITY ASSOCIATED WITH Z
C
        CALL SMIRN(Z,PROB)
        PROB = 1.0D0-PROB
        
        RETURN
        END
C---
      SUBROUTINE SMIRN(X,Y)
      DOUBLE PRECISION X, Y 
      DOUBLE PRECISION Q1, Q2, Q4, Q8

      IF(X-0.27D0)1,1,2
    1 Y=0.0D0
      GO TO 9
    2 IF(X-1.0D0)3,6,6
    3 Q1=EXP(-1.233701D0/X**2)
      Q2=Q1*Q1
      Q4=Q2*Q2
      Q8=Q4*Q4
      IF(Q8-1D-25)4,5,5
    4 Q8=0.0D0
    5 Y=(2.506628D0/X)*Q1*(1.0D0+Q8*(1.0D0+Q8*Q8))
      GO TO 9
    6 IF(X-3.1D0)8,7,7
    7 Y=1.0D0
      GO TO 9
    8 Q1=EXP(-2.0D0*X*X)
      Q2=Q1*Q1
      Q4=Q2*Q2
      Q8=Q4*Q4
      Y=1.0D0-2.0D0*(Q1-Q4+Q8*(Q1-Q8))
    9 RETURN
      END
