## Quickstart

```js
const CacheBase = require('cache-base');
const app = new CacheBase();

app.set('a.b', 'c');

console.log(app.cache.a);    //=> { b: 'c' }
console.log(app.cache.a.b);  //=> 'c'

console.log(app.get('a'));   //=> { b: 'c' }
console.log(app.get('a.b')); //=> 'c'
```

More [usage examples](#usage-examples) below.


## API

{%= apidocs("index.js") %}


## Usage examples

**Create an instance of cache-base**

```js
const app = new CacheBase();

app.set('a', 'b');
app.set('c.d', 'e');

console.log(app.get('a'));
//=> 'b'
console.log(app.get('c'));
//=> { d: 'e' }
console.log(app);
//=> CacheBase { a: 'b' }
```

**Initialize with an object**

```js
const app = new CacheBase({ a: 'b', c: { d: 'e' } });

console.log(app.get('a'));
//=> 'b'
console.log(app.get('c'));
//=> { d: 'e' }
console.log(app.get('c.d'));
//=> 'e'
console.log(app);
//=> CacheBase { cache: { a: 'b' } }
```

**Inherit**

```js
class MyApp extends CacheBase {}

const app = new MyApp();
app.set('a', 'b');
app.set('c', 'd');

console.log(app.get('a'));
//=> 'b'

console.log(app);
//=> MyApp { cache: { a: 'b', c: 'd' } }
```

**Custom namespace**

Pass a string as the first value to the contructor to define a custom property name to use for the cache. By default values are stored on the `cache` property.

```js
const CacheBase = require('cache-base');
const app = new CacheBase('data', { a: 'b' });
app.set('c.d', 'e');

// get values
console.log(app.get('a'));
//=> 'b'
console.log(app.get('c'));
//=> { d: 'e' }
console.log(app.data);
//=> { a: 'b', c: { d: 'e' } }
console.log(app);
//=> CacheBase { data: { a: 'b', c: { d: 'e' } } }
```
