/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.util;

import java.text.ParsePosition;
import java.util.Date;
import java.util.TimeZone;

public class SimpleDateFormat
extends java.text.SimpleDateFormat {
    public static final String mCMCSDateTimeFormat = "yyyy-MM-dd HH:mm:ss zzz";
    public static final String mCMCSDateFormat = "yyyy-MM-dd";
    private static final String mChefDateTime = "yyyy/MM/dd HH:mm:ss";
    public static final String mDAVCreateFormat = "yyyy-MM-dd'T'hh:mm:ss'Z'";
    public static final String mDAVModifiedFormat = "EEE, dd MMM yyyy HH:mm:ss z";

    public SimpleDateFormat() {
        this.applyPattern(mCMCSDateTimeFormat);
        this.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public String getCurrentDateTimeAsString() {
        return this.formatDateTime(new Date());
    }

    public String getCurrentDateAsString() {
        return this.formatDate(new Date());
    }

    public Date parseDateTime(String str) {
        Date date = null;
        if (str != null && str.length() > 0) {
            String pattern = this.toPattern();
            this.applyPattern(mCMCSDateTimeFormat);
            date = this.parse(str, new ParsePosition(0));
            if (date == null) {
                this.applyPattern(mChefDateTime);
                date = this.parse(str, new ParsePosition(0));
            }
            this.applyPattern(pattern);
        }
        return date;
    }

    public Date parseDAVCreateDate(String str) {
        Date date = null;
        if (str != null && str.length() > 0) {
            String pattern = this.toPattern();
            this.applyPattern(mDAVCreateFormat);
            date = this.parse(str, new ParsePosition(0));
            this.applyPattern(pattern);
        }
        return date;
    }

    public Date parseDAVModifiedDate(String str) {
        Date date = null;
        if (str != null && str.length() > 0) {
            String pattern = this.toPattern();
            this.applyPattern(mDAVModifiedFormat);
            date = this.parse(str, new ParsePosition(0));
            this.applyPattern(pattern);
        }
        return date;
    }

    public String formatDateTime(Date date) {
        String ret = "";
        String pattern = this.toPattern();
        this.applyPattern(mCMCSDateTimeFormat);
        ret = this.format(date);
        this.applyPattern(pattern);
        return ret;
    }

    public String formatDate(Date d) {
        String ret = "";
        String pattern = this.toPattern();
        this.applyPattern(mCMCSDateFormat);
        ret = this.format(d);
        this.applyPattern(pattern);
        return ret;
    }
}

