/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util.db;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.StringTokenizer;
import javax.mail.internet.MimeUtility;
import org.apache.java.lang.Bytes;
import org.apache.turbine.services.resources.TurbineResources;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.TurbineException;

public class UUIdGenerator {
    private static final String errorString = "uuid.address property in TurbineResources.properties should be a valid IP\n e.g. 18.2.3.100, or an ethernet address e.g. AE:10:3E:de:f5:77 uuid.address was ";
    private static final char[] countChar = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '-', '_'};
    private byte[] address = new byte[6];
    private String baseId = null;
    private int counter = 0;

    private final void generateNewBaseId() throws Exception {
        long now = System.currentTimeMillis();
        byte[] nowBytes = Bytes.toBytes(now);
        ByteArrayOutputStream bas = null;
        OutputStream encodedStream = null;
        try {
            bas = new ByteArrayOutputStream(16);
            encodedStream = MimeUtility.encode(bas, "base64");
            encodedStream.write(nowBytes);
            this.baseId = bas.toString("ISO-8859-1");
            this.baseId = this.baseId.replace('/', '_');
            this.baseId = this.baseId.replace('*', '-');
        }
        finally {
            Object var7_5 = null;
            if (bas != null) {
                bas.close();
            }
            if (encodedStream != null) {
                encodedStream.close();
            }
        }
    }

    public String getId() throws Exception {
        int index;
        if ((index = ++this.counter) > 4095) {
            UUIdGenerator uUIdGenerator = this;
            synchronized (uUIdGenerator) {
                if (this.counter > 4095) {
                    this.generateNewBaseId();
                    this.counter = 0;
                } else {
                    index = ++this.counter;
                }
            }
        }
        StringBuffer idbuf = new StringBuffer(18);
        idbuf.append(this.baseId);
        idbuf.append(countChar[index / 64]);
        idbuf.append(countChar[index % 64]);
        return idbuf.toString();
    }

    public UUIdGenerator() throws TurbineException {
        String addr = TurbineResources.getString("uuid.address");
        if (addr == null) {
            Log.info("UUIdGenerator is using a random number as the base for id's.  This is not the best method for many purposes, but may be adequate in some circumstances. Consider using an IP or ethernet (MAC) address if available. Edit TurbineResources.properties file and add a uuid.address= property.");
            int i = 0;
            while (i < 6) {
                this.address[i] = (byte)(255.0 * Math.random());
                ++i;
            }
        } else if (addr.indexOf(".") > 0) {
            StringTokenizer stok = new StringTokenizer(addr, ".");
            if (stok.countTokens() != 4) {
                throw new TurbineException(errorString + addr);
            }
            this.address[0] = -1;
            this.address[1] = -1;
            int i = 2;
            try {
                while (stok.hasMoreTokens()) {
                    this.address[i++] = Byte.parseByte(stok.nextToken());
                }
            }
            catch (Exception e) {
                throw new TurbineException(errorString + addr, e);
            }
        } else if (addr.indexOf(":") > 0) {
            StringTokenizer stok = new StringTokenizer(addr, ":");
            if (stok.countTokens() != 6) {
                throw new TurbineException(errorString + addr);
            }
            int i = 0;
            try {
                while (stok.hasMoreTokens()) {
                    this.address[i++] = Byte.parseByte(stok.nextToken(), 16);
                }
            }
            catch (Exception e) {
                throw new TurbineException(errorString + addr, e);
            }
        } else {
            throw new TurbineException(errorString + addr);
        }
    }
}

