% VERTCAT [overload base function]

% Copyright Notice
%
%    Copyright (C) 2014 SUPELEC
%
%    Author:  Julien Bect  <julien.bect@centralesupelec.fr>

% Copying Permission Statement
%
%    This file is part of
%
%            STK: a Small (Matlab/Octave) Toolbox for Kriging
%               (http://sourceforge.net/projects/kriging)
%
%    STK is free software: you can redistribute it and/or modify it under
%    the terms of the GNU General Public License as published by the Free
%    Software Foundation,  either version 3  of the License, or  (at your
%    option) any later version.
%
%    STK is distributed  in the hope that it will  be useful, but WITHOUT
%    ANY WARRANTY;  without even the implied  warranty of MERCHANTABILITY
%    or FITNESS  FOR A  PARTICULAR PURPOSE.  See  the GNU  General Public
%    License for more details.
%
%    You should  have received a copy  of the GNU  General Public License
%    along with STK.  If not, see <http://www.gnu.org/licenses/>.

function result = vertcat (varargin)

for i = 1:nargin,
    if isa (varargin{i}, 'stk_hrect')
        varargin{i} = varargin{i}.stk_dataframe;
    end
end

result = vertcat (varargin{:});

end % function


%!shared d, x, y
%! d = 10;
%! x = stk_hrect (d);
%! y = double (x);

%!test
%! z = vertcat (x, x);
%! assert (isequal (size (z), [4 d]));
%! assert (strcmp (class (z), 'stk_dataframe'));

%!test
%! z = vertcat (x, y);
%! assert (isequal (size (z), [4 d]));
%! assert (strcmp (class (z), 'stk_dataframe'));

%!test
%! z = vertcat (y, x);
%! assert (isequal (size (z), [4 d]));
%! assert (strcmp (class (z), 'stk_dataframe'));
