/*###############################################################################
# Linux Management Providers (LMP), OS provider package
# Copyright (C) 2007 Ilsoo Byun, ETRI <widepis@etri.re.kr ,widepis@empal.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Khahramon NURIDDINOV, TUIT <qahramon0786@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
###############################################################################*/

#include "cmpiOpenDRIM_RunningOS.h"

CMPIObjectPath* OS_OpenDRIM_RunningOS_toCMPIObjectPath(const CMPIBroker* broker, const OpenDRIM_RunningOS& instance) {
	_E_;
	Objectpath op(broker, OpenDRIM_RunningOS_classnames[0], OpenDRIM_RunningOS_NAMESPACE);

	if (!instance.Antecedent_isNULL)
		op.addKey("Antecedent", instance.Antecedent);

	if (!instance.Dependent_isNULL)
		op.addKey("Dependent", instance.Dependent);

	_L_;
	return op.getHdl();
}

CMPIInstance* OS_OpenDRIM_RunningOS_toCMPIInstance(const CMPIBroker* broker, const OpenDRIM_RunningOS& instance) {
	_E_;
	Objectpath op(broker, OS_OpenDRIM_RunningOS_toCMPIObjectPath(broker, instance));
	Instance ci(broker, op);

	_L_;
	return ci.getHdl();
}

void OS_OpenDRIM_RunningOS_toCPP(const CMPIBroker* broker, const CMPIObjectPath* ref, OpenDRIM_RunningOS& instance) {
	_E_;
	Objectpath op(broker, (CMPIObjectPath*) ref);

	if (op.getKey("Antecedent", instance.Antecedent) == OK)
		instance.Antecedent_isNULL = false;

	if (op.getKey("Dependent", instance.Dependent) == OK)
		instance.Dependent_isNULL = false;

	_L_;
}

void OS_OpenDRIM_RunningOS_toCPP(const CMPIBroker* broker, const CMPIInstance* ci, OpenDRIM_RunningOS& instance) {
	_E_;
	Instance inst(broker, (CMPIInstance*) ci);

	if (inst.getProperty("Antecedent", instance.Antecedent) == OK)
		instance.Antecedent_isNULL = false;

	if (inst.getProperty("Dependent", instance.Dependent) == OK)
		instance.Dependent_isNULL = false;

	_L_;
}

