/*
 * Copyright (c) 1996, 2006, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * Mappings from partial locale names to full locale names
 */
 static char *locale_aliases[] = {
    "ar", "ar_EG",
    "be", "be_BY",
    "bg", "bg_BG",
    "br", "br_FR",
    "ca", "ca_ES",
    "cs", "cs_CZ",
    "cz", "cs_CZ",
    "da", "da_DK",
    "de", "de_DE",
    "el", "el_GR",
    "en", "en_US",
    "eo", "eo",    /* no country for Esperanto */
    "es", "es_ES",
    "et", "et_EE",
    "eu", "eu_ES",
    "fi", "fi_FI",
    "fr", "fr_FR",
    "ga", "ga_IE",
    "gl", "gl_ES",
    "he", "iw_IL",
    "hr", "hr_HR",
#ifdef __linux__
    "hs", "en_US", // used on Linux, not clear what it stands for
#endif
    "hu", "hu_HU",
    "id", "in_ID",
    "in", "in_ID",
    "is", "is_IS",
    "it", "it_IT",
    "iw", "iw_IL",
    "ja", "ja_JP",
    "kl", "kl_GL",
    "ko", "ko_KR",
    "lt", "lt_LT",
    "lv", "lv_LV",
    "mk", "mk_MK",
    "nl", "nl_NL",
    "no", "no_NO",
    "pl", "pl_PL",
    "pt", "pt_PT",
    "ro", "ro_RO",
    "ru", "ru_RU",
    "se", "se_NO",
    "sk", "sk_SK",
    "sl", "sl_SI",
    "sq", "sq_AL",
    "sr", "sr_CS",
    "su", "fi_FI",
    "sv", "sv_SE",
    "th", "th_TH",
    "tr", "tr_TR",
#ifdef __linux__
    "ua", "en_US", // used on Linux, not clear what it stands for
#endif
    "uk", "uk_UA",
    "vi", "vi_VN",
    "wa", "wa_BE",
    "zh", "zh_CN",
#ifdef __linux__
    "catalan", "ca_ES",
    "croatian", "hr_HR",
    "czech", "cs_CZ",
    "danish", "da_DK",
    "dansk", "da_DK",
    "deutsch", "de_DE",
    "dutch", "nl_NL",
    "finnish", "fi_FI",
    "fran\xE7\x61is", "fr_FR",
    "french", "fr_FR",
    "german", "de_DE",
    "greek", "el_GR",
    "hebrew", "iw_IL",
    "hrvatski", "hr_HR",
    "hungarian", "hu_HU",
    "icelandic", "is_IS",
    "italian", "it_IT",
    "japanese", "ja_JP",
    "norwegian", "no_NO",
    "polish", "pl_PL",
    "portuguese", "pt_PT",
    "romanian", "ro_RO",
    "russian", "ru_RU",
    "slovak", "sk_SK",
    "slovene", "sl_SI",
    "slovenian", "sl_SI",
    "spanish", "es_ES",
    "swedish", "sv_SE",
    "turkish", "tr_TR",
#else
    "big5", "zh_TW.Big5",
    "chinese", "zh_CN",
    "japanese", "ja_JP",
    "tchinese", "zh_TW",
#endif
    ""
 };

/*
 * Linux/Solaris language string to ISO639 string mapping table.
 */
static char *language_names[] = {
    "C", "en",
    "POSIX", "en",
    "aa", "aa",
    "ab", "ab",
    "ae", "ae",
    "af", "af",
    "ak", "ak",
    "am", "am",
    "an", "an",
    "ar", "ar",
    "as", "as",
    "av", "av",
    "ay", "ay",
    "az", "az",
    "ba", "ba",
    "be", "be",
    "bg", "bg",
    "bh", "bh",
    "bi", "bi",
    "bm", "bm",
    "bn", "bn",
    "bo", "bo",
    "br", "br",
    "bs", "bs",
    "ca", "ca",
    "ce", "ce",
    "ch", "ch",
    "co", "co",
    "cr", "cr",
    "cs", "cs",
    "cz", "cs",
    "cu", "cu",
    "cv", "cv",
    "cy", "cy",
    "da", "da",
    "de", "de",
    "dv", "dv",
    "dz", "dz",
    "ee", "ee",
    "el", "el",
    "en", "en",
    "eo", "eo",
    "es", "es",
    "et", "et",
    "eu", "eu",
    "fa", "fa",
    "ff", "ff",
    "fi", "fi",
    "fj", "fj",
    "fo", "fo",
    "fr", "fr",
    "fy", "fy",
    "ga", "ga",
    "gd", "gd",
    "gl", "gl",
    "gn", "gn",
    "gu", "gu",
    "gv", "gv",
    "ha", "ha",
    "he", "iw",
    "hi", "hi",
    "ho", "ho",
    "hr", "hr",
#ifdef __linux__
    "hs", "en", // used on Linux, not clear what it stands for
#endif
    "ht", "ht",
    "hu", "hu",
    "hy", "hy",
    "hz", "hz",
    "ia", "ia",
    "id", "in",
    "ie", "ie",
    "ig", "ig",
    "ii", "ii",
    "ik", "ik",
    "in", "in",
    "io", "io",
    "is", "is",
    "it", "it",
    "iu", "iu",
    "iw", "iw",
    "ja", "ja",
    "ji", "yi",
    "jv", "jv",
    "ka", "ka",
    "kg", "kg",
    "ki", "ki",
    "kj", "kj",
    "kk", "kk",
    "kl", "kl",
    "km", "km",
    "kn", "kn",
    "ko", "ko",
    "kr", "kr",
    "ks", "ks",
    "ku", "ku",
    "kv", "kv",
    "kw", "kw",
    "ky", "ky",
    "la", "la",
    "lb", "lb",
    "lg", "lg",
    "li", "li",
    "ln", "ln",
    "lo", "lo",
    "lt", "lt",
    "lu", "lu",
    "lv", "lv",
    "mg", "mg",
    "mh", "mh",
    "mi", "mi",
    "mk", "mk",
    "ml", "ml",
    "mn", "mn",
    "mo", "mo",
    "mr", "mr",
    "ms", "ms",
    "mt", "mt",
    "my", "my",
    "na", "na",
    "nb", "nb",
    "nd", "nd",
    "ne", "ne",
    "ng", "ng",
    "nl", "nl",
    "nn", "nn",
    "no", "no",
    "nr", "nr",
    "nv", "nv",
    "ny", "ny",
    "oc", "oc",
    "oj", "oj",
    "om", "om",
    "or", "or",
    "os", "os",
    "pa", "pa",
    "pi", "pi",
    "pl", "pl",
    "ps", "ps",
    "pt", "pt",
    "qu", "qu",
    "rm", "rm",
    "rn", "rn",
    "ro", "ro",
    "ru", "ru",
    "rw", "rw",
    "sa", "sa",
    "sc", "sc",
    "sd", "sd",
    "se", "se",
    "sg", "sg",
    "sh", "sr", // sh is deprecated
    "si", "si",
    "sk", "sk",
    "sl", "sl",
    "sm", "sm",
    "sn", "sn",
    "so", "so",
    "sq", "sq",
    "sr", "sr",
    "ss", "ss",
    "st", "st",
    "su", "fi",
    "sv", "sv",
    "sw", "sw",
    "ta", "ta",
    "te", "te",
    "tg", "tg",
    "th", "th",
    "ti", "ti",
    "tk", "tk",
    "tl", "tl",
    "tn", "tn",
    "to", "to",
    "tr", "tr",
    "ts", "ts",
    "tt", "tt",
    "tw", "tw",
    "ty", "ty",
#ifdef __linux__
    "ua", "en", // used on Linux, not clear what it stands for
#endif
    "ug", "ug",
    "uk", "uk",
    "ur", "ur",
    "uz", "uz",
    "ve", "ve",
    "vi", "vi",
    "vo", "vo",
    "wa", "wa",
    "wo", "wo",
    "xh", "xh",
    "yi", "yi",
    "yo", "yo",
    "za", "za",
    "zh", "zh",
    "zu", "zu",
#ifdef __linux__
    "catalan", "ca",
    "croatian", "hr",
    "czech", "cs",
    "danish", "da",
    "dansk", "da",
    "deutsch", "de",
    "dutch", "nl",
    "finnish", "fi",
    "fran\xE7\x61is", "fr",
    "french", "fr",
    "german", "de",
    "greek", "el",
    "hebrew", "he",
    "hrvatski", "hr",
    "hungarian", "hu",
    "icelandic", "is",
    "italian", "it",
    "japanese", "ja",
    "norwegian", "no",
    "polish", "pl",
    "portuguese", "pt",
    "romanian", "ro",
    "russian", "ru",
    "slovak", "sk",
    "slovene", "sl",
    "slovenian", "sl",
    "spanish", "es",
    "swedish", "sv",
    "turkish", "tr",
#else
    "chinese", "zh",
    "japanese", "ja",
    "korean", "ko",
#endif
    "",
};

/*
 * Linux/Solaris country string to ISO3166 string mapping table.
 */
static char *country_names[] = {
    "AD", "AD",
    "AE", "AE",
    "AF", "AF",
    "AG", "AG",
    "AI", "AI",
    "AL", "AL",
    "AM", "AM",
    "AN", "AN",
    "AO", "AO",
    "AQ", "AQ",
    "AR", "AR",
    "AS", "AS",
    "AT", "AT",
    "AU", "AU",
    "AW", "AW",
    "AX", "AX",
    "AZ", "AZ",
    "BA", "BA",
    "BB", "BB",
    "BD", "BD",
    "BE", "BE",
    "BF", "BF",
    "BG", "BG",
    "BH", "BH",
    "BI", "BI",
    "BJ", "BJ",
    "BM", "BM",
    "BN", "BN",
    "BO", "BO",
    "BR", "BR",
    "BS", "BS",
    "BT", "BT",
    "BV", "BV",
    "BW", "BW",
    "BY", "BY",
    "BZ", "BZ",
    "CA", "CA",
    "CC", "CC",
    "CD", "CD",
    "CF", "CF",
    "CG", "CG",
    "CH", "CH",
    "CI", "CI",
    "CK", "CK",
    "CL", "CL",
    "CM", "CM",
    "CN", "CN",
    "CO", "CO",
    "CR", "CR",
    "CS", "CS",
    "CU", "CU",
    "CV", "CV",
    "CX", "CX",
    "CY", "CY",
    "CZ", "CZ",
    "DE", "DE",
    "DJ", "DJ",
    "DK", "DK",
    "DM", "DM",
    "DO", "DO",
    "DZ", "DZ",
    "EC", "EC",
    "EE", "EE",
    "EG", "EG",
    "EH", "EH",
    "ER", "ER",
    "ES", "ES",
    "ET", "ET",
    "FI", "FI",
    "FJ", "FJ",
    "FK", "FK",
    "FM", "FM",
    "FO", "FO",
    "FR", "FR",
    "GA", "GA",
    "GB", "GB",
    "GD", "GD",
    "GE", "GE",
    "GF", "GF",
    "GH", "GH",
    "GI", "GI",
    "GL", "GL",
    "GM", "GM",
    "GN", "GN",
    "GP", "GP",
    "GQ", "GQ",
    "GR", "GR",
    "GS", "GS",
    "GT", "GT",
    "GU", "GU",
    "GW", "GW",
    "GY", "GY",
    "HK", "HK",
    "HM", "HM",
    "HN", "HN",
    "HR", "HR",
    "HT", "HT",
    "HU", "HU",
    "ID", "ID",
    "IE", "IE",
    "IL", "IL",
    "IN", "IN",
    "IO", "IO",
    "IQ", "IQ",
    "IR", "IR",
    "IS", "IS",
    "IT", "IT",
    "JM", "JM",
    "JO", "JO",
    "JP", "JP",
    "KE", "KE",
    "KG", "KG",
    "KH", "KH",
    "KI", "KI",
    "KM", "KM",
    "KN", "KN",
    "KP", "KP",
    "KR", "KR",
    "KW", "KW",
    "KY", "KY",
    "KZ", "KZ",
    "LA", "LA",
    "LB", "LB",
    "LC", "LC",
    "LI", "LI",
    "LK", "LK",
    "LR", "LR",
    "LS", "LS",
    "LT", "LT",
    "LU", "LU",
    "LV", "LV",
    "LY", "LY",
    "MA", "MA",
    "MC", "MC",
    "MD", "MD",
    "MG", "MG",
    "MH", "MH",
    "MK", "MK",
    "ML", "ML",
    "MM", "MM",
    "MN", "MN",
    "MO", "MO",
    "MP", "MP",
    "MQ", "MQ",
    "MR", "MR",
    "MS", "MS",
    "MT", "MT",
    "MU", "MU",
    "MV", "MV",
    "MW", "MW",
    "MX", "MX",
    "MY", "MY",
    "MZ", "MZ",
    "NA", "NA",
    "NC", "NC",
    "NE", "NE",
    "NF", "NF",
    "NG", "NG",
    "NI", "NI",
    "NL", "NL",
    "NO", "NO",
    "NP", "NP",
    "NR", "NR",
    "NU", "NU",
    "NZ", "NZ",
    "OM", "OM",
    "PA", "PA",
    "PE", "PE",
    "PF", "PF",
    "PG", "PG",
    "PH", "PH",
    "PK", "PK",
    "PL", "PL",
    "PM", "PM",
    "PN", "PN",
    "PR", "PR",
    "PS", "PS",
    "PT", "PT",
    "PW", "PW",
    "PY", "PY",
    "QA", "QA",
    "RE", "RE",
#ifdef __linux__
    "RN", "US", // used on Linux, not clear what it stands for
#endif
    "RO", "RO",
    "RU", "RU",
    "RW", "RW",
    "SA", "SA",
    "SB", "SB",
    "SC", "SC",
    "SD", "SD",
    "SE", "SE",
    "SG", "SG",
    "SH", "SH",
    "SI", "SI",
    "SJ", "SJ",
    "SK", "SK",
    "SL", "SL",
    "SM", "SM",
    "SN", "SN",
    "SO", "SO",
    "SR", "SR",
    "ST", "ST",
    "SV", "SV",
    "SY", "SY",
    "SZ", "SZ",
    "TC", "TC",
    "TD", "TD",
    "TF", "TF",
    "TG", "TG",
    "TH", "TH",
    "TJ", "TJ",
    "TK", "TK",
    "TL", "TL",
    "TM", "TM",
    "TN", "TN",
    "TO", "TO",
    "TR", "TR",
    "TT", "TT",
    "TV", "TV",
    "TW", "TW",
    "TZ", "TZ",
    "UA", "UA",
    "UG", "UG",
    "UK", "GB",
    "UM", "UM",
    "US", "US",
    "UY", "UY",
    "UZ", "UZ",
    "VA", "VA",
    "VC", "VC",
    "VE", "VE",
    "VG", "VG",
    "VI", "VI",
    "VN", "VN",
    "VU", "VU",
    "WF", "WF",
    "WS", "WS",
    "YE", "YE",
    "YT", "YT",
    "YU", "CS", // YU has been removed from ISO 3166
    "ZA", "ZA",
    "ZM", "ZM",
    "ZW", "ZW",
    "",
};

/*
 * Linux/Solaris variant string to Java variant name mapping table.
 */
static char *variant_names[] = {
    "nynorsk", "NY",
    "",
};
