/*
 *  This file is part of the WebKit open source project.
 *  This file has been generated by generate-bindings.pl. DO NOT MODIFY!
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 */

#include "config.h"
#include "WebKitDOMTestObj.h"

#include "CSSImportRule.h"
#include "DOMObjectCache.h"
#include "Document.h"
#include "ExceptionCode.h"
#include "HTMLNames.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMDictionaryPrivate.h"
#include "WebKitDOMDocumentPrivate.h"
#include "WebKitDOMNodePrivate.h"
#include "WebKitDOMPrivate.h"
#include "WebKitDOMSVGPointPrivate.h"
#include "WebKitDOMSerializedScriptValuePrivate.h"
#include "WebKitDOMTestEnumTypePrivate.h"
#include "WebKitDOMTestNodePrivate.h"
#include "WebKitDOMTestObjPrivate.h"
#include "WebKitDOMboolPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

#define WEBKIT_DOM_TEST_OBJ_GET_PRIVATE(obj) G_TYPE_INSTANCE_GET_PRIVATE(obj, WEBKIT_TYPE_DOM_TEST_OBJ, WebKitDOMTestObjPrivate)

typedef struct _WebKitDOMTestObjPrivate {
    RefPtr<WebCore::TestObj> coreObject;
} WebKitDOMTestObjPrivate;

namespace WebKit {

WebKitDOMTestObj* kit(WebCore::TestObj* obj)
{
    if (!obj)
        return 0;

    if (gpointer ret = DOMObjectCache::get(obj))
        return WEBKIT_DOM_TEST_OBJ(ret);

    return wrapTestObj(obj);
}

WebCore::TestObj* core(WebKitDOMTestObj* request)
{
    return request ? static_cast<WebCore::TestObj*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMTestObj* wrapTestObj(WebCore::TestObj* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_TEST_OBJ(g_object_new(WEBKIT_TYPE_DOM_TEST_OBJ, "core-object", coreObject, NULL));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMTestObj, webkit_dom_test_obj, WEBKIT_TYPE_DOM_OBJECT)

enum {
    PROP_0,
    PROP_READ_ONLY_LONG_ATTR,
    PROP_READ_ONLY_STRING_ATTR,
    PROP_READ_ONLY_TEST_OBJ_ATTR,
    PROP_BYTE_ATTR,
    PROP_OCTET_ATTR,
    PROP_SHORT_ATTR,
    PROP_UNSIGNED_SHORT_ATTR,
    PROP_LONG_ATTR,
    PROP_LONG_LONG_ATTR,
    PROP_UNSIGNED_LONG_LONG_ATTR,
    PROP_STRING_ATTR,
    PROP_TEST_OBJ_ATTR,
    PROP_XML_OBJ_ATTR,
    PROP_CREATE,
    PROP_REFLECTED_STRING_ATTR,
    PROP_REFLECTED_INTEGRAL_ATTR,
    PROP_REFLECTED_UNSIGNED_INTEGRAL_ATTR,
    PROP_REFLECTED_BOOLEAN_ATTR,
    PROP_REFLECTED_URL_ATTR,
    PROP_REFLECTED_STRING_ATTR,
    PROP_REFLECTED_CUSTOM_INTEGRAL_ATTR,
    PROP_REFLECTED_CUSTOM_BOOLEAN_ATTR,
    PROP_REFLECTED_CUSTOM_URL_ATTR,
    PROP_ATTR_WITH_GETTER_EXCEPTION,
    PROP_ATTR_WITH_SETTER_EXCEPTION,
    PROP_STRING_ATTR_WITH_GETTER_EXCEPTION,
    PROP_STRING_ATTR_WITH_SETTER_EXCEPTION,
    PROP_WITH_SCRIPT_STATE_ATTRIBUTE,
    PROP_WITH_SCRIPT_EXECUTION_CONTEXT_ATTRIBUTE,
    PROP_WITH_SCRIPT_STATE_ATTRIBUTE_RAISES,
    PROP_WITH_SCRIPT_EXECUTION_CONTEXT_ATTRIBUTE_RAISES,
    PROP_WITH_SCRIPT_EXECUTION_CONTEXT_AND_SCRIPT_STATE_ATTRIBUTE,
    PROP_WITH_SCRIPT_EXECUTION_CONTEXT_AND_SCRIPT_STATE_ATTRIBUTE_RAISES,
    PROP_WITH_SCRIPT_EXECUTION_CONTEXT_AND_SCRIPT_STATE_WITH_SPACES_ATTRIBUTE,
    PROP_WITH_SCRIPT_ARGUMENTS_AND_CALL_STACK_ATTRIBUTE,
    PROP_CONDITIONAL_ATTR1,
    PROP_CONDITIONAL_ATTR2,
    PROP_CONDITIONAL_ATTR3,
    PROP_ANY_ATTRIBUTE,
    PROP_CONTENT_DOCUMENT,
    PROP_MUTABLE_POINT,
    PROP_IMMUTABLE_POINT,
    PROP_STRAWBERRY,
    PROP_STRICT_FLOAT,
    PROP_DESCRIPTION,
    PROP_ID,
    PROP_HASH,
    PROP_REPLACEABLE_ATTRIBUTE,
    PROP_NULLABLE_DOUBLE_ATTRIBUTE,
    PROP_NULLABLE_LONG_ATTRIBUTE,
    PROP_NULLABLE_BOOLEAN_ATTRIBUTE,
    PROP_NULLABLE_STRING_ATTRIBUTE,
    PROP_NULLABLE_LONG_SETTABLE_ATTRIBUTE,
    PROP_NULLABLE_STRING_VALUE,
    PROP_ATTRIBUTE,
};

static void webkit_dom_test_obj_finalize(GObject* object)
{
    WebKitDOMTestObjPrivate* priv = WEBKIT_DOM_TEST_OBJ_GET_PRIVATE(object);

    WebKit::DOMObjectCache::forget(priv->coreObject.get());

    priv->~WebKitDOMTestObjPrivate();
    G_OBJECT_CLASS(webkit_dom_test_obj_parent_class)->finalize(object);
}

static void webkit_dom_test_obj_set_property(GObject* object, guint propertyId, const GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMTestObj* self = WEBKIT_DOM_TEST_OBJ(object);
    WebCore::TestObj* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_BYTE_ATTR: {
        coreSelf->setByteAttr((g_value_get_int8(value)));
        break;
    }
    case PROP_OCTET_ATTR: {
        coreSelf->setOctetAttr((g_value_get_uint8(value)));
        break;
    }
    case PROP_UNSIGNED_SHORT_ATTR: {
        coreSelf->setUnsignedShortAttr((g_value_get_uint(value)));
        break;
    }
    case PROP_LONG_ATTR: {
        coreSelf->setLongAttr((g_value_get_long(value)));
        break;
    }
    case PROP_UNSIGNED_LONG_LONG_ATTR: {
        coreSelf->setUnsignedLongLongAttr((g_value_get_uint64(value)));
        break;
    }
    case PROP_STRING_ATTR: {
        coreSelf->setStringAttr(WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_CREATE: {
        coreSelf->setCreate((g_value_get_boolean(value)));
        break;
    }
    case PROP_REFLECTED_STRING_ATTR: {
        coreSelf->setAttribute(WebCore::HTMLNames::reflectedstringattrAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_REFLECTED_INTEGRAL_ATTR: {
        coreSelf->setIntegralAttribute(WebCore::HTMLNames::reflectedintegralattrAttr, (g_value_get_long(value)));
        break;
    }
    case PROP_REFLECTED_UNSIGNED_INTEGRAL_ATTR: {
        coreSelf->setUnsignedIntegralAttribute(WebCore::HTMLNames::reflectedunsignedintegralattrAttr, (g_value_get_ulong(value)));
        break;
    }
    case PROP_REFLECTED_BOOLEAN_ATTR: {
        coreSelf->setBooleanAttribute(WebCore::HTMLNames::reflectedbooleanattrAttr, (g_value_get_boolean(value)));
        break;
    }
    case PROP_REFLECTED_URL_ATTR: {
        coreSelf->setAttribute(WebCore::HTMLNames::reflectedurlattrAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_REFLECTED_STRING_ATTR: {
        coreSelf->setAttribute(WebCore::HTMLNames::customContentStringAttrAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_REFLECTED_CUSTOM_INTEGRAL_ATTR: {
        coreSelf->setIntegralAttribute(WebCore::HTMLNames::customContentIntegralAttrAttr, (g_value_get_long(value)));
        break;
    }
    case PROP_REFLECTED_CUSTOM_BOOLEAN_ATTR: {
        coreSelf->setBooleanAttribute(WebCore::HTMLNames::customContentBooleanAttrAttr, (g_value_get_boolean(value)));
        break;
    }
    case PROP_REFLECTED_CUSTOM_URL_ATTR: {
        coreSelf->setAttribute(WebCore::HTMLNames::customContentURLAttrAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_ATTR_WITH_GETTER_EXCEPTION: {
        coreSelf->setAttrWithGetterException((g_value_get_long(value)));
        break;
    }
    case PROP_ATTR_WITH_SETTER_EXCEPTION: {
        WebCore::ExceptionCode ec = 0;
        coreSelf->setAttrWithSetterException((g_value_get_long(value)), ec);
        break;
    }
    case PROP_STRING_ATTR_WITH_GETTER_EXCEPTION: {
        coreSelf->setStringAttrWithGetterException(WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_STRING_ATTR_WITH_SETTER_EXCEPTION: {
        WebCore::ExceptionCode ec = 0;
        coreSelf->setStringAttrWithSetterException(WTF::String::fromUTF8(g_value_get_string(value)), ec);
        break;
    }
    case PROP_WITH_SCRIPT_STATE_ATTRIBUTE: {
        coreSelf->setWithScriptStateAttribute((g_value_get_long(value)));
        break;
    }
    case PROP_CONDITIONAL_ATTR1: {
#if ENABLE(Condition1)
        coreSelf->setConditionalAttr1((g_value_get_long(value)));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Condition1")
#endif /* ENABLE(Condition1) */
        break;
    }
    case PROP_CONDITIONAL_ATTR2: {
#if ENABLE(Condition1) && ENABLE(Condition2)
        coreSelf->setConditionalAttr2((g_value_get_long(value)));
#else
#if !ENABLE(Condition1)
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Condition1")
#endif
#if !ENABLE(Condition2)
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Condition2")
#endif
#endif /* ENABLE(Condition1) && ENABLE(Condition2) */
        break;
    }
    case PROP_CONDITIONAL_ATTR3: {
#if ENABLE(Condition1) || ENABLE(Condition2)
        coreSelf->setConditionalAttr3((g_value_get_long(value)));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Condition1")
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Condition2")
#endif /* ENABLE(Condition1) || ENABLE(Condition2) */
        break;
    }
    case PROP_STRAWBERRY: {
        coreSelf->setBlueberry((g_value_get_long(value)));
        break;
    }
    case PROP_STRICT_FLOAT: {
        coreSelf->setStrictFloat((g_value_get_float(value)));
        break;
    }
    case PROP_ID: {
        coreSelf->setId((g_value_get_long(value)));
        break;
    }
    case PROP_NULLABLE_LONG_SETTABLE_ATTRIBUTE: {
        coreSelf->setNullableLongSettableAttribute((g_value_get_long(value)));
        break;
    }
    case PROP_NULLABLE_STRING_VALUE: {
        coreSelf->setNullableStringValue((g_value_get_long(value)));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_test_obj_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMTestObj* self = WEBKIT_DOM_TEST_OBJ(object);
    WebCore::TestObj* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_READ_ONLY_LONG_ATTR: {
        g_value_set_long(value, coreSelf->readOnlyLongAttr());
        break;
    }
    case PROP_READ_ONLY_STRING_ATTR: {
        g_value_take_string(value, convertToUTF8String(coreSelf->readOnlyStringAttr()));
        break;
    }
    case PROP_READ_ONLY_TEST_OBJ_ATTR: {
        RefPtr<WebCore::TestObj> ptr = coreSelf->readOnlyTestObjAttr();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_BYTE_ATTR: {
        g_value_set_int8(value, coreSelf->byteAttr());
        break;
    }
    case PROP_OCTET_ATTR: {
        g_value_set_uint8(value, coreSelf->octetAttr());
        break;
    }
    case PROP_SHORT_ATTR: {
        g_value_set_int(value, coreSelf->shortAttr());
        break;
    }
    case PROP_UNSIGNED_SHORT_ATTR: {
        g_value_set_uint(value, coreSelf->unsignedShortAttr());
        break;
    }
    case PROP_LONG_ATTR: {
        g_value_set_long(value, coreSelf->longAttr());
        break;
    }
    case PROP_LONG_LONG_ATTR: {
        g_value_set_int64(value, coreSelf->longLongAttr());
        break;
    }
    case PROP_UNSIGNED_LONG_LONG_ATTR: {
        g_value_set_uint64(value, coreSelf->unsignedLongLongAttr());
        break;
    }
    case PROP_STRING_ATTR: {
        g_value_take_string(value, convertToUTF8String(coreSelf->stringAttr()));
        break;
    }
    case PROP_TEST_OBJ_ATTR: {
        RefPtr<WebCore::TestObj> ptr = coreSelf->testObjAttr();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_XML_OBJ_ATTR: {
        RefPtr<WebCore::TestObj> ptr = coreSelf->xmlObjAttr();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_CREATE: {
        g_value_set_boolean(value, coreSelf->isCreate());
        break;
    }
    case PROP_REFLECTED_STRING_ATTR: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::reflectedstringattrAttr)));
        break;
    }
    case PROP_REFLECTED_INTEGRAL_ATTR: {
        g_value_set_long(value, coreSelf->getIntegralAttribute(WebCore::HTMLNames::reflectedintegralattrAttr));
        break;
    }
    case PROP_REFLECTED_UNSIGNED_INTEGRAL_ATTR: {
        g_value_set_ulong(value, coreSelf->getUnsignedIntegralAttribute(WebCore::HTMLNames::reflectedunsignedintegralattrAttr));
        break;
    }
    case PROP_REFLECTED_BOOLEAN_ATTR: {
        g_value_set_boolean(value, coreSelf->fastHasAttribute(WebCore::HTMLNames::reflectedbooleanattrAttr));
        break;
    }
    case PROP_REFLECTED_URL_ATTR: {
        g_value_take_string(value, convertToUTF8String(coreSelf->getURLAttribute(WebCore::HTMLNames::reflectedurlattrAttr)));
        break;
    }
    case PROP_REFLECTED_STRING_ATTR: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::customContentStringAttrAttr)));
        break;
    }
    case PROP_REFLECTED_CUSTOM_INTEGRAL_ATTR: {
        g_value_set_long(value, coreSelf->getIntegralAttribute(WebCore::HTMLNames::customContentIntegralAttrAttr));
        break;
    }
    case PROP_REFLECTED_CUSTOM_BOOLEAN_ATTR: {
        g_value_set_boolean(value, coreSelf->fastHasAttribute(WebCore::HTMLNames::customContentBooleanAttrAttr));
        break;
    }
    case PROP_REFLECTED_CUSTOM_URL_ATTR: {
        g_value_take_string(value, convertToUTF8String(coreSelf->getURLAttribute(WebCore::HTMLNames::customContentURLAttrAttr)));
        break;
    }
    case PROP_ATTR_WITH_GETTER_EXCEPTION: {
        WebCore::ExceptionCode ec = 0;
        g_value_set_long(value, coreSelf->attrWithGetterException(ec));
        break;
    }
    case PROP_ATTR_WITH_SETTER_EXCEPTION: {
        g_value_set_long(value, coreSelf->attrWithSetterException());
        break;
    }
    case PROP_STRING_ATTR_WITH_GETTER_EXCEPTION: {
        WebCore::ExceptionCode ec = 0;
        g_value_take_string(value, convertToUTF8String(coreSelf->stringAttrWithGetterException(ec)));
        break;
    }
    case PROP_STRING_ATTR_WITH_SETTER_EXCEPTION: {
        g_value_take_string(value, convertToUTF8String(coreSelf->stringAttrWithSetterException()));
        break;
    }
    case PROP_WITH_SCRIPT_STATE_ATTRIBUTE: {
        g_value_set_long(value, coreSelf->withScriptStateAttribute());
        break;
    }
    case PROP_WITH_SCRIPT_EXECUTION_CONTEXT_ATTRIBUTE: {
        RefPtr<WebCore::TestObj> ptr = coreSelf->withScriptExecutionContextAttribute();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_WITH_SCRIPT_STATE_ATTRIBUTE_RAISES: {
        WebCore::ExceptionCode ec = 0;
        RefPtr<WebCore::TestObj> ptr = coreSelf->withScriptStateAttributeRaises(ec);
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_WITH_SCRIPT_EXECUTION_CONTEXT_ATTRIBUTE_RAISES: {
        WebCore::ExceptionCode ec = 0;
        RefPtr<WebCore::TestObj> ptr = coreSelf->withScriptExecutionContextAttributeRaises(ec);
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_WITH_SCRIPT_EXECUTION_CONTEXT_AND_SCRIPT_STATE_ATTRIBUTE: {
        RefPtr<WebCore::TestObj> ptr = coreSelf->withScriptExecutionContextAndScriptStateAttribute();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_WITH_SCRIPT_EXECUTION_CONTEXT_AND_SCRIPT_STATE_ATTRIBUTE_RAISES: {
        WebCore::ExceptionCode ec = 0;
        RefPtr<WebCore::TestObj> ptr = coreSelf->withScriptExecutionContextAndScriptStateAttributeRaises(ec);
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_WITH_SCRIPT_EXECUTION_CONTEXT_AND_SCRIPT_STATE_WITH_SPACES_ATTRIBUTE: {
        RefPtr<WebCore::TestObj> ptr = coreSelf->withScriptExecutionContextAndScriptStateWithSpacesAttribute();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_WITH_SCRIPT_ARGUMENTS_AND_CALL_STACK_ATTRIBUTE: {
        RefPtr<WebCore::TestObj> ptr = coreSelf->withScriptArgumentsAndCallStackAttribute();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_CONDITIONAL_ATTR1: {
#if ENABLE(Condition1)
        g_value_set_long(value, coreSelf->conditionalAttr1());
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Condition1")
#endif /* ENABLE(Condition1) */
        break;
    }
    case PROP_CONDITIONAL_ATTR2: {
#if ENABLE(Condition1) && ENABLE(Condition2)
        g_value_set_long(value, coreSelf->conditionalAttr2());
#else
#if !ENABLE(Condition1)
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Condition1")
#endif
#if !ENABLE(Condition2)
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Condition2")
#endif
#endif /* ENABLE(Condition1) && ENABLE(Condition2) */
        break;
    }
    case PROP_CONDITIONAL_ATTR3: {
#if ENABLE(Condition1) || ENABLE(Condition2)
        g_value_set_long(value, coreSelf->conditionalAttr3());
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Condition1")
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Condition2")
#endif /* ENABLE(Condition1) || ENABLE(Condition2) */
        break;
    }
    case PROP_ANY_ATTRIBUTE: {
        RefPtr<WebCore::any> ptr = coreSelf->anyAttribute();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_CONTENT_DOCUMENT: {
        RefPtr<WebCore::Document> ptr = coreSelf->contentDocument();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_MUTABLE_POINT: {
        RefPtr<WebCore::SVGPoint> ptr = coreSelf->mutablePoint();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_IMMUTABLE_POINT: {
        RefPtr<WebCore::SVGPoint> ptr = coreSelf->immutablePoint();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_STRAWBERRY: {
        g_value_set_long(value, coreSelf->blueberry());
        break;
    }
    case PROP_STRICT_FLOAT: {
        g_value_set_float(value, coreSelf->strictFloat());
        break;
    }
    case PROP_DESCRIPTION: {
        g_value_set_long(value, coreSelf->description());
        break;
    }
    case PROP_ID: {
        g_value_set_long(value, coreSelf->id());
        break;
    }
    case PROP_HASH: {
        g_value_take_string(value, convertToUTF8String(coreSelf->hash()));
        break;
    }
    case PROP_REPLACEABLE_ATTRIBUTE: {
        g_value_set_long(value, coreSelf->replaceableAttribute());
        break;
    }
    case PROP_NULLABLE_DOUBLE_ATTRIBUTE: {
        bool isNull = false;
        g_value_set_double(value, coreSelf->nullableDoubleAttribute(isNull));
        break;
    }
    case PROP_NULLABLE_LONG_ATTRIBUTE: {
        bool isNull = false;
        g_value_set_long(value, coreSelf->nullableLongAttribute(isNull));
        break;
    }
    case PROP_NULLABLE_BOOLEAN_ATTRIBUTE: {
        bool isNull = false;
        g_value_set_boolean(value, coreSelf->nullableBooleanAttribute(isNull));
        break;
    }
    case PROP_NULLABLE_STRING_ATTRIBUTE: {
        bool isNull = false;
        g_value_take_string(value, convertToUTF8String(coreSelf->nullableStringAttribute(isNull)));
        break;
    }
    case PROP_NULLABLE_LONG_SETTABLE_ATTRIBUTE: {
        bool isNull = false;
        g_value_set_long(value, coreSelf->nullableLongSettableAttribute(isNull));
        break;
    }
    case PROP_NULLABLE_STRING_VALUE: {
        bool isNull = false;
        WebCore::ExceptionCode ec = 0;
        g_value_set_long(value, coreSelf->nullableStringValue(isNull, ec));
        break;
    }
    case PROP_ATTRIBUTE: {
        g_value_take_string(value, convertToUTF8String(coreSelf->attribute()));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static GObject* webkit_dom_test_obj_constructor(GType type, guint constructPropertiesCount, GObjectConstructParam* constructProperties)
{
    GObject* object = G_OBJECT_CLASS(webkit_dom_test_obj_parent_class)->constructor(type, constructPropertiesCount, constructProperties);

    WebKitDOMTestObjPrivate* priv = WEBKIT_DOM_TEST_OBJ_GET_PRIVATE(object);
    priv->coreObject = static_cast<WebCore::TestObj*>(WEBKIT_DOM_OBJECT(object)->coreObject);
    WebKit::DOMObjectCache::put(priv->coreObject.get(), object);

    return object;
}

static void webkit_dom_test_obj_class_init(WebKitDOMTestObjClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    g_type_class_add_private(gobjectClass, sizeof(WebKitDOMTestObjPrivate));
    gobjectClass->constructor = webkit_dom_test_obj_constructor;
    gobjectClass->finalize = webkit_dom_test_obj_finalize;
    gobjectClass->set_property = webkit_dom_test_obj_set_property;
    gobjectClass->get_property = webkit_dom_test_obj_get_property;

    g_object_class_install_property(
        gobjectClass,
        PROP_READ_ONLY_LONG_ATTR,
        g_param_spec_long(
            "read-only-long-attr",
            "TestObj:read-only-long-attr",
            "read-only glong TestObj:read-only-long-attr",
            G_MINLONG, G_MAXLONG, 0,
            WEBKIT_PARAM_READABLE));

    g_object_class_install_property(
        gobjectClass,
        PROP_READ_ONLY_STRING_ATTR,
        g_param_spec_string(
            "read-only-string-attr",
            "TestObj:read-only-string-attr",
            "read-only gchar* TestObj:read-only-string-attr",
            "",
            WEBKIT_PARAM_READABLE));

    g_object_class_install_property(
        gobjectClass,
        PROP_READ_ONLY_TEST_OBJ_ATTR,
        g_param_spec_object(
            "read-only-test-obj-attr",
            "TestObj:read-only-test-obj-attr",
            "read-only WebKitDOMTestObj* TestObj:read-only-test-obj-attr",
            WEBKIT_TYPE_DOM_TEST_OBJ,
            WEBKIT_PARAM_READABLE));

    g_object_class_install_property(
        gobjectClass,
        PROP_BYTE_ATTR,
        g_param_spec_int8(
            "byte-attr",
            "TestObj:byte-attr",
            "read-only gint8 TestObj:byte-attr",
            G_MININT8, G_MAXINT8, 0,
            WEBKIT_PARAM_READWRITE));

    g_object_class_install_property(
        gobjectClass,
        PROP_OCTET_ATTR,
        g_param_spec_uint8(
            "octet-attr",
            "TestObj:octet-attr",
            "read-only guint8 TestObj:octet-attr",
            0, G_MAXUINT8, 0,
            WEBKIT_PARAM_READWRITE));

    g_object_class_install_property(
        gobjectClass,
        PROP_SHORT_ATTR,
        g_param_spec_int(
            "short-attr",
            "TestObj:short-attr",
            "read-only gshort TestObj:short-attr",
            G_MININT, G_MAXINT, 0,
            WEBKIT_PARAM_READWRITE));

    g_object_class_install_property(
        gobjectClass,
        PROP_UNSIGNED_SHORT_ATTR,
        g_param_spec_uint(
            "unsigned-short-attr",
            "TestObj:unsigned-short-attr",
            "read-only gushort TestObj:unsigned-short-attr",
            0, G_MAXUINT, 0,
            WEBKIT_PARAM_READWRITE));

    g_object_class_install_property(
        gobjectClass,
        PROP_LONG_ATTR,
        g_param_spec_long(
            "long-attr",
            "TestObj:long-attr",
            "read-only glong TestObj:long-attr",
            G_MINLONG, G_MAXLONG, 0,
            WEBKIT_PARAM_READWRITE));

    g_object_class_install_property(
        gobjectClass,
        PROP_LONG_LONG_ATTR,
        g_param_spec_int64(
            "long-long-attr",
            "TestObj:long-long-attr",
            "read-only gint64 TestObj:long-long-attr",
            G_MININT64, G_MAXINT64, 0,
            WEBKIT_PARAM_READWRITE));

    g_object_class_install_property(
        gobjectClass,
        PROP_UNSIGNED_LONG_LONG_ATTR,
        g_param_spec_uint64(
            "unsigned-long-long-attr",
            "TestObj:unsigned-long-long-attr",
            "read-only guint64 TestObj:unsigned-long-long-attr",
            0, G_MAXUINT64, 0,
            WEBKIT_PARAM_READWRITE));

    g_object_class_install_property(
        gobjectClass,
        PROP_STRING_ATTR,
        g_param_spec_string(
            "string-attr",
            "TestObj:string-attr",
            "read-only gchar* TestObj:string-attr",
            "",
            WEBKIT_PARAM_READWRITE));

    g_object_class_install_property(
        gobjectClass,
        PROP_TEST_OBJ_ATTR,
        g_param_spec_object(
            "test-obj-attr",
            "TestObj:test-obj-attr",
            "read-only WebKitDOMTestObj* TestObj:test-obj-attr",
            WEBKIT_TYPE_DOM_TEST_OBJ,
            WEBKIT_PARAM_READWRITE));

    g_object_class_install_property(
        gobjectClass,
        PROP_XML_OBJ_ATTR,
        g_param_spec_object(
            "xml-obj-attr",
            "TestObj:xml-obj-attr",
            "read-only WebKitDOMTestObj* TestObj:xml-obj-attr",
            WEBKIT_TYPE_DOM_TEST_OBJ,
            WEBKIT_PARAM_READWRITE));

    g_object_class_install_property(
        gobjectClass,
        PROP_CREATE,
        g_param_spec_boolean(
            "create",
            "TestObj:create",
            "read-only gboolean TestObj:create",
            FALSE,
            WEBKIT_PARAM_READWRITE));

    g_object_class_install_property(
        gobjectClass,
        PROP_REFLECTED_STRING_ATTR,
        g_param_spec_string(
            "reflected-string-attr",
            "TestObj:reflected-string-attr",
            "read-only gchar* TestObj:reflected-string-attr",
            "",
            WEBKIT_PARAM_READWRITE));

    g_object_class_install_property(
        gobjectClass,
        PROP_REFLECTED_INTEGRAL_ATTR,
        g_param_spec_long(
            "reflected-integral-attr",
            "TestObj:reflected-integral-attr",
            "read-only glong TestObj:reflected-integral-attr",
            G_MINLONG, G_MAXLONG, 0,
            WEBKIT_PARAM_READWRITE));

    g_object_class_install_property(
        gobjectClass,
        PROP_REFLECTED_UNSIGNED_INTEGRAL_ATTR,
        g_param_spec_ulong(
            "reflected-unsigned-integral-attr",
            "TestObj:reflected-unsigned-integral-attr",
            "read-only gulong TestObj:reflected-unsigned-integral-attr",
            0, G_MAXULONG, 0,
            WEBKIT_PARAM_READWRITE));

    g_object_class_install_property(
        gobjectClass,
        PROP_REFLECTED_BOOLEAN_ATTR,
        g_param_spec_boolean(
            "reflected-boolean-attr",
            "TestObj:reflected-boolean-attr",
            "read-only gboolean TestObj:reflected-boolean-attr",
            FALSE,
            WEBKIT_PARAM_READWRITE));

    g_object_class_install_property(
        gobjectClass,
        PROP_REFLECTED_URL_ATTR,
        g_param_spec_string(
            "reflected-url-attr",
            "TestObj:reflected-url-attr",
            "read-only gchar* TestObj:reflected-url-attr",
            "",
            WEBKIT_PARAM_READWRITE));

    g_object_class_install_property(
        gobjectClass,
        PROP_REFLECTED_STRING_ATTR,
        g_param_spec_string(
            "reflected-string-attr",
            "TestObj:reflected-string-attr",
            "read-only gchar* TestObj:reflected-string-attr",
            "",
            WEBKIT_PARAM_READWRITE));

    g_object_class_install_property(
        gobjectClass,
        PROP_REFLECTED_CUSTOM_INTEGRAL_ATTR,
        g_param_spec_long(
            "reflected-custom-integral-attr",
            "TestObj:reflected-custom-integral-attr",
            "read-only glong TestObj:reflected-custom-integral-attr",
            G_MINLONG, G_MAXLONG, 0,
            WEBKIT_PARAM_READWRITE));

    g_object_class_install_property(
        gobjectClass,
        PROP_REFLECTED_CUSTOM_BOOLEAN_ATTR,
        g_param_spec_boolean(
            "reflected-custom-boolean-attr",
            "TestObj:reflected-custom-boolean-attr",
            "read-only gboolean TestObj:reflected-custom-boolean-attr",
            FALSE,
            WEBKIT_PARAM_READWRITE));

    g_object_class_install_property(
        gobjectClass,
        PROP_REFLECTED_CUSTOM_URL_ATTR,
        g_param_spec_string(
            "reflected-custom-url-attr",
            "TestObj:reflected-custom-url-attr",
            "read-only gchar* TestObj:reflected-custom-url-attr",
            "",
            WEBKIT_PARAM_READWRITE));

    g_object_class_install_property(
        gobjectClass,
        PROP_ATTR_WITH_GETTER_EXCEPTION,
        g_param_spec_long(
            "attr-with-getter-exception",
            "TestObj:attr-with-getter-exception",
            "read-only glong TestObj:attr-with-getter-exception",
            G_MINLONG, G_MAXLONG, 0,
            WEBKIT_PARAM_READWRITE));

    g_object_class_install_property(
        gobjectClass,
        PROP_ATTR_WITH_SETTER_EXCEPTION,
        g_param_spec_long(
            "attr-with-setter-exception",
            "TestObj:attr-with-setter-exception",
            "read-only glong TestObj:attr-with-setter-exception",
            G_MINLONG, G_MAXLONG, 0,
            WEBKIT_PARAM_READWRITE));

    g_object_class_install_property(
        gobjectClass,
        PROP_STRING_ATTR_WITH_GETTER_EXCEPTION,
        g_param_spec_string(
            "string-attr-with-getter-exception",
            "TestObj:string-attr-with-getter-exception",
            "read-only gchar* TestObj:string-attr-with-getter-exception",
            "",
            WEBKIT_PARAM_READWRITE));

    g_object_class_install_property(
        gobjectClass,
        PROP_STRING_ATTR_WITH_SETTER_EXCEPTION,
        g_param_spec_string(
            "string-attr-with-setter-exception",
            "TestObj:string-attr-with-setter-exception",
            "read-only gchar* TestObj:string-attr-with-setter-exception",
            "",
            WEBKIT_PARAM_READWRITE));

    g_object_class_install_property(
        gobjectClass,
        PROP_WITH_SCRIPT_STATE_ATTRIBUTE,
        g_param_spec_long(
            "with-script-state-attribute",
            "TestObj:with-script-state-attribute",
            "read-only glong TestObj:with-script-state-attribute",
            G_MINLONG, G_MAXLONG, 0,
            WEBKIT_PARAM_READWRITE));

    g_object_class_install_property(
        gobjectClass,
        PROP_WITH_SCRIPT_EXECUTION_CONTEXT_ATTRIBUTE,
        g_param_spec_object(
            "with-script-execution-context-attribute",
            "TestObj:with-script-execution-context-attribute",
            "read-only WebKitDOMTestObj* TestObj:with-script-execution-context-attribute",
            WEBKIT_TYPE_DOM_TEST_OBJ,
            WEBKIT_PARAM_READWRITE));

    g_object_class_install_property(
        gobjectClass,
        PROP_WITH_SCRIPT_STATE_ATTRIBUTE_RAISES,
        g_param_spec_object(
            "with-script-state-attribute-raises",
            "TestObj:with-script-state-attribute-raises",
            "read-only WebKitDOMTestObj* TestObj:with-script-state-attribute-raises",
            WEBKIT_TYPE_DOM_TEST_OBJ,
            WEBKIT_PARAM_READWRITE));

    g_object_class_install_property(
        gobjectClass,
        PROP_WITH_SCRIPT_EXECUTION_CONTEXT_ATTRIBUTE_RAISES,
        g_param_spec_object(
            "with-script-execution-context-attribute-raises",
            "TestObj:with-script-execution-context-attribute-raises",
            "read-only WebKitDOMTestObj* TestObj:with-script-execution-context-attribute-raises",
            WEBKIT_TYPE_DOM_TEST_OBJ,
            WEBKIT_PARAM_READWRITE));

    g_object_class_install_property(
        gobjectClass,
        PROP_WITH_SCRIPT_EXECUTION_CONTEXT_AND_SCRIPT_STATE_ATTRIBUTE,
        g_param_spec_object(
            "with-script-execution-context-and-script-state-attribute",
            "TestObj:with-script-execution-context-and-script-state-attribute",
            "read-only WebKitDOMTestObj* TestObj:with-script-execution-context-and-script-state-attribute",
            WEBKIT_TYPE_DOM_TEST_OBJ,
            WEBKIT_PARAM_READWRITE));

    g_object_class_install_property(
        gobjectClass,
        PROP_WITH_SCRIPT_EXECUTION_CONTEXT_AND_SCRIPT_STATE_ATTRIBUTE_RAISES,
        g_param_spec_object(
            "with-script-execution-context-and-script-state-attribute-raises",
            "TestObj:with-script-execution-context-and-script-state-attribute-raises",
            "read-only WebKitDOMTestObj* TestObj:with-script-execution-context-and-script-state-attribute-raises",
            WEBKIT_TYPE_DOM_TEST_OBJ,
            WEBKIT_PARAM_READWRITE));

    g_object_class_install_property(
        gobjectClass,
        PROP_WITH_SCRIPT_EXECUTION_CONTEXT_AND_SCRIPT_STATE_WITH_SPACES_ATTRIBUTE,
        g_param_spec_object(
            "with-script-execution-context-and-script-state-with-spaces-attribute",
            "TestObj:with-script-execution-context-and-script-state-with-spaces-attribute",
            "read-only WebKitDOMTestObj* TestObj:with-script-execution-context-and-script-state-with-spaces-attribute",
            WEBKIT_TYPE_DOM_TEST_OBJ,
            WEBKIT_PARAM_READWRITE));

    g_object_class_install_property(
        gobjectClass,
        PROP_WITH_SCRIPT_ARGUMENTS_AND_CALL_STACK_ATTRIBUTE,
        g_param_spec_object(
            "with-script-arguments-and-call-stack-attribute",
            "TestObj:with-script-arguments-and-call-stack-attribute",
            "read-only WebKitDOMTestObj* TestObj:with-script-arguments-and-call-stack-attribute",
            WEBKIT_TYPE_DOM_TEST_OBJ,
            WEBKIT_PARAM_READWRITE));

    g_object_class_install_property(
        gobjectClass,
        PROP_CONDITIONAL_ATTR1,
        g_param_spec_long(
            "conditional-attr1",
            "TestObj:conditional-attr1",
            "read-only glong TestObj:conditional-attr1",
            G_MINLONG, G_MAXLONG, 0,
            WEBKIT_PARAM_READWRITE));

    g_object_class_install_property(
        gobjectClass,
        PROP_CONDITIONAL_ATTR2,
        g_param_spec_long(
            "conditional-attr2",
            "TestObj:conditional-attr2",
            "read-only glong TestObj:conditional-attr2",
            G_MINLONG, G_MAXLONG, 0,
            WEBKIT_PARAM_READWRITE));

    g_object_class_install_property(
        gobjectClass,
        PROP_CONDITIONAL_ATTR3,
        g_param_spec_long(
            "conditional-attr3",
            "TestObj:conditional-attr3",
            "read-only glong TestObj:conditional-attr3",
            G_MINLONG, G_MAXLONG, 0,
            WEBKIT_PARAM_READWRITE));

    g_object_class_install_property(
        gobjectClass,
        PROP_ANY_ATTRIBUTE,
        g_param_spec_object(
            "any-attribute",
            "TestObj:any-attribute",
            "read-only WebKitDOMany* TestObj:any-attribute",
            WEBKIT_TYPE_DOM_ANY,
            WEBKIT_PARAM_READWRITE));

    g_object_class_install_property(
        gobjectClass,
        PROP_CONTENT_DOCUMENT,
        g_param_spec_object(
            "content-document",
            "TestObj:content-document",
            "read-only WebKitDOMDocument* TestObj:content-document",
            WEBKIT_TYPE_DOM_DOCUMENT,
            WEBKIT_PARAM_READABLE));

    g_object_class_install_property(
        gobjectClass,
        PROP_MUTABLE_POINT,
        g_param_spec_object(
            "mutable-point",
            "TestObj:mutable-point",
            "read-only WebKitDOMSVGPoint* TestObj:mutable-point",
            WEBKIT_TYPE_DOM_SVG_POINT,
            WEBKIT_PARAM_READWRITE));

    g_object_class_install_property(
        gobjectClass,
        PROP_IMMUTABLE_POINT,
        g_param_spec_object(
            "immutable-point",
            "TestObj:immutable-point",
            "read-only WebKitDOMSVGPoint* TestObj:immutable-point",
            WEBKIT_TYPE_DOM_SVG_POINT,
            WEBKIT_PARAM_READWRITE));

    g_object_class_install_property(
        gobjectClass,
        PROP_STRAWBERRY,
        g_param_spec_long(
            "strawberry",
            "TestObj:strawberry",
            "read-only glong TestObj:strawberry",
            G_MINLONG, G_MAXLONG, 0,
            WEBKIT_PARAM_READWRITE));

    g_object_class_install_property(
        gobjectClass,
        PROP_STRICT_FLOAT,
        g_param_spec_float(
            "strict-float",
            "TestObj:strict-float",
            "read-only gfloat TestObj:strict-float",
            -G_MAXFLOAT, G_MAXFLOAT, 0,
            WEBKIT_PARAM_READWRITE));

    g_object_class_install_property(
        gobjectClass,
        PROP_DESCRIPTION,
        g_param_spec_long(
            "description",
            "TestObj:description",
            "read-only glong TestObj:description",
            G_MINLONG, G_MAXLONG, 0,
            WEBKIT_PARAM_READABLE));

    g_object_class_install_property(
        gobjectClass,
        PROP_ID,
        g_param_spec_long(
            "id",
            "TestObj:id",
            "read-only glong TestObj:id",
            G_MINLONG, G_MAXLONG, 0,
            WEBKIT_PARAM_READWRITE));

    g_object_class_install_property(
        gobjectClass,
        PROP_HASH,
        g_param_spec_string(
            "hash",
            "TestObj:hash",
            "read-only gchar* TestObj:hash",
            "",
            WEBKIT_PARAM_READABLE));

    g_object_class_install_property(
        gobjectClass,
        PROP_REPLACEABLE_ATTRIBUTE,
        g_param_spec_long(
            "replaceable-attribute",
            "TestObj:replaceable-attribute",
            "read-only glong TestObj:replaceable-attribute",
            G_MINLONG, G_MAXLONG, 0,
            WEBKIT_PARAM_READABLE));

    g_object_class_install_property(
        gobjectClass,
        PROP_NULLABLE_DOUBLE_ATTRIBUTE,
        g_param_spec_double(
            "nullable-double-attribute",
            "TestObj:nullable-double-attribute",
            "read-only gdouble TestObj:nullable-double-attribute",
            -G_MAXDOUBLE, G_MAXDOUBLE, 0,
            WEBKIT_PARAM_READABLE));

    g_object_class_install_property(
        gobjectClass,
        PROP_NULLABLE_LONG_ATTRIBUTE,
        g_param_spec_long(
            "nullable-long-attribute",
            "TestObj:nullable-long-attribute",
            "read-only glong TestObj:nullable-long-attribute",
            G_MINLONG, G_MAXLONG, 0,
            WEBKIT_PARAM_READABLE));

    g_object_class_install_property(
        gobjectClass,
        PROP_NULLABLE_BOOLEAN_ATTRIBUTE,
        g_param_spec_boolean(
            "nullable-boolean-attribute",
            "TestObj:nullable-boolean-attribute",
            "read-only gboolean TestObj:nullable-boolean-attribute",
            FALSE,
            WEBKIT_PARAM_READABLE));

    g_object_class_install_property(
        gobjectClass,
        PROP_NULLABLE_STRING_ATTRIBUTE,
        g_param_spec_string(
            "nullable-string-attribute",
            "TestObj:nullable-string-attribute",
            "read-only gchar* TestObj:nullable-string-attribute",
            "",
            WEBKIT_PARAM_READABLE));

    g_object_class_install_property(
        gobjectClass,
        PROP_NULLABLE_LONG_SETTABLE_ATTRIBUTE,
        g_param_spec_long(
            "nullable-long-settable-attribute",
            "TestObj:nullable-long-settable-attribute",
            "read-only glong TestObj:nullable-long-settable-attribute",
            G_MINLONG, G_MAXLONG, 0,
            WEBKIT_PARAM_READWRITE));

    g_object_class_install_property(
        gobjectClass,
        PROP_NULLABLE_STRING_VALUE,
        g_param_spec_long(
            "nullable-string-value",
            "TestObj:nullable-string-value",
            "read-only glong TestObj:nullable-string-value",
            G_MINLONG, G_MAXLONG, 0,
            WEBKIT_PARAM_READWRITE));

    g_object_class_install_property(
        gobjectClass,
        PROP_ATTRIBUTE,
        g_param_spec_string(
            "attribute",
            "TestObj:attribute",
            "read-only gchar* TestObj:attribute",
            "",
            WEBKIT_PARAM_READABLE));

}

static void webkit_dom_test_obj_init(WebKitDOMTestObj* request)
{
    WebKitDOMTestObjPrivate* priv = WEBKIT_DOM_TEST_OBJ_GET_PRIVATE(request);
    new (priv) WebKitDOMTestObjPrivate();
}

void webkit_dom_test_obj_void_method(WebKitDOMTestObj* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self));
    WebCore::TestObj* item = WebKit::core(self);
    item->voidMethod();
}

void webkit_dom_test_obj_void_method_with_args(WebKitDOMTestObj* self, glong longArg, const gchar* strArg, WebKitDOMTestObj* objArg)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self));
    g_return_if_fail(strArg);
    g_return_if_fail(WEBKIT_DOM_IS_TEST_OBJ(objArg));
    WebCore::TestObj* item = WebKit::core(self);
    WTF::String convertedStrArg = WTF::String::fromUTF8(strArg);
    WebCore::TestObj* convertedObjArg = WebKit::core(objArg);
    item->voidMethodWithArgs(longArg, convertedStrArg, convertedObjArg);
}

gint8 webkit_dom_test_obj_byte_method(WebKitDOMTestObj* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self), 0);
    WebCore::TestObj* item = WebKit::core(self);
    gint8 result = item->byteMethod();
    return result;
}

gint8 webkit_dom_test_obj_byte_method_with_args(WebKitDOMTestObj* self, gint8 byteArg, const gchar* strArg, WebKitDOMTestObj* objArg)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self), 0);
    g_return_val_if_fail(strArg, 0);
    g_return_val_if_fail(WEBKIT_DOM_IS_TEST_OBJ(objArg), 0);
    WebCore::TestObj* item = WebKit::core(self);
    WTF::String convertedStrArg = WTF::String::fromUTF8(strArg);
    WebCore::TestObj* convertedObjArg = WebKit::core(objArg);
    gint8 result = item->byteMethodWithArgs(byteArg, convertedStrArg, convertedObjArg);
    return result;
}

guint8 webkit_dom_test_obj_octet_method(WebKitDOMTestObj* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self), 0);
    WebCore::TestObj* item = WebKit::core(self);
    guint8 result = item->octetMethod();
    return result;
}

guint8 webkit_dom_test_obj_octet_method_with_args(WebKitDOMTestObj* self, guint8 octetArg, const gchar* strArg, WebKitDOMTestObj* objArg)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self), 0);
    g_return_val_if_fail(strArg, 0);
    g_return_val_if_fail(WEBKIT_DOM_IS_TEST_OBJ(objArg), 0);
    WebCore::TestObj* item = WebKit::core(self);
    WTF::String convertedStrArg = WTF::String::fromUTF8(strArg);
    WebCore::TestObj* convertedObjArg = WebKit::core(objArg);
    guint8 result = item->octetMethodWithArgs(octetArg, convertedStrArg, convertedObjArg);
    return result;
}

glong webkit_dom_test_obj_long_method(WebKitDOMTestObj* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self), 0);
    WebCore::TestObj* item = WebKit::core(self);
    glong result = item->longMethod();
    return result;
}

glong webkit_dom_test_obj_long_method_with_args(WebKitDOMTestObj* self, glong longArg, const gchar* strArg, WebKitDOMTestObj* objArg)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self), 0);
    g_return_val_if_fail(strArg, 0);
    g_return_val_if_fail(WEBKIT_DOM_IS_TEST_OBJ(objArg), 0);
    WebCore::TestObj* item = WebKit::core(self);
    WTF::String convertedStrArg = WTF::String::fromUTF8(strArg);
    WebCore::TestObj* convertedObjArg = WebKit::core(objArg);
    glong result = item->longMethodWithArgs(longArg, convertedStrArg, convertedObjArg);
    return result;
}

WebKitDOMTestObj* webkit_dom_test_obj_obj_method(WebKitDOMTestObj* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self), 0);
    WebCore::TestObj* item = WebKit::core(self);
    RefPtr<WebCore::TestObj> gobjectResult = WTF::getPtr(item->objMethod());
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMTestObj* webkit_dom_test_obj_obj_method_with_args(WebKitDOMTestObj* self, glong longArg, const gchar* strArg, WebKitDOMTestObj* objArg)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self), 0);
    g_return_val_if_fail(strArg, 0);
    g_return_val_if_fail(WEBKIT_DOM_IS_TEST_OBJ(objArg), 0);
    WebCore::TestObj* item = WebKit::core(self);
    WTF::String convertedStrArg = WTF::String::fromUTF8(strArg);
    WebCore::TestObj* convertedObjArg = WebKit::core(objArg);
    RefPtr<WebCore::TestObj> gobjectResult = WTF::getPtr(item->objMethodWithArgs(longArg, convertedStrArg, convertedObjArg));
    return WebKit::kit(gobjectResult.get());
}

void webkit_dom_test_obj_method_with_enum_arg(WebKitDOMTestObj* self, WebKitDOMTestEnumType* enumArg)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self));
    g_return_if_fail(WEBKIT_DOM_IS_TEST_ENUM_TYPE(enumArg));
    WebCore::TestObj* item = WebKit::core(self);
    WebCore::TestEnumType* convertedEnumArg = WebKit::core(enumArg);
    item->methodWithEnumArg(convertedEnumArg);
}

WebKitDOMTestObj* webkit_dom_test_obj_method_that_requires_all_args_and_throws(WebKitDOMTestObj* self, const gchar* strArg, WebKitDOMTestObj* objArg, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self), 0);
    g_return_val_if_fail(strArg, 0);
    g_return_val_if_fail(WEBKIT_DOM_IS_TEST_OBJ(objArg), 0);
    g_return_val_if_fail(!error || !*error, 0);
    WebCore::TestObj* item = WebKit::core(self);
    WTF::String convertedStrArg = WTF::String::fromUTF8(strArg);
    WebCore::TestObj* convertedObjArg = WebKit::core(objArg);
    WebCore::ExceptionCode ec = 0;
    RefPtr<WebCore::TestObj> gobjectResult = WTF::getPtr(item->methodThatRequiresAllArgsAndThrows(convertedStrArg, convertedObjArg, ec));
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
    return WebKit::kit(gobjectResult.get());
}

void webkit_dom_test_obj_serialized_value(WebKitDOMTestObj* self, WebKitDOMSerializedScriptValue* serializedArg)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self));
    g_return_if_fail(WEBKIT_DOM_IS_SERIALIZED_SCRIPT_VALUE(serializedArg));
    WebCore::TestObj* item = WebKit::core(self);
    WebCore::SerializedScriptValue* convertedSerializedArg = WebKit::core(serializedArg);
    item->serializedValue(convertedSerializedArg);
}

void webkit_dom_test_obj_options_object(WebKitDOMTestObj* self, WebKitDOMDictionary* oo, WebKitDOMDictionary* ooo)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self));
    g_return_if_fail(WEBKIT_DOM_IS_DICTIONARY(oo));
    g_return_if_fail(WEBKIT_DOM_IS_DICTIONARY(ooo));
    WebCore::TestObj* item = WebKit::core(self);
    WebCore::Dictionary* convertedOo = WebKit::core(oo);
    WebCore::Dictionary* convertedOoo = WebKit::core(ooo);
    item->optionsObject(convertedOo, convertedOoo);
}

void webkit_dom_test_obj_method_with_exception(WebKitDOMTestObj* self, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self));
    g_return_if_fail(!error || !*error);
    WebCore::TestObj* item = WebKit::core(self);
    WebCore::ExceptionCode ec = 0;
    item->methodWithException(ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
}

void webkit_dom_test_obj_with_script_state_void(WebKitDOMTestObj* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self));
    WebCore::TestObj* item = WebKit::core(self);
    item->withScriptStateVoid();
}

WebKitDOMTestObj* webkit_dom_test_obj_with_script_state_obj(WebKitDOMTestObj* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self), 0);
    WebCore::TestObj* item = WebKit::core(self);
    RefPtr<WebCore::TestObj> gobjectResult = WTF::getPtr(item->withScriptStateObj());
    return WebKit::kit(gobjectResult.get());
}

void webkit_dom_test_obj_with_script_state_void_exception(WebKitDOMTestObj* self, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self));
    g_return_if_fail(!error || !*error);
    WebCore::TestObj* item = WebKit::core(self);
    WebCore::ExceptionCode ec = 0;
    item->withScriptStateVoidException(ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
}

WebKitDOMTestObj* webkit_dom_test_obj_with_script_state_obj_exception(WebKitDOMTestObj* self, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self), 0);
    g_return_val_if_fail(!error || !*error, 0);
    WebCore::TestObj* item = WebKit::core(self);
    WebCore::ExceptionCode ec = 0;
    RefPtr<WebCore::TestObj> gobjectResult = WTF::getPtr(item->withScriptStateObjException(ec));
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
    return WebKit::kit(gobjectResult.get());
}

void webkit_dom_test_obj_with_script_execution_context(WebKitDOMTestObj* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self));
    WebCore::TestObj* item = WebKit::core(self);
    item->withScriptExecutionContext();
}

void webkit_dom_test_obj_with_script_execution_context_and_script_state(WebKitDOMTestObj* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self));
    WebCore::TestObj* item = WebKit::core(self);
    item->withScriptExecutionContextAndScriptState();
}

WebKitDOMTestObj* webkit_dom_test_obj_with_script_execution_context_and_script_state_obj_exception(WebKitDOMTestObj* self, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self), 0);
    g_return_val_if_fail(!error || !*error, 0);
    WebCore::TestObj* item = WebKit::core(self);
    WebCore::ExceptionCode ec = 0;
    RefPtr<WebCore::TestObj> gobjectResult = WTF::getPtr(item->withScriptExecutionContextAndScriptStateObjException(ec));
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMTestObj* webkit_dom_test_obj_with_script_execution_context_and_script_state_with_spaces(WebKitDOMTestObj* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self), 0);
    WebCore::TestObj* item = WebKit::core(self);
    RefPtr<WebCore::TestObj> gobjectResult = WTF::getPtr(item->withScriptExecutionContextAndScriptStateWithSpaces());
    return WebKit::kit(gobjectResult.get());
}

void webkit_dom_test_obj_method_with_optional_arg(WebKitDOMTestObj* self, glong opt)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self));
    WebCore::TestObj* item = WebKit::core(self);
    item->methodWithOptionalArg(opt);
}

void webkit_dom_test_obj_method_with_non_optional_arg_and_optional_arg(WebKitDOMTestObj* self, glong nonOpt, glong opt)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self));
    WebCore::TestObj* item = WebKit::core(self);
    item->methodWithNonOptionalArgAndOptionalArg(nonOpt, opt);
}

void webkit_dom_test_obj_method_with_non_optional_arg_and_two_optional_args(WebKitDOMTestObj* self, glong nonOpt, glong opt1, glong opt2)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self));
    WebCore::TestObj* item = WebKit::core(self);
    item->methodWithNonOptionalArgAndTwoOptionalArgs(nonOpt, opt1, opt2);
}

void webkit_dom_test_obj_method_with_optional_string(WebKitDOMTestObj* self, const gchar* str)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self));
    g_return_if_fail(str);
    WebCore::TestObj* item = WebKit::core(self);
    WTF::String convertedStr = WTF::String::fromUTF8(str);
    item->methodWithOptionalString(convertedStr);
}

void webkit_dom_test_obj_method_with_optional_string_is_undefined(WebKitDOMTestObj* self, const gchar* str)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self));
    g_return_if_fail(str);
    WebCore::TestObj* item = WebKit::core(self);
    WTF::String convertedStr = WTF::String::fromUTF8(str);
    item->methodWithOptionalStringIsUndefined(convertedStr);
}

void webkit_dom_test_obj_method_with_optional_string_is_null_string(WebKitDOMTestObj* self, const gchar* str)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self));
    g_return_if_fail(str);
    WebCore::TestObj* item = WebKit::core(self);
    WTF::String convertedStr = WTF::String::fromUTF8(str);
    item->methodWithOptionalStringIsNullString(convertedStr);
}

gchar* webkit_dom_test_obj_conditional_method1(WebKitDOMTestObj* self)
{
#if ENABLE(Condition1)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self), 0);
    WebCore::TestObj* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->conditionalMethod1());
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Condition1")
    return 0;
#endif /* ENABLE(Condition1) */
}

void webkit_dom_test_obj_conditional_method2(WebKitDOMTestObj* self)
{
#if ENABLE(Condition1) && ENABLE(Condition2)
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self));
    WebCore::TestObj* item = WebKit::core(self);
    item->conditionalMethod2();
#else
#if !ENABLE(Condition1)
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Condition1")
#endif
#if !ENABLE(Condition2)
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Condition2")
#endif
#endif /* ENABLE(Condition1) && ENABLE(Condition2) */
}

void webkit_dom_test_obj_conditional_method3(WebKitDOMTestObj* self)
{
#if ENABLE(Condition1) || ENABLE(Condition2)
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self));
    WebCore::TestObj* item = WebKit::core(self);
    item->conditionalMethod3();
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Condition1")
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Condition2")
#endif /* ENABLE(Condition1) || ENABLE(Condition2) */
}

void webkit_dom_test_obj_class_method(WebKitDOMTestObj* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self));
    WebCore::TestObj* item = WebKit::core(self);
    item->classMethod();
}

glong webkit_dom_test_obj_class_method_with_optional(WebKitDOMTestObj* self, glong arg)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self), 0);
    WebCore::TestObj* item = WebKit::core(self);
    glong result = item->classMethodWithOptional(arg);
    return result;
}

void webkit_dom_test_obj_overloaded_method1(WebKitDOMTestObj* self, glong arg)
{
#if ENABLE(Condition1)
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self));
    WebCore::TestObj* item = WebKit::core(self);
    item->overloadedMethod1(arg);
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Condition1")
#endif /* ENABLE(Condition1) */
}

void webkit_dom_test_obj_overloaded_method1(WebKitDOMTestObj* self, const gchar* type)
{
#if ENABLE(Condition1)
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self));
    g_return_if_fail(type);
    WebCore::TestObj* item = WebKit::core(self);
    WTF::String convertedType = WTF::String::fromUTF8(type);
    item->overloadedMethod1(convertedType);
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Condition1")
#endif /* ENABLE(Condition1) */
}

void webkit_dom_test_obj_convert1(WebKitDOMTestObj* self, WebKitDOMTestNode* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self));
    g_return_if_fail(WEBKIT_DOM_IS_TEST_NODE(value));
    WebCore::TestObj* item = WebKit::core(self);
    WebCore::TestNode* convertedValue = WebKit::core(value);
    item->convert1(convertedValue);
}

void webkit_dom_test_obj_convert2(WebKitDOMTestObj* self, WebKitDOMTestNode* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self));
    g_return_if_fail(WEBKIT_DOM_IS_TEST_NODE(value));
    WebCore::TestObj* item = WebKit::core(self);
    WebCore::TestNode* convertedValue = WebKit::core(value);
    item->convert2(convertedValue);
}

void webkit_dom_test_obj_convert4(WebKitDOMTestObj* self, WebKitDOMTestNode* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self));
    g_return_if_fail(WEBKIT_DOM_IS_TEST_NODE(value));
    WebCore::TestObj* item = WebKit::core(self);
    WebCore::TestNode* convertedValue = WebKit::core(value);
    item->convert4(convertedValue);
}

void webkit_dom_test_obj_convert5(WebKitDOMTestObj* self, WebKitDOMTestNode* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self));
    g_return_if_fail(WEBKIT_DOM_IS_TEST_NODE(value));
    WebCore::TestObj* item = WebKit::core(self);
    WebCore::TestNode* convertedValue = WebKit::core(value);
    item->convert5(convertedValue);
}

WebKitDOMSVGPoint* webkit_dom_test_obj_mutable_point_function(WebKitDOMTestObj* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self), 0);
    WebCore::TestObj* item = WebKit::core(self);
    RefPtr<WebCore::SVGPoint> gobjectResult = WTF::getPtr(item->mutablePointFunction());
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMSVGPoint* webkit_dom_test_obj_immutable_point_function(WebKitDOMTestObj* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self), 0);
    WebCore::TestObj* item = WebKit::core(self);
    RefPtr<WebCore::SVGPoint> gobjectResult = WTF::getPtr(item->immutablePointFunction());
    return WebKit::kit(gobjectResult.get());
}

void webkit_dom_test_obj_orange(WebKitDOMTestObj* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self));
    WebCore::TestObj* item = WebKit::core(self);
    item->banana();
}

WebKitDOMbool* webkit_dom_test_obj_strict_function(WebKitDOMTestObj* self, const gchar* str, gfloat a, glong b, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self), 0);
    g_return_val_if_fail(str, 0);
    g_return_val_if_fail(!error || !*error, 0);
    WebCore::TestObj* item = WebKit::core(self);
    WTF::String convertedStr = WTF::String::fromUTF8(str);
    WebCore::ExceptionCode ec = 0;
    RefPtr<WebCore::bool> gobjectResult = WTF::getPtr(item->strictFunction(convertedStr, a, b, ec));
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
    return WebKit::kit(gobjectResult.get());
}

void webkit_dom_test_obj_variadic_string_method(WebKitDOMTestObj* self, const gchar* head, const gchar* tail)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self));
    g_return_if_fail(head);
    g_return_if_fail(tail);
    WebCore::TestObj* item = WebKit::core(self);
    WTF::String convertedHead = WTF::String::fromUTF8(head);
    WTF::String convertedTail = WTF::String::fromUTF8(tail);
    item->variadicStringMethod(convertedHead, convertedTail);
}

void webkit_dom_test_obj_variadic_double_method(WebKitDOMTestObj* self, gdouble head, gdouble tail)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self));
    WebCore::TestObj* item = WebKit::core(self);
    item->variadicDoubleMethod(head, tail);
}

void webkit_dom_test_obj_variadic_node_method(WebKitDOMTestObj* self, WebKitDOMNode* head, WebKitDOMNode* tail)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self));
    g_return_if_fail(WEBKIT_DOM_IS_NODE(head));
    g_return_if_fail(WEBKIT_DOM_IS_NODE(tail));
    WebCore::TestObj* item = WebKit::core(self);
    WebCore::Node* convertedHead = WebKit::core(head);
    WebCore::Node* convertedTail = WebKit::core(tail);
    item->variadicNodeMethod(convertedHead, convertedTail);
}

void webkit_dom_test_obj_any(WebKitDOMTestObj* self, gfloat a, glong b)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self));
    WebCore::TestObj* item = WebKit::core(self);
    item->any(a, b);
}

glong webkit_dom_test_obj_get_read_only_long_attr(WebKitDOMTestObj* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self), 0);
    WebCore::TestObj* item = WebKit::core(self);
    glong result = item->readOnlyLongAttr();
    return result;
}

gchar* webkit_dom_test_obj_get_read_only_string_attr(WebKitDOMTestObj* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self), 0);
    WebCore::TestObj* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->readOnlyStringAttr());
    return result;
}

WebKitDOMTestObj* webkit_dom_test_obj_get_read_only_test_obj_attr(WebKitDOMTestObj* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self), 0);
    WebCore::TestObj* item = WebKit::core(self);
    RefPtr<WebCore::TestObj> gobjectResult = WTF::getPtr(item->readOnlyTestObjAttr());
    return WebKit::kit(gobjectResult.get());
}

gint8 webkit_dom_test_obj_get_byte_attr(WebKitDOMTestObj* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self), 0);
    WebCore::TestObj* item = WebKit::core(self);
    gint8 result = item->byteAttr();
    return result;
}

void webkit_dom_test_obj_set_byte_attr(WebKitDOMTestObj* self, gint8 value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self));
    WebCore::TestObj* item = WebKit::core(self);
    item->setByteAttr(value);
}

guint8 webkit_dom_test_obj_get_octet_attr(WebKitDOMTestObj* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self), 0);
    WebCore::TestObj* item = WebKit::core(self);
    guint8 result = item->octetAttr();
    return result;
}

void webkit_dom_test_obj_set_octet_attr(WebKitDOMTestObj* self, guint8 value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self));
    WebCore::TestObj* item = WebKit::core(self);
    item->setOctetAttr(value);
}

gshort webkit_dom_test_obj_get_short_attr(WebKitDOMTestObj* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self), 0);
    WebCore::TestObj* item = WebKit::core(self);
    gshort result = item->shortAttr();
    return result;
}

void webkit_dom_test_obj_set_short_attr(WebKitDOMTestObj* self, gshort value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self));
    WebCore::TestObj* item = WebKit::core(self);
    item->setShortAttr(value);
}

gushort webkit_dom_test_obj_get_unsigned_short_attr(WebKitDOMTestObj* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self), 0);
    WebCore::TestObj* item = WebKit::core(self);
    gushort result = item->unsignedShortAttr();
    return result;
}

void webkit_dom_test_obj_set_unsigned_short_attr(WebKitDOMTestObj* self, gushort value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self));
    WebCore::TestObj* item = WebKit::core(self);
    item->setUnsignedShortAttr(value);
}

glong webkit_dom_test_obj_get_long_attr(WebKitDOMTestObj* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self), 0);
    WebCore::TestObj* item = WebKit::core(self);
    glong result = item->longAttr();
    return result;
}

void webkit_dom_test_obj_set_long_attr(WebKitDOMTestObj* self, glong value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self));
    WebCore::TestObj* item = WebKit::core(self);
    item->setLongAttr(value);
}

gint64 webkit_dom_test_obj_get_long_long_attr(WebKitDOMTestObj* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self), 0);
    WebCore::TestObj* item = WebKit::core(self);
    gint64 result = item->longLongAttr();
    return result;
}

void webkit_dom_test_obj_set_long_long_attr(WebKitDOMTestObj* self, gint64 value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self));
    WebCore::TestObj* item = WebKit::core(self);
    item->setLongLongAttr(value);
}

guint64 webkit_dom_test_obj_get_unsigned_long_long_attr(WebKitDOMTestObj* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self), 0);
    WebCore::TestObj* item = WebKit::core(self);
    guint64 result = item->unsignedLongLongAttr();
    return result;
}

void webkit_dom_test_obj_set_unsigned_long_long_attr(WebKitDOMTestObj* self, guint64 value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self));
    WebCore::TestObj* item = WebKit::core(self);
    item->setUnsignedLongLongAttr(value);
}

gchar* webkit_dom_test_obj_get_string_attr(WebKitDOMTestObj* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self), 0);
    WebCore::TestObj* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->stringAttr());
    return result;
}

void webkit_dom_test_obj_set_string_attr(WebKitDOMTestObj* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self));
    g_return_if_fail(value);
    WebCore::TestObj* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setStringAttr(convertedValue);
}

WebKitDOMTestObj* webkit_dom_test_obj_get_test_obj_attr(WebKitDOMTestObj* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self), 0);
    WebCore::TestObj* item = WebKit::core(self);
    RefPtr<WebCore::TestObj> gobjectResult = WTF::getPtr(item->testObjAttr());
    return WebKit::kit(gobjectResult.get());
}

void webkit_dom_test_obj_set_test_obj_attr(WebKitDOMTestObj* self, WebKitDOMTestObj* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self));
    g_return_if_fail(WEBKIT_DOM_IS_TEST_OBJ(value));
    WebCore::TestObj* item = WebKit::core(self);
    WebCore::TestObj* convertedValue = WebKit::core(value);
    item->setTestObjAttr(convertedValue);
}

WebKitDOMTestObj* webkit_dom_test_obj_get_xml_obj_attr(WebKitDOMTestObj* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self), 0);
    WebCore::TestObj* item = WebKit::core(self);
    RefPtr<WebCore::TestObj> gobjectResult = WTF::getPtr(item->xmlObjAttr());
    return WebKit::kit(gobjectResult.get());
}

void webkit_dom_test_obj_set_xml_obj_attr(WebKitDOMTestObj* self, WebKitDOMTestObj* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self));
    g_return_if_fail(WEBKIT_DOM_IS_TEST_OBJ(value));
    WebCore::TestObj* item = WebKit::core(self);
    WebCore::TestObj* convertedValue = WebKit::core(value);
    item->setXMLObjAttr(convertedValue);
}

gboolean webkit_dom_test_obj_get_create(WebKitDOMTestObj* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self), FALSE);
    WebCore::TestObj* item = WebKit::core(self);
    gboolean result = item->isCreate();
    return result;
}

void webkit_dom_test_obj_set_create(WebKitDOMTestObj* self, gboolean value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self));
    WebCore::TestObj* item = WebKit::core(self);
    item->setCreate(value);
}

gchar* webkit_dom_test_obj_get_reflected_string_attr(WebKitDOMTestObj* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self), 0);
    WebCore::TestObj* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::reflectedstringattrAttr));
    return result;
}

void webkit_dom_test_obj_set_reflected_string_attr(WebKitDOMTestObj* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self));
    g_return_if_fail(value);
    WebCore::TestObj* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::reflectedstringattrAttr, convertedValue);
}

glong webkit_dom_test_obj_get_reflected_integral_attr(WebKitDOMTestObj* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self), 0);
    WebCore::TestObj* item = WebKit::core(self);
    glong result = item->getIntegralAttribute(WebCore::HTMLNames::reflectedintegralattrAttr);
    return result;
}

void webkit_dom_test_obj_set_reflected_integral_attr(WebKitDOMTestObj* self, glong value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self));
    WebCore::TestObj* item = WebKit::core(self);
    item->setIntegralAttribute(WebCore::HTMLNames::reflectedintegralattrAttr, value);
}

gulong webkit_dom_test_obj_get_reflected_unsigned_integral_attr(WebKitDOMTestObj* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self), 0);
    WebCore::TestObj* item = WebKit::core(self);
    gulong result = item->getUnsignedIntegralAttribute(WebCore::HTMLNames::reflectedunsignedintegralattrAttr);
    return result;
}

void webkit_dom_test_obj_set_reflected_unsigned_integral_attr(WebKitDOMTestObj* self, gulong value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self));
    WebCore::TestObj* item = WebKit::core(self);
    item->setUnsignedIntegralAttribute(WebCore::HTMLNames::reflectedunsignedintegralattrAttr, value);
}

gboolean webkit_dom_test_obj_get_reflected_boolean_attr(WebKitDOMTestObj* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self), FALSE);
    WebCore::TestObj* item = WebKit::core(self);
    gboolean result = item->fastHasAttribute(WebCore::HTMLNames::reflectedbooleanattrAttr);
    return result;
}

void webkit_dom_test_obj_set_reflected_boolean_attr(WebKitDOMTestObj* self, gboolean value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self));
    WebCore::TestObj* item = WebKit::core(self);
    item->setBooleanAttribute(WebCore::HTMLNames::reflectedbooleanattrAttr, value);
}

gchar* webkit_dom_test_obj_get_reflected_url_attr(WebKitDOMTestObj* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self), 0);
    WebCore::TestObj* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->getURLAttribute(WebCore::HTMLNames::reflectedurlattrAttr));
    return result;
}

void webkit_dom_test_obj_set_reflected_url_attr(WebKitDOMTestObj* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self));
    g_return_if_fail(value);
    WebCore::TestObj* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::reflectedurlattrAttr, convertedValue);
}

gchar* webkit_dom_test_obj_get_reflected_string_attr(WebKitDOMTestObj* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self), 0);
    WebCore::TestObj* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::customContentStringAttrAttr));
    return result;
}

void webkit_dom_test_obj_set_reflected_string_attr(WebKitDOMTestObj* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self));
    g_return_if_fail(value);
    WebCore::TestObj* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::customContentStringAttrAttr, convertedValue);
}

glong webkit_dom_test_obj_get_reflected_custom_integral_attr(WebKitDOMTestObj* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self), 0);
    WebCore::TestObj* item = WebKit::core(self);
    glong result = item->getIntegralAttribute(WebCore::HTMLNames::customContentIntegralAttrAttr);
    return result;
}

void webkit_dom_test_obj_set_reflected_custom_integral_attr(WebKitDOMTestObj* self, glong value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self));
    WebCore::TestObj* item = WebKit::core(self);
    item->setIntegralAttribute(WebCore::HTMLNames::customContentIntegralAttrAttr, value);
}

gboolean webkit_dom_test_obj_get_reflected_custom_boolean_attr(WebKitDOMTestObj* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self), FALSE);
    WebCore::TestObj* item = WebKit::core(self);
    gboolean result = item->fastHasAttribute(WebCore::HTMLNames::customContentBooleanAttrAttr);
    return result;
}

void webkit_dom_test_obj_set_reflected_custom_boolean_attr(WebKitDOMTestObj* self, gboolean value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self));
    WebCore::TestObj* item = WebKit::core(self);
    item->setBooleanAttribute(WebCore::HTMLNames::customContentBooleanAttrAttr, value);
}

gchar* webkit_dom_test_obj_get_reflected_custom_url_attr(WebKitDOMTestObj* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self), 0);
    WebCore::TestObj* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->getURLAttribute(WebCore::HTMLNames::customContentURLAttrAttr));
    return result;
}

void webkit_dom_test_obj_set_reflected_custom_url_attr(WebKitDOMTestObj* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self));
    g_return_if_fail(value);
    WebCore::TestObj* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::customContentURLAttrAttr, convertedValue);
}

glong webkit_dom_test_obj_get_attr_with_getter_exception(WebKitDOMTestObj* self, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self), 0);
    g_return_val_if_fail(!error || !*error, 0);
    WebCore::TestObj* item = WebKit::core(self);
    WebCore::ExceptionCode ec = 0;
    glong result = item->attrWithGetterException(ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
    return result;
}

void webkit_dom_test_obj_set_attr_with_getter_exception(WebKitDOMTestObj* self, glong value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self));
    WebCore::TestObj* item = WebKit::core(self);
    item->setAttrWithGetterException(value);
}

glong webkit_dom_test_obj_get_attr_with_setter_exception(WebKitDOMTestObj* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self), 0);
    WebCore::TestObj* item = WebKit::core(self);
    glong result = item->attrWithSetterException();
    return result;
}

void webkit_dom_test_obj_set_attr_with_setter_exception(WebKitDOMTestObj* self, glong value, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self));
    g_return_if_fail(!error || !*error);
    WebCore::TestObj* item = WebKit::core(self);
    WebCore::ExceptionCode ec = 0;
    item->setAttrWithSetterException(value, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
}

gchar* webkit_dom_test_obj_get_string_attr_with_getter_exception(WebKitDOMTestObj* self, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self), 0);
    g_return_val_if_fail(!error || !*error, 0);
    WebCore::TestObj* item = WebKit::core(self);
    WebCore::ExceptionCode ec = 0;
    gchar* result = convertToUTF8String(item->stringAttrWithGetterException(ec));
    return result;
}

void webkit_dom_test_obj_set_string_attr_with_getter_exception(WebKitDOMTestObj* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self));
    g_return_if_fail(value);
    WebCore::TestObj* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setStringAttrWithGetterException(convertedValue);
}

gchar* webkit_dom_test_obj_get_string_attr_with_setter_exception(WebKitDOMTestObj* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self), 0);
    WebCore::TestObj* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->stringAttrWithSetterException());
    return result;
}

void webkit_dom_test_obj_set_string_attr_with_setter_exception(WebKitDOMTestObj* self, const gchar* value, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self));
    g_return_if_fail(value);
    g_return_if_fail(!error || !*error);
    WebCore::TestObj* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    WebCore::ExceptionCode ec = 0;
    item->setStringAttrWithSetterException(convertedValue, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
}

glong webkit_dom_test_obj_get_with_script_state_attribute(WebKitDOMTestObj* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self), 0);
    WebCore::TestObj* item = WebKit::core(self);
    glong result = item->withScriptStateAttribute();
    return result;
}

void webkit_dom_test_obj_set_with_script_state_attribute(WebKitDOMTestObj* self, glong value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self));
    WebCore::TestObj* item = WebKit::core(self);
    item->setWithScriptStateAttribute(value);
}

WebKitDOMTestObj* webkit_dom_test_obj_get_with_script_execution_context_attribute(WebKitDOMTestObj* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self), 0);
    WebCore::TestObj* item = WebKit::core(self);
    RefPtr<WebCore::TestObj> gobjectResult = WTF::getPtr(item->withScriptExecutionContextAttribute());
    return WebKit::kit(gobjectResult.get());
}

void webkit_dom_test_obj_set_with_script_execution_context_attribute(WebKitDOMTestObj* self, WebKitDOMTestObj* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self));
    g_return_if_fail(WEBKIT_DOM_IS_TEST_OBJ(value));
    WebCore::TestObj* item = WebKit::core(self);
    WebCore::TestObj* convertedValue = WebKit::core(value);
    item->setWithScriptExecutionContextAttribute(convertedValue);
}

WebKitDOMTestObj* webkit_dom_test_obj_get_with_script_state_attribute_raises(WebKitDOMTestObj* self, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self), 0);
    g_return_val_if_fail(!error || !*error, 0);
    WebCore::TestObj* item = WebKit::core(self);
    WebCore::ExceptionCode ec = 0;
    RefPtr<WebCore::TestObj> gobjectResult = WTF::getPtr(item->withScriptStateAttributeRaises(ec));
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
    return WebKit::kit(gobjectResult.get());
}

void webkit_dom_test_obj_set_with_script_state_attribute_raises(WebKitDOMTestObj* self, WebKitDOMTestObj* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self));
    g_return_if_fail(WEBKIT_DOM_IS_TEST_OBJ(value));
    WebCore::TestObj* item = WebKit::core(self);
    WebCore::TestObj* convertedValue = WebKit::core(value);
    item->setWithScriptStateAttributeRaises(convertedValue);
}

WebKitDOMTestObj* webkit_dom_test_obj_get_with_script_execution_context_attribute_raises(WebKitDOMTestObj* self, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self), 0);
    g_return_val_if_fail(!error || !*error, 0);
    WebCore::TestObj* item = WebKit::core(self);
    WebCore::ExceptionCode ec = 0;
    RefPtr<WebCore::TestObj> gobjectResult = WTF::getPtr(item->withScriptExecutionContextAttributeRaises(ec));
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
    return WebKit::kit(gobjectResult.get());
}

void webkit_dom_test_obj_set_with_script_execution_context_attribute_raises(WebKitDOMTestObj* self, WebKitDOMTestObj* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self));
    g_return_if_fail(WEBKIT_DOM_IS_TEST_OBJ(value));
    WebCore::TestObj* item = WebKit::core(self);
    WebCore::TestObj* convertedValue = WebKit::core(value);
    item->setWithScriptExecutionContextAttributeRaises(convertedValue);
}

WebKitDOMTestObj* webkit_dom_test_obj_get_with_script_execution_context_and_script_state_attribute(WebKitDOMTestObj* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self), 0);
    WebCore::TestObj* item = WebKit::core(self);
    RefPtr<WebCore::TestObj> gobjectResult = WTF::getPtr(item->withScriptExecutionContextAndScriptStateAttribute());
    return WebKit::kit(gobjectResult.get());
}

void webkit_dom_test_obj_set_with_script_execution_context_and_script_state_attribute(WebKitDOMTestObj* self, WebKitDOMTestObj* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self));
    g_return_if_fail(WEBKIT_DOM_IS_TEST_OBJ(value));
    WebCore::TestObj* item = WebKit::core(self);
    WebCore::TestObj* convertedValue = WebKit::core(value);
    item->setWithScriptExecutionContextAndScriptStateAttribute(convertedValue);
}

WebKitDOMTestObj* webkit_dom_test_obj_get_with_script_execution_context_and_script_state_attribute_raises(WebKitDOMTestObj* self, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self), 0);
    g_return_val_if_fail(!error || !*error, 0);
    WebCore::TestObj* item = WebKit::core(self);
    WebCore::ExceptionCode ec = 0;
    RefPtr<WebCore::TestObj> gobjectResult = WTF::getPtr(item->withScriptExecutionContextAndScriptStateAttributeRaises(ec));
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
    return WebKit::kit(gobjectResult.get());
}

void webkit_dom_test_obj_set_with_script_execution_context_and_script_state_attribute_raises(WebKitDOMTestObj* self, WebKitDOMTestObj* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self));
    g_return_if_fail(WEBKIT_DOM_IS_TEST_OBJ(value));
    WebCore::TestObj* item = WebKit::core(self);
    WebCore::TestObj* convertedValue = WebKit::core(value);
    item->setWithScriptExecutionContextAndScriptStateAttributeRaises(convertedValue);
}

WebKitDOMTestObj* webkit_dom_test_obj_get_with_script_execution_context_and_script_state_with_spaces_attribute(WebKitDOMTestObj* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self), 0);
    WebCore::TestObj* item = WebKit::core(self);
    RefPtr<WebCore::TestObj> gobjectResult = WTF::getPtr(item->withScriptExecutionContextAndScriptStateWithSpacesAttribute());
    return WebKit::kit(gobjectResult.get());
}

void webkit_dom_test_obj_set_with_script_execution_context_and_script_state_with_spaces_attribute(WebKitDOMTestObj* self, WebKitDOMTestObj* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self));
    g_return_if_fail(WEBKIT_DOM_IS_TEST_OBJ(value));
    WebCore::TestObj* item = WebKit::core(self);
    WebCore::TestObj* convertedValue = WebKit::core(value);
    item->setWithScriptExecutionContextAndScriptStateWithSpacesAttribute(convertedValue);
}

glong webkit_dom_test_obj_get_conditional_attr1(WebKitDOMTestObj* self)
{
#if ENABLE(Condition1)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self), 0);
    WebCore::TestObj* item = WebKit::core(self);
    glong result = item->conditionalAttr1();
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Condition1")
    return static_cast<glong>(0);
#endif /* ENABLE(Condition1) */
}

void webkit_dom_test_obj_set_conditional_attr1(WebKitDOMTestObj* self, glong value)
{
#if ENABLE(Condition1)
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self));
    WebCore::TestObj* item = WebKit::core(self);
    item->setConditionalAttr1(value);
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Condition1")
#endif /* ENABLE(Condition1) */
}

glong webkit_dom_test_obj_get_conditional_attr2(WebKitDOMTestObj* self)
{
#if ENABLE(Condition1) && ENABLE(Condition2)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self), 0);
    WebCore::TestObj* item = WebKit::core(self);
    glong result = item->conditionalAttr2();
    return result;
#else
#if !ENABLE(Condition1)
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Condition1")
#endif
#if !ENABLE(Condition2)
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Condition2")
#endif
    return static_cast<glong>(0);
#endif /* ENABLE(Condition1) && ENABLE(Condition2) */
}

void webkit_dom_test_obj_set_conditional_attr2(WebKitDOMTestObj* self, glong value)
{
#if ENABLE(Condition1) && ENABLE(Condition2)
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self));
    WebCore::TestObj* item = WebKit::core(self);
    item->setConditionalAttr2(value);
#else
#if !ENABLE(Condition1)
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Condition1")
#endif
#if !ENABLE(Condition2)
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Condition2")
#endif
#endif /* ENABLE(Condition1) && ENABLE(Condition2) */
}

glong webkit_dom_test_obj_get_conditional_attr3(WebKitDOMTestObj* self)
{
#if ENABLE(Condition1) || ENABLE(Condition2)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self), 0);
    WebCore::TestObj* item = WebKit::core(self);
    glong result = item->conditionalAttr3();
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Condition1")
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Condition2")
    return static_cast<glong>(0);
#endif /* ENABLE(Condition1) || ENABLE(Condition2) */
}

void webkit_dom_test_obj_set_conditional_attr3(WebKitDOMTestObj* self, glong value)
{
#if ENABLE(Condition1) || ENABLE(Condition2)
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self));
    WebCore::TestObj* item = WebKit::core(self);
    item->setConditionalAttr3(value);
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Condition1")
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Condition2")
#endif /* ENABLE(Condition1) || ENABLE(Condition2) */
}

WebKitDOMany* webkit_dom_test_obj_get_any_attribute(WebKitDOMTestObj* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self), 0);
    WebCore::TestObj* item = WebKit::core(self);
    RefPtr<WebCore::any> gobjectResult = WTF::getPtr(item->anyAttribute());
    return 0; // TODO: return canvas object
}

void webkit_dom_test_obj_set_any_attribute(WebKitDOMTestObj* self, WebKitDOMany* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self));
    g_return_if_fail(WEBKIT_DOM_IS_ANY(value));
    WebCore::TestObj* item = WebKit::core(self);
    WebCore::any* convertedValue = WebKit::core(value);
    item->setAnyAttribute(convertedValue);
}

WebKitDOMDocument* webkit_dom_test_obj_get_content_document(WebKitDOMTestObj* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self), 0);
    WebCore::TestObj* item = WebKit::core(self);
    RefPtr<WebCore::Document> gobjectResult = WTF::getPtr(item->contentDocument());
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMSVGPoint* webkit_dom_test_obj_get_mutable_point(WebKitDOMTestObj* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self), 0);
    WebCore::TestObj* item = WebKit::core(self);
    RefPtr<WebCore::SVGPoint> gobjectResult = WTF::getPtr(item->mutablePoint());
    return WebKit::kit(gobjectResult.get());
}

void webkit_dom_test_obj_set_mutable_point(WebKitDOMTestObj* self, WebKitDOMSVGPoint* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self));
    g_return_if_fail(WEBKIT_DOM_IS_SVG_POINT(value));
    WebCore::TestObj* item = WebKit::core(self);
    WebCore::SVGPoint* convertedValue = WebKit::core(value);
    item->setMutablePoint(convertedValue);
}

WebKitDOMSVGPoint* webkit_dom_test_obj_get_immutable_point(WebKitDOMTestObj* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self), 0);
    WebCore::TestObj* item = WebKit::core(self);
    RefPtr<WebCore::SVGPoint> gobjectResult = WTF::getPtr(item->immutablePoint());
    return WebKit::kit(gobjectResult.get());
}

void webkit_dom_test_obj_set_immutable_point(WebKitDOMTestObj* self, WebKitDOMSVGPoint* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self));
    g_return_if_fail(WEBKIT_DOM_IS_SVG_POINT(value));
    WebCore::TestObj* item = WebKit::core(self);
    WebCore::SVGPoint* convertedValue = WebKit::core(value);
    item->setImmutablePoint(convertedValue);
}

glong webkit_dom_test_obj_get_strawberry(WebKitDOMTestObj* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self), 0);
    WebCore::TestObj* item = WebKit::core(self);
    glong result = item->blueberry();
    return result;
}

void webkit_dom_test_obj_set_strawberry(WebKitDOMTestObj* self, glong value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self));
    WebCore::TestObj* item = WebKit::core(self);
    item->setBlueberry(value);
}

gfloat webkit_dom_test_obj_get_strict_float(WebKitDOMTestObj* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self), 0);
    WebCore::TestObj* item = WebKit::core(self);
    gfloat result = item->strictFloat();
    return result;
}

void webkit_dom_test_obj_set_strict_float(WebKitDOMTestObj* self, gfloat value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self));
    WebCore::TestObj* item = WebKit::core(self);
    item->setStrictFloat(value);
}

glong webkit_dom_test_obj_get_description(WebKitDOMTestObj* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self), 0);
    WebCore::TestObj* item = WebKit::core(self);
    glong result = item->description();
    return result;
}

glong webkit_dom_test_obj_get_id(WebKitDOMTestObj* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self), 0);
    WebCore::TestObj* item = WebKit::core(self);
    glong result = item->id();
    return result;
}

void webkit_dom_test_obj_set_id(WebKitDOMTestObj* self, glong value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self));
    WebCore::TestObj* item = WebKit::core(self);
    item->setId(value);
}

gchar* webkit_dom_test_obj_get_hash(WebKitDOMTestObj* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self), 0);
    WebCore::TestObj* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->hash());
    return result;
}

glong webkit_dom_test_obj_get_replaceable_attribute(WebKitDOMTestObj* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self), 0);
    WebCore::TestObj* item = WebKit::core(self);
    glong result = item->replaceableAttribute();
    return result;
}

gdouble webkit_dom_test_obj_get_nullable_double_attribute(WebKitDOMTestObj* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self), 0);
    WebCore::TestObj* item = WebKit::core(self);
    bool isNull = false;
    gdouble result = item->nullableDoubleAttribute(isNull);
    return result;
}

glong webkit_dom_test_obj_get_nullable_long_attribute(WebKitDOMTestObj* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self), 0);
    WebCore::TestObj* item = WebKit::core(self);
    bool isNull = false;
    glong result = item->nullableLongAttribute(isNull);
    return result;
}

gboolean webkit_dom_test_obj_get_nullable_boolean_attribute(WebKitDOMTestObj* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self), FALSE);
    WebCore::TestObj* item = WebKit::core(self);
    bool isNull = false;
    gboolean result = item->nullableBooleanAttribute(isNull);
    return result;
}

gchar* webkit_dom_test_obj_get_nullable_string_attribute(WebKitDOMTestObj* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self), 0);
    WebCore::TestObj* item = WebKit::core(self);
    bool isNull = false;
    gchar* result = convertToUTF8String(item->nullableStringAttribute(isNull));
    return result;
}

glong webkit_dom_test_obj_get_nullable_long_settable_attribute(WebKitDOMTestObj* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self), 0);
    WebCore::TestObj* item = WebKit::core(self);
    bool isNull = false;
    glong result = item->nullableLongSettableAttribute(isNull);
    return result;
}

void webkit_dom_test_obj_set_nullable_long_settable_attribute(WebKitDOMTestObj* self, glong value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self));
    WebCore::TestObj* item = WebKit::core(self);
    item->setNullableLongSettableAttribute(value);
}

glong webkit_dom_test_obj_get_nullable_string_value(WebKitDOMTestObj* self, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self), 0);
    g_return_val_if_fail(!error || !*error, 0);
    WebCore::TestObj* item = WebKit::core(self);
    bool isNull = false;
    WebCore::ExceptionCode ec = 0;
    glong result = item->nullableStringValue(isNull, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
    return result;
}

void webkit_dom_test_obj_set_nullable_string_value(WebKitDOMTestObj* self, glong value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self));
    WebCore::TestObj* item = WebKit::core(self);
    item->setNullableStringValue(value);
}

gchar* webkit_dom_test_obj_get_attribute(WebKitDOMTestObj* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEST_OBJ(self), 0);
    WebCore::TestObj* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->attribute());
    return result;
}

