//                                               -*- C++ -*-
/**
 *  @brief The external header file of OpenTURNS for subdir Stat
 *
 *  Copyright 2005-2019 Airbus-EDF-IMACS-Phimeca
 *
 *  This library is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef OPENTURNS_OTSTAT_HXX
#define OPENTURNS_OTSTAT_HXX

#include "openturns/Compact.hxx"
#include "openturns/CorrelationAnalysis.hxx"
#include "openturns/CorrelationMatrix.hxx"
#include "openturns/CovarianceMatrix.hxx"
#include "openturns/csv_parser_state.hxx"
#include "openturns/Full.hxx"
#include "openturns/ReverseHaltonSequence.hxx"
#include "openturns/FaureSequence.hxx"
#include "openturns/HaltonSequence.hxx"
#include "openturns/HaselgroveSequence.hxx"
#include "openturns/HistoryStrategy.hxx"
#include "openturns/HistoryStrategyImplementation.hxx"
#include "openturns/Last.hxx"
#include "openturns/LowDiscrepancySequence.hxx"
#include "openturns/LowDiscrepancySequenceImplementation.hxx"
#include "openturns/Null.hxx"
#include "openturns/Sample.hxx"
#include "openturns/SampleImplementation.hxx"
#include "openturns/FieldImplementation.hxx"
#include "openturns/Field.hxx"
#include "openturns/Field.hxx"
#include "openturns/ProcessSample.hxx"
#include "openturns/ProcessSampleImplementation.hxx"
#include "openturns/RandomGenerator.hxx"
#include "openturns/SobolSequence.hxx"
#include "openturns/TestResult.hxx"
#include "openturns/TimeSeries.hxx"
#include "openturns/FilteringWindowsImplementation.hxx"
#include "openturns/FilteringWindows.hxx"
#include "openturns/Hamming.hxx"
#include "openturns/Hanning.hxx"
#include "openturns/SpectralModel.hxx"
#include "openturns/CovarianceModelImplementation.hxx"
#include "openturns/SpectralModelImplementation.hxx"
#include "openturns/CovarianceModel.hxx"
#include "openturns/StationaryCovarianceModel.hxx"
#include "openturns/SpectralModelFactoryImplementation.hxx"
#include "openturns/SpectralModelFactory.hxx"
#include "openturns/UserDefinedSpectralModel.hxx"
#include "openturns/WelchFactory.hxx"
#include "openturns/ExponentialModel.hxx"
#include "openturns/ExponentiallyDampedCosineModel.hxx"
#include "openturns/CauchyModel.hxx"
#include "openturns/CovarianceModelFactoryImplementation.hxx"
#include "openturns/CovarianceModelFactory.hxx"
#include "openturns/UserDefinedCovarianceModel.hxx"
#include "openturns/NonStationaryCovarianceModelFactory.hxx"
#include "openturns/UserDefinedStationaryCovarianceModel.hxx"
#include "openturns/StationaryCovarianceModelFactory.hxx"
#include "openturns/SquaredExponential.hxx"
#include "openturns/GeneralizedExponential.hxx"
#include "openturns/AbsoluteExponential.hxx"
#include "openturns/FractionalBrownianMotionModel.hxx"
#include "openturns/SphericalModel.hxx"
#include "openturns/MaternModel.hxx"
#include "openturns/DiracCovarianceModel.hxx"
#include "openturns/HMatrixParameters.hxx"
#include "openturns/ProductCovarianceModel.hxx"
#include "openturns/RankMCovarianceModel.hxx"
#include "openturns/TensorizedCovarianceModel.hxx"
#include "openturns/HMatrixImplementation.hxx"
#include "openturns/HMatrix.hxx"
#include "openturns/HMatrixFactory.hxx"

#endif /* OPENTURNS_OTSTAT_HXX */
