# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1083-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(56853);
 script_bugtraq_id(15600);
 script_cve_id("CVE-2005-3863");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 1083-1 (motor)";
 script_name(name);

 desc = "The remote host is missing an update to motor
announced via advisory DSA 1083-1.

Mehdi Oudad and Kevin Fernandez discovered a buffer overflow in the
ktools library which is used in motor, an integrated development
environment for C, C++ and Java, which may lead local attackers to
execute arbitrary code.

For the old stable distribution (woody) this problem has been fixed in
version 3.2.2-2woody1.

For the stable distribution (sarge) this problem has been fixed in
version 3.4.0-2sarge1.

For the unstable distribution (sid) this problem has been fixed in
version 3.4.0-6.

We recommend that you upgrade your motor package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201083-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1083-1 (motor)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"motor", ver:"3.2.2-2woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"motor-common", ver:"3.4.0-2sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"motor", ver:"3.4.0-2sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"motor-fribidi", ver:"3.4.0-2sarge1", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
