# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1325-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(58446);
 script_cve_id("CVE-2007-1002", "CVE-2007-3257");
 script_version ("$");
 script_tag(name:"cvss_base", value:"6.8");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 1325-1 (evolution)";
 script_name(name);

 desc = "The remote host is missing an update to evolution
announced via advisory DSA 1325-1.

Several remote vulnerabilities have been discovered in Evolution, a
groupware suite with mail client and organizer. The Common Vulnerabilities
and Exposures project identifies the following problems:

CVE-2007-1002

Ulf Harnhammer discovered that a format string vulnerability in
the handling of shared calendars may allow the execution of arbitrary
code.

CVE-2007-3257

It was discovered that the IMAP code in the Evolution Data Server
performs insufficient sanitising of a value later used an array index,
which can lead to the execution of arbitrary code.

For the oldstable distribution (sarge) these problems have been fixed in
version 2.0.4-2sarge2. Packages for hppa, mips and powerpc are not yet
available. They will be provided later.

For the stable distribution (etch) these problems have been fixed
in version 2.6.3-6etch1. Packages for mips are not yet available. They
will be provided later.

For the unstable distribution (sid) these problems will be fixed soon.

We recommend that you upgrade your evolution packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201325-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1325-1 (evolution)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"evolution-common", ver:"2.6.3-6etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"evolution", ver:"2.6.3-6etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"evolution-dbg", ver:"2.6.3-6etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"evolution-dev", ver:"2.6.3-6etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"evolution-plugins", ver:"2.6.3-6etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"evolution-plugins-experimental", ver:"2.6.3-6etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"evolution", ver:"2.0.4-2sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"evolution-dev", ver:"2.0.4-2sarge2", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
