# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1960-1 (acpid)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66595);
 script_cve_id("CVE-2009-4235");
 script_version ("$Revision$");
 script_tag(name:"cvss_base", value:"6.9");
 script_tag(name:"risk_factor", value:"High");
 script_name("Debian Security Advisory DSA 1960-1 (acpid)");

 desc = "The remote host is missing an update to acpid
announced via advisory DSA 1960-1.

It was discovered that acpid, the Advanced Configuration and Power
Interface event daemon, on the oldstable distribution (etch) creates
its log file with weak permissions, which might expose sensible
information or might be abused by a local user to consume all free disk
space on the same partition of the file.


For the oldstable distribution (etch), this problem has been fixed in
version 1.0.4-5etch2.

The stable distribution (lenny) in version 1.0.8-1lenny2 and the
unstable distribution (sid) in version 1.0.10-5, have been updated to
fix the weak file permissions of the log file created by older
versions.


We recommend that you upgrade your acpid packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201960-1

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 1960-1 (acpid)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"acpid", ver:"1.0.4-5etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"acpid", ver:"1.0.8-1lenny2", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
