# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-6557 (moin)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64241);
 script_cve_id("CVE-2008-3381", "CVE-2008-0781", "CVE-2009-0260", "CVE-2009-0312");
 script_version ("$");
 script_tag(name:"cvss_base", value:"4.3");
 script_tag(name:"risk_factor", value:"Medium");
 name = "Fedora Core 10 FEDORA-2009-6557 (moin)";
 script_name(name);

 desc = "The remote host is missing an update to moin
announced via advisory FEDORA-2009-6557.

Update Information:

This update includes a security fix for a hierarchical ACL vulnerability
(hierarchical is not the default ACL mode), http://moinmo.in/SecurityFixes has
the details of the fix.

ChangeLog:

* Sat Jun 13 2009 Ville-Pekka Vainio  1.6.4-2
- Hierarchical ACL security fix from 1.8.4, 1.8 HG 897cdbe9e8f2
- Details at http://moinmo.in/SecurityFixes#moin_1.8.3
- Convert CHANGES to UTF-8

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update moin' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-6557

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 10 FEDORA-2009-6557 (moin)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"moin", rpm:"moin~1.6.4~2.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
