###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for bochs FEDORA-2007-1153
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861417);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"7.2");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "FEDORA", value: "2007-1153");
  script_cve_id("CVE-2007-2893");
  script_name( "Fedora Update for bochs FEDORA-2007-1153");
  desc = "

  Vulnerability Insight:
  Bochs is a portable x86 PC emulation software package that emulates
  enough of the x86 CPU, related AT hardware, and BIOS to run DOS,
  Windows '95, Minix 2.0, and other OS's, all on your workstation.


  Affected Software/OS:
  bochs on Fedora 7

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-July/msg00367.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of bochs");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC7")
{

  if(isrpmvuln(pkg:"bochs", rpm:"bochs~2.3~5.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bochs", rpm:"bochs~2.3~5.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bochs-debuginfo", rpm:"bochs-debuginfo~2.3~5.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bochs-dlxlinux", rpm:"bochs-dlxlinux~2.3~5.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bochs-debugger", rpm:"bochs-debugger~2.3~5.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bochs-gdb", rpm:"bochs-gdb~2.3~5.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bochs-dlxlinux", rpm:"bochs-dlxlinux~2.3~5.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bochs", rpm:"bochs~2.3~5.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bochs-debuginfo", rpm:"bochs-debuginfo~2.3~5.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bochs-gdb", rpm:"bochs-gdb~2.3~5.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bochs-debugger", rpm:"bochs-debugger~2.3~5.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}