###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_apple_safari_stack_consumption_vuln.nasl 4914 2009-09-23 16:21:29Z sep $
#
# Apple Safari 'WebKit.dll' Stack Consumption Vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900870);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"5.0");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2009-3272");
  script_name("Apple Safari 'WebKit.dll' Stack Consumption Vulnerability");
  desc = "
  Overview: This host has Apple Safari installed and is prone to Stack
  Consumption vulnerability.

  Vulnerability Insight:
  The flaw is due to error in 'WebKit.dll' in WebKit which can be caused via
  JavaScript code that calls eval on a long string composed of 'A/' sequences.

  Impact:
  Successful exploitation could allow attackers to cause stack consumption
  which may lead to the application crash.

  Impact Level: Application

  Affected Software/OS:
  Apple Safari version prior to 4.0

  Fix: Upgrade to Safari version 4.0 or latest version
  http://www.apple.com/safari/download/

  References:
  http://www.milw0rm.com/exploits/9606
  http://en.securitylab.ru/nvd/385690.php

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 3.9
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of Apple Safari");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Denial of Service");
  script_dependencies("secpod_apple_safari_detect_win_900003.nasl");
  script_require_keys("AppleSafari/Version");
  exit(0);
}


include("version_func.inc");

safariVer = get_kb_item("AppleSafari/Version");
if(!safariVer){
  exit(0);
}

# Check for Safari version < 4.0 (4.30.17.0)
if(version_is_less(version:safariVer, test_version:"4.30.17.0")){
  security_warning(0);
}
