#############################################################################
#
#  McAfee Encrypted USB Manager Remote Security Bypass Vulnerability
#
#  Copyright: SecPod
#
#  Date Written: 2008/08/12
#
#  Revision: 1.1 
#
#  Log: schandan
#  Issue #0105
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################


if(description)
{
 script_id(900026);
 script_cve_id("CVE-2008-3605");
 script_bugtraq_id(30630);
 script_copyright("Copyright (C) 2008 SecPod");
 script_version("$Revision: 1.1 $");
  script_tag(name:"cvss_base", value:"4.3");
  script_tag(name:"risk_factor", value:"Medium");
 script_category(ACT_GATHER_INFO);
 script_family("Brute force attacks");
 script_name("McAfee Encrypted USB Manager Remote Security Bypass Vulnerability");
 script_summary("Check for the version of McAfee Encrypted USB Manager");
 desc = "
 Overview : The host is running McAfee Encrypted USB Manager, which is prone
 to sensitive information disclosure vulnerability.

 Vulnerability Insight:

        The issue is caused when the password policy, 'Re-use Threshold' is set to
        non-zero value.

        Impact : Remote exploitation could lead an attacker towards password
        guessing.

 Impact Level : Application

 Affected Software/OS:
        McAfee Encrypted USB Manager 3.1.0.0 on Windows (All).

 Fix : Apply Service Pack 1,
 http://download.nai.com/products/patches/EncryptedUSB/ServicePack1-McAfeeEncryptedUSBManagerv3.zip
        OR
 Upgrade to latest McAfee Encrypted USB Manager,
 http://mcafee.com 

 References : http://secunia.com/advisories/31433/
 http://www.mcafee.com/apps/downloads/security_updates/hotfixes.asp?region=us&segment=enterprise

 CVSS Score :
        CVSS Base Score     : 4.3 (AV:N/AC:M/Au:NR/C:P/I:N/A:N)
        CVSS Temporal Score : 3.2
 Risk factor : Medium";

 script_description(desc);
 script_dependencies("secpod_reg_enum.nasl");
 script_require_keys("SMB/WindowsVersion");
 script_require_ports(139, 445);
 exit(0);
}


 include("smb_nt.inc");

 if(!get_kb_item("SMB/WindowsVersion")){
        exit(0);
 }

 # Check McAfee Encrypted USB Manager Installation
 if(!registry_key_exists(key:"SOFTWARE\McAfee\ACCESSEnterpriseManager")){
	exit(0);
 }

 name = kb_smb_name();
 login = kb_smb_login();
 domain = kb_smb_domain();
 pass = kb_smb_password();
 port = kb_smb_transport();
 
 soc = open_sock_tcp(port);
 if(!soc){
        exit(0); 
 }

 r = smb_session_request(soc:soc, remote:name);
 if(!r){
        close(soc);
        exit(0);
 }
 
 prot = smb_neg_prot(soc:soc) ;
 if(!prot){
        close(soc);
        exit(0);
 }
 
 r = smb_session_setup(soc:soc, login:login, password:pass, domain:domain, prot:prot);
 if(!r)
 {
	close(soc);
        exit(0);
 }

 uid = session_extract_uid(reply:r);
 r = smb_tconx(soc:soc, name:name, uid:uid, share:"IPC$");

 tid = tconx_extract_tid(reply:r);
 if (!tid){
        close(soc);
        exit(0);
 }

 r = smbntcreatex(soc:soc, uid:uid, tid:tid, name:"\winreg");
 if(!r){
        close(soc);
        exit(0);
 }

 pipe = smbntcreatex_extract_pipe(reply:r);
 if (!pipe){
        close(soc);
        exit(0);
 }

 r = pipe_accessible_registry(soc:soc, uid:uid, tid:tid, pipe:pipe);
 if(!r){
        close(soc);
        exit(0);
 }

 handle = registry_open_hklm(soc:soc, uid:uid, tid:tid, pipe:pipe);
 if(!handle){
        close(soc);
        exit(0);
 }

 key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";

 key_h = registry_get_key(soc:soc, uid:uid ,tid:tid ,pipe:pipe,key:key,reply:handle);
 if(!key_h)
 {
	close(soc);
        exit(0);
 }
 entries = registry_enum_key(soc:soc, uid:uid, tid:tid, pipe:pipe, reply:key_h);
 close(soc);

 foreach entry (entries)
 {
        mcAfee = registry_get_sz(key:key + entry, item:"DisplayName");
        if("McAfee Encrypted USB Manager" >< mcAfee)
        {
                if(egrep(pattern:"McAfee Encrypted USB Manager 3\.1(\.0)?$",
			 string:mcAfee)){
                        security_warning(0);
                }
                exit(0);
        }
 }
