###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_squid_dos_vuln.nasl 4083 2009-08-21 12:45:380Z aug $
#
# Squid External Auth Header Parser DOS Vulnerabilities
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(101105);
  script_version("$ Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"5.0");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2009-2855");
  script_name("Squid External Auth Header Parser DOS Vulnerabilities");
  desc = "

  Overview: This host is running Squid and is  prone to Denial Of
  Service vulnerabilities.

  Vulnerability Insight:
  The flaw is due to error in 'strListGetItem()' function within
  'src/HttpHeaderTools.c'.

  Impact:
  Successful exploitation could allow remote attackers to cause a denial of service
  via a crafted auth header with certain comma delimiters that trigger an infinite
  loop of calls to the strcspn function.

  Affected Software/OS:
  Squid Version 2.7.X

  Fix: Upgrade to Squid Version 3.1.4 or later,
  For further updates refer, http://www.squid-cache.org/Download/

  References:
  http://www.squid-cache.org/bugs/show_bug.cgi?id=2704
  http://www.openwall.com/lists/oss-security/2009/08/03/3
  http://bugs.debian.org/cgi-bin/bugreport.cgi?bug=534982

  CVSS Score:
    CVSS Base Score      : 5.0 (AV:N/AC:L/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score  : 4.2
  Risk factor : Medium";

  script_description(desc);
  script_summary("Check for the version of Squid");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Denial of Service");
  script_dependencies("secpod_squid_detect.nasl");
  exit(0);
}


include("version_func.inc");

port = 3128;
if(!get_port_state(port)){
  port = 8080;
}

if(!get_port_state(port)){
  exit(0);
}

squidVer =get_kb_item(string("www/", port, "/Squid"));
if((squidVer != NULL) && (squidVer =~ "^2\.7")){
  security_warning(port);
}
