'\"
'\" Copyright (c) 2003-2004 Paul H Alfille, MD
'\" (paul.alfille@gmail.com)
'\"
'\" Device manual page for the OWFS -- 1-wire filesystem package
'\" Based on Dallas Semiconductor, Inc's datasheets, and trial and error.
'\"
'\" Free for all use. No waranty. None. Use at your own risk.
'\" $Id$
'\"
.TH DS2413 3  2005 "OWFS Manpage" "One-Wire File System"
.SH NAME
.B DS2413
\- Dual Channel Addressable Switch
.SH SYNOPSIS
Dual Switch
.PP
.B 3A
[.]XXXXXXXXXXXX[XX][/[
.B PIO.[A|B|ALL|BYTE]
|
.B sensed.[A|B|ALL|BYTE]
|
.so man3/standard_mini.3so
]]
.SH FAMILY CODE
.PP
.I 3A
.SH SPECIAL PROPERTIES
.SS PIO.A PIO.B PIO.ALL PIO.BYTE
.I read-write, yes-no
.br
State of the open-drain output (
.I PIO
) pin. 0 = non-conducting (off), 1 = conducting (on).
.br
Writing zero will turn off the switch, non-zero will turn on the switch. Reading the
.I PIO
state will return the switch setting. To determine the actual logic level at the switch, refer to the
.I sensed
property.
.br
.I ALL
references both channels simultaneously, comma separated.
.br
.I BYTE
references both channels simultaneously as a single byte, with channel A in bit 0.
.SS sensed.A sensed.B sensed.ALL sensed.BYTE
.I read-only, yes-no
.br
Logic level at the
.I PIO
pin. 0 = ground. 1 = high (~2.4V - 5V ). Really makes sense only if the
.I PIO
state is set to zero (off), else will read zero.
.br
.I ALL
references both channels simultaneously, comma separated.
.br
.I BYTE
references both channels simultaneously as a single byte, with channel A in bit 0.
.SH STANDARD PROPERTIES
.so man3/standard.3so
.SH ALARMS
Use the
.I set_alarm
property to set the alarm triggering criteria.
.SH DESCRIPTION
.so man3/description.3so
.SS DS2413
The
.B DS2413 (3)
allows control of other devices, like LEDs and relays. It differs from the
.I DS2405
with a cleaner interface and two channels
The
.I DS2413
also has two channels like the
.I DS2406
and
.I DS2407
but has no memory, and no alarm.
There is also varying types of switch and sensing in the
.I DS2408, DS2409, LCD, DS276x, DS2450.
.br
Unique among the switches, the
.I DS2413
can switch higher voltages, up to 28V.
.SH ADDRESSING
.so man3/addressing.3so
.SH DATASHEET
.br
http://datasheets.maxim-ic.com/en/ds/DS2413.pdf
.SH SEE ALSO
.so man3/seealso.3so
.SH AVAILABILITY
http://www.owfs.org
.SH AUTHOR
Paul Alfille (paul.alfille@gmail.com)
