<?php
/**
 * Horde redirection script.
 *
 * Copyright 1999-2016 Horde LLC (http://www.horde.org/)
 *
 * See the enclosed file COPYING for license information (LGPL-2). If you
 * did not receive this file, see http://www.horde.org/licenses/lgpl.
 *
 * @author   Chuck Hagenbuch <chuck@horde.org>
 * @category Horde
 * @license  http://www.horde.org/licenses/lgpl LGPL-2
 * @package  Horde
 */

require_once __DIR__ . '/lib/Application.php';
Horde_Registry::appInit('horde', array(
    'authentication' => 'none',
    'nologintasks' => true
));

$main_page = Horde_Util::nonInputVar('horde_login_url', Horde_Util::getFormData('url'));

// Break up the requested URL in $main_page and run some sanity checks
// on it to prevent phishing and XSS attacks. If any of the checks
// fail, $main_page will be set to null.
if (!empty($main_page)) {
    // Mute errors in case of unparseable URLs
    $req = @parse_url($main_page);

    // We assume that any valid redirect URL will be in the same
    // cookie domain. This helps prevent rogue off-site Horde installs
    // from mimicking the real server.
    if (isset($req['host'])) {
        $qcookiedom = preg_quote($conf['cookie']['domain']);
        if (!preg_match('/' . $qcookiedom . '$/', $req['host'])) {
            $main_page = null;
        }
    }

    // Protocol whitelist: If the URL is fully qualified ...
    if (isset($req['scheme']) ||
        isset($req['host']) ||
        isset($req['port']) ||
        isset($req['user']) ||
        isset($req['pass'])) {
        // ... make sure it is either http or https.
        $allowed_protocols = array('http', 'https');
        if (empty($req['scheme']) ||
            !in_array($req['scheme'], $allowed_protocols)) {
            $main_page = null;
        }
    }
}

if ($main_page) {
    $main_page = new Horde_Url($main_page);
} elseif (!$registry->getAuth()) {
    /* Always redirect to login page if there is no incoming URL and nobody
     * is authenticated. */
    $main_page = Horde::url('login.php', true);
} elseif (($initial_app = $prefs->getValue('initial_application')) &&
          ($initial_app != 'horde') &&
          $registry->hasPermission($initial_app)) {
    $main_page = Horde::url($registry->getInitialPage($initial_app), true);
} elseif ($registry->getView() == Horde_Registry::VIEW_SMARTMOBILE) {
    $main_page = $registry->getServiceLink('portal');
} elseif (($initial_page = $registry->getInitialPage('horde')) &&
          !in_array(basename($initial_page), array('index.php', 'login.php'))) {
    /* Next, try the initial horde page if it is something other than
     * index.php or login.php, since that would lead to infinite loops. */
    $main_page = Horde::url($initial_page, true);
} else {
    /* Finally, fallback to the portal page. */
    $main_page = $registry->getServiceLink('portal');
}

$main_page->redirect();
