/*
 *  PlanFacile (Easy plan, in french) is a small tool to help people to
 *  write a document on a particular subject.
 *  Copyright (C) 2005  Julien BRUGUIER
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __IDEES__
#define __IDEES__

#include <src/global/global.h>

typedef struct idees CONTENEUR(Idees);

#include <src/donnees/flux/flux.h>
#include <src/donnees/commandes/commandeidea.h>
#include <src/donnees/commandes/commandemissing.h>
#include <src/donnees/commandes/commandegeneric.h>
#include <src/donnees/commandes/localisationfichier.h>

typedef struct ideereelledependances CONTENEUR(IdeeReelleDependances);

struct ideereelledependances
{
	STOCKAGE_SCALAIRE(Chaine) dependance;
	//Nom de l'ide destination de
	//la dpendance.
	STOCKAGE_SCALAIRE(Pertinence) pertinence;
	//Pertinence de la dpendance.
	STOCKAGE(LocalisationFichier) localisation;
	//Localisation de la commande #dep
	//permettant de spcifier cette
	//dpendance.
	STOCKAGE(IdeeReelleDependances) suivant;
	//Dpendance suivante de l'ide.
};
/* Structure permettant d'enregistrer les
 * dpendances d'une ide.
 * Cette structure sera utilise en interne. Elle
 * n'est donne qu' titre indicatif.
 */

typedef struct ideereelle CONTENEUR_SCALAIRE(IdeeReelle);

struct ideereelle
{
	STOCKAGE(CommandeIdea) commandeidea;
	//Ide enregistre.
	STOCKAGE(IdeeReelleDependances) dependances;
	//Dpendances prsentes dans l'ide.
	//Ces dpendances serviront  construire
	//le graphe de dpendances.
};
/* Structure d'enregistrement d'une ide.
 * On y ajoute une liste des dpendances
 * permettant de faciliter le calcul du graphe
 * de dpendances. Cependant, les dpendances
 * restent prsentes dans le flux de texte de
 * l'ide, afin de reprer leur position.
 * Cette structure sera utilise en interne. Elle
 * n'est donne qu' titre indicatif.
 */

typedef struct ideesreelles CONTENEUR_SCALAIRE(IdeesReelles);

struct ideesreelles
{
	STOCKAGE_SCALAIRE(Taille) memoire;
	//Taille mmoire occupe par
	//les ides du document.
	STOCKAGE_SCALAIRE(Taille) taille;
	//Taille relle utilise par les
	//ides.
	TABLEAU_(STOCKAGE_SCALAIRE(IdeeReelle)) idee;
	//Ides du document.
	//Elles sont simplement ajoutes
	//dans l'ordre o elles sont
	//dfinies.
};
/* Structure servant  enregistrer les ides du
 * document.
 * Cette structure sera utilise en interne. Elle
 * n'est donne qu' titre indicatif.
 */

typedef struct ideesmanquantes CONTENEUR_SCALAIRE(IdeesManquantes);

struct ideesmanquantes
{
	TABLEAU(STOCKAGE(CommandeMissing)) idee;
	//Ides manquantes rsolues.
	//Les ides sont ranges selon
	//l'indice correspondant  leur
	//premier paramtre.
	STOCKAGE_SCALAIRE(Taille) taille;
	//Taille du tableau prcdent.
	STOCKAGE(CommandeMissing) defaut;
	//Commande d'ide manquante par
	//dfaut.
};
/* Structure servant  enregistrer les ides
 * manquantes du document.
 * Cette structure sera utilise en interne. Elle
 * n'est donne qu' titre indicatif.
 */

typedef struct ideesgeneriques CONTENEUR_SCALAIRE(IdeesGeneriques);

struct ideesgeneriques
{
	STOCKAGE_SCALAIRE(Taille) memoire;
	//Taille mmoire occupe par
	//les ides gnriques du document.
	STOCKAGE_SCALAIRE(Taille) taille;
	//Taille relle utilise par les
	//ides gnriques.
	TABLEAU(STOCKAGE(CommandeGeneric)) idee;
	//Ides gnriques rsolues.
	//Elles sont simplement ajoutes
	//dans l'ordre o elles sont
	//dfinies.
	STOCKAGE(CommandeGeneric) defaut;
	//Commande d'ide gnrique par
	//dfaut.
};
/* Structure servant  enregistrer les ides
 * gnriques du document.
 * Cette structure sera utilise en interne. Elle
 * n'est donne qu' titre indicatif.
 */

struct idees
{
	STOCKAGE_SCALAIRE(IdeesReelles) idees;
	//Ides du document.
	STOCKAGE_SCALAIRE(IdeesManquantes) manquantes;
	//Ides manquantes du document.
	STOCKAGE_SCALAIRE(IdeesGeneriques) generiques;
	//Ides gnriques du document.
};
/* Structure servant  enregistrer toutes les
 * ides du document.
 */

Resultat idees_initialisation(TRAVAIL(Idees) idees);
/* Initialise une structure d'ides.
 * Renvoie RESULTAT_ERREUR_MEMOIRE en cas d'chec
 * d'une allocation mmoire.
 */

Resultat idees_idees_definition_idee(TRAVAIL(Idees) idees , TRAVAIL(CommandeIdea) commandeidea , REFERENCE_SCALAIRE(IdIdee) ididee , COREFERENCE_SCALAIRE(Booleen) remplacement);
/* Dfinit une ide.
 * L'ididee de l'ide est renvoy dans l'ididee,
 * et le boolen de remplacement indique si une
 * dfinition pralable de l'ide existait.
 * Renvoie RESULTAT_ERREUR si idees est NULL.
 * Renvoie RESULTAT_ERREUR_MEMOIRE en cas d'chec
 * d'une allocation mmoire.
 */

Resultat idees_idees_lecture_idee(TRAVAIL(Idees) idees , TRAVAIL_SCALAIRE(IdIdee) ididee , REFERENCE(CommandeIdea) commandeidea);
/* Lit une ide.
 * Renvoie RESULTAT_ERREUR_DOMAINE si l'ididee est incorrect.
 * Renvoie RESULTAT_ERREUR si idees est NULL.
 */

Resultat idees_idees_nombre(TRAVAIL(Idees) idees , REFERENCE_SCALAIRE(Taille) nombre);
/* Donne le nombre d'ides prsentes dans la structure.
 * Renvoie RESULTAT_ERREUR si idees est NULL.
 */

Resultat idees_idees_recherche_idee(TRAVAIL(Idees) idees , TRAVAIL_SCALAIRE(Chaine) reference , REFERENCE_SCALAIRE(Booleen) correct , REFERENCE_SCALAIRE(IdIdee) ididee);
/* Renvoie l'ididee d'une ide en fonction de
 * sa rfrence.
 * Si la rfrence n'tait pas celle d'une
 * ide valide, le boolen est plac  FAUX.
 * Dans le cas contraire, il est plac  VRAI,
 * et l'ididee est renvoy.
 * Renvoie RESULTAT_ERREUR si idees est NULL.
 */

Resultat idees_idees_ajout_dependance(TRAVAIL(Idees) idees , TRAVAIL_SCALAIRE(IdIdee) ididee , TRAVAIL_SCALAIRE(Chaine) dependance , TRAVAIL_SCALAIRE(Pertinence) pertinence , TRAVAIL(LocalisationFichier) localisation);
/* Ajoute une dpendance  une ide.
 * Si l'ididee est incorrect, la
 * fonction renvoie RESULTAT_ERREUR_DOMAINE.
 * Renvoie RESULTAT_ERREUR si idees est NULL.
 * Renvoie RESULTAT_ERREUR_MEMOIRE en cas d'chec
 * d'une allocation mmoire.
 */

Resultat idees_idees_retrait_dependance(TRAVAIL(Idees) idees , TRAVAIL_SCALAIRE(IdIdee) ididee , COREFERENCE_SCALAIRE(Booleen) correct , COREFERENCE_SCALAIRE(Chaine) dependance , COREFERENCE_SCALAIRE(Pertinence) pertinence , COREFERENCE(LocalisationFichier) localisation);
/* Retire une dpendance  une ide.
 * Si l'ididee est incorrect, la
 * fonction renvoie RESULTAT_ERREUR_DOMAINE.
 * Le boolen correct est mis  FAUX s'il
 * n'y avait plus de dpendances.
 * Renvoie RESULTAT_ERREUR si idees est NULL.
 * Renvoie RESULTAT_ERREUR_MEMOIRE en cas d'chec
 * d'une allocation mmoire.
 */

Resultat idees_manquantes_definition(TRAVAIL(Idees) idees , TRAVAIL(CommandeMissing) commandemissing , COREFERENCE_SCALAIRE(Booleen) correct , COREFERENCE_SCALAIRE(Booleen) defaut , REFERENCE_SCALAIRE(Indice) indice , COREFERENCE_SCALAIRE(Booleen) remplacement);
/* Dfinit une ide manquante.
 * La fonction indique si l'indice contenu dans
 * l'ide tait correct ou non, si l'ide par dfaut
 * a t modifie, et, enfin, si l'ide dfinie en remplace
 * une autre.
 * Renvoie RESULTAT_ERREUR si idees est NULL.
 * Renvoie RESULTAT_ERREUR_MEMOIRE en cas d'chec
 * d'une allocation mmoire.
 */

Resultat idees_manquantes_lecture(TRAVAIL(Idees) idees , TRAVAIL_SCALAIRE(Indice) indice , COREFERENCE_SCALAIRE(Booleen) correct , REFERENCE(CommandeMissing) commandemissing);
/* Lit une ide manquante.
 * S'il n'y a pas de dfinition explicite, la
 * valeur par dfaut est utilise. Dans ce cas,
 * si celle-ci n'est pas dfinie, le boolen est
 * galement mis  FAUX.
 * Renvoie RESULTAT_ERREUR_DOMAINE si l'indice est incorrect.
 * Renvoie RESULTAT_ERREUR si idees est NULL.
 */

Resultat idees_generiques_definition(TRAVAIL(Idees) idees , TRAVAIL(CommandeGeneric) commandegeneric , COREFERENCE_SCALAIRE(Booleen) correct , COREFERENCE_SCALAIRE(Booleen) defaut , COREFERENCE_SCALAIRE(Booleen) remplacement);
/* Dfinit une ide gnrique.
 * La fonction indique si la rfrence contenue dans
 * l'ide tait correcte ou non, si l'ide par dfaut
 * a t modifie, et, enfin, si l'ide dfinie en remplace
 * une autre.
 * Renvoie RESULTAT_ERREUR si idees est NULL.
 * Renvoie RESULTAT_ERREUR_MEMOIRE en cas d'chec
 * d'une allocation mmoire.
 */

Resultat idees_generiques_lecture(TRAVAIL(Idees) idees , TRAVAIL_SCALAIRE(Chaine) reference , COREFERENCE_SCALAIRE(Booleen) correct , REFERENCE(CommandeGeneric) commandegeneric);
/* Lit une ide gnrique.
 * S'il n'y a pas de dfinition explicite, la
 * valeur par dfaut est utilise. Dans ce cas,
 * si celle-ci n'est pas dfinie, le boolen est
 * galement mis  FAUX.
 * Renvoie RESULTAT_ERREUR si idees est NULL.
 */

Resultat idees_recherche_type(TRAVAIL(Idees) idees , TRAVAIL_SCALAIRE(Chaine) reference , COREFERENCE_SCALAIRE(Booleen) correct , COREFERENCE_SCALAIRE(TypeIdee) typeidee);
/* Recherche le type d'une ide en fonction de sa rfrence.
 * La priorit des types est IDEE_PRESENTE, IDEE_MANQUANTE et
 * IDEE_GENERIQUE.
 * Si la rfrence n'est pas trouve, le boolen correct est
 * mis a FAUX.
 * Renvoie RESULTAT_ERREUR si idees ou reference est NULL.
 */

Resultat idees_copie(TRAVAIL(Idees) idees , TRAVAIL(Idees) copie);
/* Ralise une copie d'une structure d'ides.
 * Si copie est non NULL, la valeur est dtruite
 * avant la copie.
 * Renvoie RESULTAT_ERREUR si idees est NULL.
 * Renvoie RESULTAT_ERREUR_MEMOIRE si une allocation coue.
 */

Resultat idees_destruction(TRAVAIL(Idees) idees);
/* Dtruit une structure d'ides.
 */

#endif
