/*
 *   Copyright 2009 - 2010 by Giulio Camuffo <giuliocamuffo@gmail.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as
 *   published by the Free Software Foundation; either version 2, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details
 *
 *   You should have received a copy of the GNU General Public
 *   License along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */


#include "wolfbuttons.h"

#include <KIcon>

#include <Plasma/IconWidget>

#include "flowlayout.h"
#include "playercontroller.h"

WolfButtons::WolfButtons(QGraphicsWidget *parent)
    : QGraphicsWidget(parent),
      m_layout(new FlowLayout(this)),
      m_playPause(new Plasma::IconWidget(KIcon("media-playback-start"), "", this)),
      m_stop(new Plasma::IconWidget(KIcon("media-playback-stop"), "", this)),
      m_next(new Plasma::IconWidget(KIcon("media-skip-forward"), "", this)),
      m_prev(new Plasma::IconWidget(KIcon("media-skip-backward"), "", this)),
      m_showAmarok(new Plasma::IconWidget(KIcon("amarok"), "", this))
{
    m_layout->setOrientation(FlowLayout::Horizontal);
    m_layout->setContentsMargins(0, 0, 0, 0);
    setLayout(m_layout);

    m_playPause->setMinimumSize(20,20);
    m_stop->setMinimumSize(20,20);
    m_prev->setMinimumSize(20,20);
    m_next->setMinimumSize(20,20);
    m_showAmarok->setMinimumSize(20,20);

    m_layout->addItem(m_prev);
    m_layout->addItem(m_playPause);
    m_layout->addItem(m_stop);
    m_layout->addItem(m_next);

    m_showAmarok->hide();

    connect(m_playPause, SIGNAL(clicked()), this, SIGNAL(playPausePressed()));
    connect(m_stop, SIGNAL(clicked()), this, SIGNAL(stopPressed()));
    connect(m_prev, SIGNAL(clicked()), this, SIGNAL(prevPressed()));
    connect(m_next, SIGNAL(clicked()), this, SIGNAL(nextPressed()));
    connect(m_showAmarok, SIGNAL(clicked()), this, SIGNAL(showAmarokPressed()));
}

WolfButtons::~WolfButtons()
{
}

void WolfButtons::setStatus(int status)
{
    if (status == PAUSED) {
        m_playPause->setIcon(KIcon("media-playback-start"));
        m_stop->setEnabled(true);
    } else if (status == PLAYING) {
        m_playPause->setIcon(KIcon("media-playback-pause"));	
        m_stop->setEnabled(true);
    } else {
        m_playPause->setIcon(KIcon("media-playback-start"));	
        m_stop->setEnabled(false);
    }

    m_playPause->update();
}

void WolfButtons::resizeEvent(QGraphicsSceneResizeEvent *event)
{
    QGraphicsWidget::resizeEvent(event);

    adjustLayoutSpacing();
}

void WolfButtons::setIsAmarokButtonVisible(bool visible)
{
    if (visible) {
        if (m_layout->count() == 4) {
            m_layout->setPrimarySpacing(0);
            m_layout->addItem(m_showAmarok);
            m_showAmarok->show();
            if (!isVisible()) {
                show();
                hide();
            }
        }
    } else {
        if (m_layout->count() == 5) {
            m_layout->setPrimarySpacing(0);
            m_layout->removeItem(m_showAmarok);
            m_showAmarok->hide();
        }
    }

    adjustLayoutSpacing();
}

bool WolfButtons::isAmarokButtonVisible()
{
    return (m_showAmarok->isVisible());
}

void WolfButtons::adjustLayoutSpacing()
{
    qreal spacing = m_playPause->contentsRect().width() - m_playPause->contentsRect().height();
    if (spacing >= 0) {
        m_layout->setPrimarySpacing(spacing);
    }
}

#include "wolfbuttons.moc"