# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ConnectivityStatusContract(Model):
    """Details about connectivity to a resource.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The hostname of the resource which the service
     depends on. This can be the database, storage or any other azure resource
     on which the service depends upon.
    :type name: str
    :param status: Required. Resource Connectivity Status Type identifier.
     Possible values include: 'initializing', 'success', 'failure'
    :type status: str or
     ~azure.mgmt.apimanagement.models.ConnectivityStatusType
    :param error: Error details of the connectivity to the resource.
    :type error: str
    :param last_updated: Required. The date when the resource connectivity
     status was last updated. This status should be updated every 15 minutes.
     If this status has not been updated, then it means that the service has
     lost network connectivity to the resource, from inside the Virtual
     Network.The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ`
     as specified by the ISO 8601 standard.
    :type last_updated: datetime
    :param last_status_change: Required. The date when the resource
     connectivity status last Changed from success to failure or vice-versa.
     The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as
     specified by the ISO 8601 standard.
    :type last_status_change: datetime
    """

    _validation = {
        'name': {'required': True, 'min_length': 1},
        'status': {'required': True},
        'last_updated': {'required': True},
        'last_status_change': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'error': {'key': 'error', 'type': 'str'},
        'last_updated': {'key': 'lastUpdated', 'type': 'iso-8601'},
        'last_status_change': {'key': 'lastStatusChange', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(ConnectivityStatusContract, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.status = kwargs.get('status', None)
        self.error = kwargs.get('error', None)
        self.last_updated = kwargs.get('last_updated', None)
        self.last_status_change = kwargs.get('last_status_change', None)
