# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .resource import Resource


class IssueCommentContract(Resource):
    """Issue Comment Contract details.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type for API Management resource.
    :vartype type: str
    :param text: Required. Comment text.
    :type text: str
    :param created_date: Date and time when the comment was created.
    :type created_date: datetime
    :param user_id: Required. A resource identifier for the user who left the
     comment.
    :type user_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'text': {'required': True},
        'user_id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'text': {'key': 'properties.text', 'type': 'str'},
        'created_date': {'key': 'properties.createdDate', 'type': 'iso-8601'},
        'user_id': {'key': 'properties.userId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(IssueCommentContract, self).__init__(**kwargs)
        self.text = kwargs.get('text', None)
        self.created_date = kwargs.get('created_date', None)
        self.user_id = kwargs.get('user_id', None)
