# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Literal, Mapping, Optional, TYPE_CHECKING, Union, overload

from .. import _model_base
from .._model_base import rest_field

if TYPE_CHECKING:
    from .. import models as _models


class AdditionalCapabilities(_model_base.Model):
    """AdditionalCapabilities for VM.

    :ivar ultra_ssd_enabled: The flag that enables or disables a capability to have one or more
     managed data disks with UltraSSD_LRS storage account type on the VM or VMSS.
     Managed disks with storage account type UltraSSD_LRS can be added to a virtual machine or
     virtual machine scale set only if this property is enabled.
    :vartype ultra_ssd_enabled: bool
    :ivar hibernation_enabled: The flag that enables or disables hibernation capability on the VM.
    :vartype hibernation_enabled: bool
    """

    ultra_ssd_enabled: Optional[bool] = rest_field(name="ultraSSDEnabled")
    """The flag that enables or disables a capability to have one or more managed data disks with
     UltraSSD_LRS storage account type on the VM or VMSS.
     Managed disks with storage account type UltraSSD_LRS can be added to a virtual machine or
     virtual machine scale set only if this property is enabled."""
    hibernation_enabled: Optional[bool] = rest_field(name="hibernationEnabled")
    """The flag that enables or disables hibernation capability on the VM."""

    @overload
    def __init__(
        self,
        *,
        ultra_ssd_enabled: Optional[bool] = None,
        hibernation_enabled: Optional[bool] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class AdditionalLocationsProfile(_model_base.Model):
    """Represents the configuration for additional locations where Fleet resources may be deployed.


    :ivar location_profiles: The list of location profiles. Required.
    :vartype location_profiles: list[~azure.mgmt.computefleet.models.LocationProfile]
    """

    location_profiles: List["_models.LocationProfile"] = rest_field(name="locationProfiles")
    """The list of location profiles. Required."""

    @overload
    def __init__(
        self,
        *,
        location_profiles: List["_models.LocationProfile"],
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class AdditionalUnattendContent(_model_base.Model):
    """Specifies additional XML formatted information that can be included in the
    Unattend.xml file, which is used by Windows Setup. Contents are defined by
    setting name, component name, and the pass in which the content is applied.

    :ivar pass_name: The pass name. Currently, the only allowable value is OobeSystem. Default
     value is "OobeSystem".
    :vartype pass_name: str
    :ivar component_name: The component name. Currently, the only allowable value is
     Microsoft-Windows-Shell-Setup. Default value is "Microsoft-Windows-Shell-Setup".
    :vartype component_name: str
    :ivar setting_name: Specifies the name of the setting to which the content applies. Possible
     values
     are: FirstLogonCommands and AutoLogon. Known values are: "AutoLogon" and "FirstLogonCommands".
    :vartype setting_name: str or ~azure.mgmt.computefleet.models.SettingNames
    :ivar content: Specifies the XML formatted content that is added to the unattend.xml file for
     the specified path and component. The XML must be less than 4KB and must
     include the root element for the setting or feature that is being inserted.
    :vartype content: str
    """

    pass_name: Optional[Literal["OobeSystem"]] = rest_field(name="passName")
    """The pass name. Currently, the only allowable value is OobeSystem. Default value is
     \"OobeSystem\"."""
    component_name: Optional[Literal["Microsoft-Windows-Shell-Setup"]] = rest_field(name="componentName")
    """The component name. Currently, the only allowable value is
     Microsoft-Windows-Shell-Setup. Default value is \"Microsoft-Windows-Shell-Setup\"."""
    setting_name: Optional[Union[str, "_models.SettingNames"]] = rest_field(name="settingName")
    """Specifies the name of the setting to which the content applies. Possible values
     are: FirstLogonCommands and AutoLogon. Known values are: \"AutoLogon\" and
     \"FirstLogonCommands\"."""
    content: Optional[str] = rest_field(visibility=["create", "update"])
    """Specifies the XML formatted content that is added to the unattend.xml file for
     the specified path and component. The XML must be less than 4KB and must
     include the root element for the setting or feature that is being inserted."""

    @overload
    def __init__(
        self,
        *,
        pass_name: Optional[Literal["OobeSystem"]] = None,
        component_name: Optional[Literal["Microsoft-Windows-Shell-Setup"]] = None,
        setting_name: Optional[Union[str, "_models.SettingNames"]] = None,
        content: Optional[str] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ApiEntityReference(_model_base.Model):
    """The API entity reference.

    :ivar id: The ARM resource id in the form of
     /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/...
    :vartype id: str
    """

    id: Optional[str] = rest_field()
    """The ARM resource id in the form of
     /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/..."""

    @overload
    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ApiError(_model_base.Model):
    """ApiError for Fleet.

    :ivar code: The error code.
    :vartype code: str
    :ivar target: The target of the particular error.
    :vartype target: str
    :ivar message: The error message.
    :vartype message: str
    :ivar details: The API error details.
    :vartype details: list[~azure.mgmt.computefleet.models.ApiErrorBase]
    :ivar innererror: The API inner error.
    :vartype innererror: ~azure.mgmt.computefleet.models.InnerError
    """

    code: Optional[str] = rest_field()
    """The error code."""
    target: Optional[str] = rest_field()
    """The target of the particular error."""
    message: Optional[str] = rest_field()
    """The error message."""
    details: Optional[List["_models.ApiErrorBase"]] = rest_field()
    """The API error details."""
    innererror: Optional["_models.InnerError"] = rest_field()
    """The API inner error."""

    @overload
    def __init__(
        self,
        *,
        code: Optional[str] = None,
        target: Optional[str] = None,
        message: Optional[str] = None,
        details: Optional[List["_models.ApiErrorBase"]] = None,
        innererror: Optional["_models.InnerError"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ApiErrorBase(_model_base.Model):
    """API error base.

    :ivar code: The error code.
    :vartype code: str
    :ivar target: The target of the particular error.
    :vartype target: str
    :ivar message: The error message.
    :vartype message: str
    """

    code: Optional[str] = rest_field()
    """The error code."""
    target: Optional[str] = rest_field()
    """The target of the particular error."""
    message: Optional[str] = rest_field()
    """The error message."""

    @overload
    def __init__(
        self,
        *,
        code: Optional[str] = None,
        target: Optional[str] = None,
        message: Optional[str] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ApplicationProfile(_model_base.Model):
    """Contains the list of gallery applications that should be made available to the
    VM/VMSS.

    :ivar gallery_applications: Specifies the gallery applications that should be made available to
     the VM/VMSS.
    :vartype gallery_applications: list[~azure.mgmt.computefleet.models.VMGalleryApplication]
    """

    gallery_applications: Optional[List["_models.VMGalleryApplication"]] = rest_field(name="galleryApplications")
    """Specifies the gallery applications that should be made available to the VM/VMSS."""

    @overload
    def __init__(
        self,
        *,
        gallery_applications: Optional[List["_models.VMGalleryApplication"]] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class BaseVirtualMachineProfile(_model_base.Model):  # pylint: disable=too-many-instance-attributes
    """Describes the base virtual machine profile for fleet.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar os_profile: Specifies the operating system settings for the virtual machines in the scale
     set.
    :vartype os_profile: ~azure.mgmt.computefleet.models.VirtualMachineScaleSetOSProfile
    :ivar storage_profile: Specifies the storage settings for the virtual machine disks.
    :vartype storage_profile: ~azure.mgmt.computefleet.models.VirtualMachineScaleSetStorageProfile
    :ivar network_profile: Specifies properties of the network interfaces of the virtual machines
     in the
     scale set.
    :vartype network_profile: ~azure.mgmt.computefleet.models.VirtualMachineScaleSetNetworkProfile
    :ivar security_profile: Specifies the Security related profile settings for the virtual
     machines in the
     scale set.
    :vartype security_profile: ~azure.mgmt.computefleet.models.SecurityProfile
    :ivar diagnostics_profile: Specifies the boot diagnostic settings state.
    :vartype diagnostics_profile: ~azure.mgmt.computefleet.models.DiagnosticsProfile
    :ivar extension_profile: Specifies a collection of settings for extensions installed on virtual
     machines
     in the scale set.
    :vartype extension_profile:
     ~azure.mgmt.computefleet.models.VirtualMachineScaleSetExtensionProfile
    :ivar license_type: Specifies that the image or disk that is being used was licensed
     on-premises.
     :code:`<br>`:code:`<br>` Possible values for Windows Server operating system are:
     :code:`<br>`:code:`<br>`
     Windows_Client :code:`<br>`:code:`<br>` Windows_Server :code:`<br>`:code:`<br>` Possible
     values for Linux
     Server operating system are: :code:`<br>`:code:`<br>` RHEL_BYOS (for RHEL)
     :code:`<br>`:code:`<br>` SLES_BYOS
     (for SUSE) :code:`<br>`:code:`<br>` For more information, see `Azure Hybrid Use Benefit for
     Windows
     Server
     <https://docs.microsoft.com/azure/virtual-machines/windows/hybrid-use-benefit-licensing>`_
     :code:`<br>`:code:`<br>` `Azure Hybrid Use Benefit for Linux
     Server <https://docs.microsoft.com/azure/virtual-machines/linux/azure-hybrid-benefit-linux>`_
     :code:`<br>`:code:`<br>` Minimum api-version: 2015-06-15.
    :vartype license_type: str
    :ivar scheduled_events_profile: Specifies Scheduled Event related configurations.
    :vartype scheduled_events_profile: ~azure.mgmt.computefleet.models.ScheduledEventsProfile
    :ivar user_data: UserData for the virtual machines in the scale set, which must be base-64
     encoded. Customer should not pass any secrets in here. Minimum api-version:
     2021-03-01.
    :vartype user_data: str
    :ivar capacity_reservation: Specifies the capacity reservation related details of a scale set.
     Minimum
     api-version: 2021-04-01.
    :vartype capacity_reservation: ~azure.mgmt.computefleet.models.CapacityReservationProfile
    :ivar application_profile: Specifies the gallery applications that should be made available to
     the VM/VMSS.
    :vartype application_profile: ~azure.mgmt.computefleet.models.ApplicationProfile
    :ivar hardware_profile: Specifies the hardware profile related details of a scale set. Minimum
     api-version: 2021-11-01.
    :vartype hardware_profile:
     ~azure.mgmt.computefleet.models.VirtualMachineScaleSetHardwareProfile
    :ivar service_artifact_reference: Specifies the service artifact reference id used to set same
     image version for
     all virtual machines in the scale set when using 'latest' image version.
     Minimum api-version: 2022-11-01.
    :vartype service_artifact_reference: ~azure.mgmt.computefleet.models.ServiceArtifactReference
    :ivar security_posture_reference: Specifies the security posture to be used for all virtual
     machines in the scale
     set. Minimum api-version: 2023-03-01.
    :vartype security_posture_reference: ~azure.mgmt.computefleet.models.SecurityPostureReference
    :ivar time_created: Specifies the time in which this VM profile for the Virtual Machine Scale
     Set
     was created. Minimum API version for this property is 2023-09-01. This value
     will be added to VMSS Flex VM tags when creating/updating the VMSS VM Profile
     with minimum api-version 2023-09-01. Examples: "2024-07-01T00:00:01.1234567+00:00".
    :vartype time_created: ~datetime.datetime
    """

    os_profile: Optional["_models.VirtualMachineScaleSetOSProfile"] = rest_field(name="osProfile")
    """Specifies the operating system settings for the virtual machines in the scale
     set."""
    storage_profile: Optional["_models.VirtualMachineScaleSetStorageProfile"] = rest_field(name="storageProfile")
    """Specifies the storage settings for the virtual machine disks."""
    network_profile: Optional["_models.VirtualMachineScaleSetNetworkProfile"] = rest_field(name="networkProfile")
    """Specifies properties of the network interfaces of the virtual machines in the
     scale set."""
    security_profile: Optional["_models.SecurityProfile"] = rest_field(name="securityProfile")
    """Specifies the Security related profile settings for the virtual machines in the
     scale set."""
    diagnostics_profile: Optional["_models.DiagnosticsProfile"] = rest_field(name="diagnosticsProfile")
    """Specifies the boot diagnostic settings state."""
    extension_profile: Optional["_models.VirtualMachineScaleSetExtensionProfile"] = rest_field(name="extensionProfile")
    """Specifies a collection of settings for extensions installed on virtual machines
     in the scale set."""
    license_type: Optional[str] = rest_field(name="licenseType")
    """Specifies that the image or disk that is being used was licensed on-premises.
     :code:`<br>`:code:`<br>` Possible values for Windows Server operating system are:
     :code:`<br>`:code:`<br>`
     Windows_Client :code:`<br>`:code:`<br>` Windows_Server :code:`<br>`:code:`<br>` Possible values
     for Linux
     Server operating system are: :code:`<br>`:code:`<br>` RHEL_BYOS (for RHEL)
     :code:`<br>`:code:`<br>` SLES_BYOS
     (for SUSE) :code:`<br>`:code:`<br>` For more information, see `Azure Hybrid Use Benefit for
     Windows
     Server
     <https://docs.microsoft.com/azure/virtual-machines/windows/hybrid-use-benefit-licensing>`_
     :code:`<br>`:code:`<br>` `Azure Hybrid Use Benefit for Linux
     Server <https://docs.microsoft.com/azure/virtual-machines/linux/azure-hybrid-benefit-linux>`_
     :code:`<br>`:code:`<br>` Minimum api-version: 2015-06-15."""
    scheduled_events_profile: Optional["_models.ScheduledEventsProfile"] = rest_field(name="scheduledEventsProfile")
    """Specifies Scheduled Event related configurations."""
    user_data: Optional[str] = rest_field(name="userData")
    """UserData for the virtual machines in the scale set, which must be base-64
     encoded. Customer should not pass any secrets in here. Minimum api-version:
     2021-03-01."""
    capacity_reservation: Optional["_models.CapacityReservationProfile"] = rest_field(name="capacityReservation")
    """Specifies the capacity reservation related details of a scale set. Minimum
     api-version: 2021-04-01."""
    application_profile: Optional["_models.ApplicationProfile"] = rest_field(name="applicationProfile")
    """Specifies the gallery applications that should be made available to the VM/VMSS."""
    hardware_profile: Optional["_models.VirtualMachineScaleSetHardwareProfile"] = rest_field(name="hardwareProfile")
    """Specifies the hardware profile related details of a scale set. Minimum
     api-version: 2021-11-01."""
    service_artifact_reference: Optional["_models.ServiceArtifactReference"] = rest_field(
        name="serviceArtifactReference"
    )
    """Specifies the service artifact reference id used to set same image version for
     all virtual machines in the scale set when using 'latest' image version.
     Minimum api-version: 2022-11-01."""
    security_posture_reference: Optional["_models.SecurityPostureReference"] = rest_field(
        name="securityPostureReference"
    )
    """Specifies the security posture to be used for all virtual machines in the scale
     set. Minimum api-version: 2023-03-01."""
    time_created: Optional[datetime.datetime] = rest_field(name="timeCreated", visibility=["read"], format="rfc3339")
    """Specifies the time in which this VM profile for the Virtual Machine Scale Set
     was created. Minimum API version for this property is 2023-09-01. This value
     will be added to VMSS Flex VM tags when creating/updating the VMSS VM Profile
     with minimum api-version 2023-09-01. Examples: \"2024-07-01T00:00:01.1234567+00:00\"."""

    @overload
    def __init__(
        self,
        *,
        os_profile: Optional["_models.VirtualMachineScaleSetOSProfile"] = None,
        storage_profile: Optional["_models.VirtualMachineScaleSetStorageProfile"] = None,
        network_profile: Optional["_models.VirtualMachineScaleSetNetworkProfile"] = None,
        security_profile: Optional["_models.SecurityProfile"] = None,
        diagnostics_profile: Optional["_models.DiagnosticsProfile"] = None,
        extension_profile: Optional["_models.VirtualMachineScaleSetExtensionProfile"] = None,
        license_type: Optional[str] = None,
        scheduled_events_profile: Optional["_models.ScheduledEventsProfile"] = None,
        user_data: Optional[str] = None,
        capacity_reservation: Optional["_models.CapacityReservationProfile"] = None,
        application_profile: Optional["_models.ApplicationProfile"] = None,
        hardware_profile: Optional["_models.VirtualMachineScaleSetHardwareProfile"] = None,
        service_artifact_reference: Optional["_models.ServiceArtifactReference"] = None,
        security_posture_reference: Optional["_models.SecurityPostureReference"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class BootDiagnostics(_model_base.Model):
    """Boot Diagnostics is a debugging feature which allows you to view Console Output
    and Screenshot to diagnose VM status. You can easily view the output of your
    console log. Azure also enables you to see a screenshot of the VM from the
    hypervisor.

    :ivar enabled: Whether boot diagnostics should be enabled on the Virtual Machine.
    :vartype enabled: bool
    :ivar storage_uri: Uri of the storage account to use for placing the console output and
     screenshot. If storageUri is not specified while enabling boot diagnostics,
     managed storage will be used.
    :vartype storage_uri: str
    """

    enabled: Optional[bool] = rest_field()
    """Whether boot diagnostics should be enabled on the Virtual Machine."""
    storage_uri: Optional[str] = rest_field(name="storageUri")
    """Uri of the storage account to use for placing the console output and
     screenshot. If storageUri is not specified while enabling boot diagnostics,
     managed storage will be used."""

    @overload
    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        storage_uri: Optional[str] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class CapacityReservationProfile(_model_base.Model):
    """The parameters of a capacity reservation Profile.

    :ivar capacity_reservation_group: Specifies the capacity reservation group resource id that
     should be used for
     allocating the virtual machine or scaleset vm instances provided enough
     capacity has been reserved. Please refer to https://aka.ms/CapacityReservation
     for more details.
    :vartype capacity_reservation_group: ~azure.mgmt.computefleet.models.SubResource
    """

    capacity_reservation_group: Optional["_models.SubResource"] = rest_field(name="capacityReservationGroup")
    """Specifies the capacity reservation group resource id that should be used for
     allocating the virtual machine or scaleset vm instances provided enough
     capacity has been reserved. Please refer to https://aka.ms/CapacityReservation
     for more details."""

    @overload
    def __init__(
        self,
        *,
        capacity_reservation_group: Optional["_models.SubResource"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ComputeProfile(_model_base.Model):
    """Compute Profile to use for running user's workloads.


    :ivar base_virtual_machine_profile: Base Virtual Machine Profile Properties to be specified
     according to
     "specification/compute/resource-manager/Microsoft.Compute/ComputeRP/stable/{computeApiVersion}/virtualMachineScaleSet.json#/definitions/VirtualMachineScaleSetVMProfile".  # pylint: disable=line-too-long
     Required.
    :vartype base_virtual_machine_profile:
     ~azure.mgmt.computefleet.models.BaseVirtualMachineProfile
    :ivar compute_api_version: Specifies the Microsoft.Compute API version to use when creating
     underlying Virtual Machine scale sets and Virtual Machines.
     The default value will be the latest supported computeApiVersion by Compute Fleet.
    :vartype compute_api_version: str
    :ivar platform_fault_domain_count: Specifies the number of fault domains to use when creating
     the underlying VMSS.
     A fault domain is a logical group of hardware within an Azure datacenter.
     VMs in the same fault domain share a common power source and network switch.
     If not specified, defaults to 1, which represents "Max Spreading" (using as many fault domains
     as possible).
     This property cannot be updated.
    :vartype platform_fault_domain_count: int
    :ivar additional_virtual_machine_capabilities: Specifies VMSS and VM API entity models support
     two additional capabilities as of today: ultraSSDEnabled and hibernationEnabled.
     ultraSSDEnabled: Enables UltraSSD_LRS storage account type on the VMSS VMs.
     hibernationEnabled: Enables the hibernation capability on the VMSS VMs.
     Default value is null if not specified. This property cannot be updated once set.
    :vartype additional_virtual_machine_capabilities:
     ~azure.mgmt.computefleet.models.AdditionalCapabilities
    """

    base_virtual_machine_profile: "_models.BaseVirtualMachineProfile" = rest_field(name="baseVirtualMachineProfile")
    """Base Virtual Machine Profile Properties to be specified according to
     \"specification/compute/resource-manager/Microsoft.Compute/ComputeRP/stable/{computeApiVersion}/virtualMachineScaleSet.json#/definitions/VirtualMachineScaleSetVMProfile\".  # pylint: disable=line-too-long
     Required."""
    compute_api_version: Optional[str] = rest_field(name="computeApiVersion")
    """Specifies the Microsoft.Compute API version to use when creating underlying Virtual Machine
     scale sets and Virtual Machines.
     The default value will be the latest supported computeApiVersion by Compute Fleet."""
    platform_fault_domain_count: Optional[int] = rest_field(name="platformFaultDomainCount")
    """Specifies the number of fault domains to use when creating the underlying VMSS.
     A fault domain is a logical group of hardware within an Azure datacenter.
     VMs in the same fault domain share a common power source and network switch.
     If not specified, defaults to 1, which represents \"Max Spreading\" (using as many fault
     domains as possible).
     This property cannot be updated."""
    additional_virtual_machine_capabilities: Optional["_models.AdditionalCapabilities"] = rest_field(
        name="additionalVirtualMachineCapabilities"
    )
    """Specifies VMSS and VM API entity models support two additional capabilities as of today:
     ultraSSDEnabled and hibernationEnabled.
     ultraSSDEnabled: Enables UltraSSD_LRS storage account type on the VMSS VMs.
     hibernationEnabled: Enables the hibernation capability on the VMSS VMs.
     Default value is null if not specified. This property cannot be updated once set."""

    @overload
    def __init__(
        self,
        *,
        base_virtual_machine_profile: "_models.BaseVirtualMachineProfile",
        compute_api_version: Optional[str] = None,
        platform_fault_domain_count: Optional[int] = None,
        additional_virtual_machine_capabilities: Optional["_models.AdditionalCapabilities"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class DiagnosticsProfile(_model_base.Model):
    """Specifies the boot diagnostic settings state. Minimum api-version: 2015-06-15.

    :ivar boot_diagnostics: Boot Diagnostics is a debugging feature which allows you to view
     Console Output
     and Screenshot to diagnose VM status. **NOTE**\\ : If storageUri is being
     specified then ensure that the storage account is in the same region and
     subscription as the VM. You can easily view the output of your console log.
     Azure also enables you to see a screenshot of the VM from the hypervisor.
    :vartype boot_diagnostics: ~azure.mgmt.computefleet.models.BootDiagnostics
    """

    boot_diagnostics: Optional["_models.BootDiagnostics"] = rest_field(name="bootDiagnostics")
    """Boot Diagnostics is a debugging feature which allows you to view Console Output
     and Screenshot to diagnose VM status. **NOTE**\ : If storageUri is being
     specified then ensure that the storage account is in the same region and
     subscription as the VM. You can easily view the output of your console log.
     Azure also enables you to see a screenshot of the VM from the hypervisor."""

    @overload
    def __init__(
        self,
        *,
        boot_diagnostics: Optional["_models.BootDiagnostics"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class DiffDiskSettings(_model_base.Model):
    """Describes the parameters of ephemeral disk settings that can be specified for
    operating system disk. **Note:** The ephemeral disk settings can only be
    specified for managed disk.

    :ivar option: Specifies the ephemeral disk settings for operating system disk. "Local"
    :vartype option: str or ~azure.mgmt.computefleet.models.DiffDiskOptions
    :ivar placement: Specifies the ephemeral disk placement for operating system disk. Possible
     values are: **CacheDisk,** **ResourceDisk.** The defaulting behavior is:
     **CacheDisk** if one is configured for the VM size otherwise **ResourceDisk**
     is used. Refer to the VM size documentation for Windows VM at
     https://docs.microsoft.com/azure/virtual-machines/windows/sizes and Linux VM at
     https://docs.microsoft.com/azure/virtual-machines/linux/sizes to check which VM
     sizes exposes a cache disk. Known values are: "CacheDisk", "ResourceDisk", and "NvmeDisk".
    :vartype placement: str or ~azure.mgmt.computefleet.models.DiffDiskPlacement
    """

    option: Optional[Union[str, "_models.DiffDiskOptions"]] = rest_field()
    """Specifies the ephemeral disk settings for operating system disk. \"Local\""""
    placement: Optional[Union[str, "_models.DiffDiskPlacement"]] = rest_field()
    """Specifies the ephemeral disk placement for operating system disk. Possible
     values are: **CacheDisk,** **ResourceDisk.** The defaulting behavior is:
     **CacheDisk** if one is configured for the VM size otherwise **ResourceDisk**
     is used. Refer to the VM size documentation for Windows VM at
     https://docs.microsoft.com/azure/virtual-machines/windows/sizes and Linux VM at
     https://docs.microsoft.com/azure/virtual-machines/linux/sizes to check which VM
     sizes exposes a cache disk. Known values are: \"CacheDisk\", \"ResourceDisk\", and
     \"NvmeDisk\"."""

    @overload
    def __init__(
        self,
        *,
        option: Optional[Union[str, "_models.DiffDiskOptions"]] = None,
        placement: Optional[Union[str, "_models.DiffDiskPlacement"]] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class DiskEncryptionSetParameters(_model_base.Model):
    """Describes the parameter of customer managed disk encryption set resource id
    that can be specified for disk. **Note:** The disk encryption set resource id
    can only be specified for managed disk. Please refer
    https://aka.ms/mdssewithcmkoverview for more details.

    :ivar id: Resource Id.
    :vartype id: str
    """

    id: Optional[str] = rest_field()
    """Resource Id."""

    @overload
    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class EncryptionIdentity(_model_base.Model):
    """Specifies the Managed Identity used by ADE to get access token for keyvault
    operations.

    :ivar user_assigned_identity_resource_id: Specifies ARM Resource ID of one of the user
     identities associated with the VM.
    :vartype user_assigned_identity_resource_id: str
    """

    user_assigned_identity_resource_id: Optional[str] = rest_field(name="userAssignedIdentityResourceId")
    """Specifies ARM Resource ID of one of the user identities associated with the VM."""

    @overload
    def __init__(
        self,
        *,
        user_assigned_identity_resource_id: Optional[str] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ErrorAdditionalInfo(_model_base.Model):
    """The resource management error additional info.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    type: Optional[str] = rest_field(visibility=["read"])
    """The additional info type."""
    info: Optional[Any] = rest_field(visibility=["read"])
    """The additional info."""


class ErrorDetail(_model_base.Model):
    """The error detail.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.computefleet.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.computefleet.models.ErrorAdditionalInfo]
    """

    code: Optional[str] = rest_field(visibility=["read"])
    """The error code."""
    message: Optional[str] = rest_field(visibility=["read"])
    """The error message."""
    target: Optional[str] = rest_field(visibility=["read"])
    """The error target."""
    details: Optional[List["_models.ErrorDetail"]] = rest_field(visibility=["read"])
    """The error details."""
    additional_info: Optional[List["_models.ErrorAdditionalInfo"]] = rest_field(
        name="additionalInfo", visibility=["read"]
    )
    """The error additional info."""


class ErrorResponse(_model_base.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations.

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.computefleet.models.ErrorDetail
    """

    error: Optional["_models.ErrorDetail"] = rest_field()
    """The error object."""

    @overload
    def __init__(
        self,
        *,
        error: Optional["_models.ErrorDetail"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class Resource(_model_base.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.computefleet.models.SystemData
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long"""
    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the resource."""
    type: Optional[str] = rest_field(visibility=["read"])
    """The type of the resource. E.g. \"Microsoft.Compute/virtualMachines\" or
     \"Microsoft.Storage/storageAccounts\"."""
    system_data: Optional["_models.SystemData"] = rest_field(name="systemData", visibility=["read"])
    """Azure Resource Manager metadata containing createdBy and modifiedBy information."""


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which
    has 'tags' and a 'location'.

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.computefleet.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    tags: Optional[Dict[str, str]] = rest_field()
    """Resource tags."""
    location: str = rest_field(visibility=["read", "create"])
    """The geo-location where the resource lives. Required."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class Fleet(TrackedResource):
    """An Compute Fleet resource.

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.computefleet.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.computefleet.models.FleetProperties
    :ivar zones: Zones in which the Compute Fleet is available.
    :vartype zones: list[str]
    :ivar identity: The managed service identities assigned to this resource.
    :vartype identity: ~azure.mgmt.computefleet.models.ManagedServiceIdentity
    :ivar plan: Details of the resource plan.
    :vartype plan: ~azure.mgmt.computefleet.models.Plan
    """

    properties: Optional["_models.FleetProperties"] = rest_field()
    """The resource-specific properties for this resource."""
    zones: Optional[List[str]] = rest_field()
    """Zones in which the Compute Fleet is available."""
    identity: Optional["_models.ManagedServiceIdentity"] = rest_field()
    """The managed service identities assigned to this resource."""
    plan: Optional["_models.Plan"] = rest_field()
    """Details of the resource plan."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.FleetProperties"] = None,
        zones: Optional[List[str]] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        plan: Optional["_models.Plan"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class FleetProperties(_model_base.Model):
    """Details of the Compute Fleet.

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar provisioning_state: The status of the last operation. Known values are: "Succeeded",
     "Failed", "Canceled", "Creating", "Updating", "Deleting", and "Migrating".
    :vartype provisioning_state: str or ~azure.mgmt.computefleet.models.ProvisioningState
    :ivar spot_priority_profile: Configuration Options for Spot instances in Compute Fleet.
    :vartype spot_priority_profile: ~azure.mgmt.computefleet.models.SpotPriorityProfile
    :ivar regular_priority_profile: Configuration Options for Regular instances in Compute Fleet.
    :vartype regular_priority_profile: ~azure.mgmt.computefleet.models.RegularPriorityProfile
    :ivar vm_sizes_profile: List of VM sizes supported for Compute Fleet. Required.
    :vartype vm_sizes_profile: list[~azure.mgmt.computefleet.models.VmSizeProfile]
    :ivar vm_attributes: Attribute based Fleet.
    :vartype vm_attributes: ~azure.mgmt.computefleet.models.VMAttributes
    :ivar additional_locations_profile: Represents the configuration for additional locations where
     Fleet resources may be deployed.
    :vartype additional_locations_profile:
     ~azure.mgmt.computefleet.models.AdditionalLocationsProfile
    :ivar compute_profile: Compute Profile to use for running user's workloads. Required.
    :vartype compute_profile: ~azure.mgmt.computefleet.models.ComputeProfile
    :ivar time_created: Specifies the time at which the Compute Fleet is created.
    :vartype time_created: ~datetime.datetime
    :ivar unique_id: Specifies the ID which uniquely identifies a Compute Fleet.
    :vartype unique_id: str
    """

    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The status of the last operation. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     \"Creating\", \"Updating\", \"Deleting\", and \"Migrating\"."""
    spot_priority_profile: Optional["_models.SpotPriorityProfile"] = rest_field(name="spotPriorityProfile")
    """Configuration Options for Spot instances in Compute Fleet."""
    regular_priority_profile: Optional["_models.RegularPriorityProfile"] = rest_field(name="regularPriorityProfile")
    """Configuration Options for Regular instances in Compute Fleet."""
    vm_sizes_profile: List["_models.VmSizeProfile"] = rest_field(name="vmSizesProfile")
    """List of VM sizes supported for Compute Fleet. Required."""
    vm_attributes: Optional["_models.VMAttributes"] = rest_field(name="vmAttributes")
    """Attribute based Fleet."""
    additional_locations_profile: Optional["_models.AdditionalLocationsProfile"] = rest_field(
        name="additionalLocationsProfile"
    )
    """Represents the configuration for additional locations where Fleet resources may be deployed."""
    compute_profile: "_models.ComputeProfile" = rest_field(name="computeProfile")
    """Compute Profile to use for running user's workloads. Required."""
    time_created: Optional[datetime.datetime] = rest_field(name="timeCreated", visibility=["read"], format="rfc3339")
    """Specifies the time at which the Compute Fleet is created."""
    unique_id: Optional[str] = rest_field(name="uniqueId", visibility=["read"])
    """Specifies the ID which uniquely identifies a Compute Fleet."""

    @overload
    def __init__(
        self,
        *,
        vm_sizes_profile: List["_models.VmSizeProfile"],
        compute_profile: "_models.ComputeProfile",
        spot_priority_profile: Optional["_models.SpotPriorityProfile"] = None,
        regular_priority_profile: Optional["_models.RegularPriorityProfile"] = None,
        vm_attributes: Optional["_models.VMAttributes"] = None,
        additional_locations_profile: Optional["_models.AdditionalLocationsProfile"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class FleetUpdate(_model_base.Model):
    """Fleet Update Model.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar identity: Updatable managed service identity.
    :vartype identity: ~azure.mgmt.computefleet.models.ManagedServiceIdentityUpdate
    :ivar plan: Updatable resource plan.
    :vartype plan: ~azure.mgmt.computefleet.models.ResourcePlanUpdate
    :ivar properties: RP-specific updatable properties.
    :vartype properties: ~azure.mgmt.computefleet.models.FleetProperties
    """

    tags: Optional[Dict[str, str]] = rest_field()
    """Resource tags."""
    identity: Optional["_models.ManagedServiceIdentityUpdate"] = rest_field()
    """Updatable managed service identity."""
    plan: Optional["_models.ResourcePlanUpdate"] = rest_field()
    """Updatable resource plan."""
    properties: Optional["_models.FleetProperties"] = rest_field()
    """RP-specific updatable properties."""

    @overload
    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.ManagedServiceIdentityUpdate"] = None,
        plan: Optional["_models.ResourcePlanUpdate"] = None,
        properties: Optional["_models.FleetProperties"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ImageReference(_model_base.Model):
    """Specifies information about the image to use. You can specify information about
    platform images, marketplace images, or virtual machine images. This element is
    required when you want to use a platform image, marketplace image, or virtual
    machine image, but is not used in other creation operations. NOTE: Image
    reference publisher and offer can only be set when you create the scale set.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar publisher: The image publisher.
    :vartype publisher: str
    :ivar offer: Specifies the offer of the platform image or marketplace image used to create
     the virtual machine.
    :vartype offer: str
    :ivar sku: The image SKU.
    :vartype sku: str
    :ivar version: Specifies the version of the platform image or marketplace image used to create
     the virtual machine. The allowed formats are Major.Minor.Build or 'latest'.
     Major, Minor, and Build are decimal numbers. Specify 'latest' to use the latest
     version of an image available at deploy time. Even if you use 'latest', the VM
     image will not automatically update after deploy time even if a new version
     becomes available. Please do not use field 'version' for gallery image
     deployment, gallery image should always use 'id' field for deployment, to use 'latest'
     version of gallery image, just set
    '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/images/{imageName}'  # pylint: disable=line-too-long
     in the 'id' field without version input.
    :vartype version: str
    :ivar exact_version: Specifies in decimal numbers, the version of platform image or marketplace
     image used to create the virtual machine. This readonly field differs from 'version',
     only if the value specified in 'version' field is 'latest'.
    :vartype exact_version: str
    :ivar shared_gallery_image_id: Specified the shared gallery image unique id for vm deployment.
     This can be
     fetched from shared gallery image GET call.
    :vartype shared_gallery_image_id: str
    :ivar community_gallery_image_id: Specified the community gallery image unique id for vm
     deployment. This can be
     fetched from community gallery image GET call.
    :vartype community_gallery_image_id: str
    """

    id: Optional[str] = rest_field()
    """Resource Id."""
    publisher: Optional[str] = rest_field()
    """The image publisher."""
    offer: Optional[str] = rest_field()
    """Specifies the offer of the platform image or marketplace image used to create
     the virtual machine."""
    sku: Optional[str] = rest_field()
    """The image SKU."""
    version: Optional[str] = rest_field()
    """Specifies the version of the platform image or marketplace image used to create
     the virtual machine. The allowed formats are Major.Minor.Build or 'latest'.
     Major, Minor, and Build are decimal numbers. Specify 'latest' to use the latest
     version of an image available at deploy time. Even if you use 'latest', the VM
     image will not automatically update after deploy time even if a new version
     becomes available. Please do not use field 'version' for gallery image
     deployment, gallery image should always use 'id' field for deployment, to use 'latest'
     version of gallery image, just set
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/images/{imageName}'  # pylint: disable=line-too-long
     in the 'id' field without version input."""
    exact_version: Optional[str] = rest_field(name="exactVersion", visibility=["read"])
    """Specifies in decimal numbers, the version of platform image or marketplace
     image used to create the virtual machine. This readonly field differs from 'version',
     only if the value specified in 'version' field is 'latest'."""
    shared_gallery_image_id: Optional[str] = rest_field(name="sharedGalleryImageId")
    """Specified the shared gallery image unique id for vm deployment. This can be
     fetched from shared gallery image GET call."""
    community_gallery_image_id: Optional[str] = rest_field(name="communityGalleryImageId")
    """Specified the community gallery image unique id for vm deployment. This can be
     fetched from community gallery image GET call."""

    @overload
    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        publisher: Optional[str] = None,
        offer: Optional[str] = None,
        sku: Optional[str] = None,
        version: Optional[str] = None,
        shared_gallery_image_id: Optional[str] = None,
        community_gallery_image_id: Optional[str] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class InnerError(_model_base.Model):
    """Inner error details.

    :ivar exception_type: The exception type.
    :vartype exception_type: str
    :ivar error_detail: The internal error message or exception dump.
    :vartype error_detail: str
    """

    exception_type: Optional[str] = rest_field(name="exceptionType")
    """The exception type."""
    error_detail: Optional[str] = rest_field(name="errorDetail")
    """The internal error message or exception dump."""

    @overload
    def __init__(
        self,
        *,
        exception_type: Optional[str] = None,
        error_detail: Optional[str] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class KeyVaultSecretReference(_model_base.Model):
    """Describes a reference to Key Vault Secret.


    :ivar secret_url: The URL referencing a secret in a Key Vault. Required.
    :vartype secret_url: str
    :ivar source_vault: The relative URL of the Key Vault containing the secret. Required.
    :vartype source_vault: ~azure.mgmt.computefleet.models.SubResource
    """

    secret_url: str = rest_field(name="secretUrl")
    """The URL referencing a secret in a Key Vault. Required."""
    source_vault: "_models.SubResource" = rest_field(name="sourceVault")
    """The relative URL of the Key Vault containing the secret. Required."""

    @overload
    def __init__(
        self,
        *,
        secret_url: str,
        source_vault: "_models.SubResource",
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class LinuxConfiguration(_model_base.Model):
    """Specifies the Linux operating system settings on the virtual machine. For a
    list of supported Linux distributions, see `Linux on Azure-Endorsed
    Distributions <https://docs.microsoft.com/azure/virtual-machines/linux/endorsed-distros>`_.

    :ivar disable_password_authentication: Specifies whether password authentication should be
     disabled.
    :vartype disable_password_authentication: bool
    :ivar ssh: Specifies the ssh key configuration for a Linux OS.
    :vartype ssh: ~azure.mgmt.computefleet.models.SshConfiguration
    :ivar provision_vm_agent: Indicates whether virtual machine agent should be provisioned on the
     virtual
     machine. When this property is not specified in the request body, default
     behavior is to set it to true. This will ensure that VM Agent is installed on
     the VM so that extensions can be added to the VM later.
    :vartype provision_vm_agent: bool
    :ivar patch_settings: [Preview Feature] Specifies settings related to VM Guest Patching on
     Linux.
    :vartype patch_settings: ~azure.mgmt.computefleet.models.LinuxPatchSettings
    :ivar enable_vm_agent_platform_updates: Indicates whether VMAgent Platform Updates is enabled
     for the Linux virtual
     machine. Default value is false.
    :vartype enable_vm_agent_platform_updates: bool
    """

    disable_password_authentication: Optional[bool] = rest_field(name="disablePasswordAuthentication")
    """Specifies whether password authentication should be disabled."""
    ssh: Optional["_models.SshConfiguration"] = rest_field()
    """Specifies the ssh key configuration for a Linux OS."""
    provision_vm_agent: Optional[bool] = rest_field(name="provisionVMAgent")
    """Indicates whether virtual machine agent should be provisioned on the virtual
     machine. When this property is not specified in the request body, default
     behavior is to set it to true. This will ensure that VM Agent is installed on
     the VM so that extensions can be added to the VM later."""
    patch_settings: Optional["_models.LinuxPatchSettings"] = rest_field(name="patchSettings")
    """[Preview Feature] Specifies settings related to VM Guest Patching on Linux."""
    enable_vm_agent_platform_updates: Optional[bool] = rest_field(name="enableVMAgentPlatformUpdates")
    """Indicates whether VMAgent Platform Updates is enabled for the Linux virtual
     machine. Default value is false."""

    @overload
    def __init__(
        self,
        *,
        disable_password_authentication: Optional[bool] = None,
        ssh: Optional["_models.SshConfiguration"] = None,
        provision_vm_agent: Optional[bool] = None,
        patch_settings: Optional["_models.LinuxPatchSettings"] = None,
        enable_vm_agent_platform_updates: Optional[bool] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class LinuxPatchSettings(_model_base.Model):
    """Specifies settings related to VM Guest Patching on Linux.

    :ivar patch_mode: Specifies the mode of VM Guest Patching to IaaS virtual machine or virtual
     machines associated to virtual machine scale set with OrchestrationMode as
     Flexible.:code:`<br />`:code:`<br />` Possible values are::code:`<br />`:code:`<br />`
     **ImageDefault** - The
     virtual machine's default patching configuration is used. :code:`<br />`:code:`<br />`
     **AutomaticByPlatform** - The virtual machine will be automatically updated by
     the platform. The property provisionVMAgent must be true. Known values are: "ImageDefault" and
     "AutomaticByPlatform".
    :vartype patch_mode: str or ~azure.mgmt.computefleet.models.LinuxVMGuestPatchMode
    :ivar assessment_mode: Specifies the mode of VM Guest Patch Assessment for the IaaS virtual
     machine.:code:`<br />`:code:`<br />` Possible values are::code:`<br />`:code:`<br />`
     **ImageDefault** - You
     control the timing of patch assessments on a virtual machine. :code:`<br />`:code:`<br />`
     **AutomaticByPlatform** - The platform will trigger periodic patch assessments.
     The property provisionVMAgent must be true. Known values are: "ImageDefault" and
     "AutomaticByPlatform".
    :vartype assessment_mode: str or ~azure.mgmt.computefleet.models.LinuxPatchAssessmentMode
    :ivar automatic_by_platform_settings: Specifies additional settings for patch mode
     AutomaticByPlatform in VM Guest
     Patching on Linux.
    :vartype automatic_by_platform_settings:
     ~azure.mgmt.computefleet.models.LinuxVMGuestPatchAutomaticByPlatformSettings
    """

    patch_mode: Optional[Union[str, "_models.LinuxVMGuestPatchMode"]] = rest_field(name="patchMode")
    """Specifies the mode of VM Guest Patching to IaaS virtual machine or virtual
     machines associated to virtual machine scale set with OrchestrationMode as
     Flexible.:code:`<br />`:code:`<br />` Possible values are::code:`<br />`:code:`<br />`
     **ImageDefault** - The
     virtual machine's default patching configuration is used. :code:`<br />`:code:`<br />`
     **AutomaticByPlatform** - The virtual machine will be automatically updated by
     the platform. The property provisionVMAgent must be true. Known values are: \"ImageDefault\"
     and \"AutomaticByPlatform\"."""
    assessment_mode: Optional[Union[str, "_models.LinuxPatchAssessmentMode"]] = rest_field(name="assessmentMode")
    """Specifies the mode of VM Guest Patch Assessment for the IaaS virtual
     machine.:code:`<br />`:code:`<br />` Possible values are::code:`<br />`:code:`<br />`
     **ImageDefault** - You
     control the timing of patch assessments on a virtual machine. :code:`<br />`:code:`<br />`
     **AutomaticByPlatform** - The platform will trigger periodic patch assessments.
     The property provisionVMAgent must be true. Known values are: \"ImageDefault\" and
     \"AutomaticByPlatform\"."""
    automatic_by_platform_settings: Optional["_models.LinuxVMGuestPatchAutomaticByPlatformSettings"] = rest_field(
        name="automaticByPlatformSettings"
    )
    """Specifies additional settings for patch mode AutomaticByPlatform in VM Guest
     Patching on Linux."""

    @overload
    def __init__(
        self,
        *,
        patch_mode: Optional[Union[str, "_models.LinuxVMGuestPatchMode"]] = None,
        assessment_mode: Optional[Union[str, "_models.LinuxPatchAssessmentMode"]] = None,
        automatic_by_platform_settings: Optional["_models.LinuxVMGuestPatchAutomaticByPlatformSettings"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class LinuxVMGuestPatchAutomaticByPlatformSettings(_model_base.Model):  # pylint: disable=name-too-long
    """Specifies additional settings to be applied when patch mode AutomaticByPlatform
    is selected in Linux patch settings.

    :ivar reboot_setting: Specifies the reboot setting for all AutomaticByPlatform patch
     installation
     operations. Known values are: "Unknown", "IfRequired", "Never", and "Always".
    :vartype reboot_setting: str or
     ~azure.mgmt.computefleet.models.LinuxVMGuestPatchAutomaticByPlatformRebootSetting
    :ivar bypass_platform_safety_checks_on_user_schedule: Enables customer to schedule patching
     without accidental upgrades.
    :vartype bypass_platform_safety_checks_on_user_schedule: bool
    """

    reboot_setting: Optional[Union[str, "_models.LinuxVMGuestPatchAutomaticByPlatformRebootSetting"]] = rest_field(
        name="rebootSetting"
    )
    """Specifies the reboot setting for all AutomaticByPlatform patch installation
     operations. Known values are: \"Unknown\", \"IfRequired\", \"Never\", and \"Always\"."""
    bypass_platform_safety_checks_on_user_schedule: Optional[bool] = rest_field(
        name="bypassPlatformSafetyChecksOnUserSchedule"
    )
    """Enables customer to schedule patching without accidental upgrades."""

    @overload
    def __init__(
        self,
        *,
        reboot_setting: Optional[Union[str, "_models.LinuxVMGuestPatchAutomaticByPlatformRebootSetting"]] = None,
        bypass_platform_safety_checks_on_user_schedule: Optional[bool] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class LocationProfile(_model_base.Model):
    """Represents the profile for a single additional location in the Fleet. The location and the
    virtualMachineProfileOverride (optional).


    :ivar location: The ARM location name of the additional region. If LocationProfile is
     specified, then location is required. Required.
    :vartype location: str
    :ivar virtual_machine_profile_override: An override for
     computeProfile.baseVirtualMachineProfile specific to this region.
     This override is merged with the base virtual machine profile to define the final virtual
     machine profile for the resources deployed in this location.
    :vartype virtual_machine_profile_override:
     ~azure.mgmt.computefleet.models.BaseVirtualMachineProfile
    """

    location: str = rest_field()
    """The ARM location name of the additional region. If LocationProfile is specified, then location
     is required. Required."""
    virtual_machine_profile_override: Optional["_models.BaseVirtualMachineProfile"] = rest_field(
        name="virtualMachineProfileOverride"
    )
    """An override for computeProfile.baseVirtualMachineProfile specific to this region.
     This override is merged with the base virtual machine profile to define the final virtual
     machine profile for the resources deployed in this location."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        virtual_machine_profile_override: Optional["_models.BaseVirtualMachineProfile"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ManagedServiceIdentity(_model_base.Model):
    """Managed service identity (system assigned and/or user assigned identities).

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar principal_id: The service principal ID of the system assigned identity. This property
     will only be provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of the system assigned identity. This property will only be
     provided for a system assigned identity.
    :vartype tenant_id: str
    :ivar type: The type of managed identity assigned to this resource. Required. Known values are:
     "None", "SystemAssigned", "UserAssigned", and "SystemAssigned,UserAssigned".
    :vartype type: str or ~azure.mgmt.computefleet.models.ManagedServiceIdentityType
    :ivar user_assigned_identities: The identities assigned to this resource by the user.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.computefleet.models.UserAssignedIdentity]
    """

    principal_id: Optional[str] = rest_field(name="principalId", visibility=["read"])
    """The service principal ID of the system assigned identity. This property will only be provided
     for a system assigned identity."""
    tenant_id: Optional[str] = rest_field(name="tenantId", visibility=["read"])
    """The tenant ID of the system assigned identity. This property will only be provided for a system
     assigned identity."""
    type: Union[str, "_models.ManagedServiceIdentityType"] = rest_field()
    """The type of managed identity assigned to this resource. Required. Known values are: \"None\",
     \"SystemAssigned\", \"UserAssigned\", and \"SystemAssigned,UserAssigned\"."""
    user_assigned_identities: Optional[Dict[str, "_models.UserAssignedIdentity"]] = rest_field(
        name="userAssignedIdentities"
    )
    """The identities assigned to this resource by the user."""

    @overload
    def __init__(
        self,
        *,
        type: Union[str, "_models.ManagedServiceIdentityType"],
        user_assigned_identities: Optional[Dict[str, "_models.UserAssignedIdentity"]] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ManagedServiceIdentityUpdate(_model_base.Model):
    """The template for adding optional properties.

    :ivar type: The type of managed identity assigned to this resource. Known values are: "None",
     "SystemAssigned", "UserAssigned", and "SystemAssigned,UserAssigned".
    :vartype type: str or ~azure.mgmt.computefleet.models.ManagedServiceIdentityType
    :ivar user_assigned_identities: The identities assigned to this resource by the user.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.computefleet.models.UserAssignedIdentity]
    """

    type: Optional[Union[str, "_models.ManagedServiceIdentityType"]] = rest_field()
    """The type of managed identity assigned to this resource. Known values are: \"None\",
     \"SystemAssigned\", \"UserAssigned\", and \"SystemAssigned,UserAssigned\"."""
    user_assigned_identities: Optional[Dict[str, "_models.UserAssignedIdentity"]] = rest_field(
        name="userAssignedIdentities"
    )
    """The identities assigned to this resource by the user."""

    @overload
    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.ManagedServiceIdentityType"]] = None,
        user_assigned_identities: Optional[Dict[str, "_models.UserAssignedIdentity"]] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class Operation(_model_base.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for Azure Resource Manager/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.computefleet.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.computefleet.models.Origin
    :ivar action_type: Extensible enum. Indicates the action type. "Internal" refers to actions
     that are for internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.computefleet.models.ActionType
    """

    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     \"Microsoft.Compute/virtualMachines/write\",
     \"Microsoft.Compute/virtualMachines/capture/action\"."""
    is_data_action: Optional[bool] = rest_field(name="isDataAction", visibility=["read"])
    """Whether the operation applies to data-plane. This is \"true\" for data-plane operations and
     \"false\" for Azure Resource Manager/control-plane operations."""
    display: Optional["_models.OperationDisplay"] = rest_field(visibility=["read"])
    """Localized display information for this particular operation."""
    origin: Optional[Union[str, "_models.Origin"]] = rest_field(visibility=["read"])
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
     logs UX. Default value is \"user,system\". Known values are: \"user\", \"system\", and
     \"user,system\"."""
    action_type: Optional[Union[str, "_models.ActionType"]] = rest_field(name="actionType")
    """Extensible enum. Indicates the action type. \"Internal\" refers to actions that are for
     internal only APIs. \"Internal\""""

    @overload
    def __init__(
        self,
        *,
        action_type: Optional[Union[str, "_models.ActionType"]] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class OperationDisplay(_model_base.Model):
    """Localized display information for and operation.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    provider: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly form of the resource provider name, e.g. \"Microsoft Monitoring
     Insights\" or \"Microsoft Compute\"."""
    resource: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly name of the resource type related to this operation. E.g. \"Virtual
     Machines\" or \"Job Schedule Collections\"."""
    operation: Optional[str] = rest_field(visibility=["read"])
    """The concise, localized friendly name for the operation; suitable for dropdowns. E.g. \"Create
     or Update Virtual Machine\", \"Restart Virtual Machine\"."""
    description: Optional[str] = rest_field(visibility=["read"])
    """The short, localized friendly description of the operation; suitable for tool tips and detailed
     views."""


class OSImageNotificationProfile(_model_base.Model):
    """Specifies OS Image Scheduled Event related configurations.

    :ivar not_before_timeout: Length of time a Virtual Machine being reimaged or having its OS
     upgraded will
     have to potentially approve the OS Image Scheduled Event before the event is
     auto approved (timed out). The configuration is specified in ISO 8601 format,
     and the value must not exceed 15 minutes (PT15M).
    :vartype not_before_timeout: str
    :ivar enable: Specifies whether the OS Image Scheduled event is enabled or disabled.
    :vartype enable: bool
    """

    not_before_timeout: Optional[str] = rest_field(name="notBeforeTimeout")
    """Length of time a Virtual Machine being reimaged or having its OS upgraded will
     have to potentially approve the OS Image Scheduled Event before the event is
     auto approved (timed out). The configuration is specified in ISO 8601 format,
     and the value must not exceed 15 minutes (PT15M)."""
    enable: Optional[bool] = rest_field()
    """Specifies whether the OS Image Scheduled event is enabled or disabled."""

    @overload
    def __init__(
        self,
        *,
        not_before_timeout: Optional[str] = None,
        enable: Optional[bool] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class PatchSettings(_model_base.Model):
    """Specifies settings related to VM Guest Patching on Windows.

    :ivar patch_mode: Specifies the mode of VM Guest Patching to IaaS virtual machine or virtual
     machines associated to virtual machine scale set with OrchestrationMode as
     Flexible.:code:`<br />`:code:`<br />` Possible values are::code:`<br />`:code:`<br />`
     **Manual** - You
     control the application of patches to a virtual machine. You do this by
     applying patches manually inside the VM. In this mode, automatic updates are
     disabled; the property WindowsConfiguration.enableAutomaticUpdates must be
     false:code:`<br />`:code:`<br />` **AutomaticByOS** - The virtual machine will automatically
     be
     updated by the OS. The property WindowsConfiguration.enableAutomaticUpdates
     must be true. :code:`<br />`:code:`<br />` **AutomaticByPlatform** - the virtual machine will
     automatically updated by the platform. The properties provisionVMAgent and
     WindowsConfiguration.enableAutomaticUpdates must be true. Known values are: "Manual",
     "AutomaticByOS", and "AutomaticByPlatform".
    :vartype patch_mode: str or ~azure.mgmt.computefleet.models.WindowsVMGuestPatchMode
    :ivar enable_hotpatching: Enables customers to patch their Azure VMs without requiring a
     reboot. For
     enableHotpatching, the 'provisionVMAgent' must be set to true and 'patchMode'
     must be set to 'AutomaticByPlatform'.
    :vartype enable_hotpatching: bool
    :ivar assessment_mode: Specifies the mode of VM Guest patch assessment for the IaaS virtual
     machine.:code:`<br />`:code:`<br />` Possible values are::code:`<br />`:code:`<br />`
     **ImageDefault** - You
     control the timing of patch assessments on a virtual machine.:code:`<br />`:code:`<br />`
     **AutomaticByPlatform** - The platform will trigger periodic patch assessments.
     The property provisionVMAgent must be true. Known values are: "ImageDefault" and
     "AutomaticByPlatform".
    :vartype assessment_mode: str or ~azure.mgmt.computefleet.models.WindowsPatchAssessmentMode
    :ivar automatic_by_platform_settings: Specifies additional settings for patch mode
     AutomaticByPlatform in VM Guest
     Patching on Windows.
    :vartype automatic_by_platform_settings:
     ~azure.mgmt.computefleet.models.WindowsVMGuestPatchAutomaticByPlatformSettings
    """

    patch_mode: Optional[Union[str, "_models.WindowsVMGuestPatchMode"]] = rest_field(name="patchMode")
    """Specifies the mode of VM Guest Patching to IaaS virtual machine or virtual
     machines associated to virtual machine scale set with OrchestrationMode as
     Flexible.:code:`<br />`:code:`<br />` Possible values are::code:`<br />`:code:`<br />`
     **Manual** - You
     control the application of patches to a virtual machine. You do this by
     applying patches manually inside the VM. In this mode, automatic updates are
     disabled; the property WindowsConfiguration.enableAutomaticUpdates must be
     false:code:`<br />`:code:`<br />` **AutomaticByOS** - The virtual machine will automatically be
     updated by the OS. The property WindowsConfiguration.enableAutomaticUpdates
     must be true. :code:`<br />`:code:`<br />` **AutomaticByPlatform** - the virtual machine will
     automatically updated by the platform. The properties provisionVMAgent and
     WindowsConfiguration.enableAutomaticUpdates must be true. Known values are: \"Manual\",
     \"AutomaticByOS\", and \"AutomaticByPlatform\"."""
    enable_hotpatching: Optional[bool] = rest_field(name="enableHotpatching")
    """Enables customers to patch their Azure VMs without requiring a reboot. For
     enableHotpatching, the 'provisionVMAgent' must be set to true and 'patchMode'
     must be set to 'AutomaticByPlatform'."""
    assessment_mode: Optional[Union[str, "_models.WindowsPatchAssessmentMode"]] = rest_field(name="assessmentMode")
    """Specifies the mode of VM Guest patch assessment for the IaaS virtual
     machine.:code:`<br />`:code:`<br />` Possible values are::code:`<br />`:code:`<br />`
     **ImageDefault** - You
     control the timing of patch assessments on a virtual machine.:code:`<br />`:code:`<br />`
     **AutomaticByPlatform** - The platform will trigger periodic patch assessments.
     The property provisionVMAgent must be true. Known values are: \"ImageDefault\" and
     \"AutomaticByPlatform\"."""
    automatic_by_platform_settings: Optional["_models.WindowsVMGuestPatchAutomaticByPlatformSettings"] = rest_field(
        name="automaticByPlatformSettings"
    )
    """Specifies additional settings for patch mode AutomaticByPlatform in VM Guest
     Patching on Windows."""

    @overload
    def __init__(
        self,
        *,
        patch_mode: Optional[Union[str, "_models.WindowsVMGuestPatchMode"]] = None,
        enable_hotpatching: Optional[bool] = None,
        assessment_mode: Optional[Union[str, "_models.WindowsPatchAssessmentMode"]] = None,
        automatic_by_platform_settings: Optional["_models.WindowsVMGuestPatchAutomaticByPlatformSettings"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class Plan(_model_base.Model):
    """Plan for the resource.


    :ivar name: A user defined name of the 3rd Party Artifact that is being procured. Required.
    :vartype name: str
    :ivar publisher: The publisher of the 3rd Party Artifact that is being bought. E.g. NewRelic.
     Required.
    :vartype publisher: str
    :ivar product: The 3rd Party artifact that is being procured. E.g. NewRelic. Product maps to
     the OfferID specified for the artifact at the time of Data Market onboarding. Required.
    :vartype product: str
    :ivar promotion_code: A publisher provided promotion code as provisioned in Data Market for the
     said product/artifact.
    :vartype promotion_code: str
    :ivar version: The version of the desired product/artifact.
    :vartype version: str
    """

    name: str = rest_field()
    """A user defined name of the 3rd Party Artifact that is being procured. Required."""
    publisher: str = rest_field()
    """The publisher of the 3rd Party Artifact that is being bought. E.g. NewRelic. Required."""
    product: str = rest_field()
    """The 3rd Party artifact that is being procured. E.g. NewRelic. Product maps to the OfferID
     specified for the artifact at the time of Data Market onboarding. Required."""
    promotion_code: Optional[str] = rest_field(name="promotionCode")
    """A publisher provided promotion code as provisioned in Data Market for the said
     product/artifact."""
    version: Optional[str] = rest_field()
    """The version of the desired product/artifact."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        publisher: str,
        product: str,
        promotion_code: Optional[str] = None,
        version: Optional[str] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ProxyAgentSettings(_model_base.Model):
    """Specifies ProxyAgent settings while creating the virtual machine. Minimum
    api-version: 2023-09-01.

    :ivar enabled: Specifies whether ProxyAgent feature should be enabled on the virtual machine
     or virtual machine scale set.
    :vartype enabled: bool
    :ivar mode: Specifies the mode that ProxyAgent will execute on if the feature is enabled.
     ProxyAgent will start to audit or monitor but not enforce access control over
     requests to host endpoints in Audit mode, while in Enforce mode it will enforce
     access control. The default value is Enforce mode. Known values are: "Audit" and "Enforce".
    :vartype mode: str or ~azure.mgmt.computefleet.models.Mode
    :ivar key_incarnation_id: Increase the value of this property allows user to reset the key used
     for
     securing communication channel between guest and host.
    :vartype key_incarnation_id: int
    """

    enabled: Optional[bool] = rest_field()
    """Specifies whether ProxyAgent feature should be enabled on the virtual machine
     or virtual machine scale set."""
    mode: Optional[Union[str, "_models.Mode"]] = rest_field()
    """Specifies the mode that ProxyAgent will execute on if the feature is enabled.
     ProxyAgent will start to audit or monitor but not enforce access control over
     requests to host endpoints in Audit mode, while in Enforce mode it will enforce
     access control. The default value is Enforce mode. Known values are: \"Audit\" and \"Enforce\"."""
    key_incarnation_id: Optional[int] = rest_field(name="keyIncarnationId")
    """Increase the value of this property allows user to reset the key used for
     securing communication channel between guest and host."""

    @overload
    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        mode: Optional[Union[str, "_models.Mode"]] = None,
        key_incarnation_id: Optional[int] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class PublicIPAddressSku(_model_base.Model):
    """Describes the public IP Sku. It can only be set with OrchestrationMode as
    Flexible.

    :ivar name: Specify public IP sku name. Known values are: "Basic" and "Standard".
    :vartype name: str or ~azure.mgmt.computefleet.models.PublicIPAddressSkuName
    :ivar tier: Specify public IP sku tier. Known values are: "Regional" and "Global".
    :vartype tier: str or ~azure.mgmt.computefleet.models.PublicIPAddressSkuTier
    """

    name: Optional[Union[str, "_models.PublicIPAddressSkuName"]] = rest_field()
    """Specify public IP sku name. Known values are: \"Basic\" and \"Standard\"."""
    tier: Optional[Union[str, "_models.PublicIPAddressSkuTier"]] = rest_field()
    """Specify public IP sku tier. Known values are: \"Regional\" and \"Global\"."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[Union[str, "_models.PublicIPAddressSkuName"]] = None,
        tier: Optional[Union[str, "_models.PublicIPAddressSkuTier"]] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class RegularPriorityProfile(_model_base.Model):
    """Configuration Options for Regular instances in Compute Fleet.

    :ivar capacity: Total capacity to achieve. It is currently in terms of number of VMs.
    :vartype capacity: int
    :ivar min_capacity: Minimum capacity to achieve which cannot be updated. If we will not be able
     to "guarantee" minimum capacity, we will reject the request in the sync path itself.
    :vartype min_capacity: int
    :ivar allocation_strategy: Allocation strategy to follow when determining the VM sizes
     distribution for Regular VMs. Known values are: "LowestPrice" and "Prioritized".
    :vartype allocation_strategy: str or
     ~azure.mgmt.computefleet.models.RegularPriorityAllocationStrategy
    """

    capacity: Optional[int] = rest_field()
    """Total capacity to achieve. It is currently in terms of number of VMs."""
    min_capacity: Optional[int] = rest_field(name="minCapacity")
    """Minimum capacity to achieve which cannot be updated. If we will not be able to \"guarantee\"
     minimum capacity, we will reject the request in the sync path itself."""
    allocation_strategy: Optional[Union[str, "_models.RegularPriorityAllocationStrategy"]] = rest_field(
        name="allocationStrategy"
    )
    """Allocation strategy to follow when determining the VM sizes distribution for Regular VMs. Known
     values are: \"LowestPrice\" and \"Prioritized\"."""

    @overload
    def __init__(
        self,
        *,
        capacity: Optional[int] = None,
        min_capacity: Optional[int] = None,
        allocation_strategy: Optional[Union[str, "_models.RegularPriorityAllocationStrategy"]] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ResourcePlanUpdate(_model_base.Model):
    """The template for adding optional properties.

    :ivar name: A user defined name of the 3rd Party Artifact that is being procured.
    :vartype name: str
    :ivar publisher: The publisher of the 3rd Party Artifact that is being bought. E.g. NewRelic.
    :vartype publisher: str
    :ivar product: The 3rd Party artifact that is being procured. E.g. NewRelic. Product maps to
     the OfferID specified for the artifact at the time of Data Market onboarding.
    :vartype product: str
    :ivar promotion_code: A publisher provided promotion code as provisioned in Data Market for the
     said product/artifact.
    :vartype promotion_code: str
    :ivar version: The version of the desired product/artifact.
    :vartype version: str
    """

    name: Optional[str] = rest_field()
    """A user defined name of the 3rd Party Artifact that is being procured."""
    publisher: Optional[str] = rest_field()
    """The publisher of the 3rd Party Artifact that is being bought. E.g. NewRelic."""
    product: Optional[str] = rest_field()
    """The 3rd Party artifact that is being procured. E.g. NewRelic. Product maps to the OfferID
     specified for the artifact at the time of Data Market onboarding."""
    promotion_code: Optional[str] = rest_field(name="promotionCode")
    """A publisher provided promotion code as provisioned in Data Market for the said
     product/artifact."""
    version: Optional[str] = rest_field()
    """The version of the desired product/artifact."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
        publisher: Optional[str] = None,
        product: Optional[str] = None,
        promotion_code: Optional[str] = None,
        version: Optional[str] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ScheduledEventsProfile(_model_base.Model):
    """Specifies Scheduled Event related configurations.

    :ivar terminate_notification_profile: Specifies Terminate Scheduled Event related
     configurations.
    :vartype terminate_notification_profile:
     ~azure.mgmt.computefleet.models.TerminateNotificationProfile
    :ivar os_image_notification_profile: Specifies OS Image Scheduled Event related configurations.
    :vartype os_image_notification_profile:
     ~azure.mgmt.computefleet.models.OSImageNotificationProfile
    """

    terminate_notification_profile: Optional["_models.TerminateNotificationProfile"] = rest_field(
        name="terminateNotificationProfile"
    )
    """Specifies Terminate Scheduled Event related configurations."""
    os_image_notification_profile: Optional["_models.OSImageNotificationProfile"] = rest_field(
        name="osImageNotificationProfile"
    )
    """Specifies OS Image Scheduled Event related configurations."""

    @overload
    def __init__(
        self,
        *,
        terminate_notification_profile: Optional["_models.TerminateNotificationProfile"] = None,
        os_image_notification_profile: Optional["_models.OSImageNotificationProfile"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class SecurityPostureReference(_model_base.Model):
    """Specifies the security posture to be used for all virtual machines in the scale
    set. Minimum api-version: 2023-03-01.

    :ivar id: The security posture reference id in the form of
    /CommunityGalleries/{communityGalleryName}/securityPostures/{securityPostureName}/versions/{major.minor.patch}|{major.*}|latest.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar exclude_extensions: List of virtual machine extension names to exclude when applying the
     security
     posture.
    :vartype exclude_extensions: list[str]
    :ivar is_overridable: Whether the security posture can be overridden by the user.
    :vartype is_overridable: bool
    """

    id: Optional[str] = rest_field()
    """The security posture reference id in the form of
     /CommunityGalleries/{communityGalleryName}/securityPostures/{securityPostureName}/versions/{major.minor.patch}|{major.*}|latest.  # pylint: disable=line-too-long"""
    exclude_extensions: Optional[List[str]] = rest_field(name="excludeExtensions")
    """List of virtual machine extension names to exclude when applying the security
     posture."""
    is_overridable: Optional[bool] = rest_field(name="isOverridable")
    """Whether the security posture can be overridden by the user."""

    @overload
    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        exclude_extensions: Optional[List[str]] = None,
        is_overridable: Optional[bool] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class SecurityProfile(_model_base.Model):
    """Specifies the Security profile settings for the virtual machine or virtual
    machine scale set.

    :ivar uefi_settings: Specifies the security settings like secure boot and vTPM used while
     creating
     the virtual machine. Minimum api-version: 2020-12-01.
    :vartype uefi_settings: ~azure.mgmt.computefleet.models.UefiSettings
    :ivar encryption_at_host: This property can be used by user in the request to enable or disable
     the Host
     Encryption for the virtual machine or virtual machine scale set. This will
     enable the encryption for all the disks including Resource/Temp disk at host
     itself. The default behavior is: The Encryption at host will be disabled unless
     this property is set to true for the resource.
    :vartype encryption_at_host: bool
    :ivar security_type: Specifies the SecurityType of the virtual machine. It has to be set to any
     specified value to enable UefiSettings. The default behavior is: UefiSettings
     will not be enabled unless this property is set. Known values are: "TrustedLaunch" and
     "ConfidentialVM".
    :vartype security_type: str or ~azure.mgmt.computefleet.models.SecurityTypes
    :ivar encryption_identity: Specifies the Managed Identity used by ADE to get access token for
     keyvault
     operations.
    :vartype encryption_identity: ~azure.mgmt.computefleet.models.EncryptionIdentity
    :ivar proxy_agent_settings: Specifies ProxyAgent settings while creating the virtual machine.
     Minimum
     api-version: 2023-09-01.
    :vartype proxy_agent_settings: ~azure.mgmt.computefleet.models.ProxyAgentSettings
    """

    uefi_settings: Optional["_models.UefiSettings"] = rest_field(name="uefiSettings")
    """Specifies the security settings like secure boot and vTPM used while creating
     the virtual machine. Minimum api-version: 2020-12-01."""
    encryption_at_host: Optional[bool] = rest_field(name="encryptionAtHost")
    """This property can be used by user in the request to enable or disable the Host
     Encryption for the virtual machine or virtual machine scale set. This will
     enable the encryption for all the disks including Resource/Temp disk at host
     itself. The default behavior is: The Encryption at host will be disabled unless
     this property is set to true for the resource."""
    security_type: Optional[Union[str, "_models.SecurityTypes"]] = rest_field(name="securityType")
    """Specifies the SecurityType of the virtual machine. It has to be set to any
     specified value to enable UefiSettings. The default behavior is: UefiSettings
     will not be enabled unless this property is set. Known values are: \"TrustedLaunch\" and
     \"ConfidentialVM\"."""
    encryption_identity: Optional["_models.EncryptionIdentity"] = rest_field(name="encryptionIdentity")
    """Specifies the Managed Identity used by ADE to get access token for keyvault
     operations."""
    proxy_agent_settings: Optional["_models.ProxyAgentSettings"] = rest_field(name="proxyAgentSettings")
    """Specifies ProxyAgent settings while creating the virtual machine. Minimum
     api-version: 2023-09-01."""

    @overload
    def __init__(
        self,
        *,
        uefi_settings: Optional["_models.UefiSettings"] = None,
        encryption_at_host: Optional[bool] = None,
        security_type: Optional[Union[str, "_models.SecurityTypes"]] = None,
        encryption_identity: Optional["_models.EncryptionIdentity"] = None,
        proxy_agent_settings: Optional["_models.ProxyAgentSettings"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ServiceArtifactReference(_model_base.Model):
    """Specifies the service artifact reference id used to set same image version for
    all virtual machines in the scale set when using 'latest' image version.
    Minimum api-version: 2022-11-01.

    :ivar id: The service artifact reference id in the form of
    /subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/galleries/{galleryName}/serviceArtifacts/{serviceArtifactName}/vmArtifactsProfiles/{vmArtifactsProfilesName}.  # pylint: disable=line-too-long
    :vartype id: str
    """

    id: Optional[str] = rest_field()
    """The service artifact reference id in the form of
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/galleries/{galleryName}/serviceArtifacts/{serviceArtifactName}/vmArtifactsProfiles/{vmArtifactsProfilesName}.  # pylint: disable=line-too-long"""

    @overload
    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class SpotPriorityProfile(_model_base.Model):
    """Configuration Options for Spot instances in Compute Fleet.

    :ivar capacity: Total capacity to achieve. It is currently in terms of number of VMs.
    :vartype capacity: int
    :ivar min_capacity: Minimum capacity to achieve which cannot be updated. If we will not be able
     to "guarantee" minimum capacity, we will reject the request in the sync path itself.
    :vartype min_capacity: int
    :ivar max_price_per_vm: Price per hour of each Spot VM will never exceed this.
    :vartype max_price_per_vm: float
    :ivar eviction_policy: Eviction Policy to follow when evicting Spot VMs. Known values are:
     "Delete" and "Deallocate".
    :vartype eviction_policy: str or ~azure.mgmt.computefleet.models.EvictionPolicy
    :ivar allocation_strategy: Allocation strategy to follow when determining the VM sizes
     distribution for Spot VMs. Known values are: "PriceCapacityOptimized", "LowestPrice", and
     "CapacityOptimized".
    :vartype allocation_strategy: str or ~azure.mgmt.computefleet.models.SpotAllocationStrategy
    :ivar maintain: Flag to enable/disable continuous goal seeking for the desired capacity and
     restoration of evicted Spot VMs.
     If maintain is enabled, AzureFleetRP will use all VM sizes in vmSizesProfile to create new VMs
     (if VMs are evicted deleted)
     or update existing VMs with new VM sizes (if VMs are evicted deallocated or failed to allocate
     due to capacity constraint) in order to achieve the desired capacity.
     Maintain is enabled by default.
    :vartype maintain: bool
    """

    capacity: Optional[int] = rest_field()
    """Total capacity to achieve. It is currently in terms of number of VMs."""
    min_capacity: Optional[int] = rest_field(name="minCapacity")
    """Minimum capacity to achieve which cannot be updated. If we will not be able to \"guarantee\"
     minimum capacity, we will reject the request in the sync path itself."""
    max_price_per_vm: Optional[float] = rest_field(name="maxPricePerVM")
    """Price per hour of each Spot VM will never exceed this."""
    eviction_policy: Optional[Union[str, "_models.EvictionPolicy"]] = rest_field(name="evictionPolicy")
    """Eviction Policy to follow when evicting Spot VMs. Known values are: \"Delete\" and
     \"Deallocate\"."""
    allocation_strategy: Optional[Union[str, "_models.SpotAllocationStrategy"]] = rest_field(name="allocationStrategy")
    """Allocation strategy to follow when determining the VM sizes distribution for Spot VMs. Known
     values are: \"PriceCapacityOptimized\", \"LowestPrice\", and \"CapacityOptimized\"."""
    maintain: Optional[bool] = rest_field()
    """Flag to enable/disable continuous goal seeking for the desired capacity and restoration of
     evicted Spot VMs.
     If maintain is enabled, AzureFleetRP will use all VM sizes in vmSizesProfile to create new VMs
     (if VMs are evicted deleted)
     or update existing VMs with new VM sizes (if VMs are evicted deallocated or failed to allocate
     due to capacity constraint) in order to achieve the desired capacity.
     Maintain is enabled by default."""

    @overload
    def __init__(
        self,
        *,
        capacity: Optional[int] = None,
        min_capacity: Optional[int] = None,
        max_price_per_vm: Optional[float] = None,
        eviction_policy: Optional[Union[str, "_models.EvictionPolicy"]] = None,
        allocation_strategy: Optional[Union[str, "_models.SpotAllocationStrategy"]] = None,
        maintain: Optional[bool] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class SshConfiguration(_model_base.Model):
    """SSH configuration for Linux based VMs running on Azure.

    :ivar public_keys: The list of SSH public keys used to authenticate with linux based VMs.
    :vartype public_keys: list[~azure.mgmt.computefleet.models.SshPublicKey]
    """

    public_keys: Optional[List["_models.SshPublicKey"]] = rest_field(name="publicKeys")
    """The list of SSH public keys used to authenticate with linux based VMs."""

    @overload
    def __init__(
        self,
        *,
        public_keys: Optional[List["_models.SshPublicKey"]] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class SshPublicKey(_model_base.Model):
    """Contains information about SSH certificate public key and the path on the Linux
    VM where the public key is placed.

    :ivar path: Specifies the full path on the created VM where ssh public key is stored. If
     the file already exists, the specified key is appended to the file. Example:
     /home/user/.ssh/authorized_keys.
    :vartype path: str
    :ivar key_data: SSH public key certificate used to authenticate with the VM through ssh. The
     key needs to be at least 2048-bit and in ssh-rsa format. For creating ssh keys,
     see [Create SSH keys on Linux and Mac for Linux VMs in
     Azure]https://docs.microsoft.com/azure/virtual-machines/linux/create-ssh-keys-detailed).
    :vartype key_data: str
    """

    path: Optional[str] = rest_field()
    """Specifies the full path on the created VM where ssh public key is stored. If
     the file already exists, the specified key is appended to the file. Example:
     /home/user/.ssh/authorized_keys."""
    key_data: Optional[str] = rest_field(name="keyData")
    """SSH public key certificate used to authenticate with the VM through ssh. The
     key needs to be at least 2048-bit and in ssh-rsa format. For creating ssh keys,
     see [Create SSH keys on Linux and Mac for Linux VMs in
     Azure]https://docs.microsoft.com/azure/virtual-machines/linux/create-ssh-keys-detailed)."""

    @overload
    def __init__(
        self,
        *,
        path: Optional[str] = None,
        key_data: Optional[str] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class SubResource(_model_base.Model):
    """Describes SubResource.

    :ivar id: Resource Id.
    :vartype id: str
    """

    id: Optional[str] = rest_field()
    """Resource Id."""

    @overload
    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class SystemData(_model_base.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.computefleet.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.computefleet.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    created_by: Optional[str] = rest_field(name="createdBy")
    """The identity that created the resource."""
    created_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(name="createdByType")
    """The type of identity that created the resource. Known values are: \"User\", \"Application\",
     \"ManagedIdentity\", and \"Key\"."""
    created_at: Optional[datetime.datetime] = rest_field(name="createdAt", format="rfc3339")
    """The timestamp of resource creation (UTC)."""
    last_modified_by: Optional[str] = rest_field(name="lastModifiedBy")
    """The identity that last modified the resource."""
    last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(name="lastModifiedByType")
    """The type of identity that last modified the resource. Known values are: \"User\",
     \"Application\", \"ManagedIdentity\", and \"Key\"."""
    last_modified_at: Optional[datetime.datetime] = rest_field(name="lastModifiedAt", format="rfc3339")
    """The timestamp of resource last modification (UTC)."""

    @overload
    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class TerminateNotificationProfile(_model_base.Model):
    """Specifies Terminate Scheduled Event related configurations.

    :ivar not_before_timeout: Configurable length of time a Virtual Machine being deleted will have
     to
     potentially approve the Terminate Scheduled Event before the event is auto
     approved (timed out). The configuration must be specified in ISO 8601 format,
     the default value is 5 minutes (PT5M).
    :vartype not_before_timeout: str
    :ivar enable: Specifies whether the Terminate Scheduled event is enabled or disabled.
    :vartype enable: bool
    """

    not_before_timeout: Optional[str] = rest_field(name="notBeforeTimeout")
    """Configurable length of time a Virtual Machine being deleted will have to
     potentially approve the Terminate Scheduled Event before the event is auto
     approved (timed out). The configuration must be specified in ISO 8601 format,
     the default value is 5 minutes (PT5M)."""
    enable: Optional[bool] = rest_field()
    """Specifies whether the Terminate Scheduled event is enabled or disabled."""

    @overload
    def __init__(
        self,
        *,
        not_before_timeout: Optional[str] = None,
        enable: Optional[bool] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class UefiSettings(_model_base.Model):
    """Specifies the security settings like secure boot and vTPM used while creating
    the virtual machine. Minimum api-version: 2020-12-01.

    :ivar secure_boot_enabled: Specifies whether secure boot should be enabled on the virtual
     machine. Minimum
     api-version: 2020-12-01.
    :vartype secure_boot_enabled: bool
    :ivar v_tpm_enabled: Specifies whether vTPM should be enabled on the virtual machine. Minimum
     api-version: 2020-12-01.
    :vartype v_tpm_enabled: bool
    """

    secure_boot_enabled: Optional[bool] = rest_field(name="secureBootEnabled")
    """Specifies whether secure boot should be enabled on the virtual machine. Minimum
     api-version: 2020-12-01."""
    v_tpm_enabled: Optional[bool] = rest_field(name="vTpmEnabled")
    """Specifies whether vTPM should be enabled on the virtual machine. Minimum
     api-version: 2020-12-01."""

    @overload
    def __init__(
        self,
        *,
        secure_boot_enabled: Optional[bool] = None,
        v_tpm_enabled: Optional[bool] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class UserAssignedIdentity(_model_base.Model):
    """User assigned identity properties.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID of the assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client ID of the assigned identity.
    :vartype client_id: str
    """

    principal_id: Optional[str] = rest_field(name="principalId", visibility=["read"])
    """The principal ID of the assigned identity."""
    client_id: Optional[str] = rest_field(name="clientId", visibility=["read"])
    """The client ID of the assigned identity."""


class VaultCertificate(_model_base.Model):
    """Describes a single certificate reference in a Key Vault, and where the
    certificate should reside on the VM.

    :ivar certificate_url: This is the URL of a certificate that has been uploaded to Key Vault as
     a
     secret. For adding a secret to the Key Vault, see `Add a key or secret to the
     key
     vault <https://docs.microsoft.com/azure/key-vault/key-vault-get-started/#add>`_.
     In this case, your certificate needs to be It is the Base64 encoding of the
     following JSON Object which is encoded in UTF-8: :code:`<br>`:code:`<br>` {:code:`<br>`
     "data":":code:`<Base64-encoded-certificate>`",:code:`<br>`  "dataType":"pfx",:code:`<br>`
     "password":":code:`<pfx-file-password>`":code:`<br>`} :code:`<br>` To install certificates on
     a virtual
     machine it is recommended to use the `Azure Key Vault virtual machine extension
     for
     Linux <https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-linux>`_
     or the `Azure Key Vault virtual machine extension for
     Windows <https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-windows>`_.
    :vartype certificate_url: str
    :ivar certificate_store: For Windows VMs, specifies the certificate store on the Virtual
     Machine to
     which the certificate should be added. The specified certificate store is
     implicitly in the LocalMachine account. For Linux VMs, the certificate file is
     placed under the /var/lib/waagent directory, with the file name
     &lt;UppercaseThumbprint&gt;.crt for the X509 certificate file and
     &lt;UppercaseThumbprint&gt;.prv for private key. Both of these files are .pem
     formatted.
    :vartype certificate_store: str
    """

    certificate_url: Optional[str] = rest_field(name="certificateUrl")
    """This is the URL of a certificate that has been uploaded to Key Vault as a
     secret. For adding a secret to the Key Vault, see `Add a key or secret to the
     key
     vault <https://docs.microsoft.com/azure/key-vault/key-vault-get-started/#add>`_.
     In this case, your certificate needs to be It is the Base64 encoding of the
     following JSON Object which is encoded in UTF-8: :code:`<br>`:code:`<br>` {:code:`<br>`
     \"data\":\":code:`<Base64-encoded-certificate>`\",:code:`<br>`
     \"dataType\":\"pfx\",:code:`<br>`
     \"password\":\":code:`<pfx-file-password>`\":code:`<br>`} :code:`<br>` To install certificates
     on a virtual
     machine it is recommended to use the `Azure Key Vault virtual machine extension
     for
     Linux <https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-linux>`_
     or the `Azure Key Vault virtual machine extension for
     Windows <https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-windows>`_."""
    certificate_store: Optional[str] = rest_field(name="certificateStore")
    """For Windows VMs, specifies the certificate store on the Virtual Machine to
     which the certificate should be added. The specified certificate store is
     implicitly in the LocalMachine account. For Linux VMs, the certificate file is
     placed under the /var/lib/waagent directory, with the file name
     &lt;UppercaseThumbprint&gt;.crt for the X509 certificate file and
     &lt;UppercaseThumbprint&gt;.prv for private key. Both of these files are .pem
     formatted."""

    @overload
    def __init__(
        self,
        *,
        certificate_url: Optional[str] = None,
        certificate_store: Optional[str] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class VaultSecretGroup(_model_base.Model):
    """Describes a set of certificates which are all in the same Key Vault.

    :ivar source_vault: The relative URL of the Key Vault containing all of the certificates in
     VaultCertificates.
    :vartype source_vault: ~azure.mgmt.computefleet.models.SubResource
    :ivar vault_certificates: The list of key vault references in SourceVault which contain
     certificates.
    :vartype vault_certificates: list[~azure.mgmt.computefleet.models.VaultCertificate]
    """

    source_vault: Optional["_models.SubResource"] = rest_field(name="sourceVault")
    """The relative URL of the Key Vault containing all of the certificates in
     VaultCertificates."""
    vault_certificates: Optional[List["_models.VaultCertificate"]] = rest_field(name="vaultCertificates")
    """The list of key vault references in SourceVault which contain certificates."""

    @overload
    def __init__(
        self,
        *,
        source_vault: Optional["_models.SubResource"] = None,
        vault_certificates: Optional[List["_models.VaultCertificate"]] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class VirtualHardDisk(_model_base.Model):
    """Describes the uri of a disk.

    :ivar uri: Specifies the virtual hard disk's uri.
    :vartype uri: str
    """

    uri: Optional[str] = rest_field()
    """Specifies the virtual hard disk's uri."""

    @overload
    def __init__(
        self,
        *,
        uri: Optional[str] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class VirtualMachineScaleSet(_model_base.Model):
    """An AzureFleet's virtualMachineScaleSet.

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar id: The compute RP resource id of the virtualMachineScaleSet
    "subscriptions/{subId}/resourceGroups/{rgName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmssName}".
     Required.
    :vartype id: str
    :ivar type: Type of the virtualMachineScaleSet.
    :vartype type: str
    :ivar operation_status: This represents the operationStatus of the VMSS in response to the last
     operation that was performed on it by Azure Fleet resource. Required. Known values are:
     "Succeeded", "Failed", "Canceled", "Creating", "Updating", "Deleting", and "Migrating".
    :vartype operation_status: str or ~azure.mgmt.computefleet.models.ProvisioningState
    :ivar error: Error Information when ``operationStatus`` is ``Failed``.
    :vartype error: ~azure.mgmt.computefleet.models.ApiError
    """

    id: str = rest_field(visibility=["read"])
    """The compute RP resource id of the virtualMachineScaleSet
     \"subscriptions/{subId}/resourceGroups/{rgName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmssName}\".
     Required."""
    type: Optional[str] = rest_field(visibility=["read"])
    """Type of the virtualMachineScaleSet."""
    operation_status: Union[str, "_models.ProvisioningState"] = rest_field(name="operationStatus", visibility=["read"])
    """This represents the operationStatus of the VMSS in response to the last operation that was
     performed on it by Azure Fleet resource. Required. Known values are: \"Succeeded\", \"Failed\",
     \"Canceled\", \"Creating\", \"Updating\", \"Deleting\", and \"Migrating\"."""
    error: Optional["_models.ApiError"] = rest_field(visibility=["read"])
    """Error Information when ``operationStatus`` is ``Failed``."""


class VirtualMachineScaleSetDataDisk(_model_base.Model):
    """Describes a virtual machine scale set data disk.


    :ivar name: The disk name.
    :vartype name: str
    :ivar lun: Specifies the logical unit number of the data disk. This value is used to
     identify data disks within the VM and therefore must be unique for each data
     disk attached to a VM. Required.
    :vartype lun: int
    :ivar caching: Specifies the caching requirements. Possible values are: **None,**
     **ReadOnly,** **ReadWrite.** The default values are: **None for Standard
     storage. ReadOnly for Premium storage.**. Known values are: "None", "ReadOnly", and
     "ReadWrite".
    :vartype caching: str or ~azure.mgmt.computefleet.models.CachingTypes
    :ivar write_accelerator_enabled: Specifies whether writeAccelerator should be enabled or
     disabled on the disk.
    :vartype write_accelerator_enabled: bool
    :ivar create_option: The create option. Required. Known values are: "FromImage", "Empty",
     "Attach", "Copy", and "Restore".
    :vartype create_option: str or ~azure.mgmt.computefleet.models.DiskCreateOptionTypes
    :ivar disk_size_gb: Specifies the size of an empty data disk in gigabytes. This element can be
     used
     to overwrite the size of the disk in a virtual machine image. The property
     diskSizeGB is the number of bytes x 1024^3 for the disk and the value cannot be
     larger than 1023.
    :vartype disk_size_gb: int
    :ivar managed_disk: The managed disk parameters.
    :vartype managed_disk:
     ~azure.mgmt.computefleet.models.VirtualMachineScaleSetManagedDiskParameters
    :ivar disk_iops_read_write: Specifies the Read-Write IOPS for the managed disk. Should be used
     only when
     StorageAccountType is UltraSSD_LRS. If not specified, a default value would be
     assigned based on diskSizeGB.
    :vartype disk_iops_read_write: int
    :ivar disk_m_bps_read_write: Specifies the bandwidth in MB per second for the managed disk.
     Should be used
     only when StorageAccountType is UltraSSD_LRS. If not specified, a default value
     would be assigned based on diskSizeGB.
    :vartype disk_m_bps_read_write: int
    :ivar delete_option: Specifies whether data disk should be deleted or detached upon VMSS Flex
     deletion (This feature is available for VMSS with Flexible OrchestrationMode
     only).:code:`<br>`:code:`<br>` Possible values: :code:`<br>`:code:`<br>` **Delete** If this
     value is used, the
     data disk is deleted when the VMSS Flex VM is deleted.:code:`<br>`:code:`<br>` **Detach** If
     this value is used, the data disk is retained after VMSS Flex VM is
     deleted.:code:`<br>`:code:`<br>` The default value is set to **Delete**. Known values are:
     "Delete" and "Detach".
    :vartype delete_option: str or ~azure.mgmt.computefleet.models.DiskDeleteOptionTypes
    """

    name: Optional[str] = rest_field()
    """The disk name."""
    lun: int = rest_field()
    """Specifies the logical unit number of the data disk. This value is used to
     identify data disks within the VM and therefore must be unique for each data
     disk attached to a VM. Required."""
    caching: Optional[Union[str, "_models.CachingTypes"]] = rest_field()
    """Specifies the caching requirements. Possible values are: **None,**
     **ReadOnly,** **ReadWrite.** The default values are: **None for Standard
     storage. ReadOnly for Premium storage.**. Known values are: \"None\", \"ReadOnly\", and
     \"ReadWrite\"."""
    write_accelerator_enabled: Optional[bool] = rest_field(name="writeAcceleratorEnabled")
    """Specifies whether writeAccelerator should be enabled or disabled on the disk."""
    create_option: Union[str, "_models.DiskCreateOptionTypes"] = rest_field(name="createOption")
    """The create option. Required. Known values are: \"FromImage\", \"Empty\", \"Attach\", \"Copy\",
     and \"Restore\"."""
    disk_size_gb: Optional[int] = rest_field(name="diskSizeGB")
    """Specifies the size of an empty data disk in gigabytes. This element can be used
     to overwrite the size of the disk in a virtual machine image. The property
     diskSizeGB is the number of bytes x 1024^3 for the disk and the value cannot be
     larger than 1023."""
    managed_disk: Optional["_models.VirtualMachineScaleSetManagedDiskParameters"] = rest_field(name="managedDisk")
    """The managed disk parameters."""
    disk_iops_read_write: Optional[int] = rest_field(name="diskIOPSReadWrite")
    """Specifies the Read-Write IOPS for the managed disk. Should be used only when
     StorageAccountType is UltraSSD_LRS. If not specified, a default value would be
     assigned based on diskSizeGB."""
    disk_m_bps_read_write: Optional[int] = rest_field(name="diskMBpsReadWrite")
    """Specifies the bandwidth in MB per second for the managed disk. Should be used
     only when StorageAccountType is UltraSSD_LRS. If not specified, a default value
     would be assigned based on diskSizeGB."""
    delete_option: Optional[Union[str, "_models.DiskDeleteOptionTypes"]] = rest_field(name="deleteOption")
    """Specifies whether data disk should be deleted or detached upon VMSS Flex
     deletion (This feature is available for VMSS with Flexible OrchestrationMode
     only).:code:`<br>`:code:`<br>` Possible values: :code:`<br>`:code:`<br>` **Delete** If this
     value is used, the
     data disk is deleted when the VMSS Flex VM is deleted.:code:`<br>`:code:`<br>` **Detach** If
     this value is used, the data disk is retained after VMSS Flex VM is
     deleted.:code:`<br>`:code:`<br>` The default value is set to **Delete**. Known values are:
     \"Delete\" and \"Detach\"."""

    @overload
    def __init__(
        self,
        *,
        lun: int,
        create_option: Union[str, "_models.DiskCreateOptionTypes"],
        name: Optional[str] = None,
        caching: Optional[Union[str, "_models.CachingTypes"]] = None,
        write_accelerator_enabled: Optional[bool] = None,
        disk_size_gb: Optional[int] = None,
        managed_disk: Optional["_models.VirtualMachineScaleSetManagedDiskParameters"] = None,
        disk_iops_read_write: Optional[int] = None,
        disk_m_bps_read_write: Optional[int] = None,
        delete_option: Optional[Union[str, "_models.DiskDeleteOptionTypes"]] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class VirtualMachineScaleSetExtension(_model_base.Model):
    """Describes a Virtual Machine Scale Set Extension.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: The name of the extension.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar properties: Describes the properties of a Virtual Machine Scale Set Extension.
    :vartype properties: ~azure.mgmt.computefleet.models.VirtualMachineScaleSetExtensionProperties
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """Resource Id."""
    name: Optional[str] = rest_field()
    """The name of the extension."""
    type: Optional[str] = rest_field(visibility=["read"])
    """Resource type."""
    properties: Optional["_models.VirtualMachineScaleSetExtensionProperties"] = rest_field()
    """Describes the properties of a Virtual Machine Scale Set Extension."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
        properties: Optional["_models.VirtualMachineScaleSetExtensionProperties"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class VirtualMachineScaleSetExtensionProfile(_model_base.Model):
    """Describes a virtual machine scale set extension profile.

    :ivar extensions: The virtual machine scale set child extension resources.
    :vartype extensions: list[~azure.mgmt.computefleet.models.VirtualMachineScaleSetExtension]
    :ivar extensions_time_budget: Specifies the time alloted for all extensions to start. The time
     duration
     should be between 15 minutes and 120 minutes (inclusive) and should be
     specified in ISO 8601 format. The default value is 90 minutes (PT1H30M).
     Minimum api-version: 2020-06-01.
    :vartype extensions_time_budget: str
    """

    extensions: Optional[List["_models.VirtualMachineScaleSetExtension"]] = rest_field()
    """The virtual machine scale set child extension resources."""
    extensions_time_budget: Optional[str] = rest_field(name="extensionsTimeBudget")
    """Specifies the time alloted for all extensions to start. The time duration
     should be between 15 minutes and 120 minutes (inclusive) and should be
     specified in ISO 8601 format. The default value is 90 minutes (PT1H30M).
     Minimum api-version: 2020-06-01."""

    @overload
    def __init__(
        self,
        *,
        extensions: Optional[List["_models.VirtualMachineScaleSetExtension"]] = None,
        extensions_time_budget: Optional[str] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class VirtualMachineScaleSetExtensionProperties(
    _model_base.Model
):  # pylint: disable=too-many-instance-attributes,name-too-long
    """Describes the properties of a Virtual Machine Scale Set Extension.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar force_update_tag: If a value is provided and is different from the previous value, the
     extension
     handler will be forced to update even if the extension configuration has not
     changed.
    :vartype force_update_tag: str
    :ivar publisher: The name of the extension handler publisher.
    :vartype publisher: str
    :ivar type: Specifies the type of the extension; an example is "CustomScriptExtension".
    :vartype type: str
    :ivar type_handler_version: Specifies the version of the script handler.
    :vartype type_handler_version: str
    :ivar auto_upgrade_minor_version: Indicates whether the extension should use a newer minor
     version if one is
     available at deployment time. Once deployed, however, the extension will not
     upgrade minor versions unless redeployed, even with this property set to true.
    :vartype auto_upgrade_minor_version: bool
    :ivar enable_automatic_upgrade: Indicates whether the extension should be automatically
     upgraded by the
     platform if there is a newer version of the extension available.
    :vartype enable_automatic_upgrade: bool
    :ivar settings: Json formatted public settings for the extension.
    :vartype settings: dict[str, any]
    :ivar protected_settings: The extension can contain either protectedSettings or
     protectedSettingsFromKeyVault or no protected settings at all.
    :vartype protected_settings: dict[str, any]
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :ivar provision_after_extensions: Collection of extension names after which this extension
     needs to be
     provisioned.
    :vartype provision_after_extensions: list[str]
    :ivar suppress_failures: Indicates whether failures stemming from the extension will be
     suppressed
     (Operational failures such as not connecting to the VM will not be suppressed
     regardless of this value). The default is false.
    :vartype suppress_failures: bool
    :ivar protected_settings_from_key_vault: The extensions protected settings that are passed by
     reference, and consumed
     from key vault.
    :vartype protected_settings_from_key_vault:
     ~azure.mgmt.computefleet.models.KeyVaultSecretReference
    """

    force_update_tag: Optional[str] = rest_field(name="forceUpdateTag")
    """If a value is provided and is different from the previous value, the extension
     handler will be forced to update even if the extension configuration has not
     changed."""
    publisher: Optional[str] = rest_field()
    """The name of the extension handler publisher."""
    type: Optional[str] = rest_field()
    """Specifies the type of the extension; an example is \"CustomScriptExtension\"."""
    type_handler_version: Optional[str] = rest_field(name="typeHandlerVersion")
    """Specifies the version of the script handler."""
    auto_upgrade_minor_version: Optional[bool] = rest_field(name="autoUpgradeMinorVersion")
    """Indicates whether the extension should use a newer minor version if one is
     available at deployment time. Once deployed, however, the extension will not
     upgrade minor versions unless redeployed, even with this property set to true."""
    enable_automatic_upgrade: Optional[bool] = rest_field(name="enableAutomaticUpgrade")
    """Indicates whether the extension should be automatically upgraded by the
     platform if there is a newer version of the extension available."""
    settings: Optional[Dict[str, Any]] = rest_field()
    """Json formatted public settings for the extension."""
    protected_settings: Optional[Dict[str, Any]] = rest_field(name="protectedSettings", visibility=["create", "update"])
    """The extension can contain either protectedSettings or
     protectedSettingsFromKeyVault or no protected settings at all."""
    provisioning_state: Optional[str] = rest_field(name="provisioningState", visibility=["read"])
    """The provisioning state, which only appears in the response."""
    provision_after_extensions: Optional[List[str]] = rest_field(name="provisionAfterExtensions")
    """Collection of extension names after which this extension needs to be
     provisioned."""
    suppress_failures: Optional[bool] = rest_field(name="suppressFailures")
    """Indicates whether failures stemming from the extension will be suppressed
     (Operational failures such as not connecting to the VM will not be suppressed
     regardless of this value). The default is false."""
    protected_settings_from_key_vault: Optional["_models.KeyVaultSecretReference"] = rest_field(
        name="protectedSettingsFromKeyVault"
    )
    """The extensions protected settings that are passed by reference, and consumed
     from key vault."""

    @overload
    def __init__(
        self,
        *,
        force_update_tag: Optional[str] = None,
        publisher: Optional[str] = None,
        type: Optional[str] = None,
        type_handler_version: Optional[str] = None,
        auto_upgrade_minor_version: Optional[bool] = None,
        enable_automatic_upgrade: Optional[bool] = None,
        settings: Optional[Dict[str, Any]] = None,
        protected_settings: Optional[Dict[str, Any]] = None,
        provision_after_extensions: Optional[List[str]] = None,
        suppress_failures: Optional[bool] = None,
        protected_settings_from_key_vault: Optional["_models.KeyVaultSecretReference"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class VirtualMachineScaleSetHardwareProfile(_model_base.Model):
    """Specifies the hardware settings for the virtual machine scale set.

    :ivar vm_size_properties: Specifies the properties for customizing the size of the virtual
     machine.
     Minimum api-version: 2021-11-01. Please follow the instructions in `VM
     Customization <https://aka.ms/vmcustomization>`_ for more details.
    :vartype vm_size_properties: ~azure.mgmt.computefleet.models.VMSizeProperties
    """

    vm_size_properties: Optional["_models.VMSizeProperties"] = rest_field(name="vmSizeProperties")
    """Specifies the properties for customizing the size of the virtual machine.
     Minimum api-version: 2021-11-01. Please follow the instructions in `VM
     Customization <https://aka.ms/vmcustomization>`_ for more details."""

    @overload
    def __init__(
        self,
        *,
        vm_size_properties: Optional["_models.VMSizeProperties"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class VirtualMachineScaleSetIPConfiguration(_model_base.Model):
    """Describes a virtual machine scale set network profile's IP configuration.


    :ivar name: The IP configuration name. Required.
    :vartype name: str
    :ivar properties: Describes a virtual machine scale set network profile's IP configuration
     properties.
    :vartype properties:
     ~azure.mgmt.computefleet.models.VirtualMachineScaleSetIPConfigurationProperties
    """

    name: str = rest_field()
    """The IP configuration name. Required."""
    properties: Optional["_models.VirtualMachineScaleSetIPConfigurationProperties"] = rest_field()
    """Describes a virtual machine scale set network profile's IP configuration
     properties."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        properties: Optional["_models.VirtualMachineScaleSetIPConfigurationProperties"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class VirtualMachineScaleSetIPConfigurationProperties(_model_base.Model):  # pylint: disable=name-too-long
    """Describes a virtual machine scale set network profile's IP configuration
    properties.

    :ivar subnet: Specifies the identifier of the subnet.
    :vartype subnet: ~azure.mgmt.computefleet.models.ApiEntityReference
    :ivar primary: Specifies the primary network interface in case the virtual machine has more
     than 1 network interface.
    :vartype primary: bool
    :ivar public_ip_address_configuration: The publicIPAddressConfiguration.
    :vartype public_ip_address_configuration:
     ~azure.mgmt.computefleet.models.VirtualMachineScaleSetPublicIPAddressConfiguration
    :ivar private_ip_address_version: Available from Api-Version 2017-03-30 onwards, it represents
     whether the
     specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4.  Possible
     values are: 'IPv4' and 'IPv6'. Known values are: "IPv4" and "IPv6".
    :vartype private_ip_address_version: str or ~azure.mgmt.computefleet.models.IPVersion
    :ivar application_gateway_backend_address_pools: Specifies an array of references to backend
     address pools of application
     gateways. A scale set can reference backend address pools of multiple
     application gateways. Multiple scale sets cannot use the same application
     gateway.
    :vartype application_gateway_backend_address_pools:
     list[~azure.mgmt.computefleet.models.SubResource]
    :ivar application_security_groups: Specifies an array of references to application security
     group.
    :vartype application_security_groups: list[~azure.mgmt.computefleet.models.SubResource]
    :ivar load_balancer_backend_address_pools: Specifies an array of references to backend address
     pools of load balancers. A
     scale set can reference backend address pools of one public and one internal
     load balancer. Multiple scale sets cannot use the same basic sku load balancer.
    :vartype load_balancer_backend_address_pools: list[~azure.mgmt.computefleet.models.SubResource]
    :ivar load_balancer_inbound_nat_pools: Specifies an array of references to inbound Nat pools of
     the load balancers. A
     scale set can reference inbound nat pools of one public and one internal load
     balancer. Multiple scale sets cannot use the same basic sku load balancer.
    :vartype load_balancer_inbound_nat_pools: list[~azure.mgmt.computefleet.models.SubResource]
    """

    subnet: Optional["_models.ApiEntityReference"] = rest_field()
    """Specifies the identifier of the subnet."""
    primary: Optional[bool] = rest_field()
    """Specifies the primary network interface in case the virtual machine has more
     than 1 network interface."""
    public_ip_address_configuration: Optional["_models.VirtualMachineScaleSetPublicIPAddressConfiguration"] = (
        rest_field(name="publicIPAddressConfiguration")
    )
    """The publicIPAddressConfiguration."""
    private_ip_address_version: Optional[Union[str, "_models.IPVersion"]] = rest_field(name="privateIPAddressVersion")
    """Available from Api-Version 2017-03-30 onwards, it represents whether the
     specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4.  Possible
     values are: 'IPv4' and 'IPv6'. Known values are: \"IPv4\" and \"IPv6\"."""
    application_gateway_backend_address_pools: Optional[List["_models.SubResource"]] = rest_field(
        name="applicationGatewayBackendAddressPools"
    )
    """Specifies an array of references to backend address pools of application
     gateways. A scale set can reference backend address pools of multiple
     application gateways. Multiple scale sets cannot use the same application
     gateway."""
    application_security_groups: Optional[List["_models.SubResource"]] = rest_field(name="applicationSecurityGroups")
    """Specifies an array of references to application security group."""
    load_balancer_backend_address_pools: Optional[List["_models.SubResource"]] = rest_field(
        name="loadBalancerBackendAddressPools"
    )
    """Specifies an array of references to backend address pools of load balancers. A
     scale set can reference backend address pools of one public and one internal
     load balancer. Multiple scale sets cannot use the same basic sku load balancer."""
    load_balancer_inbound_nat_pools: Optional[List["_models.SubResource"]] = rest_field(
        name="loadBalancerInboundNatPools"
    )
    """Specifies an array of references to inbound Nat pools of the load balancers. A
     scale set can reference inbound nat pools of one public and one internal load
     balancer. Multiple scale sets cannot use the same basic sku load balancer."""

    @overload
    def __init__(
        self,
        *,
        subnet: Optional["_models.ApiEntityReference"] = None,
        primary: Optional[bool] = None,
        public_ip_address_configuration: Optional["_models.VirtualMachineScaleSetPublicIPAddressConfiguration"] = None,
        private_ip_address_version: Optional[Union[str, "_models.IPVersion"]] = None,
        application_gateway_backend_address_pools: Optional[List["_models.SubResource"]] = None,
        application_security_groups: Optional[List["_models.SubResource"]] = None,
        load_balancer_backend_address_pools: Optional[List["_models.SubResource"]] = None,
        load_balancer_inbound_nat_pools: Optional[List["_models.SubResource"]] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class VirtualMachineScaleSetIpTag(_model_base.Model):
    """Contains the IP tag associated with the public IP address.

    :ivar ip_tag_type: IP tag type. Example: FirstPartyUsage.
    :vartype ip_tag_type: str
    :ivar tag: IP tag associated with the public IP. Example: SQL, Storage etc.
    :vartype tag: str
    """

    ip_tag_type: Optional[str] = rest_field(name="ipTagType")
    """IP tag type. Example: FirstPartyUsage."""
    tag: Optional[str] = rest_field()
    """IP tag associated with the public IP. Example: SQL, Storage etc."""

    @overload
    def __init__(
        self,
        *,
        ip_tag_type: Optional[str] = None,
        tag: Optional[str] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class VirtualMachineScaleSetManagedDiskParameters(_model_base.Model):  # pylint: disable=name-too-long
    """Describes the parameters of a ScaleSet managed disk.

    :ivar storage_account_type: Specifies the storage account type for the managed disk. NOTE:
     UltraSSD_LRS can
     only be used with data disks, it cannot be used with OS Disk. Known values are:
     "Standard_LRS", "Premium_LRS", "StandardSSD_LRS", "UltraSSD_LRS", "Premium_ZRS",
     "StandardSSD_ZRS", and "PremiumV2_LRS".
    :vartype storage_account_type: str or ~azure.mgmt.computefleet.models.StorageAccountTypes
    :ivar disk_encryption_set: Specifies the customer managed disk encryption set resource id for
     the managed
     disk.
    :vartype disk_encryption_set: ~azure.mgmt.computefleet.models.DiskEncryptionSetParameters
    :ivar security_profile: Specifies the security profile for the managed disk.
    :vartype security_profile: ~azure.mgmt.computefleet.models.VMDiskSecurityProfile
    """

    storage_account_type: Optional[Union[str, "_models.StorageAccountTypes"]] = rest_field(name="storageAccountType")
    """Specifies the storage account type for the managed disk. NOTE: UltraSSD_LRS can
     only be used with data disks, it cannot be used with OS Disk. Known values are:
     \"Standard_LRS\", \"Premium_LRS\", \"StandardSSD_LRS\", \"UltraSSD_LRS\", \"Premium_ZRS\",
     \"StandardSSD_ZRS\", and \"PremiumV2_LRS\"."""
    disk_encryption_set: Optional["_models.DiskEncryptionSetParameters"] = rest_field(name="diskEncryptionSet")
    """Specifies the customer managed disk encryption set resource id for the managed
     disk."""
    security_profile: Optional["_models.VMDiskSecurityProfile"] = rest_field(name="securityProfile")
    """Specifies the security profile for the managed disk."""

    @overload
    def __init__(
        self,
        *,
        storage_account_type: Optional[Union[str, "_models.StorageAccountTypes"]] = None,
        disk_encryption_set: Optional["_models.DiskEncryptionSetParameters"] = None,
        security_profile: Optional["_models.VMDiskSecurityProfile"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class VirtualMachineScaleSetNetworkConfiguration(_model_base.Model):  # pylint: disable=name-too-long
    """Describes a virtual machine scale set network profile's network configurations.


    :ivar name: The network configuration name. Required.
    :vartype name: str
    :ivar properties: Describes a virtual machine scale set network profile's IP configuration.
    :vartype properties:
     ~azure.mgmt.computefleet.models.VirtualMachineScaleSetNetworkConfigurationProperties
    """

    name: str = rest_field()
    """The network configuration name. Required."""
    properties: Optional["_models.VirtualMachineScaleSetNetworkConfigurationProperties"] = rest_field()
    """Describes a virtual machine scale set network profile's IP configuration."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        properties: Optional["_models.VirtualMachineScaleSetNetworkConfigurationProperties"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class VirtualMachineScaleSetNetworkConfigurationDnsSettings(_model_base.Model):  # pylint: disable=name-too-long
    """Describes a virtual machines scale sets network configuration's DNS settings.

    :ivar dns_servers: List of DNS servers IP addresses.
    :vartype dns_servers: list[str]
    """

    dns_servers: Optional[List[str]] = rest_field(name="dnsServers")
    """List of DNS servers IP addresses."""

    @overload
    def __init__(
        self,
        *,
        dns_servers: Optional[List[str]] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class VirtualMachineScaleSetNetworkConfigurationProperties(
    _model_base.Model
):  # pylint: disable=too-many-instance-attributes,name-too-long
    """Describes a virtual machine scale set network profile's IP configuration.


    :ivar primary: Specifies the primary network interface in case the virtual machine has more
     than 1 network interface.
    :vartype primary: bool
    :ivar enable_accelerated_networking: Specifies whether the network interface is accelerated
     networking-enabled.
    :vartype enable_accelerated_networking: bool
    :ivar disable_tcp_state_tracking: Specifies whether the network interface is disabled for tcp
     state tracking.
    :vartype disable_tcp_state_tracking: bool
    :ivar enable_fpga: Specifies whether the network interface is FPGA networking-enabled.
    :vartype enable_fpga: bool
    :ivar network_security_group: The network security group.
    :vartype network_security_group: ~azure.mgmt.computefleet.models.SubResource
    :ivar dns_settings: The dns settings to be applied on the network interfaces.
    :vartype dns_settings:
     ~azure.mgmt.computefleet.models.VirtualMachineScaleSetNetworkConfigurationDnsSettings
    :ivar ip_configurations: Specifies the IP configurations of the network interface. Required.
    :vartype ip_configurations:
     list[~azure.mgmt.computefleet.models.VirtualMachineScaleSetIPConfiguration]
    :ivar enable_ip_forwarding: Whether IP forwarding enabled on this NIC.
    :vartype enable_ip_forwarding: bool
    :ivar delete_option: Specify what happens to the network interface when the VM is deleted.
     Known values are: "Delete" and "Detach".
    :vartype delete_option: str or ~azure.mgmt.computefleet.models.DeleteOptions
    :ivar auxiliary_mode: Specifies whether the Auxiliary mode is enabled for the Network Interface
     resource. Known values are: "None", "AcceleratedConnections", and "Floating".
    :vartype auxiliary_mode: str or ~azure.mgmt.computefleet.models.NetworkInterfaceAuxiliaryMode
    :ivar auxiliary_sku: Specifies whether the Auxiliary sku is enabled for the Network Interface
     resource. Known values are: "None", "A1", "A2", "A4", and "A8".
    :vartype auxiliary_sku: str or ~azure.mgmt.computefleet.models.NetworkInterfaceAuxiliarySku
    """

    primary: Optional[bool] = rest_field()
    """Specifies the primary network interface in case the virtual machine has more
     than 1 network interface."""
    enable_accelerated_networking: Optional[bool] = rest_field(name="enableAcceleratedNetworking")
    """Specifies whether the network interface is accelerated networking-enabled."""
    disable_tcp_state_tracking: Optional[bool] = rest_field(name="disableTcpStateTracking")
    """Specifies whether the network interface is disabled for tcp state tracking."""
    enable_fpga: Optional[bool] = rest_field(name="enableFpga")
    """Specifies whether the network interface is FPGA networking-enabled."""
    network_security_group: Optional["_models.SubResource"] = rest_field(name="networkSecurityGroup")
    """The network security group."""
    dns_settings: Optional["_models.VirtualMachineScaleSetNetworkConfigurationDnsSettings"] = rest_field(
        name="dnsSettings"
    )
    """The dns settings to be applied on the network interfaces."""
    ip_configurations: List["_models.VirtualMachineScaleSetIPConfiguration"] = rest_field(name="ipConfigurations")
    """Specifies the IP configurations of the network interface. Required."""
    enable_ip_forwarding: Optional[bool] = rest_field(name="enableIPForwarding")
    """Whether IP forwarding enabled on this NIC."""
    delete_option: Optional[Union[str, "_models.DeleteOptions"]] = rest_field(name="deleteOption")
    """Specify what happens to the network interface when the VM is deleted. Known values are:
     \"Delete\" and \"Detach\"."""
    auxiliary_mode: Optional[Union[str, "_models.NetworkInterfaceAuxiliaryMode"]] = rest_field(name="auxiliaryMode")
    """Specifies whether the Auxiliary mode is enabled for the Network Interface
     resource. Known values are: \"None\", \"AcceleratedConnections\", and \"Floating\"."""
    auxiliary_sku: Optional[Union[str, "_models.NetworkInterfaceAuxiliarySku"]] = rest_field(name="auxiliarySku")
    """Specifies whether the Auxiliary sku is enabled for the Network Interface
     resource. Known values are: \"None\", \"A1\", \"A2\", \"A4\", and \"A8\"."""

    @overload
    def __init__(
        self,
        *,
        ip_configurations: List["_models.VirtualMachineScaleSetIPConfiguration"],
        primary: Optional[bool] = None,
        enable_accelerated_networking: Optional[bool] = None,
        disable_tcp_state_tracking: Optional[bool] = None,
        enable_fpga: Optional[bool] = None,
        network_security_group: Optional["_models.SubResource"] = None,
        dns_settings: Optional["_models.VirtualMachineScaleSetNetworkConfigurationDnsSettings"] = None,
        enable_ip_forwarding: Optional[bool] = None,
        delete_option: Optional[Union[str, "_models.DeleteOptions"]] = None,
        auxiliary_mode: Optional[Union[str, "_models.NetworkInterfaceAuxiliaryMode"]] = None,
        auxiliary_sku: Optional[Union[str, "_models.NetworkInterfaceAuxiliarySku"]] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class VirtualMachineScaleSetNetworkProfile(_model_base.Model):
    """Describes a virtual machine scale set network profile.

    :ivar health_probe: A reference to a load balancer probe used to determine the health of an
     instance in the virtual machine scale set. The reference will be in the form:
    '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/probes/{probeName}'.  # pylint: disable=line-too-long
    :vartype health_probe: ~azure.mgmt.computefleet.models.ApiEntityReference
    :ivar network_interface_configurations: The list of network configurations.
    :vartype network_interface_configurations:
     list[~azure.mgmt.computefleet.models.VirtualMachineScaleSetNetworkConfiguration]
    :ivar network_api_version: specifies the Microsoft.Network API version used when creating
     networking
     resources in the Network Interface Configurations for Virtual Machine Scale Set
     with orchestration mode 'Flexible'. "2020-11-01"
    :vartype network_api_version: str or ~azure.mgmt.computefleet.models.NetworkApiVersion
    """

    health_probe: Optional["_models.ApiEntityReference"] = rest_field(name="healthProbe")
    """A reference to a load balancer probe used to determine the health of an
     instance in the virtual machine scale set. The reference will be in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/probes/{probeName}'.  # pylint: disable=line-too-long"""
    network_interface_configurations: Optional[List["_models.VirtualMachineScaleSetNetworkConfiguration"]] = rest_field(
        name="networkInterfaceConfigurations"
    )
    """The list of network configurations."""
    network_api_version: Optional[Union[str, "_models.NetworkApiVersion"]] = rest_field(name="networkApiVersion")
    """specifies the Microsoft.Network API version used when creating networking
     resources in the Network Interface Configurations for Virtual Machine Scale Set
     with orchestration mode 'Flexible'. \"2020-11-01\""""

    @overload
    def __init__(
        self,
        *,
        health_probe: Optional["_models.ApiEntityReference"] = None,
        network_interface_configurations: Optional[List["_models.VirtualMachineScaleSetNetworkConfiguration"]] = None,
        network_api_version: Optional[Union[str, "_models.NetworkApiVersion"]] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class VirtualMachineScaleSetOSDisk(_model_base.Model):  # pylint: disable=too-many-instance-attributes
    """Describes a virtual machine scale set operating system disk.


    :ivar name: The disk name.
    :vartype name: str
    :ivar caching: Specifies the caching requirements. Possible values are: **None,**
     **ReadOnly,** **ReadWrite.** The default values are: **None for Standard
     storage. ReadOnly for Premium storage.**. Known values are: "None", "ReadOnly", and
     "ReadWrite".
    :vartype caching: str or ~azure.mgmt.computefleet.models.CachingTypes
    :ivar write_accelerator_enabled: Specifies whether writeAccelerator should be enabled or
     disabled on the disk.
    :vartype write_accelerator_enabled: bool
    :ivar create_option: Specifies how the virtual machines in the scale set should be created. The
     only
     allowed value is: **FromImage.** This value is used when you are using an image
     to create the virtual machine. If you are using a platform image, you also use
     the imageReference element described above. If you are using a marketplace
     image, you  also use the plan element previously described. Required. Known values are:
     "FromImage", "Empty", "Attach", "Copy", and "Restore".
    :vartype create_option: str or ~azure.mgmt.computefleet.models.DiskCreateOptionTypes
    :ivar diff_disk_settings: Specifies the ephemeral disk Settings for the operating system disk
     used by the
     virtual machine scale set.
    :vartype diff_disk_settings: ~azure.mgmt.computefleet.models.DiffDiskSettings
    :ivar disk_size_gb: Specifies the size of an empty data disk in gigabytes. This element can be
     used
     to overwrite the size of the disk in a virtual machine image. The property 'diskSizeGB'
     is the number of bytes x 1024^3 for the disk and the value cannot
     be larger than 1023.
    :vartype disk_size_gb: int
    :ivar os_type: This property allows you to specify the type of the OS that is included in the
     disk if creating a VM from user-image or a specialized VHD. Possible values
     are: **Windows,** **Linux.**. Known values are: "Windows" and "Linux".
    :vartype os_type: str or ~azure.mgmt.computefleet.models.OperatingSystemTypes
    :ivar image: Specifies information about the unmanaged user image to base the scale set on.
    :vartype image: ~azure.mgmt.computefleet.models.VirtualHardDisk
    :ivar vhd_containers: Specifies the container urls that are used to store operating system
     disks for
     the scale set.
    :vartype vhd_containers: list[str]
    :ivar managed_disk: The managed disk parameters.
    :vartype managed_disk:
     ~azure.mgmt.computefleet.models.VirtualMachineScaleSetManagedDiskParameters
    :ivar delete_option: Specifies whether OS Disk should be deleted or detached upon VMSS Flex
     deletion
     (This feature is available for VMSS with Flexible OrchestrationMode only).
     :code:`<br>`:code:`<br>` Possible values: :code:`<br>`:code:`<br>` **Delete** If this value is
     used, the OS
     disk is deleted when VMSS Flex VM is deleted.:code:`<br>`:code:`<br>` **Detach** If this value
     is used, the OS disk is retained after VMSS Flex VM is deleted. :code:`<br>`:code:`<br>` The
     default value is set to **Delete**. For an Ephemeral OS Disk, the default value
     is set to **Delete**. User cannot change the delete option for Ephemeral OS
     Disk. Known values are: "Delete" and "Detach".
    :vartype delete_option: str or ~azure.mgmt.computefleet.models.DiskDeleteOptionTypes
    """

    name: Optional[str] = rest_field()
    """The disk name."""
    caching: Optional[Union[str, "_models.CachingTypes"]] = rest_field()
    """Specifies the caching requirements. Possible values are: **None,**
     **ReadOnly,** **ReadWrite.** The default values are: **None for Standard
     storage. ReadOnly for Premium storage.**. Known values are: \"None\", \"ReadOnly\", and
     \"ReadWrite\"."""
    write_accelerator_enabled: Optional[bool] = rest_field(name="writeAcceleratorEnabled")
    """Specifies whether writeAccelerator should be enabled or disabled on the disk."""
    create_option: Union[str, "_models.DiskCreateOptionTypes"] = rest_field(name="createOption")
    """Specifies how the virtual machines in the scale set should be created. The only
     allowed value is: **FromImage.** This value is used when you are using an image
     to create the virtual machine. If you are using a platform image, you also use
     the imageReference element described above. If you are using a marketplace
     image, you  also use the plan element previously described. Required. Known values are:
     \"FromImage\", \"Empty\", \"Attach\", \"Copy\", and \"Restore\"."""
    diff_disk_settings: Optional["_models.DiffDiskSettings"] = rest_field(name="diffDiskSettings")
    """Specifies the ephemeral disk Settings for the operating system disk used by the
     virtual machine scale set."""
    disk_size_gb: Optional[int] = rest_field(name="diskSizeGB")
    """Specifies the size of an empty data disk in gigabytes. This element can be used
     to overwrite the size of the disk in a virtual machine image. The property 'diskSizeGB'
     is the number of bytes x 1024^3 for the disk and the value cannot
     be larger than 1023."""
    os_type: Optional[Union[str, "_models.OperatingSystemTypes"]] = rest_field(name="osType")
    """This property allows you to specify the type of the OS that is included in the
     disk if creating a VM from user-image or a specialized VHD. Possible values
     are: **Windows,** **Linux.**. Known values are: \"Windows\" and \"Linux\"."""
    image: Optional["_models.VirtualHardDisk"] = rest_field()
    """Specifies information about the unmanaged user image to base the scale set on."""
    vhd_containers: Optional[List[str]] = rest_field(name="vhdContainers")
    """Specifies the container urls that are used to store operating system disks for
     the scale set."""
    managed_disk: Optional["_models.VirtualMachineScaleSetManagedDiskParameters"] = rest_field(name="managedDisk")
    """The managed disk parameters."""
    delete_option: Optional[Union[str, "_models.DiskDeleteOptionTypes"]] = rest_field(name="deleteOption")
    """Specifies whether OS Disk should be deleted or detached upon VMSS Flex deletion
     (This feature is available for VMSS with Flexible OrchestrationMode only).
     :code:`<br>`:code:`<br>` Possible values: :code:`<br>`:code:`<br>` **Delete** If this value is
     used, the OS
     disk is deleted when VMSS Flex VM is deleted.:code:`<br>`:code:`<br>` **Detach** If this value
     is used, the OS disk is retained after VMSS Flex VM is deleted. :code:`<br>`:code:`<br>` The
     default value is set to **Delete**. For an Ephemeral OS Disk, the default value
     is set to **Delete**. User cannot change the delete option for Ephemeral OS
     Disk. Known values are: \"Delete\" and \"Detach\"."""

    @overload
    def __init__(
        self,
        *,
        create_option: Union[str, "_models.DiskCreateOptionTypes"],
        name: Optional[str] = None,
        caching: Optional[Union[str, "_models.CachingTypes"]] = None,
        write_accelerator_enabled: Optional[bool] = None,
        diff_disk_settings: Optional["_models.DiffDiskSettings"] = None,
        disk_size_gb: Optional[int] = None,
        os_type: Optional[Union[str, "_models.OperatingSystemTypes"]] = None,
        image: Optional["_models.VirtualHardDisk"] = None,
        vhd_containers: Optional[List[str]] = None,
        managed_disk: Optional["_models.VirtualMachineScaleSetManagedDiskParameters"] = None,
        delete_option: Optional[Union[str, "_models.DiskDeleteOptionTypes"]] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class VirtualMachineScaleSetOSProfile(_model_base.Model):
    """Describes a virtual machine scale set OS profile.

    :ivar computer_name_prefix: Specifies the computer name prefix for all of the virtual machines
     in the scale
     set. Computer name prefixes must be 1 to 15 characters long.
    :vartype computer_name_prefix: str
    :ivar admin_username: Specifies the name of the administrator account. :code:`<br>`:code:`<br>`
     **Windows-only
     restriction:** Cannot end in "." :code:`<br>`:code:`<br>` **Disallowed values:**
     "administrator", "admin", "user", "user1", "test", "user2", "test1", "user3",
     "admin1", "1", "123", "a", "actuser", "adm", "admin2", "aspnet", "backup",
     "console", "david", "guest", "john", "owner", "root", "server", "sql",
     "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5".
     :code:`<br>`:code:`<br>` **Minimum-length (Linux):** 1  character :code:`<br>`:code:`<br>`
     **Max-length
     (Linux):** 64 characters :code:`<br>`:code:`<br>` **Max-length (Windows):** 20 characters.
    :vartype admin_username: str
    :ivar admin_password: Specifies the password of the administrator account.
     :code:`<br>`:code:`<br>` **Minimum-length
     (Windows):** 8 characters :code:`<br>`:code:`<br>` **Minimum-length (Linux):** 6 characters
     :code:`<br>`:code:`<br>` **Max-length (Windows):** 123 characters :code:`<br>`:code:`<br>`
     **Max-length
     (Linux):** 72 characters :code:`<br>`:code:`<br>` **Complexity requirements:** 3 out of 4
     conditions below need to be fulfilled :code:`<br>` Has lower characters :code:`<br>`Has upper
     characters :code:`<br>` Has a digit :code:`<br>` Has a special character (Regex match [\\W_])
     :code:`<br>`:code:`<br>` **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd",
     "P@ssword123", "Pa$$word", "pass@word1", "Password!", "Password1",
     "Password22", "iloveyou!" :code:`<br>`:code:`<br>` For resetting the password, see `How to
     reset the Remote Desktop service or its login password in a Windows
     VM <https://docs.microsoft.com/troubleshoot/azure/virtual-machines/reset-rdp>`_
     :code:`<br>`:code:`<br>` For resetting root password, see `Manage users, SSH, and check or
     repair disks on Azure Linux VMs using the VMAccess
     Extension
     <https://docs.microsoft.com/troubleshoot/azure/virtual-machines/troubleshoot-ssh-connection>`_.
    :vartype admin_password: str
    :ivar custom_data: Specifies a base-64 encoded string of custom data. The base-64 encoded
     string
     is decoded to a binary array that is saved as a file on the Virtual Machine.
     The maximum length of the binary array is 65535 bytes. For using cloud-init for
     your VM, see `Using cloud-init to customize a Linux VM during
     creation <https://docs.microsoft.com/azure/virtual-machines/linux/using-cloud-init>`_.
    :vartype custom_data: str
    :ivar windows_configuration: Specifies Windows operating system settings on the virtual
     machine.
    :vartype windows_configuration: ~azure.mgmt.computefleet.models.WindowsConfiguration
    :ivar linux_configuration: Specifies the Linux operating system settings on the virtual
     machine. For a
     list of supported Linux distributions, see `Linux on Azure-Endorsed
     Distributions <https://docs.microsoft.com/azure/virtual-machines/linux/endorsed-distros>`_.
    :vartype linux_configuration: ~azure.mgmt.computefleet.models.LinuxConfiguration
    :ivar secrets: Specifies set of certificates that should be installed onto the virtual
     machines in the scale set. To install certificates on a virtual machine it is
     recommended to use the `Azure Key Vault virtual machine extension for
     Linux <https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-linux>`_
     or the `Azure Key Vault virtual machine extension for
     Windows <https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-windows>`_.
    :vartype secrets: list[~azure.mgmt.computefleet.models.VaultSecretGroup]
    :ivar allow_extension_operations: Specifies whether extension operations should be allowed on
     the virtual machine
     scale set. This may only be set to False when no extensions are present on the
     virtual machine scale set.
    :vartype allow_extension_operations: bool
    :ivar require_guest_provision_signal: Optional property which must either be set to True or
     omitted.
    :vartype require_guest_provision_signal: bool
    """

    computer_name_prefix: Optional[str] = rest_field(name="computerNamePrefix")
    """Specifies the computer name prefix for all of the virtual machines in the scale
     set. Computer name prefixes must be 1 to 15 characters long."""
    admin_username: Optional[str] = rest_field(name="adminUsername")
    """Specifies the name of the administrator account. :code:`<br>`:code:`<br>` **Windows-only
     restriction:** Cannot end in \".\" :code:`<br>`:code:`<br>` **Disallowed values:**
     \"administrator\", \"admin\", \"user\", \"user1\", \"test\", \"user2\", \"test1\", \"user3\",
     \"admin1\", \"1\", \"123\", \"a\", \"actuser\", \"adm\", \"admin2\", \"aspnet\", \"backup\",
     \"console\", \"david\", \"guest\", \"john\", \"owner\", \"root\", \"server\", \"sql\",
     \"support\", \"support_388945a0\", \"sys\", \"test2\", \"test3\", \"user4\", \"user5\".
     :code:`<br>`:code:`<br>` **Minimum-length (Linux):** 1  character :code:`<br>`:code:`<br>`
     **Max-length
     (Linux):** 64 characters :code:`<br>`:code:`<br>` **Max-length (Windows):** 20 characters."""
    admin_password: Optional[str] = rest_field(name="adminPassword", visibility=["create", "update"])
    """Specifies the password of the administrator account. :code:`<br>`:code:`<br>` **Minimum-length
     (Windows):** 8 characters :code:`<br>`:code:`<br>` **Minimum-length (Linux):** 6 characters
     :code:`<br>`:code:`<br>` **Max-length (Windows):** 123 characters :code:`<br>`:code:`<br>`
     **Max-length
     (Linux):** 72 characters :code:`<br>`:code:`<br>` **Complexity requirements:** 3 out of 4
     conditions below need to be fulfilled :code:`<br>` Has lower characters :code:`<br>`Has upper
     characters :code:`<br>` Has a digit :code:`<br>` Has a special character (Regex match [\W_])
     :code:`<br>`:code:`<br>` **Disallowed values:** \"abc@123\", \"P@$$w0rd\", \"P@ssw0rd\",
     \"P@ssword123\", \"Pa$$word\", \"pass@word1\", \"Password!\", \"Password1\",
     \"Password22\", \"iloveyou!\" :code:`<br>`:code:`<br>` For resetting the password, see `How to
     reset the Remote Desktop service or its login password in a Windows
     VM <https://docs.microsoft.com/troubleshoot/azure/virtual-machines/reset-rdp>`_
     :code:`<br>`:code:`<br>` For resetting root password, see `Manage users, SSH, and check or
     repair disks on Azure Linux VMs using the VMAccess
     Extension
     <https://docs.microsoft.com/troubleshoot/azure/virtual-machines/troubleshoot-ssh-connection>`_."""
    custom_data: Optional[str] = rest_field(name="customData", visibility=["create", "update"])
    """Specifies a base-64 encoded string of custom data. The base-64 encoded string
     is decoded to a binary array that is saved as a file on the Virtual Machine.
     The maximum length of the binary array is 65535 bytes. For using cloud-init for
     your VM, see `Using cloud-init to customize a Linux VM during
     creation <https://docs.microsoft.com/azure/virtual-machines/linux/using-cloud-init>`_."""
    windows_configuration: Optional["_models.WindowsConfiguration"] = rest_field(name="windowsConfiguration")
    """Specifies Windows operating system settings on the virtual machine."""
    linux_configuration: Optional["_models.LinuxConfiguration"] = rest_field(name="linuxConfiguration")
    """Specifies the Linux operating system settings on the virtual machine. For a
     list of supported Linux distributions, see `Linux on Azure-Endorsed
     Distributions <https://docs.microsoft.com/azure/virtual-machines/linux/endorsed-distros>`_."""
    secrets: Optional[List["_models.VaultSecretGroup"]] = rest_field()
    """Specifies set of certificates that should be installed onto the virtual
     machines in the scale set. To install certificates on a virtual machine it is
     recommended to use the `Azure Key Vault virtual machine extension for
     Linux <https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-linux>`_
     or the `Azure Key Vault virtual machine extension for
     Windows <https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-windows>`_."""
    allow_extension_operations: Optional[bool] = rest_field(name="allowExtensionOperations")
    """Specifies whether extension operations should be allowed on the virtual machine
     scale set. This may only be set to False when no extensions are present on the
     virtual machine scale set."""
    require_guest_provision_signal: Optional[bool] = rest_field(name="requireGuestProvisionSignal")
    """Optional property which must either be set to True or omitted."""

    @overload
    def __init__(
        self,
        *,
        computer_name_prefix: Optional[str] = None,
        admin_username: Optional[str] = None,
        admin_password: Optional[str] = None,
        custom_data: Optional[str] = None,
        windows_configuration: Optional["_models.WindowsConfiguration"] = None,
        linux_configuration: Optional["_models.LinuxConfiguration"] = None,
        secrets: Optional[List["_models.VaultSecretGroup"]] = None,
        allow_extension_operations: Optional[bool] = None,
        require_guest_provision_signal: Optional[bool] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class VirtualMachineScaleSetPublicIPAddressConfiguration(_model_base.Model):  # pylint: disable=name-too-long
    """Describes a virtual machines scale set IP Configuration's PublicIPAddress
    configuration.


    :ivar name: The publicIP address configuration name. Required.
    :vartype name: str
    :ivar properties: Describes a virtual machines scale set IP Configuration's PublicIPAddress
     configuration.
    :vartype properties:
     ~azure.mgmt.computefleet.models.VirtualMachineScaleSetPublicIPAddressConfigurationProperties
    :ivar sku: Describes the public IP Sku. It can only be set with OrchestrationMode as
     Flexible.
    :vartype sku: ~azure.mgmt.computefleet.models.PublicIPAddressSku
    """

    name: str = rest_field()
    """The publicIP address configuration name. Required."""
    properties: Optional["_models.VirtualMachineScaleSetPublicIPAddressConfigurationProperties"] = rest_field()
    """Describes a virtual machines scale set IP Configuration's PublicIPAddress
     configuration."""
    sku: Optional["_models.PublicIPAddressSku"] = rest_field()
    """Describes the public IP Sku. It can only be set with OrchestrationMode as
     Flexible."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        properties: Optional["_models.VirtualMachineScaleSetPublicIPAddressConfigurationProperties"] = None,
        sku: Optional["_models.PublicIPAddressSku"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettings(_model_base.Model):  # pylint: disable=name-too-long
    """Describes a virtual machines scale sets network configuration's DNS settings.


    :ivar domain_name_label: The Domain name label.The concatenation of the domain name label and
     vm index
     will be the domain name labels of the PublicIPAddress resources that will be
     created. Required.
    :vartype domain_name_label: str
    :ivar domain_name_label_scope: The Domain name label scope.The concatenation of the hashed
     domain name label
     that generated according to the policy from domain name label scope and vm
     index will be the domain name labels of the PublicIPAddress resources that will
     be created. Known values are: "TenantReuse", "SubscriptionReuse", "ResourceGroupReuse", and
     "NoReuse".
    :vartype domain_name_label_scope: str or
     ~azure.mgmt.computefleet.models.DomainNameLabelScopeTypes
    """

    domain_name_label: str = rest_field(name="domainNameLabel")
    """The Domain name label.The concatenation of the domain name label and vm index
     will be the domain name labels of the PublicIPAddress resources that will be
     created. Required."""
    domain_name_label_scope: Optional[Union[str, "_models.DomainNameLabelScopeTypes"]] = rest_field(
        name="domainNameLabelScope"
    )
    """The Domain name label scope.The concatenation of the hashed domain name label
     that generated according to the policy from domain name label scope and vm
     index will be the domain name labels of the PublicIPAddress resources that will
     be created. Known values are: \"TenantReuse\", \"SubscriptionReuse\", \"ResourceGroupReuse\",
     and \"NoReuse\"."""

    @overload
    def __init__(
        self,
        *,
        domain_name_label: str,
        domain_name_label_scope: Optional[Union[str, "_models.DomainNameLabelScopeTypes"]] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class VirtualMachineScaleSetPublicIPAddressConfigurationProperties(_model_base.Model):  # pylint: disable=name-too-long
    """Describes a virtual machines scale set IP Configuration's PublicIPAddress
    configuration.

    :ivar idle_timeout_in_minutes: The idle timeout of the public IP address.
    :vartype idle_timeout_in_minutes: int
    :ivar dns_settings: The dns settings to be applied on the publicIP addresses .
    :vartype dns_settings:
     ~azure.mgmt.computefleet.models.VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettings
    :ivar ip_tags: The list of IP tags associated with the public IP address.
    :vartype ip_tags: list[~azure.mgmt.computefleet.models.VirtualMachineScaleSetIpTag]
    :ivar public_ip_prefix: The PublicIPPrefix from which to allocate publicIP addresses.
    :vartype public_ip_prefix: ~azure.mgmt.computefleet.models.SubResource
    :ivar public_ip_address_version: Available from Api-Version 2019-07-01 onwards, it represents
     whether the
     specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4. Possible
     values are: 'IPv4' and 'IPv6'. Known values are: "IPv4" and "IPv6".
    :vartype public_ip_address_version: str or ~azure.mgmt.computefleet.models.IPVersion
    :ivar delete_option: Specify what happens to the public IP when the VM is deleted. Known values
     are: "Delete" and "Detach".
    :vartype delete_option: str or ~azure.mgmt.computefleet.models.DeleteOptions
    """

    idle_timeout_in_minutes: Optional[int] = rest_field(name="idleTimeoutInMinutes")
    """The idle timeout of the public IP address."""
    dns_settings: Optional["_models.VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettings"] = rest_field(
        name="dnsSettings"
    )
    """The dns settings to be applied on the publicIP addresses ."""
    ip_tags: Optional[List["_models.VirtualMachineScaleSetIpTag"]] = rest_field(name="ipTags")
    """The list of IP tags associated with the public IP address."""
    public_ip_prefix: Optional["_models.SubResource"] = rest_field(name="publicIPPrefix")
    """The PublicIPPrefix from which to allocate publicIP addresses."""
    public_ip_address_version: Optional[Union[str, "_models.IPVersion"]] = rest_field(name="publicIPAddressVersion")
    """Available from Api-Version 2019-07-01 onwards, it represents whether the
     specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4. Possible
     values are: 'IPv4' and 'IPv6'. Known values are: \"IPv4\" and \"IPv6\"."""
    delete_option: Optional[Union[str, "_models.DeleteOptions"]] = rest_field(name="deleteOption")
    """Specify what happens to the public IP when the VM is deleted. Known values are: \"Delete\" and
     \"Detach\"."""

    @overload
    def __init__(
        self,
        *,
        idle_timeout_in_minutes: Optional[int] = None,
        dns_settings: Optional["_models.VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettings"] = None,
        ip_tags: Optional[List["_models.VirtualMachineScaleSetIpTag"]] = None,
        public_ip_prefix: Optional["_models.SubResource"] = None,
        public_ip_address_version: Optional[Union[str, "_models.IPVersion"]] = None,
        delete_option: Optional[Union[str, "_models.DeleteOptions"]] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class VirtualMachineScaleSetStorageProfile(_model_base.Model):
    """Describes a virtual machine scale set storage profile.

    :ivar image_reference: Specifies information about the image to use. You can specify
     information about
     platform images, marketplace images, or virtual machine images. This element is
     required when you want to use a platform image, marketplace image, or virtual
     machine image, but is not used in other creation operations.
    :vartype image_reference: ~azure.mgmt.computefleet.models.ImageReference
    :ivar os_disk: Specifies information about the operating system disk used by the virtual
     machines in the scale set. For more information about disks, see `About disks
     and VHDs for Azure virtual
     machines <https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview>`_.
    :vartype os_disk: ~azure.mgmt.computefleet.models.VirtualMachineScaleSetOSDisk
    :ivar data_disks: Specifies the parameters that are used to add data disks to the virtual
     machines in the scale set. For more information about disks, see `About disks
     and VHDs for Azure virtual
     machines <https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview>`_.
    :vartype data_disks: list[~azure.mgmt.computefleet.models.VirtualMachineScaleSetDataDisk]
    :ivar disk_controller_type: Specifies the disk controller type configured for the virtual
     machines in the scale set. Minimum api-version: 2022-08-01. Known values are: "SCSI" and
     "NVMe".
    :vartype disk_controller_type: str or ~azure.mgmt.computefleet.models.DiskControllerTypes
    """

    image_reference: Optional["_models.ImageReference"] = rest_field(name="imageReference")
    """Specifies information about the image to use. You can specify information about
     platform images, marketplace images, or virtual machine images. This element is
     required when you want to use a platform image, marketplace image, or virtual
     machine image, but is not used in other creation operations."""
    os_disk: Optional["_models.VirtualMachineScaleSetOSDisk"] = rest_field(name="osDisk")
    """Specifies information about the operating system disk used by the virtual
     machines in the scale set. For more information about disks, see `About disks
     and VHDs for Azure virtual
     machines <https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview>`_."""
    data_disks: Optional[List["_models.VirtualMachineScaleSetDataDisk"]] = rest_field(name="dataDisks")
    """Specifies the parameters that are used to add data disks to the virtual
     machines in the scale set. For more information about disks, see `About disks
     and VHDs for Azure virtual
     machines <https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview>`_."""
    disk_controller_type: Optional[Union[str, "_models.DiskControllerTypes"]] = rest_field(name="diskControllerType")
    """Specifies the disk controller type configured for the virtual machines in the scale set.
     Minimum api-version: 2022-08-01. Known values are: \"SCSI\" and \"NVMe\"."""

    @overload
    def __init__(
        self,
        *,
        image_reference: Optional["_models.ImageReference"] = None,
        os_disk: Optional["_models.VirtualMachineScaleSetOSDisk"] = None,
        data_disks: Optional[List["_models.VirtualMachineScaleSetDataDisk"]] = None,
        disk_controller_type: Optional[Union[str, "_models.DiskControllerTypes"]] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class VMAttributeMinMaxDouble(_model_base.Model):
    """VMAttributes using double values.

    :ivar min: Minimum value. default 0. Double.MinValue().
    :vartype min: float
    :ivar max: Maximum value. Double.MaxValue(1.7976931348623157E+308).
    :vartype max: float
    """

    min: Optional[float] = rest_field()
    """Minimum value. default 0. Double.MinValue()."""
    max: Optional[float] = rest_field()
    """Maximum value. Double.MaxValue(1.7976931348623157E+308)."""

    @overload
    def __init__(
        self,
        *,
        min: Optional[float] = None,  # pylint: disable=redefined-builtin
        max: Optional[float] = None,  # pylint: disable=redefined-builtin
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class VMAttributeMinMaxInteger(_model_base.Model):
    """While retrieving VMSizes from CRS, Min = 0 (uint.MinValue) if not specified, Max = 4294967295
    (uint.MaxValue) if not specified. This allows to filter VMAttributes on all available VMSizes.

    :ivar min: Min VMSize from CRS, Min = 0 (uint.MinValue) if not specified.
    :vartype min: int
    :ivar max: Max VMSize from CRS, Max = 4294967295 (uint.MaxValue) if not specified.
    :vartype max: int
    """

    min: Optional[int] = rest_field()
    """Min VMSize from CRS, Min = 0 (uint.MinValue) if not specified."""
    max: Optional[int] = rest_field()
    """Max VMSize from CRS, Max = 4294967295 (uint.MaxValue) if not specified."""

    @overload
    def __init__(
        self,
        *,
        min: Optional[int] = None,  # pylint: disable=redefined-builtin
        max: Optional[int] = None,  # pylint: disable=redefined-builtin
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class VMAttributes(_model_base.Model):  # pylint: disable=too-many-instance-attributes
    """VMAttributes that will be used to filter VMSizes which will be used to build Fleet.


    :ivar v_cpu_count: The range of vCpuCount specified from Min to Max. Must be specified if
     VMAttributes are specified, either Min or Max is required if specified. Required.
    :vartype v_cpu_count: ~azure.mgmt.computefleet.models.VMAttributeMinMaxInteger
    :ivar memory_in_gi_b: The range of memory specified from Min to Max. Must be specified if
     VMAttributes are specified, either Min or Max is required if specified. Required.
    :vartype memory_in_gi_b: ~azure.mgmt.computefleet.models.VMAttributeMinMaxDouble
    :ivar memory_in_gi_b_per_v_cpu: The range of memory in GiB per vCPU specified from min to max.
     Optional parameter. Either Min or Max is required if specified.
    :vartype memory_in_gi_b_per_v_cpu: ~azure.mgmt.computefleet.models.VMAttributeMinMaxDouble
    :ivar local_storage_support: Specifies whether the VMSize supporting local storage should be
     used to build Fleet or not. Known values are: "Excluded", "Included", and "Required".
    :vartype local_storage_support: str or ~azure.mgmt.computefleet.models.VMAttributeSupport
    :ivar local_storage_in_gi_b: LocalStorageSupport should be set to "Included" or "Required" to
     use this VMAttribute.
     If localStorageSupport is "Excluded", this VMAttribute can not be used.
    :vartype local_storage_in_gi_b: ~azure.mgmt.computefleet.models.VMAttributeMinMaxDouble
    :ivar local_storage_disk_types: The local storage disk types specified as a list.
     LocalStorageSupport should be set to "Included" or "Required" to use this VMAttribute.
     If localStorageSupport is "Excluded", this VMAttribute can not be used.
    :vartype local_storage_disk_types: list[str or
     ~azure.mgmt.computefleet.models.LocalStorageDiskType]
    :ivar data_disk_count: The range of data disk count specified from Min to Max. Optional
     parameter. Either Min or Max is required if specified.
    :vartype data_disk_count: ~azure.mgmt.computefleet.models.VMAttributeMinMaxInteger
    :ivar network_interface_count: The range of network interface count specified from Min to Max.
     Optional parameter. Either Min or Max is required if specified.
    :vartype network_interface_count: ~azure.mgmt.computefleet.models.VMAttributeMinMaxInteger
    :ivar network_bandwidth_in_mbps: The range of network bandwidth in Mbps specified from Min to
     Max. Optional parameter. Either Min or Max is required if specified.
    :vartype network_bandwidth_in_mbps: ~azure.mgmt.computefleet.models.VMAttributeMinMaxDouble
    :ivar rdma_support: Specifies whether the VMSize supporting RDMA (Remote Direct Memory Access)
     should be used to build Fleet or not. Known values are: "Excluded", "Included", and "Required".
    :vartype rdma_support: str or ~azure.mgmt.computefleet.models.VMAttributeSupport
    :ivar rdma_network_interface_count: The range of RDMA (Remote Direct Memory Access) network
     interface count specified from Min to Max. Optional parameter. Either Min or Max is required if
     specified.
     rdmaSupport should be set to "Included" or "Required" to use this VMAttribute.
     If rdmaSupport is "Excluded", this VMAttribute can not be used.
    :vartype rdma_network_interface_count: ~azure.mgmt.computefleet.models.VMAttributeMinMaxInteger
    :ivar accelerator_support: Specifies whether the VMSize supporting accelerator should be used
     to build Fleet or not.
     acceleratorSupport should be set to "Included" or "Required" to use this VMAttribute.
     If acceleratorSupport is "Excluded", this VMAttribute can not be used. Known values are:
     "Excluded", "Included", and "Required".
    :vartype accelerator_support: str or ~azure.mgmt.computefleet.models.VMAttributeSupport
    :ivar accelerator_manufacturers: The accelerator manufacturers specified as a list.
     acceleratorSupport should be set to "Included" or "Required" to use this VMAttribute.
     If acceleratorSupport is "Excluded", this VMAttribute can not be used.
    :vartype accelerator_manufacturers: list[str or
     ~azure.mgmt.computefleet.models.AcceleratorManufacturer]
    :ivar accelerator_types: The accelerator types specified as a list. acceleratorSupport should
     be set to "Included" or "Required" to use this VMAttribute.
     If acceleratorSupport is "Excluded", this VMAttribute can not be used.
    :vartype accelerator_types: list[str or ~azure.mgmt.computefleet.models.AcceleratorType]
    :ivar accelerator_count: The range of accelerator count specified from min to max. Optional
     parameter. Either Min or Max is required if specified.
     acceleratorSupport should be set to "Included" or "Required" to use this VMAttribute.
     If acceleratorSupport is "Excluded", this VMAttribute can not be used.
    :vartype accelerator_count: ~azure.mgmt.computefleet.models.VMAttributeMinMaxInteger
    :ivar vm_categories: The VM category specified as a list. Optional parameter.
    :vartype vm_categories: list[str or ~azure.mgmt.computefleet.models.VMCategory]
    :ivar architecture_types: The VM architecture types specified as a list. Optional parameter.
    :vartype architecture_types: list[str or ~azure.mgmt.computefleet.models.ArchitectureType]
    :ivar cpu_manufacturers: The VM CPU manufacturers specified as a list. Optional parameter.
    :vartype cpu_manufacturers: list[str or ~azure.mgmt.computefleet.models.CpuManufacturer]
    :ivar burstable_support: Specifies whether the VMSize supporting burstable capability should be
     used to build Fleet or not. Known values are: "Excluded", "Included", and "Required".
    :vartype burstable_support: str or ~azure.mgmt.computefleet.models.VMAttributeSupport
    :ivar excluded_vm_sizes: Specifies which VMSizes should be excluded while building Fleet.
     Optional parameter.
    :vartype excluded_vm_sizes: list[str]
    """

    v_cpu_count: "_models.VMAttributeMinMaxInteger" = rest_field(name="vCpuCount")
    """The range of vCpuCount specified from Min to Max. Must be specified if VMAttributes are
     specified, either Min or Max is required if specified. Required."""
    memory_in_gi_b: "_models.VMAttributeMinMaxDouble" = rest_field(name="memoryInGiB")
    """The range of memory specified from Min to Max. Must be specified if VMAttributes are specified,
     either Min or Max is required if specified. Required."""
    memory_in_gi_b_per_v_cpu: Optional["_models.VMAttributeMinMaxDouble"] = rest_field(name="memoryInGiBPerVCpu")
    """The range of memory in GiB per vCPU specified from min to max. Optional parameter. Either Min
     or Max is required if specified."""
    local_storage_support: Optional[Union[str, "_models.VMAttributeSupport"]] = rest_field(name="localStorageSupport")
    """Specifies whether the VMSize supporting local storage should be used to build Fleet or not.
     Known values are: \"Excluded\", \"Included\", and \"Required\"."""
    local_storage_in_gi_b: Optional["_models.VMAttributeMinMaxDouble"] = rest_field(name="localStorageInGiB")
    """LocalStorageSupport should be set to \"Included\" or \"Required\" to use this VMAttribute.
     If localStorageSupport is \"Excluded\", this VMAttribute can not be used."""
    local_storage_disk_types: Optional[List[Union[str, "_models.LocalStorageDiskType"]]] = rest_field(
        name="localStorageDiskTypes"
    )
    """The local storage disk types specified as a list. LocalStorageSupport should be set to
     \"Included\" or \"Required\" to use this VMAttribute.
     If localStorageSupport is \"Excluded\", this VMAttribute can not be used."""
    data_disk_count: Optional["_models.VMAttributeMinMaxInteger"] = rest_field(name="dataDiskCount")
    """The range of data disk count specified from Min to Max. Optional parameter. Either Min or Max
     is required if specified."""
    network_interface_count: Optional["_models.VMAttributeMinMaxInteger"] = rest_field(name="networkInterfaceCount")
    """The range of network interface count specified from Min to Max. Optional parameter. Either Min
     or Max is required if specified."""
    network_bandwidth_in_mbps: Optional["_models.VMAttributeMinMaxDouble"] = rest_field(name="networkBandwidthInMbps")
    """The range of network bandwidth in Mbps specified from Min to Max. Optional parameter. Either
     Min or Max is required if specified."""
    rdma_support: Optional[Union[str, "_models.VMAttributeSupport"]] = rest_field(name="rdmaSupport")
    """Specifies whether the VMSize supporting RDMA (Remote Direct Memory Access) should be used to
     build Fleet or not. Known values are: \"Excluded\", \"Included\", and \"Required\"."""
    rdma_network_interface_count: Optional["_models.VMAttributeMinMaxInteger"] = rest_field(
        name="rdmaNetworkInterfaceCount"
    )
    """The range of RDMA (Remote Direct Memory Access) network interface count specified from Min to
     Max. Optional parameter. Either Min or Max is required if specified.
     rdmaSupport should be set to \"Included\" or \"Required\" to use this VMAttribute.
     If rdmaSupport is \"Excluded\", this VMAttribute can not be used."""
    accelerator_support: Optional[Union[str, "_models.VMAttributeSupport"]] = rest_field(name="acceleratorSupport")
    """Specifies whether the VMSize supporting accelerator should be used to build Fleet or not.
     acceleratorSupport should be set to \"Included\" or \"Required\" to use this VMAttribute.
     If acceleratorSupport is \"Excluded\", this VMAttribute can not be used. Known values are:
     \"Excluded\", \"Included\", and \"Required\"."""
    accelerator_manufacturers: Optional[List[Union[str, "_models.AcceleratorManufacturer"]]] = rest_field(
        name="acceleratorManufacturers"
    )
    """The accelerator manufacturers specified as a list.
     acceleratorSupport should be set to \"Included\" or \"Required\" to use this VMAttribute.
     If acceleratorSupport is \"Excluded\", this VMAttribute can not be used."""
    accelerator_types: Optional[List[Union[str, "_models.AcceleratorType"]]] = rest_field(name="acceleratorTypes")
    """The accelerator types specified as a list. acceleratorSupport should be set to \"Included\" or
     \"Required\" to use this VMAttribute.
     If acceleratorSupport is \"Excluded\", this VMAttribute can not be used."""
    accelerator_count: Optional["_models.VMAttributeMinMaxInteger"] = rest_field(name="acceleratorCount")
    """The range of accelerator count specified from min to max. Optional parameter. Either Min or Max
     is required if specified.
     acceleratorSupport should be set to \"Included\" or \"Required\" to use this VMAttribute.
     If acceleratorSupport is \"Excluded\", this VMAttribute can not be used."""
    vm_categories: Optional[List[Union[str, "_models.VMCategory"]]] = rest_field(name="vmCategories")
    """The VM category specified as a list. Optional parameter."""
    architecture_types: Optional[List[Union[str, "_models.ArchitectureType"]]] = rest_field(name="architectureTypes")
    """The VM architecture types specified as a list. Optional parameter."""
    cpu_manufacturers: Optional[List[Union[str, "_models.CpuManufacturer"]]] = rest_field(name="cpuManufacturers")
    """The VM CPU manufacturers specified as a list. Optional parameter."""
    burstable_support: Optional[Union[str, "_models.VMAttributeSupport"]] = rest_field(name="burstableSupport")
    """Specifies whether the VMSize supporting burstable capability should be used to build Fleet or
     not. Known values are: \"Excluded\", \"Included\", and \"Required\"."""
    excluded_vm_sizes: Optional[List[str]] = rest_field(name="excludedVMSizes")
    """Specifies which VMSizes should be excluded while building Fleet. Optional parameter."""

    @overload
    def __init__(
        self,
        *,
        v_cpu_count: "_models.VMAttributeMinMaxInteger",
        memory_in_gi_b: "_models.VMAttributeMinMaxDouble",
        memory_in_gi_b_per_v_cpu: Optional["_models.VMAttributeMinMaxDouble"] = None,
        local_storage_support: Optional[Union[str, "_models.VMAttributeSupport"]] = None,
        local_storage_in_gi_b: Optional["_models.VMAttributeMinMaxDouble"] = None,
        local_storage_disk_types: Optional[List[Union[str, "_models.LocalStorageDiskType"]]] = None,
        data_disk_count: Optional["_models.VMAttributeMinMaxInteger"] = None,
        network_interface_count: Optional["_models.VMAttributeMinMaxInteger"] = None,
        network_bandwidth_in_mbps: Optional["_models.VMAttributeMinMaxDouble"] = None,
        rdma_support: Optional[Union[str, "_models.VMAttributeSupport"]] = None,
        rdma_network_interface_count: Optional["_models.VMAttributeMinMaxInteger"] = None,
        accelerator_support: Optional[Union[str, "_models.VMAttributeSupport"]] = None,
        accelerator_manufacturers: Optional[List[Union[str, "_models.AcceleratorManufacturer"]]] = None,
        accelerator_types: Optional[List[Union[str, "_models.AcceleratorType"]]] = None,
        accelerator_count: Optional["_models.VMAttributeMinMaxInteger"] = None,
        vm_categories: Optional[List[Union[str, "_models.VMCategory"]]] = None,
        architecture_types: Optional[List[Union[str, "_models.ArchitectureType"]]] = None,
        cpu_manufacturers: Optional[List[Union[str, "_models.CpuManufacturer"]]] = None,
        burstable_support: Optional[Union[str, "_models.VMAttributeSupport"]] = None,
        excluded_vm_sizes: Optional[List[str]] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class VMDiskSecurityProfile(_model_base.Model):
    """Specifies the security profile settings for the managed disk. **Note:** It can
    only be set for Confidential VMs.

    :ivar security_encryption_type: Specifies the EncryptionType of the managed disk. It is set to
     DiskWithVMGuestState for encryption of the managed disk along with VMGuestState
     blob, VMGuestStateOnly for encryption of just the VMGuestState blob, and
     NonPersistedTPM for not persisting firmware state in the VMGuestState blob..
     **Note:** It can be set for only Confidential VMs. Known values are: "VMGuestStateOnly",
     "DiskWithVMGuestState", and "NonPersistedTPM".
    :vartype security_encryption_type: str or
     ~azure.mgmt.computefleet.models.SecurityEncryptionTypes
    :ivar disk_encryption_set: Specifies the customer managed disk encryption set resource id for
     the managed
     disk that is used for Customer Managed Key encrypted ConfidentialVM OS Disk and
     VMGuest blob.
    :vartype disk_encryption_set: ~azure.mgmt.computefleet.models.DiskEncryptionSetParameters
    """

    security_encryption_type: Optional[Union[str, "_models.SecurityEncryptionTypes"]] = rest_field(
        name="securityEncryptionType"
    )
    """Specifies the EncryptionType of the managed disk. It is set to
     DiskWithVMGuestState for encryption of the managed disk along with VMGuestState
     blob, VMGuestStateOnly for encryption of just the VMGuestState blob, and
     NonPersistedTPM for not persisting firmware state in the VMGuestState blob..
     **Note:** It can be set for only Confidential VMs. Known values are: \"VMGuestStateOnly\",
     \"DiskWithVMGuestState\", and \"NonPersistedTPM\"."""
    disk_encryption_set: Optional["_models.DiskEncryptionSetParameters"] = rest_field(name="diskEncryptionSet")
    """Specifies the customer managed disk encryption set resource id for the managed
     disk that is used for Customer Managed Key encrypted ConfidentialVM OS Disk and
     VMGuest blob."""

    @overload
    def __init__(
        self,
        *,
        security_encryption_type: Optional[Union[str, "_models.SecurityEncryptionTypes"]] = None,
        disk_encryption_set: Optional["_models.DiskEncryptionSetParameters"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class VMGalleryApplication(_model_base.Model):
    """Specifies the required information to reference a compute gallery application
    version.


    :ivar tags: Optional, Specifies a passthrough value for more generic context.
    :vartype tags: str
    :ivar order: Optional, Specifies the order in which the packages have to be installed.
    :vartype order: int
    :ivar package_reference_id: Specifies the GalleryApplicationVersion resource id on the form of
    /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/applications/{application}/versions/{version}.  # pylint: disable=line-too-long
     Required.
    :vartype package_reference_id: str
    :ivar configuration_reference: Optional, Specifies the uri to an azure blob that will replace
     the default
     configuration for the package if provided.
    :vartype configuration_reference: str
    :ivar treat_failure_as_deployment_failure: Optional, If true, any failure for any operation in
     the VmApplication will fail
     the deployment.
    :vartype treat_failure_as_deployment_failure: bool
    :ivar enable_automatic_upgrade: If set to true, when a new Gallery Application version is
     available in PIR/SIG,
     it will be automatically updated for the VM/VMSS.
    :vartype enable_automatic_upgrade: bool
    """

    tags: Optional[str] = rest_field()
    """Optional, Specifies a passthrough value for more generic context."""
    order: Optional[int] = rest_field()
    """Optional, Specifies the order in which the packages have to be installed."""
    package_reference_id: str = rest_field(name="packageReferenceId")
    """Specifies the GalleryApplicationVersion resource id on the form of
     /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/applications/{application}/versions/{version}.  # pylint: disable=line-too-long
     Required."""
    configuration_reference: Optional[str] = rest_field(name="configurationReference")
    """Optional, Specifies the uri to an azure blob that will replace the default
     configuration for the package if provided."""
    treat_failure_as_deployment_failure: Optional[bool] = rest_field(name="treatFailureAsDeploymentFailure")
    """Optional, If true, any failure for any operation in the VmApplication will fail
     the deployment."""
    enable_automatic_upgrade: Optional[bool] = rest_field(name="enableAutomaticUpgrade")
    """If set to true, when a new Gallery Application version is available in PIR/SIG,
     it will be automatically updated for the VM/VMSS."""

    @overload
    def __init__(
        self,
        *,
        package_reference_id: str,
        tags: Optional[str] = None,
        order: Optional[int] = None,
        configuration_reference: Optional[str] = None,
        treat_failure_as_deployment_failure: Optional[bool] = None,
        enable_automatic_upgrade: Optional[bool] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class VmSizeProfile(_model_base.Model):
    """Specifications about a VM Size. This will also contain the corresponding rank and weight in
    future.


    :ivar name: The Sku name (e.g. 'Standard_DS1_v2'). Required.
    :vartype name: str
    :ivar rank: The rank of the VM size. This is used with
     'RegularPriorityAllocationStrategy.Prioritized'
     The lower the number, the higher the priority. Starting with 0.
    :vartype rank: int
    """

    name: str = rest_field()
    """The Sku name (e.g. 'Standard_DS1_v2'). Required."""
    rank: Optional[int] = rest_field()
    """The rank of the VM size. This is used with 'RegularPriorityAllocationStrategy.Prioritized'
     The lower the number, the higher the priority. Starting with 0."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        rank: Optional[int] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class VMSizeProperties(_model_base.Model):
    """Specifies VM Size Property settings on the virtual machine.

    :ivar v_cpus_available: Specifies the number of vCPUs available for the VM. When this property
     is not
     specified in the request body the default behavior is to set it to the value of
     vCPUs available for that VM size exposed in api response of `List all available
     virtual machine sizes in a
     region <https://docs.microsoft.com/en-us/rest/api/compute/resource-skus/list>`_.
    :vartype v_cpus_available: int
    :ivar v_cpus_per_core: Specifies the vCPU to physical core ratio. When this property is not
     specified
     in the request body the default behavior is set to the value of vCPUsPerCore
     for the VM Size exposed in api response of `List all available virtual machine
     sizes in a
     region <https://docs.microsoft.com/en-us/rest/api/compute/resource-skus/list>`_.
     **Setting this property to 1 also means that hyper-threading is disabled.**.
    :vartype v_cpus_per_core: int
    """

    v_cpus_available: Optional[int] = rest_field(name="vCPUsAvailable")
    """Specifies the number of vCPUs available for the VM. When this property is not
     specified in the request body the default behavior is to set it to the value of
     vCPUs available for that VM size exposed in api response of `List all available
     virtual machine sizes in a
     region <https://docs.microsoft.com/en-us/rest/api/compute/resource-skus/list>`_."""
    v_cpus_per_core: Optional[int] = rest_field(name="vCPUsPerCore")
    """Specifies the vCPU to physical core ratio. When this property is not specified
     in the request body the default behavior is set to the value of vCPUsPerCore
     for the VM Size exposed in api response of `List all available virtual machine
     sizes in a
     region <https://docs.microsoft.com/en-us/rest/api/compute/resource-skus/list>`_.
     **Setting this property to 1 also means that hyper-threading is disabled.**."""

    @overload
    def __init__(
        self,
        *,
        v_cpus_available: Optional[int] = None,
        v_cpus_per_core: Optional[int] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class WindowsConfiguration(_model_base.Model):
    """Specifies Windows operating system settings on the virtual machine.

    :ivar provision_vm_agent: Indicates whether virtual machine agent should be provisioned on the
     virtual
     machine. When this property is not specified in the request body, it is set to
     true by default. This will ensure that VM Agent is installed on the VM so that
     extensions can be added to the VM later.
    :vartype provision_vm_agent: bool
    :ivar enable_automatic_updates: Indicates whether Automatic Updates is enabled for the Windows
     virtual machine.
     Default value is true. For virtual machine scale sets, this property can be
     updated and updates will take effect on OS reprovisioning.
    :vartype enable_automatic_updates: bool
    :ivar time_zone: Specifies the time zone of the virtual machine. e.g. "Pacific Standard Time".
     Possible values can be
     `TimeZoneInfo.Id
     <https://docs.microsoft.com/dotnet/api/system.timezoneinfo.id?#System_TimeZoneInfo_Id>`_
     value from time zones returned by
     `TimeZoneInfo.GetSystemTimeZones
     <https://docs.microsoft.com/dotnet/api/system.timezoneinfo.getsystemtimezones>`_.
    :vartype time_zone: str
    :ivar additional_unattend_content: Specifies additional base-64 encoded XML formatted
     information that can be
     included in the Unattend.xml file, which is used by Windows Setup.
    :vartype additional_unattend_content:
     list[~azure.mgmt.computefleet.models.AdditionalUnattendContent]
    :ivar patch_settings: [Preview Feature] Specifies settings related to VM Guest Patching on
     Windows.
    :vartype patch_settings: ~azure.mgmt.computefleet.models.PatchSettings
    :ivar win_rm: Specifies the Windows Remote Management listeners. This enables remote Windows
     PowerShell.
    :vartype win_rm: ~azure.mgmt.computefleet.models.WinRMConfiguration
    :ivar enable_vm_agent_platform_updates: Indicates whether VMAgent Platform Updates is enabled
     for the Windows virtual
     machine. Default value is false.
    :vartype enable_vm_agent_platform_updates: bool
    """

    provision_vm_agent: Optional[bool] = rest_field(name="provisionVMAgent")
    """Indicates whether virtual machine agent should be provisioned on the virtual
     machine. When this property is not specified in the request body, it is set to
     true by default. This will ensure that VM Agent is installed on the VM so that
     extensions can be added to the VM later."""
    enable_automatic_updates: Optional[bool] = rest_field(name="enableAutomaticUpdates")
    """Indicates whether Automatic Updates is enabled for the Windows virtual machine.
     Default value is true. For virtual machine scale sets, this property can be
     updated and updates will take effect on OS reprovisioning."""
    time_zone: Optional[str] = rest_field(name="timeZone")
    """Specifies the time zone of the virtual machine. e.g. \"Pacific Standard Time\".
     Possible values can be
     `TimeZoneInfo.Id
     <https://docs.microsoft.com/dotnet/api/system.timezoneinfo.id?#System_TimeZoneInfo_Id>`_
     value from time zones returned by
     `TimeZoneInfo.GetSystemTimeZones
     <https://docs.microsoft.com/dotnet/api/system.timezoneinfo.getsystemtimezones>`_."""
    additional_unattend_content: Optional[List["_models.AdditionalUnattendContent"]] = rest_field(
        name="additionalUnattendContent"
    )
    """Specifies additional base-64 encoded XML formatted information that can be
     included in the Unattend.xml file, which is used by Windows Setup."""
    patch_settings: Optional["_models.PatchSettings"] = rest_field(name="patchSettings")
    """[Preview Feature] Specifies settings related to VM Guest Patching on Windows."""
    win_rm: Optional["_models.WinRMConfiguration"] = rest_field(name="winRM")
    """Specifies the Windows Remote Management listeners. This enables remote Windows
     PowerShell."""
    enable_vm_agent_platform_updates: Optional[bool] = rest_field(name="enableVMAgentPlatformUpdates")
    """Indicates whether VMAgent Platform Updates is enabled for the Windows virtual
     machine. Default value is false."""

    @overload
    def __init__(
        self,
        *,
        provision_vm_agent: Optional[bool] = None,
        enable_automatic_updates: Optional[bool] = None,
        time_zone: Optional[str] = None,
        additional_unattend_content: Optional[List["_models.AdditionalUnattendContent"]] = None,
        patch_settings: Optional["_models.PatchSettings"] = None,
        win_rm: Optional["_models.WinRMConfiguration"] = None,
        enable_vm_agent_platform_updates: Optional[bool] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class WindowsVMGuestPatchAutomaticByPlatformSettings(_model_base.Model):  # pylint: disable=name-too-long
    """Specifies additional settings to be applied when patch mode AutomaticByPlatform
    is selected in Windows patch settings.

    :ivar reboot_setting: Specifies the reboot setting for all AutomaticByPlatform patch
     installation
     operations. Known values are: "Unknown", "IfRequired", "Never", and "Always".
    :vartype reboot_setting: str or
     ~azure.mgmt.computefleet.models.WindowsVMGuestPatchAutomaticByPlatformRebootSetting
    :ivar bypass_platform_safety_checks_on_user_schedule: Enables customer to schedule patching
     without accidental upgrades.
    :vartype bypass_platform_safety_checks_on_user_schedule: bool
    """

    reboot_setting: Optional[Union[str, "_models.WindowsVMGuestPatchAutomaticByPlatformRebootSetting"]] = rest_field(
        name="rebootSetting"
    )
    """Specifies the reboot setting for all AutomaticByPlatform patch installation
     operations. Known values are: \"Unknown\", \"IfRequired\", \"Never\", and \"Always\"."""
    bypass_platform_safety_checks_on_user_schedule: Optional[bool] = rest_field(
        name="bypassPlatformSafetyChecksOnUserSchedule"
    )
    """Enables customer to schedule patching without accidental upgrades."""

    @overload
    def __init__(
        self,
        *,
        reboot_setting: Optional[Union[str, "_models.WindowsVMGuestPatchAutomaticByPlatformRebootSetting"]] = None,
        bypass_platform_safety_checks_on_user_schedule: Optional[bool] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class WinRMConfiguration(_model_base.Model):
    """Describes Windows Remote Management configuration of the VM.

    :ivar listeners: The list of Windows Remote Management listeners.
    :vartype listeners: list[~azure.mgmt.computefleet.models.WinRMListener]
    """

    listeners: Optional[List["_models.WinRMListener"]] = rest_field()
    """The list of Windows Remote Management listeners."""

    @overload
    def __init__(
        self,
        *,
        listeners: Optional[List["_models.WinRMListener"]] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class WinRMListener(_model_base.Model):
    """Describes Protocol and thumbprint of Windows Remote Management listener.

    :ivar protocol: Specifies the protocol of WinRM listener. Possible values are: **http,**
     **https.**. Known values are: "Http" and "Https".
    :vartype protocol: str or ~azure.mgmt.computefleet.models.ProtocolTypes
    :ivar certificate_url: This is the URL of a certificate that has been uploaded to Key Vault as
     a
     secret. For adding a secret to the Key Vault, see `Add a key or secret to the
     key
     vault <https://docs.microsoft.com/azure/key-vault/key-vault-get-started/#add>`_.
     In this case, your certificate needs to be the Base64 encoding of the following
     JSON Object which is encoded in UTF-8: :code:`<br>`:code:`<br>` {:code:`<br>`
     "data":":code:`<Base64-encoded-certificate>`",:code:`<br>`  "dataType":"pfx",:code:`<br>`
     "password":":code:`<pfx-file-password>`":code:`<br>`} :code:`<br>` To install certificates on
     a virtual
     machine it is recommended to use the `Azure Key Vault virtual machine extension
     for
     Linux <https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-linux>`_
     or the `Azure Key Vault virtual machine extension for
     Windows <https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-windows>`_.
    :vartype certificate_url: str
    """

    protocol: Optional[Union[str, "_models.ProtocolTypes"]] = rest_field()
    """Specifies the protocol of WinRM listener. Possible values are: **http,**
     **https.**. Known values are: \"Http\" and \"Https\"."""
    certificate_url: Optional[str] = rest_field(name="certificateUrl")
    """This is the URL of a certificate that has been uploaded to Key Vault as a
     secret. For adding a secret to the Key Vault, see `Add a key or secret to the
     key
     vault <https://docs.microsoft.com/azure/key-vault/key-vault-get-started/#add>`_.
     In this case, your certificate needs to be the Base64 encoding of the following
     JSON Object which is encoded in UTF-8: :code:`<br>`:code:`<br>` {:code:`<br>`
     \"data\":\":code:`<Base64-encoded-certificate>`\",:code:`<br>`
     \"dataType\":\"pfx\",:code:`<br>`
     \"password\":\":code:`<pfx-file-password>`\":code:`<br>`} :code:`<br>` To install certificates
     on a virtual
     machine it is recommended to use the `Azure Key Vault virtual machine extension
     for
     Linux <https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-linux>`_
     or the `Azure Key Vault virtual machine extension for
     Windows <https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-windows>`_."""

    @overload
    def __init__(
        self,
        *,
        protocol: Optional[Union[str, "_models.ProtocolTypes"]] = None,
        certificate_url: Optional[str] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)
