# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['proselint',
 'proselint.checks',
 'proselint.checks.airlinese',
 'proselint.checks.annotations',
 'proselint.checks.archaism',
 'proselint.checks.cliches',
 'proselint.checks.consistency',
 'proselint.checks.corporate_speak',
 'proselint.checks.cursing',
 'proselint.checks.dates_times',
 'proselint.checks.hedging',
 'proselint.checks.hyperbole',
 'proselint.checks.inprogress',
 'proselint.checks.jargon',
 'proselint.checks.lexical_illusions',
 'proselint.checks.lgbtq',
 'proselint.checks.links',
 'proselint.checks.malapropisms',
 'proselint.checks.misc',
 'proselint.checks.mixed_metaphors',
 'proselint.checks.mondegreens',
 'proselint.checks.needless_variants',
 'proselint.checks.nonwords',
 'proselint.checks.oxymorons',
 'proselint.checks.psychology',
 'proselint.checks.redundancy',
 'proselint.checks.security',
 'proselint.checks.sexism',
 'proselint.checks.skunked_terms',
 'proselint.checks.spelling',
 'proselint.checks.terms',
 'proselint.checks.typography',
 'proselint.checks.uncomparables',
 'proselint.checks.weasel_words']

package_data = \
{'': ['*']}

install_requires = \
['click>=8.0.0,<9.0.0', 'future>=0.18.2,<0.19.0', 'six>=1.15.0,<2.0.0']

entry_points = \
{'console_scripts': ['proselint = proselint.command_line:proselint']}

setup_kwargs = {
    'name': 'proselint',
    'version': '0.13.0',
    'description': 'A linter for prose.',
    'long_description': '<img src="https://raw.githubusercontent.com/amperser/proselint/main/logo.png" alt="proselint logo" width="200">\n\n![Workflow status](https://github.com/amperser/proselint/actions/workflows/ci-lint-test.yml/badge.svg)\n[![Reviewed by Hound](https://img.shields.io/badge/Reviewed_by-Hound-8E64B0.svg)](https://houndci.com)\n[![Code Climate](https://codeclimate.com/repos/5538989ee30ba0793100090f/badges/e10a2fe18a9256d69e2a/gpa.svg)](https://codeclimate.com/repos/5538989ee30ba0793100090f/feed)\n[![codecov](https://codecov.io/gh/amperser/proselint/branch/main/graph/badge.svg?token=8E0I9sRpot)](https://codecov.io/gh/amperser/proselint)\n[![License](https://img.shields.io/badge/License-BSD-blue.svg)](https://en.wikipedia.org/wiki/BSD_licenses)\n\nWriting is notoriously hard, even for the best writers, and it\'s not for lack of good advice — a tremendous amount of knowledge about the craft is strewn across usage guides, dictionaries, technical manuals, essays, pamphlets, websites, and the hearts and minds of great authors and editors. But poring over Strunk & White hardly makes one a better writer — it turns you into neither Strunk nor White. And nobody has the capacity to apply all the advice from *Garner’s Modern English Usage*, an 1100-page usage guide, to everything they write. In fact, the whole notion that one becomes a better writer by reading advice on writing rests on untenable assumptions about learning and memory. The traditional formats of knowledge about writing are thus essentially inert, waiting to be transformed.\n\nWe devised a simple solution: `proselint`, a linter for English prose. A linter is a computer program that, akin to a spell checker, scans through a file and detects issues — like how a real lint roller helps you get unwanted lint off of your shirt.\n\n`proselint` places the world\'s greatest writers and editors by your side, where they whisper suggestions on how to improve your prose. You’ll be guided by advice inspired by Bryan Garner, David Foster Wallace, Chuck Palahniuk, Steve Pinker, Mary Norris, Mark Twain, Elmore Leonard, George Orwell, Matthew Butterick, William Strunk, Elwyn White, Philip Corbett, Ernest Gowers, and the editorial staff of the world’s finest literary magazines and newspapers, among others. Our goal is to aggregate knowledge about best practices in writing and to make that knowledge immediately accessible to all authors in the form of a linter for prose; all in a neat command-line utility that you can integrate into other tools, scripts, and workflows.\n\n### Installation\n\nTo get this up and running, install it using [pip]:\n\n```bash\npip install proselint\n```\n\n[pip]: https://packaging.python.org/installing/#use-pip-for-installing\n\n#### Fedora\n\n```bash\nsudo dnf install proselint\n```\n\n#### Debian\n\n```bash\nsudo apt install python3-proselint\n```\n\n#### Ubuntu\n\n```bash\nsudo add-apt-repository universe\nsudo apt install python3-proselint\n```\n\n### Plugins for other software\n\n`proselint` is available on:\n\n- A [demo editor](http://proselint.com/write)\n- [Sublime Text](https://github.com/amperser/proselint/tree/main/plugins/sublime/SublimeLinter-contrib-proselint)\n- [Atom Editor](https://github.com/smockle/linter-proselint) (thanks to [Clay Miller](https://github.com/smockle)).\n- [Emacs via Flycheck](http://www.flycheck.org/).\n- Vim via [ALE](https://github.com/w0rp/ale) or [Syntastic](https://github.com/vim-syntastic/syntastic) (thanks to @lcd047, @Carreau, and [Daniel M. Capella](https://github.com/polyzen))\n- [Phabricator\'s `arc` CLI](https://github.com/google/arc-proselint) (thanks to [Jeff Verkoeyen](https://github.com/jverkoey))\n- [Danger](https://github.com/dbgrandi/danger-prose) (thanks to [David Grandinetti](https://github.com/dbgrandi) and [Orta Therox](https://github.com/orta))\n- [Visual Studio Code](https://github.com/ppeszko/vscode-proselint) (thanks to [Patryk Peszko](https://github.com/ppeszko))\n- [coala](https://github.com/coala-analyzer/bear-docs/blob/master/docs/ProseLintBear.rst) (thanks to the [coala Development Group](https://github.com/coala-analyzer))\n- [IntelliJ](https://github.com/kropp/intellij-proselint) (by [Victor Kropp](https://github.com/kropp))\n- [pre-commit](https://pre-commit.com/) (by [Andy Airey](https://github.com/aairey))\n- [Statick](https://github.com/sscpac/statick-md)\n\n### Usage\n\nSuppose you have a document `text.md` with the following text:\n\n```\nJohn is very unique.\n```\n\nYou can run `proselint` over the document using the command line:\n\n```bash\nproselint text.md\n```\n\nThis prints a list of suggestions to stdout, one per line. Each suggestion has the form:\n\n```bash\ntext.md:<line>:<column>: <check_name> <message>\n```\n\nFor example,\n\n```bash\ntext.md:0:10: wallace.uncomparables Comparison of an uncomparable: \'unique\' cannot be compared.\n```\n\nThe command-line utility can also print suggestions in JSON using the `--json` flag. In this case, the output is considerably richer:\n\n```jsonc\n{\n  // Type of check that output this suggestion.\n  check: "wallace.uncomparables",\n\n  // Message to describe the suggestion.\n  message: "Comparison of an uncomparable: \'unique\' cannot be compared.",\n\n  // The person or organization giving the suggestion.\n  source: "David Foster Wallace"\n\n  // URL pointing to the source material.\n  source_url: "http://www.telegraph.co.uk/a/9715551"\n\n  // Line where the error starts.\n  line: 0,\n\n  // Column where the error starts.\n  column: 10,\n\n  // Index in the text where the error starts.\n  start: 10,\n\n  // Index in the text where the error ends.\n  end: 21,\n\n  // length from start -> end\n  extent: 11,\n\n  // How important is this? Can be "suggestion", "warning", or "error".\n  severity: "warning",\n\n  // Possible replacements.\n  replacements: [\n    {\n      value: "unique"\n    }\n  ]\n}\n```\n\nTo run the linter as part of another Python program, you can use the `lint` function in `proselint.tools`:\n\n```python\nimport proselint\n\nsuggestions = proselint.tools.lint("This sentence is very unique")\n```\n\nThis will return a list of suggestions:\n\n```python\n[(\'weasel_words.very\', "Substitute \'damn\' every time you\'re inclined to write \'very;\' your editor will delete it and the writing will be just as it should be.", 0, 17, 17, 22, 5, \'warning\', None), (\'uncomparables.misc\', "Comparison of an uncomparable: \'very unique.\' is not comparable.", 0, 17, 17, 29, 12, \'warning\', None)]\n```\n\n### Checks\n\nYou can disable any of the checks by modifying `$XDG_CONFIG_HOME/proselint/config`. If `$XDG_CONFIG_HOME` is not set or empty, `~/.config/proselint/config` will be used. Additionally, for compatibility reasons, the legacy configuration `~/.proselintrc` will be checked if `$XDG_CONFIG_HOME/proselint/config` does not exist.\n\n```json\n{\n  "checks": {\n    "typography.diacritical_marks": false\n  }\n}\n```\n\n| ID    | Description     |\n| ----- | --------------- |\n| `airlinese.misc` | Avoiding jargon of the airline industry |\n| `annotations.misc` | Catching annotations left in the text |\n| `archaism.misc` | Avoiding archaic forms |\n| `cliches.hell` | Avoiding a common cliché |\n| `cliches.misc` | Avoiding clichés |\n| `consistency.spacing` | Consistent sentence spacing |\n| `consistency.spelling` | Consistent spelling |\n| `corporate_speak.misc` | Avoiding corporate buzzwords |\n| `cursing.filth` | Words to avoid |\n| `cursing.nfl` | Avoiding words banned by the NFL |\n| `dates_times.am_pm` | Using the right form for the time of day |\n| `dates_times.dates` | Stylish formatting of dates |\n| `hedging.misc` | Not hedging |\n| `hyperbole.misc` | Not being hyperbolic |\n| `jargon.misc` | Avoiding miscellaneous jargon |\n| `lgbtq.offensive_terms` | Avoding offensive LGBTQ terms |\n| `lgbtq.terms` | Misused LGBTQ terms |\n| `lexical_illusions.misc` | Avoiding lexical illusions |\n| `links.broken` | Linking only to existing sites |\n| `malapropisms.misc` | Avoiding common malapropisms |\n| `misc.apologizing` | Being confident |\n| `misc.back_formations` | Avoiding needless backformations |\n| `misc.bureaucratese` | Avoiding bureaucratese |\n| `misc.but` | Avoid starting a paragraph with "But..." |\n| `misc.capitalization` | Capitalizing only what ought to be capitalized |\n| `misc.chatspeak` | Avoiding lolling and other chatspeak |\n| `misc.commercialese` | Avoiding jargon of the commercial world |\n| `misc.currency` | Avoiding redundant currency symbols |\n| `misc.debased` | Avoiding debased language |\n| `misc.false_plurals` | Avoiding false plurals |\n| `misc.illogic` | Avoiding illogical forms |\n| `misc.inferior_superior` | Superior to, not than |\n| `misc.latin` | Avoiding overuse of Latin phrases |\n| `misc.many_a` | Many a singular |\n| `misc.metaconcepts` | Avoiding overuse of metaconcepts |\n| `misc.narcissism` | Talking about the subject, not its study |\n| `misc.phrasal_adjectives` | Hyphenating phrasal adjectives |\n| `misc.preferred_forms` | Miscellaneous preferred forms |\n| `misc.pretension` | Avoiding being pretentious |\n| `misc.professions` | Calling jobs by the right name |\n| `misc.punctuation` | Using punctuation assiduously |\n| `misc.scare_quotes` | Using scare quotes only when needed |\n| `misc.suddenly` | Avoiding the word suddenly |\n| `misc.tense_present` | Advice from Tense Present |\n| `misc.waxed` | Waxing poetic |\n| `misc.whence` | Using "whence" |\n| `mixed_metaphors.misc` | Not mixing metaphors |\n| `mondegreens.misc` | Avoiding mondegreen |\n| `needless_variants.misc` | Using the preferred form |\n| `nonwords.misc` | Avoid using nonwords |\n| `oxymorons.misc` | Avoiding oxymorons |\n| `psychology.misc` | Avoiding misused psychological terms |\n| `redundancy.misc` | Avoiding redundancy and saying things twice |\n| `redundancy.ras_syndrome` | Avoiding RAS syndrome |\n| `skunked_terms.misc` | Avoid using skunked terms |\n| `spelling.able_atable` | -able vs. -atable |\n| `spelling.able_ible` | -able vs. -ible |\n| `spelling.athletes` | Spelling of athlete names |\n| `spelling.em_im_en_in` | -em vs. -im and -en vs. -in |\n| `spelling.er_or` | -er vs. -or |\n| `spelling.in_un` | in- vs. un- |\n| `spelling.misc` | Spelling words corectly |\n| `security.credit_card` | Keeping credit card numbers secret |\n| `security.password` | Keeping passwords secret |\n| `sexism.misc` | Avoiding sexist language |\n| `terms.animal_adjectives` | Animal adjectives |\n| `terms.denizen_labels` | Calling denizens by the right name |\n| `terms.eponymous_adjectives` | Calling people by the right name |\n| `terms.venery` | Call groups of animals by the right name |\n| `typography.diacritical_marks` | Using dïacríticâl marks |\n| `typography.exclamation` | Avoiding overuse of exclamation |\n| `typography.symbols` | Using the right symbols |\n| `uncomparables.misc` | Not comparing uncomparables |\n| `weasel_words.misc` | Avoiding weasel words |\n| `weasel_words.very` | Avoiding the word "very" |\n\n### Contributing\n\nInterested in contributing to `proselint`? Great — there are plenty of ways you can help. Read more on [our website], where we describe how you can help us build `proselint` into the greatest writing tool in the world.\n\n- [Issue Tracker](http://github.com/amperser/proselint/issues)\n- [Source Code](http://github.com/amperser/proselint)\n\n[our website]: http://proselint.com/contributing/\n\n### Support\n\nIf you run into a problem, please [open an issue](http://github.com/amperser/proselint/issues) in or send an email to hello@amperser.com.\n\n### Running Automated Tests\n\nAutomated tests are included in the `proselint/tests` directory. To run these tests locally, you can use `./utils`.\n\n### License\n\nThe project is licensed under the BSD license.\n',
    'author': 'Amperser Labs',
    'author_email': 'hello@amperser.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://proselint.com',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6.1,<4.0.0',
}


setup(**setup_kwargs)
