/*
 * Copyright (C) 2013 Canonical, Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "fakeviewfindersettingscontrol.h"
#include "fakecameraservice.h"
#include "fakevideorenderercontrol.h"

#include <QDebug>

FakeViewfinderSettingsControl::FakeViewfinderSettingsControl(FakeCameraService *service, QObject *parent)
    :QCameraViewfinderSettingsControl(parent),
      m_service(service)
{
}

FakeViewfinderSettingsControl::~FakeViewfinderSettingsControl()
{
}

bool FakeViewfinderSettingsControl::isViewfinderParameterSupported(ViewfinderParameter parameter) const
{
    if (parameter == QCameraViewfinderSettingsControl::Resolution ||
            parameter == QCameraViewfinderSettingsControl::MinimumFrameRate ||
            parameter == QCameraViewfinderSettingsControl::MaximumFrameRate ) {
        return true;
    }

    return false;
}

void FakeViewfinderSettingsControl::setViewfinderParameter(ViewfinderParameter parameter, const QVariant &value)
{
    if (!isViewfinderParameterSupported(parameter)) {
        qWarning() << "Viewfinder dos not support parameter " << parameter;
        return;
    }

    switch (parameter) {
    case QCameraViewfinderSettingsControl::Resolution: {
        QSize size = value.toSize();
        QSize dataSize(size.height(), size.width());
        m_service->fakeSensor().setViewfinderSize(dataSize);
        break;
    }
    case QCameraViewfinderSettingsControl::MinimumFrameRate:
    case QCameraViewfinderSettingsControl::MaximumFrameRate:
        qWarning() << "Camera framerate boundaries are set by the backend";
        break;
    default:
        break;
    }
}

QVariant FakeViewfinderSettingsControl::viewfinderParameter(ViewfinderParameter parameter) const
{
    if (!isViewfinderParameterSupported(parameter)) {
        qWarning() << "Viewfinder dos not support parameter " << parameter;
        return QVariant();
    }

    switch (parameter) {
    case QCameraViewfinderSettingsControl::Resolution: {
        QSize dataSize =    m_service->fakeSensor().viewfinderSize();
        QSize size(dataSize.height(), dataSize.width());
        return QVariant(size);
    }
    case QCameraViewfinderSettingsControl::MinimumFrameRate:
        return 15;
    case QCameraViewfinderSettingsControl::MaximumFrameRate:
        return 30;
    default:
        break;
    }

    return QVariant();
}
