% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DianaParam.R
\docType{class}
\name{DianaParam-class}
\alias{DianaParam-class}
\alias{show,DianaParam-method}
\alias{.defaultScalarArguments,DianaParam-method}
\alias{DianaParam}
\alias{clusterRows,ANY,DianaParam-method}
\title{Divisive analysis clustering}
\usage{
DianaParam(
  metric = NULL,
  dist.fun = NULL,
  stand = NULL,
  cut.fun = NULL,
  cut.dynamic = FALSE,
  cut.params = list()
)

\S4method{clusterRows}{ANY,DianaParam}(x, BLUSPARAM, full = FALSE)
}
\arguments{
\item{metric}{String specifying the distance metric to use in \code{\link{diana}}.
If \code{NULL}, the default metric is used.
If \code{dist.fun} is supplied, \code{metric} is passed to that function instead.}

\item{dist.fun}{Function specifying the function to use to compute the distance matrix. 
The function should accept a data matrix and a \code{method=} string (used to accept \code{metric}) and return a dissimilarity matrix of type \link{dist}.
If \code{NULL}, the \code{stats::\link{dist}} function is used by default.}

\item{stand}{Further arguments to pass to \code{\link{diana}}.}

\item{cut.fun}{Function specifying the method to use to cut the dendrogram.
The first argument of this function should be the output of \code{\link{hclust}},
and the return value should be an atomic vector specifying the cluster assignment for each observation.
Defaults to \code{\link{cutree}} if \code{cut.dynamic=FALSE} and \code{\link[dynamicTreeCut]{cutreeDynamic}} otherwise.}

\item{cut.dynamic}{Logical scalar indicating whether a dynamic tree cut should be performed using the \pkg{dynamicTreeCut} package.}

\item{cut.params}{Further arguments to pass to \code{cut.fun}.}

\item{x}{A numeric matrix-like object where rows represent observations and columns represent variables.}

\item{BLUSPARAM}{A \linkS4class{HclustParam} object.}

\item{full}{Logical scalar indicating whether the hierarchical clustering statistics should be returned.}
}
\value{
The \code{DianaParam} constructor will return a \linkS4class{DianaParam} object with the specified parameters.

The \code{clusterRows} method will return a factor of length equal to \code{nrow(x)} containing the cluster assignments.
If \code{full=TRUE}, a list is returned with \code{clusters} (the factor, as above) and \code{objects}
(a list containing \code{diana}, the function output; \code{dist}, the dissimilarity matrix; and \code{hclust}, a \link{hclust} object created from \code{diana}).
}
\description{
Use the \code{\link{diana}} function to perform divisive analysis clustering.
}
\details{
To modify an existing DianaParam object \code{x},
users can simply call \code{x[[i]]} or \code{x[[i]] <- value} where \code{i} is any argument used in the constructor.

If \code{cut.fun=NULL}, \code{cut.dynamic=FALSE} and \code{cut.params} does not have \code{h} or \code{k},
\code{\link{clusterRows}} will automatically set \code{h} to half the tree height when calling \code{\link{cutree}}.
}
\examples{
clusterRows(iris[,1:4], DianaParam())
clusterRows(iris[,1:4], DianaParam(metric="manhattan"))

}
\seealso{
\code{\link{diana}}, which actually does all the heavy lifting.

\linkS4class{HclustParam}, for the more commonly used implementation of hierarchical clustering.
}
\author{
Aaron Lun
}
