% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/position-beeswarm.R
\name{position_beeswarm}
\alias{position_beeswarm}
\title{Violin point-style plots to show overlapping points. x must be discrete.}
\usage{
position_beeswarm(priority = c("ascending", "descending", "density", "random",
  "none"), cex = 1, groupOnX = NULL, dodge.width = 0)
}
\arguments{
\item{priority}{Method used to perform point layout (see \code{\link{swarmx}})}

\item{cex}{Scaling for adjusting point spacing (see \code{\link{swarmx}})}

\item{groupOnX}{if TRUE then jitter is added to the x axis and if FALSE jitter is added to the y axis. Prior to v0.6.0, the default NULL causes the function to guess which axis is the categorical one based on the number of unique entries in each. This could result in unexpected results when the x variable has few unique values and so in v0.6.0 the default was changed to always jitter on the x axis unless groupOnX=FALSE. Also consider \code{\link[ggplot2]{coord_flip}}.}

\item{dodge.width}{Amount by which points from different aesthetic groups will be dodged. This requires that one of the aesthetics is a factor.}
}
\description{
Violin point-style plots to show overlapping points. x must be discrete.
}
\examples{

  ggplot2::qplot(class, hwy, data = ggplot2::mpg, position=position_beeswarm())

}
\seealso{
\code{\link{position_quasirandom}}, \code{\link[beeswarm]{swarmx}}

Other position adjustments: \code{\link{position_quasirandom}}
}
