% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gprofiler2.R
\name{publish_gosttable}
\alias{publish_gosttable}
\title{Create and save a table with the functional enrichment analysis results.}
\usage{
publish_gosttable(
  gostres,
  highlight_terms = NULL,
  use_colors = TRUE,
  show_columns = c("source", "term_name", "term_size", "intersection_size"),
  filename = NULL,
  ggplot = TRUE
)
}
\arguments{
\item{gostres}{named list from gost() function (with names 'result' and 'meta') or a data frame that has columns named "term_id" and "p_value(s)".}

\item{highlight_terms}{vector of selected term IDs from the analysis or a (subset) data.frame that has a column called 'term_id'. All data is shown if set to NULL.}

\item{use_colors}{if enabled, the p-values are highlighted in the viridis colorscale just as in g:Profiler, otherwise the table has no background colors.}

\item{show_columns}{names of additional columns to show besides term_id and p_value. By default the output table shows additional columns named "source", "term_name", "term_size", "intersection_size"}

\item{filename}{file name to create on disk and save the annotated plot. Filename extension should be from c("png", "pdf", "jpeg", "tiff", "bmp").}

\item{ggplot}{if FALSE, then the function returns a gtable object.}
}
\value{
The output is a ggplot object.
}
\description{
This function creates a table mainly for the results from gost() function.
However, if the input at least contains columns named 'term_id' and 'p_value' then any enrichment results data frame can be visualised in a table with this function.
}
\details{
The output table is very similar to the one shown under the Manhattan plot.
}
\examples{
 # gostres <- gost(c("Klf4", "Pax5", "Sox2", "Nanog"), organism = "mmusculus")
 gostres <- readRDS(system.file("extdata", "gost_example_mmusculus.rds", package = "gprofiler2"))
 publish_gosttable(gostres, highlight_terms = c("GO:0001010", "REAC:R-MMU-8939245"))
}
\author{
Liis Kolberg <liis.kolberg@ut.ee>
}
