#include <gsl/gsl_sf_dilog.h>
#include <gsl/gsl_errno.h>

/* function names generated by removing  "gsl_sf" from the beginning
   of the name.  Thus gsl_sf_dilog_e goes to dilog_e. */


void dilog_e(const double *x, const int *len, double *val, double *err, int *status)
{
	int i;
	gsl_sf_result result;
	gsl_set_error_handler_off();
  
	for(i = 0; i< *len ; i++){
		status[i] = gsl_sf_dilog_e(x[i] , &result) ;
		val[i] = result.val;
		err[i] = result.err;
	}
}  

void complex_dilog_e(const double *r, const double *theta, const int *len, double *val_re, double *val_im, double *err_re, double *err_im, int *status)
{
	int i;
	gsl_sf_result re;
	gsl_sf_result im;
	gsl_set_error_handler_off();
  
	for(i = 0; i< *len ; i++){
		status[i] = gsl_sf_complex_dilog_e(r[i], theta[i], &re, &im) ;

		val_re[i] = re.val;
		val_im[i] = im.val;

		err_re[i] = re.err;
		err_im[i] = im.err;
	}
}  

