% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sCorrect-getVarCov2.R
\name{getVarCov2}
\alias{getVarCov2}
\alias{getVarCov2.lvmfit}
\alias{getVarCov2.lvmfit2}
\title{Residual Variance-Covariance Matrix With Small Sample Correction.}
\usage{
getVarCov2(object, ...)

\method{getVarCov2}{lvmfit}(object, ssc = lava.options()$ssc, ...)

\method{getVarCov2}{lvmfit2}(object, ...)
}
\arguments{
\item{object}{a \code{lvmfit} or \code{lvmfit2} object (i.e. output of \code{lava::estimate} or \code{lavaSearch2::estimate2}).}

\item{...}{additional argument passed to \code{estimate2} when using a \code{lvmfit} object.}

\item{ssc}{[character] method used to correct the small sample bias of the variance coefficients: no correction (\code{"none"}/\code{FALSE}/\code{NA}),
correct the first order bias in the residual variance (\code{"residual"}), or correct the first order bias in the estimated coefficients \code{"cox"}).
Only relevant when using a \code{lvmfit} object.}
}
\value{
A matrix with as many rows and column as the number of endogenous variables
}
\description{
Reconstruct the residual variance-covariance matrix from a latent variable model. 
It is similar to \code{nlme::getVarCov} but with small sample correction.
}
\details{
When argument object is a \code{lvmfit} object, the method first calls \code{estimate2} and then extract the residuals.
}
\examples{
#### simulate data ####
set.seed(10)
n <- 101

Y1 <- rnorm(n, mean = 0)
Y2 <- rnorm(n, mean = 0.3)
Id <- findInterval(runif(n), seq(0.1,1,0.1))
data.df <- rbind(data.frame(Y=Y1,G="1",Id = Id),
           data.frame(Y=Y2,G="2",Id = Id)
           )

#### latent variable models ####
library(lava)
e.lvm <- estimate(lvm(Y ~ G), data = data.df)
getVarCov2(e.lvm)

}
\concept{extractor}
\keyword{smallSampleCorrection}
