% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ResampleResult_operators.R
\name{getRRDump}
\alias{getRRDump}
\title{Return the error dump of ResampleResult.}
\usage{
getRRDump(res)
}
\arguments{
\item{res}{(\link{ResampleResult})\cr
The result of \link{resample}.}
}
\value{
\link{list}.
}
\description{
Returns the error dumps generated during resampling, which can be used with \code{debugger()}
to debug errors. These dumps are saved if \link{configureMlr} configuration \code{on.error.dump},
or the corresponding learner \code{config}, is \code{TRUE}.

The returned object is a list with as many entries as the resampling being used has folds. Each of these
entries can have a subset of the following slots, depending on which step in the resampling iteration failed:
\dQuote{train} (error during training step), \dQuote{predict.train} (prediction on training subset),
\dQuote{predict.test} (prediction on test subset).
}
\seealso{
Other debug: 
\code{\link{FailureModel}},
\code{\link{ResampleResult}},
\code{\link{getPredictionDump}()}
}
\concept{debug}
